/*
 * Decompiled with CFR 0.152.
 */
package org.testng.xml.internal;

import java.util.List;
import java.util.Set;
import org.testng.TestNGException;
import org.testng.collections.Lists;
import org.testng.collections.Sets;
import org.testng.xml.XmlClass;
import org.testng.xml.XmlSuite;
import org.testng.xml.XmlTest;

public final class XmlSuiteUtils {
    private XmlSuiteUtils() {
    }

    public static XmlSuite cloneIfContainsTestsWithNamesMatchingAny(XmlSuite xmlSuite, List<String> list) {
        if (list == null || list.isEmpty()) {
            throw new TestNGException("Please provide a valid list of names to check.");
        }
        for (XmlSuite xmlSuite2 : xmlSuite.getChildSuites()) {
            XmlSuite xmlSuite3 = XmlSuiteUtils.cloneIfSuiteContainTestsWithNamesMatchingAny(xmlSuite2, list);
            if (xmlSuite3 == null) continue;
            return xmlSuite3;
        }
        XmlSuite xmlSuite4 = XmlSuiteUtils.cloneIfSuiteContainTestsWithNamesMatchingAny(xmlSuite, list);
        if (xmlSuite4 == null) {
            throw new TestNGException("The test(s) <" + list.toString() + "> cannot be found.");
        }
        return xmlSuite4;
    }

    public static void validateIfSuitesContainDuplicateTests(List<XmlSuite> list) {
        for (XmlSuite xmlSuite : list) {
            XmlSuiteUtils.ensureNoDuplicateTestsArePresent(xmlSuite);
            XmlSuiteUtils.validateIfSuitesContainDuplicateTests(xmlSuite.getChildSuites());
        }
    }

    public static void adjustSuiteNamesToEnsureUniqueness(List<XmlSuite> list) {
        XmlSuiteUtils.adjustSuiteNamesToEnsureUniqueness(list, Sets.newHashSet());
    }

    public static XmlSuite newXmlSuiteUsing(List<String> list) {
        XmlSuite xmlSuite = new XmlSuite();
        xmlSuite.setVerbose(0);
        xmlSuite.setName("Jar suite");
        XmlTest xmlTest = new XmlTest(xmlSuite);
        xmlTest.setXmlClasses(XmlSuiteUtils.constructXmlClassesUsing(list));
        return xmlSuite;
    }

    static void ensureNoDuplicateTestsArePresent(XmlSuite xmlSuite) {
        Set set = Sets.newHashSet();
        for (XmlTest xmlTest : xmlSuite.getTests()) {
            if (set.add(xmlTest.getName())) continue;
            throw new TestNGException("Two tests in the same suite [" + xmlSuite.getName() + "] cannot have the same name: " + xmlTest.getName());
        }
    }

    private static List<XmlClass> constructXmlClassesUsing(List<String> list) {
        List<XmlClass> list2 = Lists.newLinkedList();
        for (String string : list) {
            XmlClass xmlClass = new XmlClass(string);
            list2.add(xmlClass);
        }
        return list2;
    }

    private static XmlSuite cloneIfSuiteContainTestsWithNamesMatchingAny(XmlSuite xmlSuite, List<String> list) {
        List<XmlTest> list2 = Lists.newLinkedList();
        for (XmlTest xmlTest : xmlSuite.getTests()) {
            if (!xmlTest.nameMatchesAny(list)) continue;
            list2.add(xmlTest);
        }
        if (list2.isEmpty()) {
            return null;
        }
        return XmlSuiteUtils.cleanClone(xmlSuite, list2);
    }

    private static XmlSuite cleanClone(XmlSuite xmlSuite, List<XmlTest> list) {
        XmlSuite xmlSuite2 = (XmlSuite)xmlSuite.clone();
        xmlSuite2.getTests().clear();
        xmlSuite2.getTests().addAll(list);
        return xmlSuite2;
    }

    private static void adjustSuiteNamesToEnsureUniqueness(List<XmlSuite> list, Set<String> set) {
        for (XmlSuite xmlSuite : list) {
            String string = xmlSuite.getName();
            int n = 0;
            String string2 = string;
            while (set.contains(string2)) {
                string2 = string + " (" + n++ + ")";
            }
            if (n > 0) {
                xmlSuite.setName(string2);
                set.add(string2);
            } else {
                set.add(string);
            }
            XmlSuiteUtils.adjustSuiteNamesToEnsureUniqueness(xmlSuite.getChildSuites(), set);
        }
    }
}

