/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.actions;

import java.awt.Component;
import java.awt.event.ActionEvent;
import org.openstreetmap.josm.actions.ToggleAction;
import org.openstreetmap.josm.data.preferences.BooleanProperty;
import org.openstreetmap.josm.gui.MainApplication;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.ListenerList;

public class ExpertToggleAction
extends ToggleAction {
    private static final ListenerList<ExpertModeChangeListener> listeners = ListenerList.createUnchecked();
    private static final ListenerList<Component> visibilityToggleListeners = ListenerList.createUnchecked();
    private static final BooleanProperty PREF_EXPERT = new BooleanProperty("expert", false);
    private static final ExpertToggleAction INSTANCE = new ExpertToggleAction();

    private static synchronized void fireExpertModeChanged(boolean isExpert) {
        listeners.fireEvent(listener -> listener.expertChanged(isExpert));
        visibilityToggleListeners.fireEvent(c -> c.setVisible(isExpert));
    }

    public static void addExpertModeChangeListener(ExpertModeChangeListener listener) {
        ExpertToggleAction.addExpertModeChangeListener(listener, false);
    }

    public static synchronized void addExpertModeChangeListener(ExpertModeChangeListener listener, boolean fireWhenAdding) {
        if (listener == null) {
            return;
        }
        listeners.addWeakListener(listener);
        if (fireWhenAdding) {
            listener.expertChanged(ExpertToggleAction.isExpert());
        }
    }

    public static synchronized void removeExpertModeChangeListener(ExpertModeChangeListener listener) {
        if (listener == null) {
            return;
        }
        listeners.removeListener(listener);
    }

    public static synchronized void addVisibilitySwitcher(Component c) {
        if (c == null) {
            return;
        }
        visibilityToggleListeners.addWeakListener(c);
        c.setVisible(ExpertToggleAction.isExpert());
    }

    public static synchronized void removeVisibilitySwitcher(Component c) {
        if (c == null) {
            return;
        }
        visibilityToggleListeners.removeListener(c);
    }

    public static synchronized boolean hasVisibilitySwitcher(Component c) {
        if (c == null) {
            return false;
        }
        return visibilityToggleListeners.containsListener(c);
    }

    public ExpertToggleAction() {
        super(I18n.tr("Expert Mode", new Object[0]), "expert", I18n.tr("Enable/disable expert mode", new Object[0]), null, false);
        this.setToolbarId("expertmode");
        if (MainApplication.getToolbar() != null) {
            MainApplication.getToolbar().register(this);
        }
        this.setSelected(PREF_EXPERT.get());
        this.notifySelectedState();
    }

    @Override
    protected final void notifySelectedState() {
        super.notifySelectedState();
        PREF_EXPERT.put(this.isSelected());
        ExpertToggleAction.fireExpertModeChanged(this.isSelected());
    }

    public void setExpert(boolean isExpert) {
        if (this.isSelected() != isExpert) {
            this.setSelected(isExpert);
            this.notifySelectedState();
        }
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        this.toggleSelectedState(e);
        this.notifySelectedState();
    }

    public static ExpertToggleAction getInstance() {
        return INSTANCE;
    }

    public static boolean isExpert() {
        return INSTANCE.isSelected();
    }

    @FunctionalInterface
    public static interface ExpertModeChangeListener {
        public void expertChanged(boolean var1);
    }
}

