/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.gui.history;

import java.util.HashSet;
import java.util.Set;
import javax.swing.DefaultListSelectionModel;
import javax.swing.ListSelectionModel;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;

public class SelectionSynchronizer
implements ListSelectionListener {
    private final Set<ListSelectionModel> participants = new HashSet<ListSelectionModel>();
    private boolean preventRecursion;

    public void participateInSynchronizedSelection(ListSelectionModel model) {
        if (model == null) {
            return;
        }
        if (this.participants.contains(model)) {
            return;
        }
        this.participants.add(model);
        model.addListSelectionListener(this);
    }

    @Override
    public void valueChanged(ListSelectionEvent e) {
        if (this.preventRecursion) {
            return;
        }
        this.preventRecursion = true;
        DefaultListSelectionModel referenceModel = (DefaultListSelectionModel)e.getSource();
        int i = referenceModel.getMinSelectionIndex();
        int j = referenceModel.getMaxSelectionIndex();
        for (ListSelectionModel model : this.participants) {
            if (model == e.getSource()) continue;
            model.setSelectionInterval(i, j);
        }
        this.preventRecursion = false;
    }
}

