/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.io.remotecontrol.handler;

import java.awt.geom.Area;
import java.awt.geom.Rectangle2D;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.Set;
import java.util.concurrent.Future;
import org.openstreetmap.josm.actions.AutoScaleAction;
import org.openstreetmap.josm.actions.downloadtasks.DownloadOsmTask;
import org.openstreetmap.josm.actions.downloadtasks.DownloadParams;
import org.openstreetmap.josm.actions.downloadtasks.PostDownloadHandler;
import org.openstreetmap.josm.data.Bounds;
import org.openstreetmap.josm.data.coor.LatLon;
import org.openstreetmap.josm.data.osm.BBox;
import org.openstreetmap.josm.data.osm.DataSet;
import org.openstreetmap.josm.data.osm.OsmPrimitive;
import org.openstreetmap.josm.data.osm.Relation;
import org.openstreetmap.josm.data.osm.SimplePrimitiveId;
import org.openstreetmap.josm.data.osm.search.SearchCompiler;
import org.openstreetmap.josm.data.osm.search.SearchParseError;
import org.openstreetmap.josm.data.osm.visitor.BoundingXYVisitor;
import org.openstreetmap.josm.gui.MainApplication;
import org.openstreetmap.josm.gui.MapFrame;
import org.openstreetmap.josm.gui.Notification;
import org.openstreetmap.josm.gui.util.GuiHelper;
import org.openstreetmap.josm.io.remotecontrol.AddTagsDialog;
import org.openstreetmap.josm.io.remotecontrol.PermissionPrefWithDefault;
import org.openstreetmap.josm.io.remotecontrol.handler.RequestHandler;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.Logging;
import org.openstreetmap.josm.tools.SubclassFilteredCollection;
import org.openstreetmap.josm.tools.Utils;

public class LoadAndZoomHandler
extends RequestHandler {
    public static final String command = "load_and_zoom";
    public static final String command2 = "zoom";
    private static final String CURRENT_SELECTION = "currentselection";
    private double minlat;
    private double maxlat;
    private double minlon;
    private double maxlon;
    private final Set<SimplePrimitiveId> toSelect = new LinkedHashSet<SimplePrimitiveId>();
    private boolean isKeepingCurrentSelection;

    @Override
    public String getPermissionMessage() {
        String msg = I18n.tr("Remote Control has been asked to load data from the API.", new Object[0]) + "<br>" + I18n.tr("Bounding box: ", new Object[0]) + new BBox(this.minlon, this.minlat, this.maxlon, this.maxlat).toStringCSV(", ");
        if (this.args.containsKey("select") && !this.toSelect.isEmpty()) {
            msg = msg + "<br>" + I18n.tr("Selection: {0}", this.toSelect.size());
        }
        return msg;
    }

    @Override
    public String[] getMandatoryParams() {
        return new String[]{"bottom", "top", "left", "right"};
    }

    @Override
    public String[] getOptionalParams() {
        return new String[]{"new_layer", "layer_name", "addtags", "select", "zoom_mode", "changeset_comment", "changeset_source", "changeset_hashtags", "changeset_tags", "search", "layer_locked", "download_policy", "upload_policy"};
    }

    @Override
    public String getUsage() {
        return "download a bounding box from the API, zoom to the downloaded area and optionally select one or more objects";
    }

    @Override
    public String[] getUsageExamples() {
        return this.getUsageExamples(this.myCommand);
    }

    @Override
    public String[] getUsageExamples(String cmd) {
        if (command.equals(cmd)) {
            return new String[]{"/load_and_zoom?addtags=wikipedia:de=Wei%C3%9Fe_Gasse|maxspeed=5&select=way23071688,way23076176,way23076177,&left=13.740&right=13.741&top=51.05&bottom=51.049", "/load_and_zoom?left=8.19&right=8.20&top=48.605&bottom=48.590&select=node413602999&new_layer=true"};
        }
        return new String[]{"/zoom?left=8.19&right=8.20&top=48.605&bottom=48.590&select=node413602999", "/zoom?left=8.19&right=8.20&top=48.605&bottom=48.590&search=highway+OR+railway", "/zoom?left=8.19&right=8.20&top=48.605&bottom=48.590&search=currentselection&addtags=foo=bar"};
    }

    @Override
    protected void handleRequest() throws RequestHandler.RequestHandlerErrorException {
        DownloadOsmTask osmTask = new DownloadOsmTask();
        try {
            DownloadParams settings = this.getDownloadParams();
            if (command.equals(this.myCommand)) {
                if (!PermissionPrefWithDefault.LOAD_DATA.isAllowed()) {
                    Logging.info("RemoteControl: download forbidden by preferences");
                } else {
                    Area toDownload = null;
                    if (!settings.isNewLayer()) {
                        Area present = null;
                        DataSet ds = MainApplication.getLayerManager().getEditDataSet();
                        if (ds != null) {
                            present = ds.getDataSourceArea();
                        }
                        if (present != null && !present.isEmpty()) {
                            toDownload = new Area(new Rectangle2D.Double(this.minlon, this.minlat, this.maxlon - this.minlon, this.maxlat - this.minlat));
                            toDownload.subtract(present);
                            if (!toDownload.isEmpty()) {
                                Rectangle2D downloadBounds = toDownload.getBounds2D();
                                this.minlat = downloadBounds.getMinY();
                                this.minlon = downloadBounds.getMinX();
                                this.maxlat = downloadBounds.getMaxY();
                                this.maxlon = downloadBounds.getMaxX();
                            }
                        }
                    }
                    if (toDownload != null && toDownload.isEmpty()) {
                        Logging.info("RemoteControl: no download necessary");
                    } else {
                        Future<?> future = osmTask.download(settings, new Bounds(this.minlat, this.minlon, this.maxlat, this.maxlon), null);
                        MainApplication.worker.submit(new PostDownloadHandler(osmTask, future));
                    }
                }
            }
        }
        catch (RuntimeException ex) {
            Logging.warn("RemoteControl: Error parsing load_and_zoom remote control request:");
            Logging.error(ex);
            throw new RequestHandler.RequestHandlerErrorException(ex);
        }
        if (this.args.containsKey("addtags") && !this.isKeepingCurrentSelection) {
            GuiHelper.executeByMainWorkerInEDT(() -> {
                DataSet ds = MainApplication.getLayerManager().getEditDataSet();
                if (ds == null) {
                    return;
                }
                ds.clearSelection();
            });
        }
        LinkedHashSet forTagAdd = new LinkedHashSet();
        Bounds bbox = new Bounds(this.minlat, this.minlon, this.maxlat, this.maxlon);
        if (this.args.containsKey("select") && PermissionPrefWithDefault.CHANGE_SELECTION.isAllowed()) {
            GuiHelper.executeByMainWorkerInEDT(() -> {
                LinkedHashSet<OsmPrimitive> newSel = new LinkedHashSet<OsmPrimitive>();
                DataSet ds = MainApplication.getLayerManager().getEditDataSet();
                if (ds == null) {
                    return;
                }
                for (SimplePrimitiveId id : this.toSelect) {
                    OsmPrimitive p = ds.getPrimitiveById(id);
                    if (p == null) continue;
                    newSel.add(p);
                    forTagAdd.add(p);
                }
                if (this.isKeepingCurrentSelection) {
                    Collection sel = ds.getSelected();
                    newSel.addAll(sel);
                    forTagAdd.addAll(sel);
                }
                this.toSelect.clear();
                ds.setSelected(newSel);
                this.zoom(newSel, bbox);
                MapFrame map = MainApplication.getMap();
                if (MainApplication.isDisplayingMapView() && map.relationListDialog != null) {
                    map.relationListDialog.selectRelations(null);
                    map.relationListDialog.dataChanged(null);
                    map.relationListDialog.selectRelations(Utils.filteredCollection(newSel, Relation.class));
                }
            });
        } else if (this.args.containsKey("search") && PermissionPrefWithDefault.CHANGE_SELECTION.isAllowed()) {
            try {
                SearchCompiler.Match search = SearchCompiler.compile((String)this.args.get("search"));
                MainApplication.worker.submit(() -> {
                    DataSet ds = MainApplication.getLayerManager().getEditDataSet();
                    SubclassFilteredCollection<OsmPrimitive, OsmPrimitive> filteredPrimitives = SubclassFilteredCollection.filter(ds.allPrimitives(), search);
                    ds.setSelected(filteredPrimitives);
                    forTagAdd.addAll(filteredPrimitives);
                    this.zoom(filteredPrimitives, bbox);
                });
            }
            catch (SearchParseError ex) {
                Logging.error(ex);
                throw new RequestHandler.RequestHandlerErrorException(ex);
            }
        } else {
            this.zoom(Collections.emptySet(), bbox);
        }
        if (this.args.containsKey("changeset_tags")) {
            MainApplication.worker.submit(() -> {
                DataSet ds = MainApplication.getLayerManager().getEditDataSet();
                if (ds != null) {
                    for (String[] key : AddTagsDialog.parseUrlTagsToKeyValues((String)this.args.get("changeset_tags"))) {
                        ds.addChangeSetTag(key[0], key[1]);
                    }
                }
            });
        }
        if (this.args.containsKey("changeset_comment") || this.args.containsKey("changeset_source") || this.args.containsKey("changeset_hashtags")) {
            MainApplication.worker.submit(() -> {
                DataSet ds = MainApplication.getLayerManager().getEditDataSet();
                if (ds != null) {
                    for (String tag : Arrays.asList("changeset_comment", "changeset_source", "changeset_hashtags")) {
                        if (!this.args.containsKey(tag)) continue;
                        ds.addChangeSetTag(tag.substring("changeset_".length()), (String)this.args.get(tag));
                    }
                }
            });
        }
        if (this.args.containsKey("addtags")) {
            GuiHelper.executeByMainWorkerInEDT(() -> {
                if (!forTagAdd.isEmpty()) {
                    AddTagsDialog.addTags(this.args, this.sender, (Collection<? extends OsmPrimitive>)forTagAdd);
                } else {
                    new Notification(this.isKeepingCurrentSelection ? I18n.tr("You clicked on a JOSM remotecontrol link that would apply tags onto selected objects.\nSince no objects have been selected before this click, no tags were added.\nSelect one or more objects and click the link again.", new Object[0]) : I18n.tr("You clicked on a JOSM remotecontrol link that would apply tags onto objects.\nUnfortunately that link seems to be broken.\nTechnical explanation: the URL query parameter ''select='' or ''search='' has an invalid value.\nAsk someone at the origin of the clicked link to fix this.", new Object[0])).setIcon(2).setDuration(Notification.TIME_LONG).show();
                }
            });
        }
    }

    protected void zoom(Collection<OsmPrimitive> primitives, Bounds bbox) {
        if (!PermissionPrefWithDefault.CHANGE_VIEWPORT.isAllowed()) {
            return;
        }
        if (!"download".equals(this.args.get("zoom_mode")) && !primitives.isEmpty()) {
            AutoScaleAction.autoScale(AutoScaleAction.AutoScaleMode.SELECTION);
        } else if (MainApplication.isDisplayingMapView()) {
            GuiHelper.executeByMainWorkerInEDT(() -> {
                BoundingXYVisitor bbox1 = new BoundingXYVisitor();
                bbox1.visit(bbox);
                MainApplication.getMap().mapView.zoomTo(bbox1);
            });
        }
    }

    @Override
    public PermissionPrefWithDefault getPermissionPref() {
        return null;
    }

    @Override
    protected void validateRequest() throws RequestHandler.RequestHandlerBadRequestException {
        this.validateDownloadParams();
        this.minlat = 0.0;
        this.maxlat = 0.0;
        this.minlon = 0.0;
        this.maxlon = 0.0;
        try {
            this.minlat = LatLon.roundToOsmPrecision(Double.parseDouble(this.args != null ? (String)this.args.get("bottom") : ""));
            this.maxlat = LatLon.roundToOsmPrecision(Double.parseDouble(this.args != null ? (String)this.args.get("top") : ""));
            this.minlon = LatLon.roundToOsmPrecision(Double.parseDouble(this.args != null ? (String)this.args.get("left") : ""));
            this.maxlon = LatLon.roundToOsmPrecision(Double.parseDouble(this.args != null ? (String)this.args.get("right") : ""));
        }
        catch (NumberFormatException e) {
            throw new RequestHandler.RequestHandlerBadRequestException("NumberFormatException (" + e.getMessage() + ')', e);
        }
        if (!LatLon.isValidLat(this.minlat) || !LatLon.isValidLat(this.maxlat)) {
            throw new RequestHandler.RequestHandlerBadRequestException(I18n.tr("The latitudes must be between {0} and {1}", -90.0, 90.0));
        }
        if (!LatLon.isValidLon(this.minlon) || !LatLon.isValidLon(this.maxlon)) {
            throw new RequestHandler.RequestHandlerBadRequestException(I18n.tr("The longitudes must be between {0} and {1}", -180.0, 180.0));
        }
        if (this.minlat > this.maxlat || this.minlon > this.maxlon) {
            throw new RequestHandler.RequestHandlerBadRequestException(I18n.tr("The minima must be less than the maxima", new Object[0]));
        }
        if (this.args != null && this.args.containsKey("select")) {
            this.toSelect.clear();
            for (String item : ((String)this.args.get("select")).split(",")) {
                if (item.isEmpty()) continue;
                if (CURRENT_SELECTION.equalsIgnoreCase(item)) {
                    this.isKeepingCurrentSelection = true;
                    continue;
                }
                try {
                    this.toSelect.add(SimplePrimitiveId.fromString(item));
                }
                catch (IllegalArgumentException ex) {
                    Logging.log(Logging.LEVEL_WARN, "RemoteControl: invalid selection '" + item + "' ignored", ex);
                }
            }
        }
    }
}

