# -*- coding: utf-8 -*-
"""
Copyright (c) 2010-2014 Jennifer Ennis, William Tisäter.

This program is free software: you can redistribute it and/or modify
it under the terms of the GNU Lesser General Public License as published by
the Free Software Foundation, either version 3 of the License, or
(at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU Lesser General Public License
along with this program.  If not, see <http://www.gnu.org/licenses/lgpl.txt>.
"""

def time_zone_by_country_and_region(country_code, region_code=None):
    """
    Returns time zone from country and region code.

    :arg country_code: Country code
    :arg region_code: Region code
    """
    timezone = country_dict.get(country_code)
    if not timezone:
        return None

    if isinstance(timezone, str):
        return timezone

    return timezone.get(region_code)


country_dict = {
    'AD': 'Europe/Andorra',
    'AE': 'Asia/Dubai',
    'AF': 'Asia/Kabul',
    'AG': 'America/Antigua',
    'AI': 'America/Anguilla',
    'AL': 'Europe/Tirane',
    'AM': 'Asia/Yerevan',
    'AN': 'America/Curacao',
    'AO': 'Africa/Luanda',
    'AR': {
        '01': 'America/Argentina/Buenos_Aires',
        '02': 'America/Argentina/Catamarca',
        '03': 'America/Argentina/Tucuman',
        '04': 'America/Argentina/Rio_Gallegos',
        '05': 'America/Argentina/Cordoba',
        '06': 'America/Argentina/Tucuman',
        '07': 'America/Argentina/Buenos_Aires',
        '08': 'America/Argentina/Buenos_Aires',
        '09': 'America/Argentina/Tucuman',
        '10': 'America/Argentina/Jujuy',
        '11': 'America/Argentina/San_Luis',
        '12': 'America/Argentina/La_Rioja',
        '13': 'America/Argentina/Mendoza',
        '14': 'America/Argentina/Buenos_Aires',
        '15': 'America/Argentina/San_Luis',
        '16': 'America/Argentina/Buenos_Aires',
        '17': 'America/Argentina/Salta',
        '18': 'America/Argentina/San_Juan',
        '19': 'America/Argentina/San_Luis',
        '20': 'America/Argentina/Rio_Gallegos',
        '21': 'America/Argentina/Buenos_Aires',
        '22': 'America/Argentina/Catamarca',
        '23': 'America/Argentina/Ushuaia',
        '24': 'America/Argentina/Tucuman'
    },
    'AS': 'US/Samoa',
    'AT': 'Europe/Vienna',
    'AU': {
        '01': 'Australia/Canberra',
        '02': 'Australia/NSW',
        '03': 'Australia/North',
        '04': 'Australia/Queensland',
        '05': 'Australia/South',
        '06': 'Australia/Tasmania',
        '07': 'Australia/Victoria',
        '08': 'Australia/West'
    },
    'AW': 'America/Aruba',
    'AX': 'Europe/Mariehamn',
    'AZ': 'Asia/Baku',
    'BA': 'Europe/Sarajevo',
    'BB': 'America/Barbados',
    'BD': 'Asia/Dhaka',
    'BE': 'Europe/Brussels',
    'BF': 'Africa/Ouagadougou',
    'BG': 'Europe/Sofia',
    'BH': 'Asia/Bahrain',
    'BI': 'Africa/Bujumbura',
    'BJ': 'Africa/Porto-Novo',
    'BL': 'America/St_Barthelemy',
    'BM': 'Atlantic/Bermuda',
    'BN': 'Asia/Brunei',
    'BO': 'America/La_Paz',
    'BQ': 'America/Curacao',
    'BR': {
        '01': 'America/Rio_Branco',
        '02': 'America/Maceio',
        '03': 'America/Sao_Paulo',
        '04': 'America/Manaus',
        '05': 'America/Bahia',
        '06': 'America/Fortaleza',
        '07': 'America/Sao_Paulo',
        '08': 'America/Sao_Paulo',
        '11': 'America/Campo_Grande',
        '13': 'America/Belem',
        '14': 'America/Cuiaba',
        '15': 'America/Sao_Paulo',
        '16': 'America/Belem',
        '17': 'America/Recife',
        '18': 'America/Sao_Paulo',
        '20': 'America/Fortaleza',
        '21': 'America/Sao_Paulo',
        '22': 'America/Recife',
        '23': 'America/Sao_Paulo',
        '24': 'America/Porto_Velho',
        '25': 'America/Boa_Vista',
        '26': 'America/Sao_Paulo',
        '27': 'America/Sao_Paulo',
        '28': 'America/Maceio',
        '29': 'America/Sao_Paulo',
        '30': 'America/Recife',
        '31': 'America/Araguaina'
    },
    'BS': 'America/Nassau',
    'BT': 'Asia/Thimphu',
    'BW': 'Africa/Gaborone',
    'BY': 'Europe/Minsk',
    'BZ': 'America/Belize',
    'CA': {
        'AB': 'America/Edmonton',
        'BC': 'America/Vancouver',
        'MB': 'America/Winnipeg',
        'NB': 'America/Halifax',
        'NL': 'America/St_Johns',
        'NS': 'America/Halifax',
        'NT': 'America/Yellowknife',
        'NU': 'America/Rankin_Inlet',
        'ON': 'America/Toronto',
        'PE': 'America/Halifax',
        'QC': 'America/Montreal',
        'SK': 'America/Regina',
        'YT': 'America/Whitehorse'
    },
    'CC': 'Indian/Cocos',
    'CD': {
        '02': 'Africa/Kinshasa',
        '05': 'Africa/Lubumbashi',
        '06': 'Africa/Kinshasa',
        '08': 'Africa/Kinshasa',
        '10': 'Africa/Lubumbashi',
        '11': 'Africa/Lubumbashi',
        '12': 'Africa/Lubumbashi'
    },
    'CF': 'Africa/Bangui',
    'CG': 'Africa/Brazzaville',
    'CH': 'Europe/Zurich',
    'CI': 'Africa/Abidjan',
    'CK': 'Pacific/Rarotonga',
    'CL': 'Chile/Continental',
    'CM': 'Africa/Lagos',
    'CN': {
        '01': 'Asia/Shanghai',
        '02': 'Asia/Shanghai',
        '03': 'Asia/Shanghai',
        '04': 'Asia/Shanghai',
        '05': 'Asia/Harbin',
        '06': 'Asia/Chongqing',
        '07': 'Asia/Shanghai',
        '08': 'Asia/Harbin',
        '09': 'Asia/Shanghai',
        '10': 'Asia/Shanghai',
        '11': 'Asia/Chongqing',
        '12': 'Asia/Shanghai',
        '13': 'Asia/Urumqi',
        '14': 'Asia/Chongqing',
        '15': 'Asia/Chongqing',
        '16': 'Asia/Chongqing',
        '18': 'Asia/Chongqing',
        '19': 'Asia/Harbin',
        '20': 'Asia/Harbin',
        '21': 'Asia/Chongqing',
        '22': 'Asia/Harbin',
        '23': 'Asia/Shanghai',
        '24': 'Asia/Chongqing',
        '25': 'Asia/Shanghai',
        '26': 'Asia/Chongqing',
        '28': 'Asia/Shanghai',
        '29': 'Asia/Chongqing',
        '30': 'Asia/Chongqing',
        '31': 'Asia/Chongqing',
        '32': 'Asia/Chongqing',
        '33': 'Asia/Chongqing'
    },
    'CO': 'America/Bogota',
    'CR': 'America/Costa_Rica',
    'CU': 'America/Havana',
    'CV': 'Atlantic/Cape_Verde',
    'CW': 'America/Curacao',
    'CX': 'Indian/Christmas',
    'CY': 'Asia/Nicosia',
    'CZ': 'Europe/Prague',
    'DE': 'Europe/Berlin',
    'DJ': 'Africa/Djibouti',
    'DK': 'Europe/Copenhagen',
    'DM': 'America/Dominica',
    'DO': 'America/Santo_Domingo',
    'DZ': 'Africa/Algiers',
    'EC': {
        '01': 'Pacific/Galapagos',
        '02': 'America/Guayaquil',
        '03': 'America/Guayaquil',
        '04': 'America/Guayaquil',
        '05': 'America/Guayaquil',
        '06': 'America/Guayaquil',
        '07': 'America/Guayaquil',
        '08': 'America/Guayaquil',
        '09': 'America/Guayaquil',
        '10': 'America/Guayaquil',
        '11': 'America/Guayaquil',
        '12': 'America/Guayaquil',
        '13': 'America/Guayaquil',
        '14': 'America/Guayaquil',
        '15': 'America/Guayaquil',
        '17': 'America/Guayaquil',
        '18': 'America/Guayaquil',
        '19': 'America/Guayaquil',
        '20': 'America/Guayaquil',
        '22': 'America/Guayaquil'
    },
    'EE': 'Europe/Tallinn',
    'EG': 'Africa/Cairo',
    'EH': 'Africa/El_Aaiun',
    'ER': 'Africa/Asmera',
    'ES': {
        '07': 'Europe/Madrid',
        '27': 'Europe/Madrid',
        '29': 'Europe/Madrid',
        '31': 'Europe/Madrid',
        '32': 'Europe/Madrid',
        '34': 'Europe/Madrid',
        '39': 'Europe/Madrid',
        '51': 'Africa/Ceuta',
        '52': 'Europe/Madrid',
        '53': 'Atlantic/Canary',
        '54': 'Europe/Madrid',
        '55': 'Europe/Madrid',
        '56': 'Europe/Madrid',
        '57': 'Europe/Madrid',
        '58': 'Europe/Madrid',
        '59': 'Europe/Madrid',
        '60': 'Europe/Madrid'
    },
    'ET': 'Africa/Addis_Ababa',
    'FI': 'Europe/Helsinki',
    'FJ': 'Pacific/Fiji',
    'FK': 'Atlantic/Stanley',
    'FO': 'Atlantic/Faeroe',
    'FR': 'Europe/Paris',
    'FX': 'Europe/Paris',
    'GA': 'Africa/Libreville',
    'GB': 'Europe/London',
    'GD': 'America/Grenada',
    'GE': 'Asia/Tbilisi',
    'GF': 'America/Cayenne',
    'GG': 'Europe/Guernsey',
    'GH': 'Africa/Accra',
    'GI': 'Europe/Gibraltar',
    'GL': {
        '01': 'America/Thule',
        '02': 'America/Godthab',
        '03': 'America/Godthab'
    },
    'GM': 'Africa/Banjul',
    'GN': 'Africa/Conakry',
    'GP': 'America/Guadeloupe',
    'GQ': 'Africa/Malabo',
    'GR': 'Europe/Athens',
    'GS': 'Atlantic/South_Georgia',
    'GT': 'America/Guatemala',
    'GU': 'Pacific/Guam',
    'GW': 'Africa/Bissau',
    'GY': 'America/Guyana',
    'HK': 'Asia/Hong_Kong',
    'HN': 'America/Tegucigalpa',
    'HR': 'Europe/Zagreb',
    'HT': 'America/Port-au-Prince',
    'HU': 'Europe/Budapest',
    'ID': {
        '01': 'Asia/Pontianak',
        '02': 'Asia/Makassar',
        '03': 'Asia/Jakarta',
        '04': 'Asia/Jakarta',
        '05': 'Asia/Jakarta',
        '06': 'Asia/Jakarta',
        '07': 'Asia/Jakarta',
        '08': 'Asia/Jakarta',
        '09': 'Asia/Jayapura',
        '10': 'Asia/Jakarta',
        '11': 'Asia/Pontianak',
        '12': 'Asia/Makassar',
        '13': 'Asia/Makassar',
        '14': 'Asia/Makassar',
        '15': 'Asia/Jakarta',
        '16': 'Asia/Makassar',
        '17': 'Asia/Makassar',
        '18': 'Asia/Makassar',
        '19': 'Asia/Pontianak',
        '20': 'Asia/Makassar',
        '21': 'Asia/Makassar',
        '22': 'Asia/Makassar',
        '23': 'Asia/Makassar',
        '24': 'Asia/Jakarta',
        '25': 'Asia/Pontianak',
        '26': 'Asia/Pontianak',
        '30': 'Asia/Jakarta',
        '31': 'Asia/Makassar',
        '33': 'Asia/Jakarta'
    },
    'IE': 'Europe/Dublin',
    'IL': 'Asia/Jerusalem',
    'IM': 'Europe/Isle_of_Man',
    'IN': 'Asia/Calcutta',
    'IO': 'Indian/Chagos',
    'IQ': 'Asia/Baghdad',
    'IR': 'Asia/Tehran',
    'IS': 'Atlantic/Reykjavik',
    'IT': 'Europe/Rome',
    'JE': 'Europe/Jersey',
    'JM': 'America/Jamaica',
    'JO': 'Asia/Amman',
    'JP': 'Asia/Tokyo',
    'KE': 'Africa/Nairobi',
    'KG': 'Asia/Bishkek',
    'KH': 'Asia/Phnom_Penh',
    'KI': 'Pacific/Tarawa',
    'KM': 'Indian/Comoro',
    'KN': 'America/St_Kitts',
    'KP': 'Asia/Pyongyang',
    'KR': 'Asia/Seoul',
    'KW': 'Asia/Kuwait',
    'KY': 'America/Cayman',
    'KZ': {
        '01': 'Asia/Almaty',
        '02': 'Asia/Almaty',
        '03': 'Asia/Qyzylorda',
        '04': 'Asia/Aqtobe',
        '05': 'Asia/Qyzylorda',
        '06': 'Asia/Aqtau',
        '07': 'Asia/Oral',
        '08': 'Asia/Qyzylorda',
        '09': 'Asia/Aqtau',
        '10': 'Asia/Qyzylorda',
        '11': 'Asia/Almaty',
        '12': 'Asia/Qyzylorda',
        '13': 'Asia/Aqtobe',
        '14': 'Asia/Qyzylorda',
        '15': 'Asia/Almaty',
        '16': 'Asia/Aqtobe',
        '17': 'Asia/Almaty'
    },
    'LA': 'Asia/Vientiane',
    'LB': 'Asia/Beirut',
    'LC': 'America/St_Lucia',
    'LI': 'Europe/Vaduz',
    'LK': 'Asia/Colombo',
    'LR': 'Africa/Monrovia',
    'LS': 'Africa/Maseru',
    'LT': 'Europe/Vilnius',
    'LU': 'Europe/Luxembourg',
    'LV': 'Europe/Riga',
    'LY': 'Africa/Tripoli',
    'MA': 'Africa/Casablanca',
    'MC': 'Europe/Monaco',
    'MD': 'Europe/Chisinau',
    'ME': 'Europe/Podgorica',
    'MF': 'America/Marigot',
    'MG': 'Indian/Antananarivo',
    'MK': 'Europe/Skopje',
    'ML': 'Africa/Bamako',
    'MM': 'Asia/Rangoon',
    'MN': 'Asia/Choibalsan',
    'MO': 'Asia/Macao',
    'MP': 'Pacific/Saipan',
    'MQ': 'America/Martinique',
    'MR': 'Africa/Nouakchott',
    'MS': 'America/Montserrat',
    'MT': 'Europe/Malta',
    'MU': 'Indian/Mauritius',
    'MV': 'Indian/Maldives',
    'MW': 'Africa/Blantyre',
    'MX': {
        '01': 'America/Mexico_City',
        '02': 'America/Tijuana',
        '03': 'America/Hermosillo',
        '04': 'America/Merida',
        '05': 'America/Mexico_City',
        '06': 'America/Chihuahua',
        '07': 'America/Monterrey',
        '08': 'America/Mexico_City',
        '09': 'America/Mexico_City',
        '10': 'America/Mazatlan',
        '11': 'America/Mexico_City',
        '12': 'America/Mexico_City',
        '13': 'America/Mexico_City',
        '14': 'America/Mazatlan',
        '15': 'America/Chihuahua',
        '16': 'America/Mexico_City',
        '17': 'America/Mexico_City',
        '18': 'America/Mazatlan',
        '19': 'America/Monterrey',
        '20': 'America/Mexico_City',
        '21': 'America/Mexico_City',
        '22': 'America/Mexico_City',
        '23': 'America/Cancun',
        '24': 'America/Mexico_City',
        '25': 'America/Mazatlan',
        '26': 'America/Hermosillo',
        '27': 'America/Merida',
        '28': 'America/Monterrey',
        '29': 'America/Mexico_City',
        '30': 'America/Mexico_City',
        '31': 'America/Merida',
        '32': 'America/Monterrey'
    },
    'MY': {
        '01': 'Asia/Kuala_Lumpur',
        '02': 'Asia/Kuala_Lumpur',
        '03': 'Asia/Kuala_Lumpur',
        '04': 'Asia/Kuala_Lumpur',
        '05': 'Asia/Kuala_Lumpur',
        '06': 'Asia/Kuala_Lumpur',
        '07': 'Asia/Kuala_Lumpur',
        '08': 'Asia/Kuala_Lumpur',
        '09': 'Asia/Kuala_Lumpur',
        '11': 'Asia/Kuching',
        '12': 'Asia/Kuala_Lumpur',
        '13': 'Asia/Kuala_Lumpur',
        '14': 'Asia/Kuala_Lumpur',
        '15': 'Asia/Kuching',
        '16': 'Asia/Kuching'
    },
    'MZ': 'Africa/Maputo',
    'NA': 'Africa/Windhoek',
    'NC': 'Pacific/Noumea',
    'NE': 'Africa/Niamey',
    'NF': 'Pacific/Norfolk',
    'NG': 'Africa/Lagos',
    'NI': 'America/Managua',
    'NL': 'Europe/Amsterdam',
    'NO': 'Europe/Oslo',
    'NP': 'Asia/Katmandu',
    'NR': 'Pacific/Nauru',
    'NU': 'Pacific/Niue',
    'NZ': {
        '85': 'Pacific/Auckland',
        'E7': 'Pacific/Auckland',
        'E8': 'Pacific/Auckland',
        'E9': 'Pacific/Auckland',
        'F1': 'Pacific/Auckland',
        'F2': 'Pacific/Auckland',
        'F3': 'Pacific/Auckland',
        'F4': 'Pacific/Auckland',
        'F5': 'Pacific/Auckland',
        'F7': 'Pacific/Chatham',
        'F8': 'Pacific/Auckland',
        'F9': 'Pacific/Auckland',
        'G1': 'Pacific/Auckland',
        'G2': 'Pacific/Auckland',
        'G3': 'Pacific/Auckland'
    },
    'OM': 'Asia/Muscat',
    'PA': 'America/Panama',
    'PE': 'America/Lima',
    'PF': 'Pacific/Marquesas',
    'PG': 'Pacific/Port_Moresby',
    'PH': 'Asia/Manila',
    'PK': 'Asia/Karachi',
    'PL': 'Europe/Warsaw',
    'PM': 'America/Miquelon',
    'PN': 'Pacific/Pitcairn',
    'PR': 'America/Puerto_Rico',
    'PS': 'Asia/Gaza',
    'PT': {
        '02': 'Europe/Lisbon',
        '03': 'Europe/Lisbon',
        '04': 'Europe/Lisbon',
        '05': 'Europe/Lisbon',
        '06': 'Europe/Lisbon',
        '07': 'Europe/Lisbon',
        '08': 'Europe/Lisbon',
        '09': 'Europe/Lisbon',
        '10': 'Atlantic/Madeira',
        '11': 'Europe/Lisbon',
        '13': 'Europe/Lisbon',
        '14': 'Europe/Lisbon',
        '16': 'Europe/Lisbon',
        '17': 'Europe/Lisbon',
        '18': 'Europe/Lisbon',
        '19': 'Europe/Lisbon',
        '20': 'Europe/Lisbon',
        '21': 'Europe/Lisbon',
        '22': 'Europe/Lisbon'
    },
    'PW': 'Pacific/Palau',
    'PY': 'America/Asuncion',
    'QA': 'Asia/Qatar',
    'RE': 'Indian/Reunion',
    'RO': 'Europe/Bucharest',
    'RS': 'Europe/Belgrade',
    'RU': {
        '01': 'Europe/Volgograd',
        '02': 'Asia/Irkutsk',
        '03': 'Asia/Novokuznetsk',
        '04': 'Asia/Novosibirsk',
        '05': 'Asia/Vladivostok',
        '06': 'Europe/Moscow',
        '07': 'Europe/Volgograd',
        '08': 'Europe/Samara',
        '09': 'Europe/Moscow',
        '10': 'Europe/Moscow',
        '11': 'Asia/Irkutsk',
        '13': 'Asia/Yekaterinburg',
        '14': 'Asia/Irkutsk',
        '15': 'Asia/Anadyr',
        '16': 'Europe/Samara',
        '17': 'Europe/Volgograd',
        '18': 'Asia/Krasnoyarsk',
        '20': 'Asia/Irkutsk',
        '21': 'Europe/Moscow',
        '22': 'Europe/Volgograd',
        '23': 'Europe/Kaliningrad',
        '24': 'Europe/Volgograd',
        '25': 'Europe/Moscow',
        '26': 'Asia/Kamchatka',
        '27': 'Europe/Volgograd',
        '28': 'Europe/Moscow',
        '29': 'Asia/Novokuznetsk',
        '30': 'Asia/Vladivostok',
        '31': 'Asia/Krasnoyarsk',
        '32': 'Asia/Omsk',
        '33': 'Asia/Yekaterinburg',
        '34': 'Asia/Yekaterinburg',
        '35': 'Asia/Yekaterinburg',
        '36': 'Asia/Anadyr',
        '37': 'Europe/Moscow',
        '38': 'Europe/Volgograd',
        '39': 'Asia/Krasnoyarsk',
        '40': 'Asia/Yekaterinburg',
        '41': 'Europe/Moscow',
        '42': 'Europe/Moscow',
        '43': 'Europe/Moscow',
        '44': 'Asia/Magadan',
        '45': 'Europe/Samara',
        '46': 'Europe/Samara',
        '47': 'Europe/Moscow',
        '48': 'Europe/Moscow',
        '49': 'Europe/Moscow',
        '50': 'Asia/Yekaterinburg',
        '51': 'Europe/Moscow',
        '52': 'Europe/Moscow',
        '53': 'Asia/Novosibirsk',
        '54': 'Asia/Omsk',
        '55': 'Europe/Samara',
        '56': 'Europe/Moscow',
        '57': 'Europe/Samara',
        '58': 'Asia/Yekaterinburg',
        '59': 'Asia/Vladivostok',
        '60': 'Europe/Kaliningrad',
        '61': 'Europe/Volgograd',
        '62': 'Europe/Moscow',
        '63': 'Asia/Yakutsk',
        '64': 'Asia/Sakhalin',
        '65': 'Europe/Samara',
        '66': 'Europe/Moscow',
        '67': 'Europe/Samara',
        '68': 'Europe/Volgograd',
        '69': 'Europe/Moscow',
        '70': 'Europe/Volgograd',
        '71': 'Asia/Yekaterinburg',
        '72': 'Europe/Moscow',
        '73': 'Europe/Samara',
        '74': 'Asia/Krasnoyarsk',
        '75': 'Asia/Novosibirsk',
        '76': 'Europe/Moscow',
        '77': 'Europe/Moscow',
        '78': 'Asia/Yekaterinburg',
        '79': 'Asia/Irkutsk',
        '80': 'Asia/Yekaterinburg',
        '81': 'Europe/Samara',
        '82': 'Asia/Irkutsk',
        '83': 'Europe/Moscow',
        '84': 'Europe/Volgograd',
        '85': 'Europe/Moscow',
        '86': 'Europe/Moscow',
        '87': 'Asia/Novosibirsk',
        '88': 'Europe/Moscow',
        '89': 'Asia/Vladivostok'
    },
    'RW': 'Africa/Kigali',
    'SA': 'Asia/Riyadh',
    'SB': 'Pacific/Guadalcanal',
    'SC': 'Indian/Mahe',
    'SD': 'Africa/Khartoum',
    'SE': 'Europe/Stockholm',
    'SG': 'Asia/Singapore',
    'SH': 'Atlantic/St_Helena',
    'SI': 'Europe/Ljubljana',
    'SJ': 'Arctic/Longyearbyen',
    'SK': 'Europe/Bratislava',
    'SL': 'Africa/Freetown',
    'SM': 'Europe/San_Marino',
    'SN': 'Africa/Dakar',
    'SO': 'Africa/Mogadishu',
    'SR': 'America/Paramaribo',
    'SS': 'Africa/Juba',
    'ST': 'Africa/Sao_Tome',
    'SV': 'America/El_Salvador',
    'SX': 'America/Curacao',
    'SY': 'Asia/Damascus',
    'SZ': 'Africa/Mbabane',
    'TC': 'America/Grand_Turk',
    'TD': 'Africa/Ndjamena',
    'TF': 'Indian/Kerguelen',
    'TG': 'Africa/Lome',
    'TH': 'Asia/Bangkok',
    'TJ': 'Asia/Dushanbe',
    'TK': 'Pacific/Fakaofo',
    'TL': 'Asia/Dili',
    'TM': 'Asia/Ashgabat',
    'TN': 'Africa/Tunis',
    'TO': 'Pacific/Tongatapu',
    'TR': 'Asia/Istanbul',
    'TT': 'America/Port_of_Spain',
    'TV': 'Pacific/Funafuti',
    'TW': 'Asia/Taipei',
    'TZ': 'Africa/Dar_es_Salaam',
    'UA': {
        '01': 'Europe/Kiev',
        '02': 'Europe/Kiev',
        '03': 'Europe/Uzhgorod',
        '04': 'Europe/Zaporozhye',
        '05': 'Europe/Zaporozhye',
        '06': 'Europe/Uzhgorod',
        '07': 'Europe/Zaporozhye',
        '08': 'Europe/Simferopol',
        '09': 'Europe/Kiev',
        '10': 'Europe/Zaporozhye',
        '11': 'Europe/Simferopol',
        '12': 'Europe/Kiev',
        '13': 'Europe/Kiev',
        '14': 'Europe/Zaporozhye',
        '15': 'Europe/Uzhgorod',
        '16': 'Europe/Zaporozhye',
        '17': 'Europe/Simferopol',
        '18': 'Europe/Zaporozhye',
        '19': 'Europe/Kiev',
        '20': 'Europe/Simferopol',
        '21': 'Europe/Kiev',
        '22': 'Europe/Uzhgorod',
        '23': 'Europe/Kiev',
        '24': 'Europe/Uzhgorod',
        '25': 'Europe/Uzhgorod',
        '26': 'Europe/Zaporozhye',
        '27': 'Europe/Kiev'
    },
    'UG': 'Africa/Kampala',
    'US': {
        'AK': 'America/Anchorage',
        'AL': 'America/Chicago',
        'AR': 'America/Chicago',
        'AZ': 'America/Phoenix',
        'CA': 'America/Los_Angeles',
        'CO': 'America/Denver',
        'CT': 'America/New_York',
        'DC': 'America/New_York',
        'DE': 'America/New_York',
        'FL': 'America/New_York',
        'GA': 'America/New_York',
        'HI': 'Pacific/Honolulu',
        'IA': 'America/Chicago',
        'ID': 'America/Denver',
        'IL': 'America/Chicago',
        'IN': 'America/Indianapolis',
        'KS': 'America/Chicago',
        'KY': 'America/New_York',
        'LA': 'America/Chicago',
        'MA': 'America/New_York',
        'MD': 'America/New_York',
        'ME': 'America/New_York',
        'MI': 'America/New_York',
        'MN': 'America/Chicago',
        'MO': 'America/Chicago',
        'MS': 'America/Chicago',
        'MT': 'America/Denver',
        'NC': 'America/New_York',
        'ND': 'America/Chicago',
        'NE': 'America/Chicago',
        'NH': 'America/New_York',
        'NJ': 'America/New_York',
        'NM': 'America/Denver',
        'NV': 'America/Los_Angeles',
        'NY': 'America/New_York',
        'OH': 'America/New_York',
        'OK': 'America/Chicago',
        'OR': 'America/Los_Angeles',
        'PA': 'America/New_York',
        'RI': 'America/New_York',
        'SC': 'America/New_York',
        'SD': 'America/Chicago',
        'TN': 'America/Chicago',
        'TX': 'America/Chicago',
        'UT': 'America/Denver',
        'VA': 'America/New_York',
        'VT': 'America/New_York',
        'WA': 'America/Los_Angeles',
        'WI': 'America/Chicago',
        'WV': 'America/New_York',
        'WY': 'America/Denver'
    },
    'UY': 'America/Montevideo',
    'UZ': {
        '01': 'Asia/Tashkent',
        '02': 'Asia/Samarkand',
        '03': 'Asia/Tashkent',
        '06': 'Asia/Tashkent',
        '07': 'Asia/Samarkand',
        '08': 'Asia/Samarkand',
        '09': 'Asia/Samarkand',
        '10': 'Asia/Samarkand',
        '12': 'Asia/Samarkand',
        '13': 'Asia/Tashkent',
        '14': 'Asia/Tashkent'
    },
    'VA': 'Europe/Vatican',
    'VC': 'America/St_Vincent',
    'VE': 'America/Caracas',
    'VG': 'America/Tortola',
    'VI': 'America/St_Thomas',
    'VN': 'Asia/Phnom_Penh',
    'VU': 'Pacific/Efate',
    'WF': 'Pacific/Wallis',
    'WS': 'Pacific/Samoa',
    'YE': 'Asia/Aden',
    'YT': 'Indian/Mayotte',
    'YU': 'Europe/Belgrade',
    'ZA': 'Africa/Johannesburg',
    'ZM': 'Africa/Lusaka',
    'ZW': 'Africa/Harare'
}
