/*
 * Decompiled with CFR 0.152.
 */
package net.sf.sdedit.ui.components;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JTable;
import javax.swing.SwingUtilities;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableModel;
import net.sf.sdedit.util.UIUtilities;

public class PropertyTable
extends JComponent
implements TableModel,
TableCellRenderer,
MouseListener {
    private static final long serialVersionUID = 6758557956454728031L;
    private JTable table;
    private Map<String, String> properties;
    private List<TableModelListener> listeners;
    private List<PropertyChangeListener> pclisteners;
    private Set<String> editableProperties;
    private TableCellRenderer tcr;
    private Map<String, JButton> buttons;

    public PropertyTable(int keyWidth, int valueWidth) {
        this.setLayout(new BorderLayout());
        this.buttons = new HashMap<String, JButton>();
        this.properties = new LinkedHashMap<String, String>();
        this.listeners = new LinkedList<TableModelListener>();
        this.pclisteners = new LinkedList<PropertyChangeListener>();
        this.editableProperties = new HashSet<String>();
        this.table = new JTable(this);
        this.table.setTableHeader(null);
        this.add((Component)this.table, "West");
        UIUtilities.setColumnWidths(this.table, keyWidth, valueWidth, 100);
        this.table.setOpaque(false);
        this.table.setShowGrid(false);
        this.tcr = this.table.getDefaultRenderer(String.class);
        this.table.setDefaultRenderer(String.class, this);
        this.table.addMouseListener(this);
    }

    public void addProperty(String key, String value, boolean editable, JButton button) {
        this.properties.put(key, value);
        if (editable) {
            this.editableProperties.add(key);
        }
        if (button != null) {
            this.buttons.put(key, button);
        }
    }

    @Override
    public void addTableModelListener(TableModelListener l) {
        this.listeners.add(l);
    }

    @Override
    public void addPropertyChangeListener(PropertyChangeListener pcl) {
        this.pclisteners.add(pcl);
    }

    @Override
    public void removePropertyChangeListener(PropertyChangeListener pcl) {
        this.pclisteners.remove(pcl);
    }

    @Override
    public Class<?> getColumnClass(int columnIndex) {
        return String.class;
    }

    @Override
    public int getColumnCount() {
        return 3;
    }

    @Override
    public String getColumnName(int columnIndex) {
        return "";
    }

    @Override
    public int getRowCount() {
        return this.properties.size();
    }

    protected String getKey(int rowIndex) {
        ArrayList<String> keys = new ArrayList<String>();
        keys.addAll(this.properties.keySet());
        String key = (String)keys.get(rowIndex);
        return key;
    }

    @Override
    public Object getValueAt(int rowIndex, int columnIndex) {
        if (columnIndex == 2) {
            return "";
        }
        String key = this.getKey(rowIndex);
        if (columnIndex == 0) {
            return key;
        }
        return this.properties.get(key);
    }

    @Override
    public boolean isCellEditable(int rowIndex, int columnIndex) {
        if (columnIndex != 1) {
            return false;
        }
        String key = this.getKey(rowIndex);
        return this.editableProperties.contains(key);
    }

    @Override
    public void removeTableModelListener(TableModelListener l) {
        this.listeners.remove(l);
    }

    @Override
    public void setValueAt(Object value, int rowIndex, int columnIndex) {
        String key = this.getKey(rowIndex);
        String old = this.properties.get(key);
        this.properties.put(key, String.valueOf(value));
        PropertyChangeEvent pce = new PropertyChangeEvent(this, key, old, value);
        TableModelEvent tme = new TableModelEvent(this, rowIndex, rowIndex, columnIndex);
        for (TableModelListener tml : this.listeners) {
            tml.tableChanged(tme);
        }
        for (PropertyChangeListener pcl : this.pclisteners) {
            pcl.propertyChange(pce);
        }
    }

    @Override
    public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
        if (column == 2) {
            String key = this.getKey(row);
            JButton button = this.buttons.get(key);
            if (button == null) {
                return new JLabel();
            }
            return button;
        }
        boolean editable = this.isCellEditable(row, column);
        int borderRight = column == 0 ? 5 : 1;
        JLabel label = (JLabel)this.tcr.getTableCellRendererComponent(table, value, false, false, row, column);
        if (editable) {
            label.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createLineBorder(Color.black, 1), BorderFactory.createEmptyBorder(13, 0, 13, 0)));
        } else {
            label.setBorder(BorderFactory.createEmptyBorder(14, 1, 14, borderRight));
        }
        label.setOpaque(editable);
        if (column == 0) {
            label.setHorizontalAlignment(11);
        } else {
            label.setHorizontalAlignment(10);
        }
        return label;
    }

    @Override
    public void mouseClicked(MouseEvent e) {
        JButton button;
        int row;
        String key;
        int column;
        if (SwingUtilities.isLeftMouseButton(e) && (column = this.table.getSelectedColumn()) == 2 && (key = this.getKey(row = this.table.getSelectedRow())) != null && (button = this.buttons.get(key)) != null) {
            if (button.getAction() != null) {
                button.getAction().actionPerformed(null);
            } else {
                ActionEvent ae = new ActionEvent(button, 0, "");
                for (ActionListener al : button.getActionListeners()) {
                    al.actionPerformed(ae);
                }
            }
        }
    }

    @Override
    public void mouseEntered(MouseEvent e) {
    }

    @Override
    public void mouseExited(MouseEvent e) {
    }

    @Override
    public void mousePressed(MouseEvent e) {
    }

    @Override
    public void mouseReleased(MouseEvent e) {
    }
}

