/*
 * Decompiled with CFR 0.152.
 */
package com.jcraft.jsch;

import com.jcraft.jsch.Buffer;
import com.jcraft.jsch.Cipher;
import com.jcraft.jsch.HASH;
import com.jcraft.jsch.JSch;
import com.jcraft.jsch.JSchException;
import com.jcraft.jsch.KeyPairDSA;
import com.jcraft.jsch.KeyPairECDSA;
import com.jcraft.jsch.KeyPairPKCS8;
import com.jcraft.jsch.KeyPairRSA;
import com.jcraft.jsch.Random;
import com.jcraft.jsch.Session;
import com.jcraft.jsch.Signature;
import com.jcraft.jsch.Util;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Hashtable;
import java.util.Vector;

public abstract class KeyPair {
    public static final int ERROR = 0;
    public static final int DSA = 1;
    public static final int RSA = 2;
    public static final int ECDSA = 3;
    public static final int UNKNOWN = 4;
    static final int VENDOR_OPENSSH = 0;
    static final int VENDOR_FSECURE = 1;
    static final int VENDOR_PUTTY = 2;
    static final int VENDOR_PKCS8 = 3;
    int vendor = 0;
    private static final byte[] cr = Util.str2byte("\n");
    protected String publicKeyComment = "no comment";
    JSch jsch = null;
    private Cipher cipher;
    private HASH hash;
    private Random random;
    private byte[] passphrase;
    static byte[][] header = new byte[][]{Util.str2byte("Proc-Type: 4,ENCRYPTED"), Util.str2byte("DEK-Info: DES-EDE3-CBC,")};
    private static byte[] space = Util.str2byte(" ");
    protected boolean encrypted = false;
    protected byte[] data = null;
    private byte[] iv = null;
    private byte[] publickeyblob = null;
    private static final String[] header1 = new String[]{"PuTTY-User-Key-File-2: ", "Encryption: ", "Comment: ", "Public-Lines: "};
    private static final String[] header2 = new String[]{"Private-Lines: "};
    private static final String[] header3 = new String[]{"Private-MAC: "};

    public static KeyPair genKeyPair(JSch jSch, int n) throws JSchException {
        return KeyPair.genKeyPair(jSch, n, 1024);
    }

    public static KeyPair genKeyPair(JSch jSch, int n, int n2) throws JSchException {
        KeyPair keyPair = null;
        if (n == 1) {
            keyPair = new KeyPairDSA(jSch);
        } else if (n == 2) {
            keyPair = new KeyPairRSA(jSch);
        } else if (n == 3) {
            keyPair = new KeyPairECDSA(jSch);
        }
        if (keyPair != null) {
            keyPair.generate(n2);
        }
        return keyPair;
    }

    abstract void generate(int var1) throws JSchException;

    abstract byte[] getBegin();

    abstract byte[] getEnd();

    abstract int getKeySize();

    public abstract byte[] getSignature(byte[] var1);

    public abstract Signature getVerifier();

    public abstract byte[] forSSHAgent() throws JSchException;

    public String getPublicKeyComment() {
        return this.publicKeyComment;
    }

    public void setPublicKeyComment(String string) {
        this.publicKeyComment = string;
    }

    public KeyPair(JSch jSch) {
        this.jsch = jSch;
    }

    abstract byte[] getPrivateKey();

    public void writePrivateKey(OutputStream outputStream) {
        this.writePrivateKey(outputStream, null);
    }

    public void writePrivateKey(OutputStream outputStream, byte[] byArray) {
        byte[][] byArrayArray;
        byte[] byArray2;
        byte[] byArray3;
        if (byArray == null) {
            byArray = this.passphrase;
        }
        if ((byArray3 = this.encrypt(byArray2 = this.getPrivateKey(), byArrayArray = new byte[1][], byArray)) != byArray2) {
            Util.bzero(byArray2);
        }
        byte[] byArray4 = byArrayArray[0];
        byte[] byArray5 = Util.toBase64(byArray3, 0, byArray3.length);
        try {
            int n;
            outputStream.write(this.getBegin());
            outputStream.write(cr);
            if (byArray != null) {
                outputStream.write(header[0]);
                outputStream.write(cr);
                outputStream.write(header[1]);
                for (n = 0; n < byArray4.length; ++n) {
                    outputStream.write(KeyPair.b2a((byte)(byArray4[n] >>> 4 & 0xF)));
                    outputStream.write(KeyPair.b2a((byte)(byArray4[n] & 0xF)));
                }
                outputStream.write(cr);
                outputStream.write(cr);
            }
            for (n = 0; n < byArray5.length; n += 64) {
                if (n + 64 < byArray5.length) {
                    outputStream.write(byArray5, n, 64);
                    outputStream.write(cr);
                    continue;
                }
                outputStream.write(byArray5, n, byArray5.length - n);
                outputStream.write(cr);
                break;
            }
            outputStream.write(this.getEnd());
            outputStream.write(cr);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    abstract byte[] getKeyTypeName();

    public abstract int getKeyType();

    public byte[] getPublicKeyBlob() {
        return this.publickeyblob;
    }

    public void writePublicKey(OutputStream outputStream, String string) {
        byte[] byArray = this.getPublicKeyBlob();
        byte[] byArray2 = Util.toBase64(byArray, 0, byArray.length);
        try {
            outputStream.write(this.getKeyTypeName());
            outputStream.write(space);
            outputStream.write(byArray2, 0, byArray2.length);
            outputStream.write(space);
            outputStream.write(Util.str2byte(string));
            outputStream.write(cr);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void writePublicKey(String string, String string2) throws FileNotFoundException, IOException {
        FileOutputStream fileOutputStream = new FileOutputStream(string);
        this.writePublicKey(fileOutputStream, string2);
        fileOutputStream.close();
    }

    public void writeSECSHPublicKey(OutputStream outputStream, String string) {
        byte[] byArray = this.getPublicKeyBlob();
        byte[] byArray2 = Util.toBase64(byArray, 0, byArray.length);
        try {
            int n;
            outputStream.write(Util.str2byte("---- BEGIN SSH2 PUBLIC KEY ----"));
            outputStream.write(cr);
            outputStream.write(Util.str2byte("Comment: \"" + string + "\""));
            outputStream.write(cr);
            for (int i = 0; i < byArray2.length; i += n) {
                n = 70;
                if (byArray2.length - i < n) {
                    n = byArray2.length - i;
                }
                outputStream.write(byArray2, i, n);
                outputStream.write(cr);
            }
            outputStream.write(Util.str2byte("---- END SSH2 PUBLIC KEY ----"));
            outputStream.write(cr);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void writeSECSHPublicKey(String string, String string2) throws FileNotFoundException, IOException {
        FileOutputStream fileOutputStream = new FileOutputStream(string);
        this.writeSECSHPublicKey(fileOutputStream, string2);
        fileOutputStream.close();
    }

    public void writePrivateKey(String string) throws FileNotFoundException, IOException {
        this.writePrivateKey(string, null);
    }

    public void writePrivateKey(String string, byte[] byArray) throws FileNotFoundException, IOException {
        FileOutputStream fileOutputStream = new FileOutputStream(string);
        this.writePrivateKey(fileOutputStream, byArray);
        fileOutputStream.close();
    }

    public String getFingerPrint() {
        byte[] byArray;
        if (this.hash == null) {
            this.hash = this.genHash();
        }
        if ((byArray = this.getPublicKeyBlob()) == null) {
            return null;
        }
        return Util.getFingerPrint(this.hash, byArray);
    }

    private byte[] encrypt(byte[] byArray, byte[][] byArray2, byte[] byArray3) {
        if (byArray3 == null) {
            return byArray;
        }
        if (this.cipher == null) {
            this.cipher = this.genCipher();
        }
        byArray2[0] = new byte[this.cipher.getIVSize()];
        byte[] byArray4 = byArray2[0];
        if (this.random == null) {
            this.random = this.genRandom();
        }
        this.random.fill(byArray4, 0, byArray4.length);
        byte[] byArray5 = this.genKey(byArray3, byArray4);
        byte[] byArray6 = byArray;
        int n = this.cipher.getIVSize();
        byte[] byArray7 = new byte[(byArray6.length / n + 1) * n];
        System.arraycopy(byArray6, 0, byArray7, 0, byArray6.length);
        int n2 = n - byArray6.length % n;
        for (int i = byArray7.length - 1; byArray7.length - n2 <= i; --i) {
            byArray7[i] = (byte)n2;
        }
        byArray6 = byArray7;
        try {
            this.cipher.init(0, byArray5, byArray4);
            this.cipher.update(byArray6, 0, byArray6.length, byArray6, 0);
        }
        catch (Exception exception) {
            // empty catch block
        }
        Util.bzero(byArray5);
        return byArray6;
    }

    abstract boolean parse(byte[] var1);

    private byte[] decrypt(byte[] byArray, byte[] byArray2, byte[] byArray3) {
        try {
            byte[] byArray4 = this.genKey(byArray2, byArray3);
            this.cipher.init(1, byArray4, byArray3);
            Util.bzero(byArray4);
            byte[] byArray5 = new byte[byArray.length];
            this.cipher.update(byArray, 0, byArray.length, byArray5, 0);
            return byArray5;
        }
        catch (Exception exception) {
            return null;
        }
    }

    int writeSEQUENCE(byte[] byArray, int n, int n2) {
        byArray[n++] = 48;
        n = this.writeLength(byArray, n, n2);
        return n;
    }

    int writeINTEGER(byte[] byArray, int n, byte[] byArray2) {
        byArray[n++] = 2;
        n = this.writeLength(byArray, n, byArray2.length);
        System.arraycopy(byArray2, 0, byArray, n, byArray2.length);
        return n += byArray2.length;
    }

    int writeOCTETSTRING(byte[] byArray, int n, byte[] byArray2) {
        byArray[n++] = 4;
        n = this.writeLength(byArray, n, byArray2.length);
        System.arraycopy(byArray2, 0, byArray, n, byArray2.length);
        return n += byArray2.length;
    }

    int writeDATA(byte[] byArray, byte by, int n, byte[] byArray2) {
        byArray[n++] = by;
        n = this.writeLength(byArray, n, byArray2.length);
        System.arraycopy(byArray2, 0, byArray, n, byArray2.length);
        return n += byArray2.length;
    }

    int countLength(int n) {
        int n2 = 1;
        if (n <= 127) {
            return n2;
        }
        while (n > 0) {
            n >>>= 8;
            ++n2;
        }
        return n2;
    }

    int writeLength(byte[] byArray, int n, int n2) {
        int n3 = this.countLength(n2) - 1;
        if (n3 == 0) {
            byArray[n++] = (byte)n2;
            return n;
        }
        byArray[n++] = (byte)(0x80 | n3);
        int n4 = n + n3;
        while (n3 > 0) {
            byArray[n + n3 - 1] = (byte)(n2 & 0xFF);
            n2 >>>= 8;
            --n3;
        }
        return n4;
    }

    private Random genRandom() {
        if (this.random == null) {
            try {
                Class<?> clazz = Class.forName(JSch.getConfig("random"));
                this.random = (Random)clazz.newInstance();
            }
            catch (Exception exception) {
                System.err.println("connect: random " + exception);
            }
        }
        return this.random;
    }

    private HASH genHash() {
        try {
            Class<?> clazz = Class.forName(JSch.getConfig("md5"));
            this.hash = (HASH)clazz.newInstance();
            this.hash.init();
        }
        catch (Exception exception) {
            // empty catch block
        }
        return this.hash;
    }

    private Cipher genCipher() {
        try {
            Class<?> clazz = Class.forName(JSch.getConfig("3des-cbc"));
            this.cipher = (Cipher)clazz.newInstance();
        }
        catch (Exception exception) {
            // empty catch block
        }
        return this.cipher;
    }

    synchronized byte[] genKey(byte[] byArray, byte[] byArray2) {
        if (this.cipher == null) {
            this.cipher = this.genCipher();
        }
        if (this.hash == null) {
            this.hash = this.genHash();
        }
        byte[] byArray3 = new byte[this.cipher.getBlockSize()];
        int n = this.hash.getBlockSize();
        byte[] byArray4 = new byte[byArray3.length / n * n + (byArray3.length % n == 0 ? 0 : n)];
        try {
            byte[] byArray5 = null;
            if (this.vendor == 0) {
                int n2 = 0;
                while (n2 + n <= byArray4.length) {
                    if (byArray5 != null) {
                        this.hash.update(byArray5, 0, byArray5.length);
                    }
                    this.hash.update(byArray, 0, byArray.length);
                    this.hash.update(byArray2, 0, byArray2.length > 8 ? 8 : byArray2.length);
                    byArray5 = this.hash.digest();
                    System.arraycopy(byArray5, 0, byArray4, n2, byArray5.length);
                    n2 += byArray5.length;
                }
                System.arraycopy(byArray4, 0, byArray3, 0, byArray3.length);
            } else if (this.vendor == 1) {
                int n3 = 0;
                while (n3 + n <= byArray4.length) {
                    if (byArray5 != null) {
                        this.hash.update(byArray5, 0, byArray5.length);
                    }
                    this.hash.update(byArray, 0, byArray.length);
                    byArray5 = this.hash.digest();
                    System.arraycopy(byArray5, 0, byArray4, n3, byArray5.length);
                    n3 += byArray5.length;
                }
                System.arraycopy(byArray4, 0, byArray3, 0, byArray3.length);
            } else if (this.vendor == 2) {
                Class<?> clazz = Class.forName(JSch.getConfig("sha-1"));
                HASH hASH = (HASH)clazz.newInstance();
                byArray5 = new byte[4];
                byArray3 = new byte[40];
                for (int i = 0; i < 2; ++i) {
                    hASH.init();
                    byArray5[3] = (byte)i;
                    hASH.update(byArray5, 0, byArray5.length);
                    hASH.update(byArray, 0, byArray.length);
                    System.arraycopy(hASH.digest(), 0, byArray3, i * 20, 20);
                }
            }
        }
        catch (Exception exception) {
            System.err.println(exception);
        }
        return byArray3;
    }

    public void setPassphrase(String string) {
        if (string == null || string.length() == 0) {
            this.setPassphrase((byte[])null);
        } else {
            this.setPassphrase(Util.str2byte(string));
        }
    }

    public void setPassphrase(byte[] byArray) {
        if (byArray != null && byArray.length == 0) {
            byArray = null;
        }
        this.passphrase = byArray;
    }

    public boolean isEncrypted() {
        return this.encrypted;
    }

    public boolean decrypt(String string) {
        if (string == null || string.length() == 0) {
            return !this.encrypted;
        }
        return this.decrypt(Util.str2byte(string));
    }

    public boolean decrypt(byte[] byArray) {
        if (!this.encrypted) {
            return true;
        }
        if (byArray == null) {
            return !this.encrypted;
        }
        byte[] byArray2 = new byte[byArray.length];
        System.arraycopy(byArray, 0, byArray2, 0, byArray2.length);
        byArray = byArray2;
        byte[] byArray3 = this.decrypt(this.data, byArray, this.iv);
        Util.bzero(byArray);
        if (this.parse(byArray3)) {
            this.encrypted = false;
        }
        return !this.encrypted;
    }

    public static KeyPair load(JSch jSch, String string) throws JSchException {
        String string2 = string + ".pub";
        if (!new File(string2).exists()) {
            string2 = null;
        }
        return KeyPair.load(jSch, string, string2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static KeyPair load(JSch jSch, String string, String string2) throws JSchException {
        byte[] byArray;
        byte[] byArray2;
        block8: {
            byArray2 = null;
            byArray = null;
            try {
                byArray2 = Util.fromFile(string);
            }
            catch (IOException iOException) {
                throw new JSchException(iOException.toString(), iOException);
            }
            String string3 = string2;
            if (string2 == null) {
                string3 = string + ".pub";
            }
            try {
                byArray = Util.fromFile(string3);
            }
            catch (IOException iOException) {
                if (string2 == null) break block8;
                throw new JSchException(iOException.toString(), iOException);
            }
        }
        try {
            KeyPair keyPair = KeyPair.load(jSch, byArray2, byArray);
            return keyPair;
        }
        finally {
            Util.bzero(byArray2);
        }
    }

    public static KeyPair load(JSch jSch, byte[] byArray, byte[] byArray2) throws JSchException {
        Object object;
        Cipher cipher;
        String string;
        int n;
        int n2;
        byte[] byArray3;
        byte[] byArray4;
        boolean bl;
        byte[] byArray5;
        block104: {
            byArray5 = new byte[8];
            bl = true;
            byArray4 = null;
            byArray3 = null;
            n2 = 0;
            n = 0;
            string = "";
            cipher = null;
            if (byArray2 == null && byArray != null && byArray.length > 11 && byArray[0] == 0 && byArray[1] == 0 && byArray[2] == 0 && (byArray[3] == 7 || byArray[3] == 19)) {
                Buffer buffer = new Buffer(byArray);
                buffer.skip(byArray.length);
                String string2 = new String(buffer.getString());
                buffer.rewind();
                KeyPair keyPair = null;
                if (string2.equals("ssh-rsa")) {
                    keyPair = KeyPairRSA.fromSSHAgent(jSch, buffer);
                } else if (string2.equals("ssh-dss")) {
                    keyPair = KeyPairDSA.fromSSHAgent(jSch, buffer);
                } else if (string2.equals("ecdsa-sha2-nistp256") || string2.equals("ecdsa-sha2-nistp384") || string2.equals("ecdsa-sha2-nistp512")) {
                    keyPair = KeyPairECDSA.fromSSHAgent(jSch, buffer);
                } else {
                    throw new JSchException("privatekey: invalid key " + new String(byArray, 4, 7));
                }
                return keyPair;
            }
            try {
                Object object2;
                int n3;
                KeyPair keyPair;
                object = byArray;
                if (object != null && (keyPair = KeyPair.loadPPK(jSch, (byte[])object)) != null) {
                    return keyPair;
                }
                int n4 = object != null ? ((byte[])object).length : 0;
                for (n3 = 0; n3 < n4 && (object[n3] != 45 || n3 + 4 >= n4 || object[n3 + 1] != 45 || object[n3 + 2] != 45 || object[n3 + 3] != 45 || object[n3 + 4] != 45); ++n3) {
                }
                while (n3 < n4) {
                    if (object[n3] == 66 && n3 + 3 < n4 && object[n3 + 1] == 69 && object[n3 + 2] == 71 && object[n3 + 3] == 73) {
                        if ((n3 += 6) + 2 >= n4) {
                            throw new JSchException("invalid privatekey: " + byArray);
                        }
                        if (object[n3] == 68 && object[n3 + 1] == 83 && object[n3 + 2] == 65) {
                            n2 = 1;
                        } else if (object[n3] == 82 && object[n3 + 1] == 83 && object[n3 + 2] == 65) {
                            n2 = 2;
                        } else if (object[n3] == 69 && object[n3 + 1] == 67) {
                            n2 = 3;
                        } else if (object[n3] == 83 && object[n3 + 1] == 83 && object[n3 + 2] == 72) {
                            n2 = 4;
                            n = 1;
                        } else if (n3 + 6 < n4 && object[n3] == 80 && object[n3 + 1] == 82 && object[n3 + 2] == 73 && object[n3 + 3] == 86 && object[n3 + 4] == 65 && object[n3 + 5] == 84 && object[n3 + 6] == 69) {
                            n2 = 4;
                            n = 3;
                            bl = false;
                            n3 += 3;
                        } else if (n3 + 8 < n4 && object[n3] == 69 && object[n3 + 1] == 78 && object[n3 + 2] == 67 && object[n3 + 3] == 82 && object[n3 + 4] == 89 && object[n3 + 5] == 80 && object[n3 + 6] == 84 && object[n3 + 7] == 69 && object[n3 + 8] == 68) {
                            n2 = 4;
                            n = 3;
                            n3 += 5;
                        } else {
                            throw new JSchException("invalid privatekey: " + byArray);
                        }
                        n3 += 3;
                        continue;
                    }
                    if (object[n3] == 65 && n3 + 7 < n4 && object[n3 + 1] == 69 && object[n3 + 2] == 83 && object[n3 + 3] == 45 && object[n3 + 4] == 50 && object[n3 + 5] == 53 && object[n3 + 6] == 54 && object[n3 + 7] == 45) {
                        n3 += 8;
                        if (Session.checkCipher(JSch.getConfig("aes256-cbc"))) {
                            Class<?> clazz = Class.forName(JSch.getConfig("aes256-cbc"));
                            cipher = (Cipher)clazz.newInstance();
                            byArray5 = new byte[cipher.getIVSize()];
                            continue;
                        }
                        throw new JSchException("privatekey: aes256-cbc is not available " + byArray);
                    }
                    if (object[n3] == 65 && n3 + 7 < n4 && object[n3 + 1] == 69 && object[n3 + 2] == 83 && object[n3 + 3] == 45 && object[n3 + 4] == 49 && object[n3 + 5] == 57 && object[n3 + 6] == 50 && object[n3 + 7] == 45) {
                        n3 += 8;
                        if (Session.checkCipher(JSch.getConfig("aes192-cbc"))) {
                            Class<?> clazz = Class.forName(JSch.getConfig("aes192-cbc"));
                            cipher = (Cipher)clazz.newInstance();
                            byArray5 = new byte[cipher.getIVSize()];
                            continue;
                        }
                        throw new JSchException("privatekey: aes192-cbc is not available " + byArray);
                    }
                    if (object[n3] == 65 && n3 + 7 < n4 && object[n3 + 1] == 69 && object[n3 + 2] == 83 && object[n3 + 3] == 45 && object[n3 + 4] == 49 && object[n3 + 5] == 50 && object[n3 + 6] == 56 && object[n3 + 7] == 45) {
                        n3 += 8;
                        if (Session.checkCipher(JSch.getConfig("aes128-cbc"))) {
                            Class<?> clazz = Class.forName(JSch.getConfig("aes128-cbc"));
                            cipher = (Cipher)clazz.newInstance();
                            byArray5 = new byte[cipher.getIVSize()];
                            continue;
                        }
                        throw new JSchException("privatekey: aes128-cbc is not available " + byArray);
                    }
                    if (object[n3] == 67 && n3 + 3 < n4 && object[n3 + 1] == 66 && object[n3 + 2] == 67 && object[n3 + 3] == 44) {
                        n3 += 4;
                        for (int i = 0; i < byArray5.length; ++i) {
                            byArray5[i] = (byte)((KeyPair.a2b((byte)object[n3++]) << 4 & 0xF0) + (KeyPair.a2b((byte)object[n3++]) & 0xF));
                        }
                        continue;
                    }
                    if (object[n3] == 13 && n3 + 1 < ((byte[])object).length && object[n3 + 1] == 10) {
                        ++n3;
                        continue;
                    }
                    if (object[n3] == 10 && n3 + 1 < ((byte[])object).length) {
                        if (object[n3 + 1] == 10) {
                            n3 += 2;
                            break;
                        }
                        if (object[n3 + 1] == 13 && n3 + 2 < ((Object)object).length && object[n3 + 2] == 10) {
                            n3 += 3;
                            break;
                        }
                        boolean bl2 = false;
                        for (int i = n3 + 1; i < ((Object)object).length && object[i] != 10; ++i) {
                            if (object[i] != 58) continue;
                            bl2 = true;
                            break;
                        }
                        if (!bl2) {
                            ++n3;
                            if (n == 3) break;
                            bl = false;
                            break;
                        }
                    }
                    ++n3;
                }
                if (object != null) {
                    if (n2 == 0) {
                        throw new JSchException("invalid privatekey: " + byArray);
                    }
                    int n5 = n3;
                    while (n3 < n4 && object[n3] != 45) {
                        ++n3;
                    }
                    if (n4 - n3 == 0 || n3 - n5 == 0) {
                        throw new JSchException("invalid privatekey: " + byArray);
                    }
                    byte[] byArray6 = new byte[n3 - n5];
                    System.arraycopy(object, n5, byArray6, 0, byArray6.length);
                    object2 = byArray6;
                    n5 = 0;
                    n3 = 0;
                    int n6 = ((byte[])object2).length;
                    while (n3 < n6) {
                        if (object2[n3] == 10) {
                            boolean bl3 = object2[n3 - 1] == 13;
                            System.arraycopy(object2, n3 + 1, object2, n3 - (bl3 ? 1 : 0), n6 - (n3 + 1));
                            if (bl3) {
                                --n6;
                            }
                            --n6;
                            continue;
                        }
                        if (object2[n3] == 45) break;
                        ++n3;
                    }
                    if (n3 - n5 > 0) {
                        byArray4 = Util.fromBase64((byte[])object2, n5, n3 - n5);
                    }
                    Util.bzero((byte[])object2);
                }
                if (byArray4 != null && byArray4.length > 4 && byArray4[0] == 63 && byArray4[1] == 111 && byArray4[2] == -7 && byArray4[3] == -21) {
                    Buffer buffer = new Buffer(byArray4);
                    buffer.getInt();
                    buffer.getInt();
                    byte[] byArray7 = buffer.getString();
                    object2 = Util.byte2str(buffer.getString());
                    if (((String)object2).equals("3des-cbc")) {
                        buffer.getInt();
                        byte[] byArray8 = new byte[byArray4.length - buffer.getOffSet()];
                        buffer.getByte(byArray8);
                        byArray4 = byArray8;
                        bl = true;
                        throw new JSchException("unknown privatekey format: " + byArray);
                    }
                    if (((String)object2).equals("none")) {
                        buffer.getInt();
                        buffer.getInt();
                        bl = false;
                        byte[] byArray9 = new byte[byArray4.length - buffer.getOffSet()];
                        buffer.getByte(byArray9);
                        byArray4 = byArray9;
                    }
                }
                if (byArray2 == null) break block104;
                try {
                    object = byArray2;
                    n4 = ((byte[])object).length;
                    if (((byte[])object).length > 4 && object[0] == 45 && object[1] == 45 && object[2] == 45 && object[3] == 45) {
                        int n7;
                        boolean bl4 = true;
                        n3 = 0;
                        while (((Object)object).length > ++n3 && object[n3] != 10) {
                        }
                        if (((Object)object).length <= n3) {
                            bl4 = false;
                        }
                        while (bl4) {
                            if (object[n3] == 10) {
                                n7 = 0;
                                for (int i = n3 + 1; i < ((Object)object).length && object[i] != 10; ++i) {
                                    if (object[i] != 58) continue;
                                    n7 = 1;
                                    break;
                                }
                                if (n7 == 0) {
                                    ++n3;
                                    break;
                                }
                            }
                            ++n3;
                        }
                        if (((Object)object).length <= n3) {
                            bl4 = false;
                        }
                        n7 = n3;
                        while (bl4 && n3 < n4) {
                            if (object[n3] == 10) {
                                System.arraycopy(object, n3 + 1, object, n3, n4 - n3 - 1);
                                --n4;
                                continue;
                            }
                            if (object[n3] == 45) break;
                            ++n3;
                        }
                        if (bl4) {
                            byArray3 = Util.fromBase64((byte[])object, n7, n3 - n7);
                            if (byArray == null || n2 == 4) {
                                if (byArray3[8] == 100) {
                                    n2 = 1;
                                } else if (byArray3[8] == 114) {
                                    n2 = 2;
                                }
                            }
                        }
                    } else if (object[0] == 115 && object[1] == 115 && object[2] == 104 && object[3] == 45) {
                        if (byArray == null && ((byte[])object).length > 7) {
                            if (object[4] == 100) {
                                n2 = 1;
                            } else if (object[4] == 114) {
                                n2 = 2;
                            }
                        }
                        for (n3 = 0; n3 < n4 && object[n3] != 32; ++n3) {
                        }
                        if (++n3 < n4) {
                            int n8 = n3;
                            while (n3 < n4 && object[n3] != 32) {
                                ++n3;
                            }
                            byArray3 = Util.fromBase64((byte[])object, n8, n3 - n8);
                        }
                        if (n3++ < n4) {
                            int n9 = n3;
                            while (n3 < n4 && object[n3] != 10) {
                                ++n3;
                            }
                            if (n3 > 0 && object[n3 - 1] == 13) {
                                --n3;
                            }
                            if (n9 < n3) {
                                string = new String((byte[])object, n9, n3 - n9);
                            }
                        }
                    } else if (object[0] == 101 && object[1] == 99 && object[2] == 100 && object[3] == 115) {
                        if (byArray == null && ((Object)object).length > 7) {
                            n2 = 3;
                        }
                        for (n3 = 0; n3 < n4 && object[n3] != 32; ++n3) {
                        }
                        if (++n3 < n4) {
                            int n10 = n3;
                            while (n3 < n4 && object[n3] != 32) {
                                ++n3;
                            }
                            byArray3 = Util.fromBase64((byte[])object, n10, n3 - n10);
                        }
                        if (n3++ < n4) {
                            int n11 = n3;
                            while (n3 < n4 && object[n3] != 10) {
                                ++n3;
                            }
                            if (n3 > 0 && object[n3 - 1] == 13) {
                                --n3;
                            }
                            if (n11 < n3) {
                                string = new String((byte[])object, n11, n3 - n11);
                            }
                        }
                    }
                }
                catch (Exception exception) {}
            }
            catch (Exception exception) {
                if (exception instanceof JSchException) {
                    throw (JSchException)exception;
                }
                if (exception instanceof Throwable) {
                    throw new JSchException(exception.toString(), exception);
                }
                throw new JSchException(exception.toString());
            }
        }
        object = null;
        if (n2 == 1) {
            object = new KeyPairDSA(jSch);
        } else if (n2 == 2) {
            object = new KeyPairRSA(jSch);
        } else if (n2 == 3) {
            object = new KeyPairECDSA(jSch);
        } else if (n == 3) {
            object = new KeyPairPKCS8(jSch);
        }
        if (object != null) {
            ((KeyPair)object).encrypted = bl;
            ((KeyPair)object).publickeyblob = byArray3;
            ((KeyPair)object).vendor = n;
            ((KeyPair)object).publicKeyComment = string;
            ((KeyPair)object).cipher = cipher;
            if (bl) {
                ((KeyPair)object).encrypted = true;
                ((KeyPair)object).iv = byArray5;
                ((KeyPair)object).data = byArray4;
            } else {
                if (((KeyPair)object).parse(byArray4)) {
                    ((KeyPair)object).encrypted = false;
                    return object;
                }
                throw new JSchException("invalid privatekey: " + byArray);
            }
        }
        return object;
    }

    private static byte a2b(byte by) {
        if (48 <= by && by <= 57) {
            return (byte)(by - 48);
        }
        return (byte)(by - 97 + 10);
    }

    private static byte b2a(byte by) {
        if (0 <= by && by <= 9) {
            return (byte)(by + 48);
        }
        return (byte)(by - 10 + 65);
    }

    public void dispose() {
        Util.bzero(this.passphrase);
    }

    public void finalize() {
        this.dispose();
    }

    static KeyPair loadPPK(JSch jSch, byte[] byArray) throws JSchException {
        Object object;
        byte[] byArray2 = null;
        byte[] byArray3 = null;
        int n = 0;
        Buffer buffer = new Buffer(byArray);
        Hashtable hashtable = new Hashtable();
        while (KeyPair.parseHeader(buffer, hashtable)) {
        }
        String string = (String)hashtable.get("PuTTY-User-Key-File-2");
        if (string == null) {
            return null;
        }
        n = Integer.parseInt((String)hashtable.get("Public-Lines"));
        byArray2 = KeyPair.parseLines(buffer, n);
        while (KeyPair.parseHeader(buffer, hashtable)) {
        }
        n = Integer.parseInt((String)hashtable.get("Private-Lines"));
        byArray3 = KeyPair.parseLines(buffer, n);
        while (KeyPair.parseHeader(buffer, hashtable)) {
        }
        byArray3 = Util.fromBase64(byArray3, 0, byArray3.length);
        byArray2 = Util.fromBase64(byArray2, 0, byArray2.length);
        KeyPair keyPair = null;
        if (string.equals("ssh-rsa")) {
            object = new Buffer(byArray2);
            ((Buffer)object).skip(byArray2.length);
            int n2 = ((Buffer)object).getInt();
            ((Buffer)object).getByte(new byte[n2]);
            byte[] byArray4 = new byte[((Buffer)object).getInt()];
            ((Buffer)object).getByte(byArray4);
            byte[] byArray5 = new byte[((Buffer)object).getInt()];
            ((Buffer)object).getByte(byArray5);
            keyPair = new KeyPairRSA(jSch, byArray5, byArray4, null);
        } else if (string.equals("ssh-dss")) {
            object = new Buffer(byArray2);
            ((Buffer)object).skip(byArray2.length);
            int n3 = ((Buffer)object).getInt();
            ((Buffer)object).getByte(new byte[n3]);
            byte[] byArray6 = new byte[((Buffer)object).getInt()];
            ((Buffer)object).getByte(byArray6);
            byte[] byArray7 = new byte[((Buffer)object).getInt()];
            ((Buffer)object).getByte(byArray7);
            byte[] byArray8 = new byte[((Buffer)object).getInt()];
            ((Buffer)object).getByte(byArray8);
            byte[] byArray9 = new byte[((Buffer)object).getInt()];
            ((Buffer)object).getByte(byArray9);
            keyPair = new KeyPairDSA(jSch, byArray6, byArray7, byArray8, byArray9, null);
        } else {
            return null;
        }
        if (keyPair == null) {
            return null;
        }
        keyPair.encrypted = !hashtable.get("Encryption").equals("none");
        keyPair.vendor = 2;
        keyPair.publicKeyComment = (String)hashtable.get("Comment");
        if (keyPair.encrypted) {
            if (Session.checkCipher(JSch.getConfig("aes256-cbc"))) {
                try {
                    object = Class.forName(JSch.getConfig("aes256-cbc"));
                    keyPair.cipher = (Cipher)((Class)object).newInstance();
                    keyPair.iv = new byte[keyPair.cipher.getIVSize()];
                }
                catch (Exception exception) {
                    throw new JSchException("The cipher 'aes256-cbc' is required, but it is not available.");
                }
            } else {
                throw new JSchException("The cipher 'aes256-cbc' is required, but it is not available.");
            }
            keyPair.data = byArray3;
        } else {
            keyPair.data = byArray3;
            keyPair.parse(byArray3);
        }
        return keyPair;
    }

    private static byte[] parseLines(Buffer buffer, int n) {
        byte[] byArray = buffer.buffer;
        int n2 = buffer.index;
        byte[] byArray2 = null;
        int n3 = n2;
        while (n-- > 0) {
            while (byArray.length > n3) {
                if (byArray[n3++] != 13) continue;
                if (byArray2 == null) {
                    byArray2 = new byte[n3 - n2 - 1];
                    System.arraycopy(byArray, n2, byArray2, 0, n3 - n2 - 1);
                    break;
                }
                byte[] byArray3 = new byte[byArray2.length + n3 - n2 - 1];
                System.arraycopy(byArray2, 0, byArray3, 0, byArray2.length);
                System.arraycopy(byArray, n2, byArray3, byArray2.length, n3 - n2 - 1);
                for (int i = 0; i < byArray2.length; ++i) {
                    byArray2[i] = 0;
                }
                byArray2 = byArray3;
                break;
            }
            if (byArray[n3] == 10) {
                // empty if block
            }
            n2 = ++n3;
        }
        if (byArray2 != null) {
            buffer.index = n2;
        }
        return byArray2;
    }

    private static boolean parseHeader(Buffer buffer, Hashtable hashtable) {
        int n;
        byte[] byArray = buffer.buffer;
        int n2 = buffer.index;
        String string = null;
        String string2 = null;
        for (n = n2; n < byArray.length && byArray[n] != 13; ++n) {
            if (byArray[n] != 58) continue;
            string = new String(byArray, n2, n - n2);
            if (++n < byArray.length && byArray[n] == 32) {
                ++n;
            }
            n2 = n;
            break;
        }
        if (string == null) {
            return false;
        }
        for (n = n2; n < byArray.length; ++n) {
            if (byArray[n] != 13) continue;
            string2 = new String(byArray, n2, n - n2);
            if (++n < byArray.length && byArray[n] == 10) {
                ++n;
            }
            n2 = n;
            break;
        }
        if (string2 != null) {
            hashtable.put(string, string2);
            buffer.index = n2;
        }
        return string != null && string2 != null;
    }

    void copy(KeyPair keyPair) {
        this.publickeyblob = keyPair.publickeyblob;
        this.vendor = keyPair.vendor;
        this.publicKeyComment = keyPair.publicKeyComment;
        this.cipher = keyPair.cipher;
    }

    class ASN1 {
        byte[] buf;
        int start;
        int length;

        ASN1(byte[] byArray) throws ASN1Exception {
            this(byArray, 0, byArray.length);
        }

        ASN1(byte[] byArray, int n, int n2) throws ASN1Exception {
            this.buf = byArray;
            this.start = n;
            this.length = n2;
            if (n + n2 > byArray.length) {
                throw new ASN1Exception();
            }
        }

        int getType() {
            return this.buf[this.start] & 0xFF;
        }

        boolean isSEQUENCE() {
            return this.getType() == 48;
        }

        boolean isINTEGER() {
            return this.getType() == 2;
        }

        boolean isOBJECT() {
            return this.getType() == 6;
        }

        boolean isOCTETSTRING() {
            return this.getType() == 4;
        }

        private int getLength(int[] nArray) {
            int n;
            int n2 = nArray[0];
            if (((n = this.buf[n2++] & 0xFF) & 0x80) != 0) {
                int n3 = n & 0x7F;
                n = 0;
                while (n3-- > 0) {
                    n = (n << 8) + (this.buf[n2++] & 0xFF);
                }
            }
            nArray[0] = n2;
            return n;
        }

        byte[] getContent() {
            int[] nArray = new int[]{this.start + 1};
            int n = this.getLength(nArray);
            int n2 = nArray[0];
            byte[] byArray = new byte[n];
            System.arraycopy(this.buf, n2, byArray, 0, byArray.length);
            return byArray;
        }

        ASN1[] getContents() throws ASN1Exception {
            int n;
            byte by = this.buf[this.start];
            int[] nArray = new int[]{this.start + 1};
            if (by == 5) {
                return new ASN1[0];
            }
            int n2 = nArray[0];
            Vector<ASN1> vector = new Vector<ASN1>();
            for (int i = this.getLength(nArray); i > 0; i -= n) {
                --i;
                int n3 = ++n2;
                nArray[0] = n2;
                n = this.getLength(nArray);
                n2 = nArray[0];
                i -= n2 - n3;
                vector.addElement(new ASN1(this.buf, n3 - 1, 1 + (n2 - n3) + n));
                n2 += n;
            }
            ASN1[] aSN1Array = new ASN1[vector.size()];
            for (n = 0; n < vector.size(); ++n) {
                aSN1Array[n] = (ASN1)vector.elementAt(n);
            }
            return aSN1Array;
        }
    }

    class ASN1Exception
    extends Exception {
        ASN1Exception() {
        }
    }
}

