/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.ast;

import java.util.List;
import org.jruby.RubySymbol;
import org.jruby.ast.Node;
import org.jruby.ast.NodeType;
import org.jruby.ast.types.INameNode;
import org.jruby.ast.visitor.NodeVisitor;
import org.jruby.lexer.yacc.ISourcePosition;

public class ArgumentNode
extends Node
implements INameNode {
    private RubySymbol identifier;
    private int location;

    public ArgumentNode(ISourcePosition position, RubySymbol identifier, int location) {
        super(position, false);
        this.identifier = identifier;
        this.location = location;
    }

    @Override
    public NodeType getNodeType() {
        return NodeType.ARGUMENTNODE;
    }

    @Override
    public <T> T accept(NodeVisitor<T> visitor) {
        return visitor.visitArgumentNode(this);
    }

    public int getDepth() {
        return this.location >> 16;
    }

    public int getIndex() {
        return this.location & 0xFFFF;
    }

    @Override
    public RubySymbol getName() {
        return this.identifier;
    }

    @Override
    public List<Node> childNodes() {
        return EMPTY_LIST;
    }
}

