# -*- coding: utf-8 -*-
info = {
    "name": "nb",
    "date_order": "DMY",
    "january": [
        "januar",
        "jan"
    ],
    "february": [
        "februar",
        "feb"
    ],
    "march": [
        "mars",
        "mar"
    ],
    "april": [
        "april",
        "apr"
    ],
    "may": [
        "mai"
    ],
    "june": [
        "juni",
        "jun"
    ],
    "july": [
        "juli",
        "jul"
    ],
    "august": [
        "august",
        "aug"
    ],
    "september": [
        "september",
        "sep"
    ],
    "october": [
        "oktober",
        "okt"
    ],
    "november": [
        "november",
        "nov"
    ],
    "december": [
        "desember",
        "des"
    ],
    "monday": [
        "mandag",
        "man"
    ],
    "tuesday": [
        "tirsdag",
        "tir"
    ],
    "wednesday": [
        "onsdag",
        "ons"
    ],
    "thursday": [
        "torsdag",
        "tor"
    ],
    "friday": [
        "fredag",
        "fre"
    ],
    "saturday": [
        "lørdag",
        "lør"
    ],
    "sunday": [
        "søndag",
        "søn"
    ],
    "am": [
        "am"
    ],
    "pm": [
        "pm"
    ],
    "year": [
        "år"
    ],
    "month": [
        "måned",
        "mnd",
        "md"
    ],
    "week": [
        "uke",
        "u",
        "uker"
    ],
    "day": [
        "dag",
        "d",
        "dager"
    ],
    "hour": [
        "time",
        "t",
        "timer"
    ],
    "minute": [
        "minutt",
        "min",
        "m"
    ],
    "second": [
        "sekund",
        "sek",
        "s"
    ],
    "relative-type": {
        "1 year ago": [
            "i fjor"
        ],
        "0 year ago": [
            "i år"
        ],
        "in 1 year": [
            "neste år"
        ],
        "1 month ago": [
            "forrige måned",
            "forrige md"
        ],
        "0 month ago": [
            "denne måneden",
            "denne md"
        ],
        "in 1 month": [
            "neste måned",
            "neste md"
        ],
        "1 week ago": [
            "forrige uke"
        ],
        "0 week ago": [
            "denne uken"
        ],
        "in 1 week": [
            "neste uke"
        ],
        "1 day ago": [
            "i går"
        ],
        "0 day ago": [
            "i dag"
        ],
        "in 1 day": [
            "i morgen"
        ],
        "0 hour ago": [
            "denne timen"
        ],
        "0 minute ago": [
            "dette minuttet"
        ],
        "0 second ago": [
            "nå"
        ]
    },
    "relative-type-regex": {
        "in \\1 year": [
            "om (\\d+) år"
        ],
        "\\1 year ago": [
            "for (\\d+) år siden",
            "–(\\d+) år"
        ],
        "in \\1 month": [
            "om (\\d+) måned",
            "om (\\d+) måneder",
            "om (\\d+) md"
        ],
        "\\1 month ago": [
            "for (\\d+) måned siden",
            "for (\\d+) måneder siden",
            "for (\\d+) md siden"
        ],
        "in \\1 week": [
            "om (\\d+) uke",
            "om (\\d+) uker",
            "om (\\d+) u"
        ],
        "\\1 week ago": [
            "for (\\d+) uke siden",
            "for (\\d+) uker siden",
            "for (\\d+) u siden"
        ],
        "in \\1 day": [
            "om (\\d+) døgn",
            "om (\\d+) d"
        ],
        "\\1 day ago": [
            "for (\\d+) døgn siden",
            "for (\\d+) d siden",
            "for (\\d+) dager siden"
        ],
        "in \\1 hour": [
            "om (\\d+) time",
            "om (\\d+) timer",
            "om (\\d+) t"
        ],
        "\\1 hour ago": [
            "for (\\d+) time siden",
            "for (\\d+) timer siden",
            "for (\\d+) t siden"
        ],
        "in \\1 minute": [
            "om (\\d+) minutt",
            "om (\\d+) minutter",
            "om (\\d+) min"
        ],
        "\\1 minute ago": [
            "for (\\d+) minutt siden",
            "for (\\d+) minutter siden",
            "for (\\d+) min siden"
        ],
        "in \\1 second": [
            "om (\\d+) sekund",
            "om (\\d+) sekunder",
            "om (\\d+) sek"
        ],
        "\\1 second ago": [
            "for (\\d+) sekund siden",
            "for (\\d+) sekunder siden",
            "for (\\d+) sek siden"
        ]
    },
    "locale_specific": {
        "nb-SJ": {
            "name": "nb-SJ"
        }
    },
    "ago": [
        "siden"
    ],
    "in": [
        "om"
    ],
    "skip": [
        " ",
        ".",
        ",",
        ";",
        "-",
        "/",
        "'",
        "|",
        "@",
        "[",
        "]",
        "，"
    ]
}