# API version 1

In this document, the Notes API major version 1 and all its minor versions are described. An introduction with general information about versions, capabilities, compatibility between versions, authentication and input parameters can be found in the [README](README.md).


## Minor versions

| API version | Introduced with app version | Remarkable Changes |
|:-----------:|:----------------------------|:-------------------|
|  **1.0**    | Notes 3.3 (May 2020)        | Separate title, no auto rename based on content |



## Note attributes

The app and the API is mainly about notes. So, let's have a look about the attributes of a note. The description of endpoints and operations will refer to this attribute definition.

| Attribute | Type | Description | since API version |
|:----------|:-----|:-------------------------|:-------------------|
| `id` | integer | Every note has a unique identifier which is created by the server. It can be used to query and update a specific note. | 1.0 |
| `content` | string | Notes can contain arbitrary text. Formatting should be done using Markdown, but not every markup can be supported by every client. Therefore, markup should be used with care. | 1.0 |
| `title` | string | The note's title is also used as filename for the note's file. Therefore, some special characters are automatically removed and a sequential number is added if a note with the same title in the same category exists. When saving a title, the sanitized value is returned and should be adopted by your client. | 1.0 |
| `category` | string | Every note is assigned to a category. By default, the category is an empty string (not null), which means the note is uncategorized. Categories are mapped to folders in the file backend. Illegal characters are automatically removed and the respective folder is automatically created. Sub-categories (mapped to sub-folders) can be created by using `/` as delimiter. | 1.0 |
| `favorite` | boolean | If a note is marked as favorite, it is displayed at the top of the notes' list. Default is `false`. | 1.0 |
| `modified` | integer | Unix timestamp for the last modified date/time of the note. If not provided on note creation or content update, the current time is used. | 1.0 |


## Endpoints and Operations

The base URL for all calls is:

    https://user:password@yournextcloud.com/index.php/apps/notes/api/v1/

All defined routes in the specification are appended to this url. To access all notes for instance use this url (here shown as `curl` command):

    curl -u user:password https://yournextcloud.com/index.php/apps/notes/api/v1/notes



### Get all notes (`GET /notes`)
<details><summary>Details</summary>

#### Request parameters
| Parameter | Type | Description |
|:------|:-----|:-----|
| `exclude` | string, optional | Fields which should be excluded from response, seperated with a comma e.g.: `?exclude=content,title`. You can use this in order to reduce transferred data size if you are interested in specific attributes, only. |
| `purgeBefore` | integer, optional | All notes without change before of this Unix timestamp are purged from the response, i.e. only the attribute `id` is included. You should use the Unix timestamp value from the last request's HTTP response header `Last-Modified` in order to reduce transferred data size. |
| `If-None-Match` | HTTP header, optional | Use this in order to reduce transferred data size (see [HTTP ETag](https://en.wikipedia.org/wiki/HTTP_ETag)). You should use the value from the last request's HTTP response header `ETag`. |

#### Response
##### 200 OK
- **HTTP Header**: `ETag` (see [HTTP ETag](https://en.wikipedia.org/wiki/HTTP_ETag)).
- **Body**: list of notes (see section [Note attributes](#note-attributes)), example:
```js
[
    {
        "id": 76,
        "modified": 1376753464,
        "title": "New note",
        "category": "sub-directory",
        "content": "New note\n and something more",
        "favorite": false
    }, // etc
]
```
</details>


### Get single note (`GET /notes/{id}`)
<details><summary>Details</summary>

#### Request parameters
| Parameter | Type | Description |
|:------|:-----|:-----|
| `id` | integer, required (path) | ID of the note to query. |

#### Response
##### 200 OK
- **Body**: note (see section [Note attributes](#note-attributes)), example:
```js
{
    "id": 76,
    "modified": 1376753464,
    "title": "New note",
    "category": "sub-directory",
    "content": "New note\n and something more",
    "favorite": false
}
```
##### 400 Bad Request
Invalid ID supplied.

##### 404 Not Found
Note not found.
</details>


### Create note (`POST /notes`)
<details><summary>Details</summary>

#### Request parameters
- **Body**: See section [Note attributes](#note-attributes) (except for `id`).  All attributes are optional. Example: 
```js
{
    "title": "New note",
    "category": "Category/Sub Category",
    "content": "New note\n and something more",
}
```

#### Response
##### 200 OK
- **Body**: note (see section [Note attributes](#note-attributes)), example see section [Get single note](#get-single-note-get-notesid).

##### 400 Bad Request
Invalid ID supplied.

##### 507 Insufficient Storage
Not enough free storage for saving the note's content.
</details>


### Update note (`PUT /notes/{id}`)
<details><summary>Details</summary>

#### Request parameters
| Parameter | Type | Description |
|:------|:-----|:-----|
| `id` | integer, required (path) | ID of the note to update. |
- **Body**: See section [Note attributes](#note-attributes) (except for `id`).  All attributes are optional. Example see section [Create note](#create-note-post-notes).

#### Response
##### 200 OK
- **Body**: note (see section [Note attributes](#note-attributes)), example see section [Get single note](#get-single-note-get-notesid).

##### 400 Bad Request
Invalid ID supplied.

##### 404 Not Found
Note not found.

##### 507 Insufficient Storage
Not enough free storage for saving the note's content.
</details>


### Delete note (`DELETE /notes/{id}`)
<details><summary>Details</summary>

#### Request parameters
| Parameter | Type | Description |
|:------|:-----|:-----|
| `id` | integer, required (path) | ID of the note to delete. |

#### Response
##### 200 OK
Note is deleted.

##### 400 Bad Request
Invalid ID supplied.

##### 404 Not Found
Note not found.
</details>
