﻿/*
* Copyright 2010-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
*
* Licensed under the Apache License, Version 2.0 (the "License").
* You may not use this file except in compliance with the License.
* A copy of the License is located at
*
*  http://aws.amazon.com/apache2.0
*
* or in the "license" file accompanying this file. This file is distributed
* on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either
* express or implied. See the License for the specific language governing
* permissions and limitations under the License.
*/

#pragma once
#include <aws/mediaconvert/MediaConvert_EXPORTS.h>
#include <aws/core/utils/memory/stl/AWSString.h>

namespace Aws
{
namespace MediaConvert
{
namespace Model
{
  enum class LanguageCode
  {
    NOT_SET,
    ENG,
    SPA,
    FRA,
    DEU,
    GER,
    ZHO,
    ARA,
    HIN,
    JPN,
    RUS,
    POR,
    ITA,
    URD,
    VIE,
    KOR,
    PAN,
    ABK,
    AAR,
    AFR,
    AKA,
    SQI,
    AMH,
    ARG,
    HYE,
    ASM,
    AVA,
    AVE,
    AYM,
    AZE,
    BAM,
    BAK,
    EUS,
    BEL,
    BEN,
    BIH,
    BIS,
    BOS,
    BRE,
    BUL,
    MYA,
    CAT,
    KHM,
    CHA,
    CHE,
    NYA,
    CHU,
    CHV,
    COR,
    COS,
    CRE,
    HRV,
    CES,
    DAN,
    DIV,
    NLD,
    DZO,
    ENM,
    EPO,
    EST,
    EWE,
    FAO,
    FIJ,
    FIN,
    FRM,
    FUL,
    GLA,
    GLG,
    LUG,
    KAT,
    ELL,
    GRN,
    GUJ,
    HAT,
    HAU,
    HEB,
    HER,
    HMO,
    HUN,
    ISL,
    IDO,
    IBO,
    IND,
    INA,
    ILE,
    IKU,
    IPK,
    GLE,
    JAV,
    KAL,
    KAN,
    KAU,
    KAS,
    KAZ,
    KIK,
    KIN,
    KIR,
    KOM,
    KON,
    KUA,
    KUR,
    LAO,
    LAT,
    LAV,
    LIM,
    LIN,
    LIT,
    LUB,
    LTZ,
    MKD,
    MLG,
    MSA,
    MAL,
    MLT,
    GLV,
    MRI,
    MAR,
    MAH,
    MON,
    NAU,
    NAV,
    NDE,
    NBL,
    NDO,
    NEP,
    SME,
    NOR,
    NOB,
    NNO,
    OCI,
    OJI,
    ORI,
    ORM,
    OSS,
    PLI,
    FAS,
    POL,
    PUS,
    QUE,
    QAA,
    RON,
    ROH,
    RUN,
    SMO,
    SAG,
    SAN,
    SRD,
    SRB,
    SNA,
    III,
    SND,
    SIN,
    SLK,
    SLV,
    SOM,
    SOT,
    SUN,
    SWA,
    SSW,
    SWE,
    TGL,
    TAH,
    TGK,
    TAM,
    TAT,
    TEL,
    THA,
    BOD,
    TIR,
    TON,
    TSO,
    TSN,
    TUR,
    TUK,
    TWI,
    UIG,
    UKR,
    UZB,
    VEN,
    VOL,
    WLN,
    CYM,
    FRY,
    WOL,
    XHO,
    YID,
    YOR,
    ZHA,
    ZUL,
    ORJ,
    QPC,
    TNG
  };

namespace LanguageCodeMapper
{
AWS_MEDIACONVERT_API LanguageCode GetLanguageCodeForName(const Aws::String& name);

AWS_MEDIACONVERT_API Aws::String GetNameForLanguageCode(LanguageCode value);
} // namespace LanguageCodeMapper
} // namespace Model
} // namespace MediaConvert
} // namespace Aws
