/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.action.admin.indices.template.get;

import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.admin.indices.template.get.GetComponentTemplateAction;
import org.elasticsearch.action.support.ActionFilters;
import org.elasticsearch.action.support.master.TransportMasterNodeReadAction;
import org.elasticsearch.cluster.ClusterState;
import org.elasticsearch.cluster.block.ClusterBlockException;
import org.elasticsearch.cluster.block.ClusterBlockLevel;
import org.elasticsearch.cluster.metadata.ComponentTemplate;
import org.elasticsearch.cluster.metadata.IndexNameExpressionResolver;
import org.elasticsearch.cluster.service.ClusterService;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.regex.Regex;
import org.elasticsearch.threadpool.ThreadPool;
import org.elasticsearch.transport.TransportService;

public class TransportGetComponentTemplateAction
extends TransportMasterNodeReadAction<GetComponentTemplateAction.Request, GetComponentTemplateAction.Response> {
    @Inject
    public TransportGetComponentTemplateAction(TransportService transportService, ClusterService clusterService, ThreadPool threadPool, ActionFilters actionFilters, IndexNameExpressionResolver indexNameExpressionResolver) {
        super("cluster:admin/component_template/get", transportService, clusterService, threadPool, actionFilters, GetComponentTemplateAction.Request::new, indexNameExpressionResolver);
    }

    @Override
    protected String executor() {
        return "same";
    }

    @Override
    protected GetComponentTemplateAction.Response read(StreamInput in) throws IOException {
        return new GetComponentTemplateAction.Response(in);
    }

    @Override
    protected ClusterBlockException checkBlock(GetComponentTemplateAction.Request request, ClusterState state) {
        return state.blocks().globalBlockedException(ClusterBlockLevel.METADATA_READ);
    }

    @Override
    protected void masterOperation(GetComponentTemplateAction.Request request, ClusterState state, ActionListener<GetComponentTemplateAction.Response> listener) {
        Map<String, ComponentTemplate> allTemplates = state.metaData().componentTemplates();
        if (request.names().length == 0) {
            listener.onResponse(new GetComponentTemplateAction.Response(allTemplates));
            return;
        }
        HashMap<String, ComponentTemplate> results = new HashMap<String, ComponentTemplate>();
        for (String name : request.names()) {
            if (Regex.isSimpleMatchPattern(name)) {
                for (Map.Entry<String, ComponentTemplate> entry : allTemplates.entrySet()) {
                    if (!Regex.simpleMatch(name, entry.getKey())) continue;
                    results.put(entry.getKey(), entry.getValue());
                }
                continue;
            }
            if (!allTemplates.containsKey(name)) continue;
            results.put(name, allTemplates.get(name));
        }
        listener.onResponse(new GetComponentTemplateAction.Response(results));
    }
}

