/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.common.io.stream;

import java.io.IOException;
import java.util.function.Supplier;
import org.elasticsearch.Version;
import org.elasticsearch.common.bytes.BytesReference;
import org.elasticsearch.common.io.stream.BytesStreamOutput;
import org.elasticsearch.common.io.stream.NamedWriteableAwareStreamInput;
import org.elasticsearch.common.io.stream.NamedWriteableRegistry;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.io.stream.Writeable;

public abstract class DelayableWriteable<T extends Writeable>
implements Supplier<T>,
Writeable {
    public static <T extends Writeable> DelayableWriteable<T> referencing(T reference) {
        return new Referencing<T>(reference);
    }

    public static <T extends Writeable> DelayableWriteable<T> delayed(Writeable.Reader<T> reader, StreamInput in) throws IOException {
        return new Delayed<T>(reader, in);
    }

    private DelayableWriteable() {
    }

    public abstract boolean isDelayed();

    private static class Referencing<T extends Writeable>
    extends DelayableWriteable<T> {
        private T reference;

        Referencing(T reference) {
            this.reference = reference;
        }

        @Override
        public void writeTo(StreamOutput out) throws IOException {
            try (BytesStreamOutput buffer = new BytesStreamOutput();){
                buffer.setVersion(out.getVersion());
                this.reference.writeTo(buffer);
                out.writeBytesReference(buffer.bytes());
            }
        }

        @Override
        public T get() {
            return this.reference;
        }

        @Override
        public boolean isDelayed() {
            return false;
        }
    }

    private static class Delayed<T extends Writeable>
    extends DelayableWriteable<T> {
        private final Writeable.Reader<T> reader;
        private final Version remoteVersion;
        private final BytesReference serialized;
        private final NamedWriteableRegistry registry;

        Delayed(Writeable.Reader<T> reader, StreamInput in) throws IOException {
            this.reader = reader;
            this.remoteVersion = in.getVersion();
            this.serialized = in.readBytesReference();
            this.registry = in.namedWriteableRegistry();
        }

        @Override
        public void writeTo(StreamOutput out) throws IOException {
            if (out.getVersion() == this.remoteVersion) {
                out.writeBytesReference(this.serialized);
            } else {
                Delayed.referencing(this.get()).writeTo(out);
            }
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        @Override
        public T get() {
            try (StreamInput in = this.registry == null ? this.serialized.streamInput() : new NamedWriteableAwareStreamInput(this.serialized.streamInput(), this.registry);){
                in.setVersion(this.remoteVersion);
                Writeable writeable = (Writeable)this.reader.read(in);
                return (T)writeable;
            }
            catch (IOException e) {
                throw new RuntimeException("unexpected error expanding aggregations", e);
            }
        }

        @Override
        public boolean isDelayed() {
            return true;
        }
    }
}

