/*
 * Decompiled with CFR 0.152.
 */
package net.sf.freecol.client.gui.option;

import javax.swing.DefaultComboBoxModel;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.ListCellRenderer;
import net.sf.freecol.client.gui.option.OptionUI;
import net.sf.freecol.client.gui.plaf.FreeColComboBoxRenderer;
import net.sf.freecol.common.i18n.Messages;
import net.sf.freecol.common.io.FreeColModFile;
import net.sf.freecol.common.option.ModOption;

public final class ModOptionUI
extends OptionUI<ModOption> {
    private final JComboBox<FreeColModFile> box;

    public ModOptionUI(ModOption option, boolean editable) {
        super(option, editable);
        DefaultComboBoxModel<FreeColModFile> model = new DefaultComboBoxModel<FreeColModFile>();
        for (FreeColModFile choice : option.getChoices()) {
            model.addElement(choice);
        }
        this.box = new JComboBox();
        this.box.setModel(model);
        this.box.setRenderer(new BoxRenderer());
        if (option.getValue() != null) {
            this.box.setSelectedItem(option.getValue());
        }
        this.initialize();
    }

    private static void labelModFile(JLabel label, FreeColModFile modFile) {
        String key = "mod." + modFile.getId();
        label.setText(Messages.getName(key));
        if (Messages.containsKey(Messages.shortDescriptionKey(key))) {
            label.setToolTipText(Messages.getShortDescription(key));
        }
    }

    @Override
    public ListCellRenderer getListCellRenderer() {
        return new ModOptionRenderer();
    }

    @Override
    public void updateOption() {
        ((ModOption)this.getOption()).setValue((FreeColModFile)this.box.getSelectedItem());
    }

    @Override
    public JComboBox getComponent() {
        return this.box;
    }

    @Override
    public void reset() {
        this.box.setSelectedItem(((ModOption)this.getOption()).getValue());
    }

    private static class ModOptionRenderer
    extends FreeColComboBoxRenderer<ModOption> {
        private ModOptionRenderer() {
        }

        @Override
        public void setLabelValues(JLabel label, ModOption value) {
            FreeColModFile modFile = value.getValue();
            if (modFile == null) {
                label.setText(value.toString());
            } else {
                ModOptionUI.labelModFile(label, modFile);
            }
        }
    }

    private static class BoxRenderer
    extends FreeColComboBoxRenderer<FreeColModFile> {
        private BoxRenderer() {
        }

        @Override
        public void setLabelValues(JLabel label, FreeColModFile value) {
            if (value != null) {
                ModOptionUI.labelModFile(label, value);
            }
        }
    }
}

