/*
 * Decompiled with CFR 0.152.
 */
package freemind.view.mindmapview;

import freemind.main.Resources;
import freemind.main.Tools;
import freemind.modes.MindMapNode;
import freemind.view.mindmapview.NodeFoldingComponent;
import freemind.view.mindmapview.NodeMotionListenerView;
import freemind.view.mindmapview.NodeView;
import freemind.view.mindmapview.NodeViewLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Point;
import java.util.logging.Logger;
import javax.swing.JComponent;

public abstract class NodeViewLayoutAdapter
implements NodeViewLayout {
    protected final int LISTENER_VIEW_WIDTH = 10;
    protected static Logger logger = null;
    protected Point location = new Point();
    private static Dimension minDimension;
    private NodeView view;
    private MindMapNode model;
    private int childCount;
    private JComponent content;
    private int vGap;
    private int spaceAround;

    public NodeViewLayoutAdapter() {
        if (logger == null) {
            logger = Resources.getInstance().getLogger(this.getClass().getName());
        }
    }

    @Override
    public void addLayoutComponent(String arg0, Component arg1) {
    }

    @Override
    public void removeLayoutComponent(Component arg0) {
    }

    @Override
    public Dimension minimumLayoutSize(Container arg0) {
        if (minDimension == null) {
            minDimension = new Dimension(0, 0);
        }
        return minDimension;
    }

    @Override
    public Dimension preferredLayoutSize(Container c) {
        if (!c.isValid()) {
            c.validate();
        }
        return c.getSize();
    }

    @Override
    public void layoutContainer(Container c) {
        this.setUp(c);
        this.layout();
        Point location2 = this.view.getLocation();
        Tools.convertPointToAncestor((Component)this.view, location2, this.view.getMap());
        this.layoutOtherItems();
        this.shutDown();
    }

    private void layoutOtherItems() {
        int componentCount = this.view.getComponentCount();
        for (int i = 0; i < componentCount; ++i) {
            Component component = this.view.getComponent(i);
            if (component instanceof NodeMotionListenerView) {
                NodeMotionListenerView nodeMotionListenerView = (NodeMotionListenerView)component;
                this.layoutNodeMotionListenerView(nodeMotionListenerView);
                continue;
            }
            if (!(component instanceof NodeFoldingComponent)) continue;
            NodeFoldingComponent foldingComponent = (NodeFoldingComponent)component;
            this.layoutNodeFoldingComponent(foldingComponent);
        }
    }

    protected abstract void layout();

    private void setUp(Container c) {
        NodeView localView = (NodeView)c;
        localView.syncronizeAttributeView();
        int localChildCount = localView.getComponentCount() - 1;
        for (int i = 0; i < localChildCount; ++i) {
            localView.getComponent(i).validate();
        }
        this.view = localView;
        this.model = localView.getModel();
        this.childCount = localChildCount;
        this.content = localView.getContent();
        this.vGap = this.getModel().isVisible() ? this.getView().getVGap() : this.getView().getVisibleParentView().getVGap();
        this.spaceAround = this.view.getMap().getZoomed(50);
    }

    private void shutDown() {
        this.view = null;
        this.model = null;
        this.content = null;
        this.childCount = 0;
        this.vGap = 0;
        this.spaceAround = 0;
    }

    protected NodeView getView() {
        return this.view;
    }

    protected MindMapNode getModel() {
        return this.model;
    }

    protected int getChildCount() {
        return this.childCount;
    }

    protected JComponent getContent() {
        return this.content;
    }

    protected int getChildContentHeight(boolean isLeft) {
        int childCount = this.getChildCount();
        if (childCount == 0) {
            return 0;
        }
        int height = 0;
        int count = 0;
        for (int i = 0; i < childCount; ++i) {
            NodeView child;
            Component component = this.getView().getComponent(i);
            if (!(component instanceof NodeView) || (child = (NodeView)component).isLeft() != isLeft) continue;
            int additionalCloudHeigth = child.getAdditionalCloudHeigth();
            int contentHeight = child.getContent().getHeight();
            height += contentHeight + additionalCloudHeigth;
            ++count;
        }
        return height + this.vGap * (count - 1);
    }

    protected int getChildVerticalShift(boolean isLeft) {
        int shift = 0;
        boolean isFirstNodeView = false;
        boolean foundNodeView = false;
        for (int i = 0; i < this.getChildCount(); ++i) {
            NodeView child;
            Component component = this.getView().getComponent(i);
            if (!(component instanceof NodeView) || (child = (NodeView)component).isLeft() != isLeft) continue;
            int childShift = child.getShift();
            if (childShift < 0 || isFirstNodeView) {
                shift += childShift;
                isFirstNodeView = false;
            }
            shift -= child.getContent().getY() - this.getSpaceAround();
            foundNodeView = true;
        }
        if (foundNodeView) {
            shift -= this.getSpaceAround();
        }
        return shift;
    }

    protected int getChildHorizontalShift() {
        if (this.getChildCount() == 0) {
            return 0;
        }
        int shift = 0;
        for (int i = 0; i < this.getChildCount(); ++i) {
            int shiftCandidate;
            Component component = this.getView().getComponent(i);
            if (!(component instanceof NodeView)) continue;
            NodeView child = (NodeView)component;
            if (child.isLeft()) {
                shiftCandidate = -child.getContent().getX() - child.getContent().getWidth();
                if (child.isContentVisible()) {
                    shiftCandidate -= child.getHGap() + child.getAdditionalCloudHeigth() / 2;
                }
            } else {
                shiftCandidate = -child.getContent().getX();
                if (child.isContentVisible()) {
                    shiftCandidate += child.getHGap();
                }
            }
            shift = Math.min(shift, shiftCandidate);
        }
        return shift;
    }

    protected void placeRightChildren(int childVerticalShift) {
        int baseX = this.getContent().getX() + this.getContent().getWidth();
        int y = this.getContent().getY() + childVerticalShift;
        int right = baseX + this.getSpaceAround();
        NodeView child = null;
        for (int i = 0; i < this.getChildCount(); ++i) {
            NodeView component;
            Component componentC = this.getView().getComponent(i);
            if (!(componentC instanceof NodeView) || (component = (NodeView)componentC).isLeft()) continue;
            child = component;
            int additionalCloudHeigth = child.getAdditionalCloudHeigth() / 2;
            y += additionalCloudHeigth;
            int shiftY = child.getShift();
            int childHGap = child.getContent().isVisible() ? child.getHGap() : 0;
            int x = baseX + childHGap - child.getContent().getX();
            if (shiftY < 0) {
                child.setLocation(x, y);
                y -= shiftY;
            } else {
                child.setLocation(x, y += shiftY);
            }
            y += child.getHeight() - 2 * this.getSpaceAround() + this.getVGap() + additionalCloudHeigth;
            right = Math.max(right, x + child.getWidth() + additionalCloudHeigth);
        }
        int bottom = this.getContent().getY() + this.getContent().getHeight() + this.getSpaceAround();
        if (child != null) {
            this.getView().setSize(right, Math.max(bottom, child.getY() + child.getHeight() + child.getAdditionalCloudHeigth() / 2));
        } else {
            this.getView().setSize(right, bottom);
        }
    }

    protected void placeLeftChildren(int childVerticalShift) {
        int baseX = this.getContent().getX();
        int y = this.getContent().getY() + childVerticalShift;
        int right = baseX + this.getContent().getWidth() + this.getSpaceAround();
        NodeView child = null;
        for (int i = 0; i < this.getChildCount(); ++i) {
            NodeView component;
            Component componentC = this.getView().getComponent(i);
            if (!(componentC instanceof NodeView) || !(component = (NodeView)componentC).isLeft()) continue;
            child = component;
            int additionalCloudHeigth = child.getAdditionalCloudHeigth() / 2;
            y += additionalCloudHeigth;
            int shiftY = child.getShift();
            int childHGap = child.getContent().isVisible() ? child.getHGap() : 0;
            int x = baseX - childHGap - child.getContent().getX() - child.getContent().getWidth();
            if (shiftY < 0) {
                child.setLocation(x, y);
                y -= shiftY;
            } else {
                child.setLocation(x, y += shiftY);
            }
            y += child.getHeight() - 2 * this.getSpaceAround() + this.getVGap() + additionalCloudHeigth;
            right = Math.max(right, x + child.getWidth());
        }
        int bottom = this.getContent().getY() + this.getContent().getHeight() + this.getSpaceAround();
        if (child != null) {
            this.getView().setSize(right, Math.max(bottom, child.getY() + child.getHeight() + child.getAdditionalCloudHeigth() / 2));
        } else {
            this.getView().setSize(right, bottom);
        }
    }

    int getVGap() {
        return this.vGap;
    }

    int getSpaceAround() {
        return this.spaceAround;
    }

    @Override
    public void layoutNodeFoldingComponent(NodeFoldingComponent pFoldingComponent) {
        NodeView movedView = pFoldingComponent.getNodeView();
        Point location = movedView.getFoldingMarkPosition();
        JComponent content = movedView.getContent();
        Tools.convertPointToAncestor((Component)content, location, pFoldingComponent.getParent());
        pFoldingComponent.setCorrectedLocation(location);
        Dimension preferredSize = pFoldingComponent.getPreferredSize();
        pFoldingComponent.setSize(preferredSize.width, preferredSize.height);
    }
}

