/*
 * Decompiled with CFR 0.152.
 */
package org.fibs.geotag.dcraw;

import com.acme.JPM.Decoders.PpmDecoder;
import java.awt.Frame;
import java.awt.Image;
import java.awt.MediaTracker;
import java.awt.Toolkit;
import java.awt.image.BufferedImage;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import javax.imageio.ImageIO;
import org.fibs.geotag.Settings;
import org.fibs.geotag.util.ImageInputStreamGobbler;
import org.fibs.geotag.util.ImageUtil;
import org.fibs.geotag.util.InputStreamGobbler;
import org.fibs.geotag.util.Util;

public final class Dcraw {
    private static boolean available = false;

    private Dcraw() {
    }

    public static boolean isAvailable() {
        return available;
    }

    public static void checkDcrawAvailable() {
        boolean found = true;
        ArrayList<String> command = new ArrayList<String>();
        String dcraw = Settings.get(Settings.SETTING.DCRAW_PATH, "dcraw");
        command.add(dcraw);
        command.add("-v");
        ProcessBuilder processBuilder = new ProcessBuilder(command);
        try {
            Process process = processBuilder.redirectErrorStream(true).start();
            new InputStreamGobbler(process, (OutputStream)System.out).start();
            process.waitFor();
        }
        catch (IOException e) {
            e.printStackTrace();
            found = false;
        }
        catch (InterruptedException e) {
            e.printStackTrace();
            found = false;
        }
        available = found;
    }

    public static BufferedImage getEmbeddedImage(File rawFile) {
        byte[] imageData;
        long start;
        block11: {
            if (!available) {
                return null;
            }
            start = System.currentTimeMillis();
            ArrayList<String> command = new ArrayList<String>();
            String dcraw = Settings.get(Settings.SETTING.DCRAW_PATH, "dcraw");
            command.add(dcraw);
            command.add("-c");
            command.add("-e");
            command.add(rawFile.getPath());
            ProcessBuilder processBuilder = new ProcessBuilder(command);
            try {
                Process process = processBuilder.redirectErrorStream(true).start();
                InputStream inputStream = process.getInputStream();
                ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
                ImageInputStreamGobbler gobbler = new ImageInputStreamGobbler(inputStream, (OutputStream)outputStream);
                gobbler.start();
                try {
                    process.waitFor();
                    int sleeptime = 10;
                    while (gobbler.isAlive()) {
                        Thread.sleep(10L);
                    }
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                }
                imageData = outputStream.toByteArray();
                byte[] filenameBytes = rawFile.getPath().getBytes();
                inputStream.close();
                outputStream.close();
                if (!Util.startsWith(imageData, filenameBytes)) break block11;
                System.err.println(new String(imageData));
                return null;
            }
            catch (IOException e) {
                e.printStackTrace();
                return null;
            }
        }
        ByteArrayInputStream imageStream = new ByteArrayInputStream(imageData);
        long readStart = System.currentTimeMillis();
        BufferedImage bufferedImage = ImageIO.read(imageStream);
        long readEnd = System.currentTimeMillis();
        imageStream.close();
        if (bufferedImage == null) {
            imageStream = new ByteArrayInputStream(imageData);
            PpmDecoder producer = new PpmDecoder(imageStream);
            Image image = Toolkit.getDefaultToolkit().createImage(producer);
            MediaTracker mediaTracker = new MediaTracker(new Frame());
            mediaTracker.addImage(image, 0);
            try {
                mediaTracker.waitForID(0);
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
            bufferedImage = ImageUtil.bufferImage(image);
            imageStream.close();
        }
        if (bufferedImage == null) {
            System.err.println("No thumbnail for " + rawFile.getName() + ' ' + imageData.length + " bytes");
        }
        long finished = System.currentTimeMillis();
        System.out.println("Loading RAW " + rawFile.getName() + " " + (double)(finished - start) / 1000.0 + " (" + (double)(readEnd - readStart) / 1000.0 + ")");
        return bufferedImage;
    }

    public static void main(String[] args) {
        int[] bufferSizes;
        if (args.length != 1) {
            System.out.println("Usage java " + Dcraw.class.getCanonicalName() + " <filename>");
            return;
        }
        Dcraw.checkDcrawAvailable();
        System.out.println(args[0]);
        int[] nArray = bufferSizes = new int[]{1, 1024, 2048, 10240, 16384, 20480, 0xA00000};
        int n = bufferSizes.length;
        int n2 = 0;
        while (n2 < n) {
            int bufferSize = nArray[n2];
            ImageInputStreamGobbler.setDefaultBufferSize(bufferSize);
            File file = new File(args[0]);
            long start = System.currentTimeMillis();
            BufferedImage image = Dcraw.getEmbeddedImage(file);
            System.out.println(image.getHeight());
            long stop = System.currentTimeMillis();
            System.out.println("Buffer: " + bufferSize + " : " + (stop - start) + "ms");
            ++n2;
        }
    }
}

