/*
 * Decompiled with CFR 0.152.
 */
package org.gephi.utils;

import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.image.BufferedImage;

public class TimeIntervalGraphics {
    public static final Color DEFAULT_FILL = new Color(153, 255, 255);
    public static final Color DEFAULT_BORDER = new Color(2, 104, 255);
    private double min;
    private double max;
    private double range;

    public TimeIntervalGraphics(double min, double max) {
        min = this.normalize(min);
        max = this.normalize(max);
        if (min > max) {
            throw new IllegalArgumentException("min should be less or equal than max");
        }
        this.min = min;
        this.max = max;
        this.calculateRange();
    }

    private void calculateRange() {
        this.range = this.max - this.min;
    }

    public BufferedImage createTimeIntervalImage(double start, double end, int width, int height) {
        return this.createTimeIntervalImage(start, end, width, height, null, null, null);
    }

    public BufferedImage createTimeIntervalImage(double start, double end, int width, int height, Color fill, Color border) {
        return this.createTimeIntervalImage(start, end, width, height, fill, border, null);
    }

    public BufferedImage createTimeIntervalImage(double start, double end, int width, int height, Color fill, Color border, Color background) {
        if (start > end) {
            throw new IllegalArgumentException("start should be less or equal than end");
        }
        return this.createTimeIntervalImage(new double[]{start}, new double[]{end}, width, height, fill, border, background);
    }

    public BufferedImage createTimeIntervalImage(double[] starts, double[] ends, int width, int height, Color fill, Color border, Color background) {
        if (starts.length != ends.length) {
            throw new IllegalArgumentException("start and ends length should be equal");
        }
        if (fill == null) {
            fill = DEFAULT_FILL;
        }
        if (border == null) {
            border = DEFAULT_BORDER;
        }
        BufferedImage image = new BufferedImage(width, height, 2);
        Graphics2D g = image.createGraphics();
        g.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        if (background != null) {
            g.setBackground(background);
            g.clearRect(0, 0, width, height);
        }
        g.translate(1, 0);
        width -= 2;
        if (this.range == 0.0) {
            g.setColor(fill);
            g.fillRect(0, 0, width, height);
            g.setColor(border);
            g.drawLine(-1, 0, -1, height);
            g.drawLine(width, 0, width, height);
        } else {
            double xTickWidth = (double)width / this.range;
            for (int i = 0; i < starts.length; ++i) {
                g.setColor(fill);
                int startPixel = (int)(xTickWidth * (this.normalizeToRange(starts[i]) - this.min));
                int endPixel = (int)(xTickWidth * (this.normalizeToRange(ends[i]) - this.min));
                int rectWidth = endPixel - startPixel;
                if (rectWidth == 0) {
                    rectWidth = 1;
                }
                g.fillRect(startPixel, 0, rectWidth, height);
                g.setColor(border);
                g.drawLine(startPixel, 0, startPixel, height);
                g.drawLine(endPixel, 0, endPixel, height);
            }
        }
        return image;
    }

    public double getMax() {
        return this.max;
    }

    public void setMax(double max) {
        if ((max = this.normalize(max)) < this.min) {
            throw new IllegalArgumentException("min should be less or equal than max");
        }
        this.max = max;
        this.calculateRange();
    }

    public double getMin() {
        return this.min;
    }

    public void setMin(double min) {
        if (this.max < (min = this.normalize(min))) {
            throw new IllegalArgumentException("min should be less or equal than max");
        }
        this.min = min;
        this.calculateRange();
    }

    private double normalize(double d) {
        if (d == Double.NEGATIVE_INFINITY) {
            return -1.7976931348623157E308;
        }
        if (d == Double.POSITIVE_INFINITY) {
            return Double.MAX_VALUE;
        }
        return d;
    }

    private double normalizeToRange(double d) {
        if (d == Double.NEGATIVE_INFINITY || d < this.min) {
            return this.min;
        }
        if (d == Double.POSITIVE_INFINITY || d > this.max) {
            return this.max;
        }
        return d;
    }

    public void setMinMax(double min, double max) {
        min = this.normalize(min);
        if ((max = this.normalize(max)) < min) {
            throw new IllegalArgumentException("min should be less or equal than max");
        }
        this.min = min;
        this.max = max;
        this.calculateRange();
    }
}

