/*
 * Decompiled with CFR 0.152.
 */
package tim.prune.correlate;

import javax.swing.JOptionPane;
import tim.prune.App;
import tim.prune.I18nManager;
import tim.prune.UpdateMessageBroker;
import tim.prune.correlate.Correlator;
import tim.prune.correlate.MediaPreviewTableModel;
import tim.prune.correlate.MediaPreviewTableRow;
import tim.prune.correlate.PointMediaPair;
import tim.prune.data.DataPoint;
import tim.prune.data.MediaList;
import tim.prune.data.MediaObject;
import tim.prune.data.Photo;
import tim.prune.data.PhotoList;
import tim.prune.data.TimeDifference;
import tim.prune.undo.UndoCorrelatePhotos;

public class PhotoCorrelator
extends Correlator {
    public PhotoCorrelator(App app) {
        super(app);
    }

    public String getNameKey() {
        return "function.correlatephotos";
    }

    protected String getMediaTypeKey() {
        return "photo";
    }

    protected MediaList getMediaList() {
        return this._app.getTrackInfo().getPhotoList();
    }

    protected void createPreview(TimeDifference timeDifference, boolean bl) {
        TimeDifference timeDifference2 = this.parseTimeLimit();
        double d = this.parseDistanceLimit();
        MediaPreviewTableModel mediaPreviewTableModel = new MediaPreviewTableModel("dialog.correlate.select.photoname");
        PhotoList photoList = this._app.getTrackInfo().getPhotoList();
        int n = photoList.getNumPhotos();
        int n2 = 0;
        while (n2 < n) {
            Photo photo = photoList.getPhoto(n2);
            PointMediaPair pointMediaPair = this.getPointPairForMedia(this._app.getTrackInfo().getTrack(), photo, timeDifference);
            MediaPreviewTableRow mediaPreviewTableRow = new MediaPreviewTableRow(pointMediaPair);
            boolean bl2 = pointMediaPair.isValid();
            if (photo.getCurrentStatus() != MediaObject.Status.NOT_CONNECTED) {
                bl2 = false;
            }
            if (timeDifference2 != null && bl2) {
                long l = pointMediaPair.getMinSeconds();
                boolean bl3 = bl2 = l <= timeDifference2.getTotalSeconds();
            }
            if (d > 0.0 && bl2) {
                double d2;
                double d3 = DataPoint.calculateRadiansBetween(pointMediaPair.getPointBefore(), pointMediaPair.getPointAfter());
                double d4 = pointMediaPair.getFraction();
                if (d4 > 0.5) {
                    d4 = 1.0 - d4;
                }
                boolean bl4 = bl2 = (d2 = d3 * d4) < d;
            }
            if (pointMediaPair.getSecondsBefore() == 0L && pointMediaPair.getPointBefore().isDuplicate(photo.getDataPoint())) {
                bl2 = false;
            }
            mediaPreviewTableRow.setCorrelateFlag(bl2);
            mediaPreviewTableModel.addRow(mediaPreviewTableRow);
            ++n2;
        }
        this._previewTable.setModel(mediaPreviewTableModel);
        mediaPreviewTableModel.setDistanceUnits(this.getSelectedDistanceUnits());
        this._previewTable.setAutoResizeMode(4);
        int[] nArray = new int[]{150, 160, 100, 100, 50};
        int n3 = 0;
        while (n3 < mediaPreviewTableModel.getColumnCount()) {
            this._previewTable.getColumnModel().getColumn(n3).setPreferredWidth(nArray[n3]);
            ++n3;
        }
        this._okButton.setEnabled(mediaPreviewTableModel.hasAnySelected());
        if (bl && !mediaPreviewTableModel.hasAnySelected()) {
            JOptionPane.showMessageDialog(this._dialog, I18nManager.getText("dialog.correlate.alloutsiderange"), I18nManager.getText(this.getNameKey()), 0);
        }
    }

    protected void finishCorrelation() {
        Object object;
        PointMediaPair[] pointMediaPairArray = this.getPointPairs();
        if (pointMediaPairArray == null || pointMediaPairArray.length <= 0) {
            return;
        }
        UndoCorrelatePhotos undoCorrelatePhotos = new UndoCorrelatePhotos(this._app.getTrackInfo());
        int n = pointMediaPairArray.length;
        int n2 = 0;
        int n3 = 0;
        int n4 = 0;
        PointMediaPair pointMediaPair = null;
        n2 = 0;
        while (n2 < n) {
            pointMediaPair = pointMediaPairArray[n2];
            if (pointMediaPair != null && pointMediaPair.isValid()) {
                if (pointMediaPair.getMinSeconds() == 0L) {
                    object = pointMediaPair.getPointBefore().getPhoto();
                    if (object == null) {
                        pointMediaPair.getPointBefore().setPhoto((Photo)pointMediaPair.getMedia());
                        pointMediaPair.getMedia().setDataPoint(pointMediaPair.getPointBefore());
                    } else if (!object.equals(pointMediaPair.getMedia())) {
                        ++n4;
                    }
                } else {
                    ++n4;
                }
                ++n3;
            }
            ++n2;
        }
        if (n4 > 0) {
            object = new DataPoint[n4];
            int n5 = 0;
            DataPoint dataPoint = null;
            n2 = 0;
            while (n2 < n) {
                pointMediaPair = pointMediaPairArray[n2];
                if (pointMediaPair != null && pointMediaPair.isValid()) {
                    dataPoint = null;
                    if (pointMediaPair.getMinSeconds() == 0L && pointMediaPair.getPointBefore().getPhoto() != null && !pointMediaPair.getPointBefore().getPhoto().equals(pointMediaPair.getMedia())) {
                        dataPoint = pointMediaPair.getPointBefore().clonePoint();
                    } else if (pointMediaPair.getMinSeconds() > 0L) {
                        dataPoint = DataPoint.interpolate(pointMediaPair.getPointBefore(), pointMediaPair.getPointAfter(), pointMediaPair.getFraction());
                    }
                    if (dataPoint != null) {
                        dataPoint.setPhoto((Photo)pointMediaPair.getMedia());
                        pointMediaPair.getMedia().setDataPoint(dataPoint);
                        dataPoint.setSegmentStart(true);
                        object[n5] = dataPoint;
                        ++n5;
                    }
                }
                ++n2;
            }
            this._app.getTrackInfo().getTrack().appendPoints((DataPoint[])object);
        }
        undoCorrelatePhotos.setNumPhotosCorrelated(n3);
        this._app.completeFunction(undoCorrelatePhotos, n3 + " " + (n3 == 1 ? I18nManager.getText("confirm.correlatephotos.single") : I18nManager.getText("confirm.correlatephotos.multi")));
        if (n4 == 0) {
            UpdateMessageBroker.informSubscribers((byte)4);
        }
    }
}

