/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.jcs.auxiliary.remote;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.InetSocketAddress;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.URL;
import java.rmi.RemoteException;
import java.rmi.registry.LocateRegistry;
import java.rmi.registry.Registry;
import java.rmi.server.RMISocketFactory;
import java.util.Enumeration;
import java.util.Properties;
import org.apache.commons.jcs.auxiliary.remote.RemoteLocation;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class RemoteUtils {
    private static final Log log = LogFactory.getLog(RemoteUtils.class);

    private RemoteUtils() {
    }

    public static Registry createRegistry(int port) {
        Registry registry = null;
        if (port < 1024) {
            if (log.isWarnEnabled()) {
                log.warn("createRegistry> Port chosen was less than 1024, will use default [1099] instead.");
            }
            port = 1099;
        }
        try {
            registry = LocateRegistry.createRegistry(port);
            log.info("createRegistry> Created the registry on port " + port);
        }
        catch (RemoteException e) {
            log.warn("createRegistry> Problem creating registry. It may already be started. " + e.getMessage());
        }
        catch (Throwable t) {
            log.error("createRegistry> Problem creating registry.", t);
        }
        if (registry == null) {
            try {
                registry = LocateRegistry.getRegistry(port);
            }
            catch (RemoteException e) {
                log.error("createRegistry> Problem getting a registry reference.", e);
            }
        }
        return registry;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Properties loadProps(String propFile) throws IOException {
        InputStream is = RemoteUtils.class.getResourceAsStream(propFile);
        if (null == is && propFile != null && !propFile.startsWith("/")) {
            is = RemoteUtils.class.getResourceAsStream("/" + propFile);
        }
        if (null == is) {
            is = new File(propFile).exists() ? new FileInputStream(propFile) : new URL(propFile).openStream();
        }
        Properties props = new Properties();
        try {
            props.load(is);
            if (log.isDebugEnabled()) {
                log.debug("props.size=" + props.size());
            }
            if (log.isDebugEnabled()) {
                Enumeration<Object> en = props.keys();
                StringBuilder buf = new StringBuilder();
                while (en.hasMoreElements()) {
                    String key = (String)en.nextElement();
                    buf.append("\n" + key + " = " + props.getProperty(key));
                }
                log.debug(buf.toString());
            }
        }
        catch (Exception ex) {
            log.error("Error loading remote properties, for file name [" + propFile + "]", ex);
        }
        finally {
            if (is != null) {
                is.close();
            }
        }
        return props;
    }

    public static void configureGlobalCustomSocketFactory(final int timeoutMillis) {
        block4: {
            try {
                if (timeoutMillis > 0) {
                    if (log.isInfoEnabled()) {
                        log.info("RmiSocketFactoryTimeoutMillis [" + timeoutMillis + "].  Configuring a custom socket factory.");
                    }
                    RMISocketFactory.setSocketFactory(new RMISocketFactory(){

                        @Override
                        public Socket createSocket(String host, int port) throws IOException {
                            Socket socket = new Socket();
                            socket.setSoTimeout(timeoutMillis);
                            socket.setSoLinger(false, 0);
                            socket.connect(new InetSocketAddress(host, port), timeoutMillis);
                            return socket;
                        }

                        @Override
                        public ServerSocket createServerSocket(int port) throws IOException {
                            return new ServerSocket(port);
                        }
                    });
                }
            }
            catch (IOException e) {
                RMISocketFactory factoryInUse = RMISocketFactory.getSocketFactory();
                if (factoryInUse == null || factoryInUse.getClass().getName().startsWith("org.apache.commons.jcs")) break block4;
                log.info("Could not create new custom socket factory. " + e.getMessage() + " Factory in use = " + RMISocketFactory.getSocketFactory());
            }
        }
    }

    public static String getNamingURL(RemoteLocation location, String serviceName) {
        return RemoteUtils.getNamingURL(location.getHost(), location.getPort(), serviceName);
    }

    public static String getNamingURL(String registryHost, int registryPort, String serviceName) {
        if (registryHost.contains(":")) {
            return "//[" + registryHost.replaceFirst("%", "%25") + "]:" + registryPort + "/" + serviceName;
        }
        String registryURL = "//" + registryHost + ":" + registryPort + "/" + serviceName;
        return registryURL;
    }
}

