/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.data.tagging.ac;

import org.openstreetmap.josm.data.tagging.ac.AutoCompletionPriority;

public class AutoCompletionItem
implements Comparable<AutoCompletionItem> {
    private AutoCompletionPriority priority;
    private final String value;

    public AutoCompletionItem(String value, AutoCompletionPriority priority) {
        this.value = value;
        this.priority = priority;
    }

    public AutoCompletionItem(String value) {
        this.value = value;
        this.priority = AutoCompletionPriority.UNKNOWN;
    }

    public AutoCompletionItem() {
        this.value = "";
        this.priority = AutoCompletionPriority.UNKNOWN;
    }

    public AutoCompletionPriority getPriority() {
        return this.priority;
    }

    public void setPriority(AutoCompletionPriority priority) {
        this.priority = priority;
    }

    public String getValue() {
        return this.value;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("<val='").append(this.value).append("',").append(this.priority).append('>');
        return sb.toString();
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.priority == null ? 0 : this.priority.hashCode());
        result = 31 * result + (this.value == null ? 0 : this.value.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (obj instanceof String) {
            return obj.equals(this.value);
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        AutoCompletionItem other = (AutoCompletionItem)obj;
        if (this.priority == null ? other.priority != null : !this.priority.equals(other.priority)) {
            return false;
        }
        return !(this.value == null ? other.value != null : !this.value.equals(other.value));
    }

    @Override
    public int compareTo(AutoCompletionItem other) {
        int ret = other.priority.compareTo(this.priority);
        if (ret != 0) {
            return ret;
        }
        return this.value.compareTo(other.value);
    }
}

