/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl.source.tree.java;

import com.intellij.lang.ASTNode;
import com.intellij.psi.JavaTokenType;
import com.intellij.psi.impl.PsiImplUtil;
import com.intellij.psi.impl.source.tree.CompositeElement;
import com.intellij.psi.impl.source.tree.Factory;
import com.intellij.psi.impl.source.tree.JavaElementType;
import com.intellij.psi.impl.source.tree.LeafElement;
import com.intellij.psi.impl.source.tree.SharedImplUtil;
import com.intellij.psi.impl.source.tree.TreeElement;
import com.intellij.psi.tree.IElementType;
import com.intellij.util.CharTable;
import org.jetbrains.annotations.NotNull;

public class ReferenceListElement
extends CompositeElement {
    private final IElementType myKeyword;
    private final String myKeywordText;
    private final IElementType mySeparator;
    private final String mySeparatorText;

    public ReferenceListElement(IElementType type2, IElementType keywordType, String keywordText) {
        this(type2, keywordType, keywordText, JavaTokenType.COMMA, ",");
    }

    public ReferenceListElement(IElementType type2, IElementType keyword, String keywordText, IElementType separator, String separatorText) {
        super(type2);
        this.myKeyword = keyword;
        this.myKeywordText = keywordText;
        this.mySeparator = separator;
        this.mySeparatorText = separatorText;
    }

    @Override
    public TreeElement addInternal(TreeElement first2, ASTNode last2, ASTNode anchor2, Boolean before) {
        TreeElement firstAdded = super.addInternal(first2, last2, anchor2, before);
        CharTable treeCharTab = SharedImplUtil.findCharTableByTree(this);
        if (first2 == last2 && first2.getElementType() == JavaElementType.JAVA_CODE_REFERENCE) {
            LeafElement separator;
            ASTNode child;
            for (child = first2.getTreeNext(); child != null && child.getElementType() != this.mySeparator; child = child.getTreeNext()) {
                if (child.getElementType() != JavaElementType.JAVA_CODE_REFERENCE) continue;
                separator = Factory.createSingleLeafElement(this.mySeparator, this.mySeparatorText, treeCharTab, this.getManager());
                super.addInternal(separator, separator, first2, Boolean.FALSE);
                break;
            }
            for (child = first2.getTreePrev(); child != null && child.getElementType() != this.mySeparator; child = child.getTreePrev()) {
                if (child.getElementType() != JavaElementType.JAVA_CODE_REFERENCE) continue;
                separator = Factory.createSingleLeafElement(this.mySeparator, this.mySeparatorText, treeCharTab, this.getManager());
                super.addInternal(separator, separator, child, Boolean.FALSE);
                break;
            }
        }
        if (this.findChildByType(this.myKeyword) == null && this.findChildByType(JavaElementType.JAVA_CODE_REFERENCE) != null) {
            LeafElement keyword = Factory.createSingleLeafElement(this.myKeyword, this.myKeywordText, treeCharTab, this.getManager());
            super.addInternal(keyword, keyword, this.getFirstChildNode(), Boolean.TRUE);
        }
        return firstAdded;
    }

    @Override
    public void deleteChildInternal(@NotNull ASTNode child) {
        if (child == null) {
            ReferenceListElement.$$$reportNull$$$0(0);
        }
        if (child.getElementType() == JavaElementType.JAVA_CODE_REFERENCE) {
            ASTNode next = PsiImplUtil.skipWhitespaceAndComments(child.getTreeNext());
            if (next != null && next.getElementType() == this.mySeparator) {
                this.deleteChildInternal(next);
            } else {
                ASTNode prev = PsiImplUtil.skipWhitespaceAndCommentsBack(child.getTreePrev());
                if (prev != null && (prev.getElementType() == this.mySeparator || prev.getElementType() == this.myKeyword)) {
                    this.deleteChildInternal(prev);
                }
            }
        }
        super.deleteChildInternal(child);
    }

    @Override
    public int getChildRole(@NotNull ASTNode child) {
        if (child == null) {
            ReferenceListElement.$$$reportNull$$$0(1);
        }
        assert (child.getTreeParent() == this) : child;
        IElementType childType = child.getElementType();
        if (childType == JavaTokenType.COMMA) {
            return 23;
        }
        if (childType == JavaElementType.JAVA_CODE_REFERENCE) {
            return 29;
        }
        return 0;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        objectArray2[0] = "child";
        objectArray2[1] = "com/intellij/psi/impl/source/tree/java/ReferenceListElement";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "deleteChildInternal";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "getChildRole";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

