/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.fir.resolve.diagnostics.collectors.components;

import com.intellij.psi.PsiElement;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.TypeCastException;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.diagnostics.DiagnosticFactory0;
import org.jetbrains.kotlin.diagnostics.DiagnosticFactory1;
import org.jetbrains.kotlin.diagnostics.DiagnosticFactory2;
import org.jetbrains.kotlin.diagnostics.DiagnosticFactoryWithPsiElement;
import org.jetbrains.kotlin.diagnostics.Errors;
import org.jetbrains.kotlin.diagnostics.FirErrors;
import org.jetbrains.kotlin.diagnostics.ParametrizedDiagnostic;
import org.jetbrains.kotlin.diagnostics.SimpleDiagnostic;
import org.jetbrains.kotlin.fir.FirSourceElement;
import org.jetbrains.kotlin.fir.FirSourceElementKt;
import org.jetbrains.kotlin.fir.declarations.FirErrorFunction;
import org.jetbrains.kotlin.fir.diagnostics.FirDiagnostic;
import org.jetbrains.kotlin.fir.diagnostics.FirSimpleDiagnostic;
import org.jetbrains.kotlin.fir.diagnostics.FirStubDiagnostic;
import org.jetbrains.kotlin.fir.expressions.FirErrorExpression;
import org.jetbrains.kotlin.fir.expressions.FirErrorLoop;
import org.jetbrains.kotlin.fir.references.FirErrorNamedReference;
import org.jetbrains.kotlin.fir.resolve.diagnostics.ConeDiagnostic;
import org.jetbrains.kotlin.fir.resolve.diagnostics.DiagnosticReporter;
import org.jetbrains.kotlin.fir.resolve.diagnostics.FirAmbiguityError;
import org.jetbrains.kotlin.fir.resolve.diagnostics.FirInapplicableCandidateError;
import org.jetbrains.kotlin.fir.resolve.diagnostics.FirOperatorAmbiguityError;
import org.jetbrains.kotlin.fir.resolve.diagnostics.FirTypeMismatchError;
import org.jetbrains.kotlin.fir.resolve.diagnostics.FirUnresolvedNameError;
import org.jetbrains.kotlin.fir.resolve.diagnostics.FirUnresolvedReferenceError;
import org.jetbrains.kotlin.fir.resolve.diagnostics.FirUnresolvedSymbolError;
import org.jetbrains.kotlin.fir.resolve.diagnostics.FirVariableExpectedError;
import org.jetbrains.kotlin.fir.resolve.diagnostics.collectors.AbstractDiagnosticCollector;
import org.jetbrains.kotlin.fir.resolve.diagnostics.collectors.components.AbstractDiagnosticCollectorComponent;
import org.jetbrains.kotlin.fir.resolve.diagnostics.collectors.components.ErrorNodeDiagnosticCollectorComponent$WhenMappings;
import org.jetbrains.kotlin.fir.symbols.AbstractFirBasedSymbol;
import org.jetbrains.kotlin.fir.types.ConeKotlinType;
import org.jetbrains.kotlin.fir.types.FirErrorTypeRef;
import org.jetbrains.kotlin.name.Name;
import org.jetbrains.kotlin.psi.KtElement;
import org.jetbrains.kotlin.psi.KtExpression;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000`\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J \u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0002J\u0010\u0010\r\u001a\u00020\u00062\u0006\u0010\u000e\u001a\u00020\u000fH\u0016J\u0010\u0010\u0010\u001a\u00020\u00062\u0006\u0010\u0011\u001a\u00020\u0012H\u0016J\u0010\u0010\u0013\u001a\u00020\u00062\u0006\u0010\u0014\u001a\u00020\u0015H\u0016J\u0010\u0010\u0016\u001a\u00020\u00062\u0006\u0010\u0017\u001a\u00020\u0018H\u0016J\u0010\u0010\u0019\u001a\u00020\u00062\u0006\u0010\u001a\u001a\u00020\u001bH\u0016J\u0012\u0010\u001c\u001a\b\u0012\u0004\u0012\u00020\u001e0\u001d*\u00020\u001fH\u0002\u00a8\u0006 "}, d2={"Lorg/jetbrains/kotlin/fir/resolve/diagnostics/collectors/components/ErrorNodeDiagnosticCollectorComponent;", "Lorg/jetbrains/kotlin/fir/resolve/diagnostics/collectors/components/AbstractDiagnosticCollectorComponent;", "collector", "Lorg/jetbrains/kotlin/fir/resolve/diagnostics/collectors/AbstractDiagnosticCollector;", "(Lorg/jetbrains/kotlin/fir/resolve/diagnostics/collectors/AbstractDiagnosticCollector;)V", "reportFirDiagnostic", "", "diagnostic", "Lorg/jetbrains/kotlin/fir/diagnostics/FirDiagnostic;", "source", "Lorg/jetbrains/kotlin/fir/FirSourceElement;", "reporter", "Lorg/jetbrains/kotlin/fir/resolve/diagnostics/DiagnosticReporter;", "visitErrorExpression", "errorExpression", "Lorg/jetbrains/kotlin/fir/expressions/FirErrorExpression;", "visitErrorFunction", "errorFunction", "Lorg/jetbrains/kotlin/fir/declarations/FirErrorFunction;", "visitErrorLoop", "errorLoop", "Lorg/jetbrains/kotlin/fir/expressions/FirErrorLoop;", "visitErrorNamedReference", "errorNamedReference", "Lorg/jetbrains/kotlin/fir/references/FirErrorNamedReference;", "visitErrorTypeRef", "errorTypeRef", "Lorg/jetbrains/kotlin/fir/types/FirErrorTypeRef;", "getFactory", "Lorg/jetbrains/kotlin/diagnostics/DiagnosticFactory0;", "Lcom/intellij/psi/PsiElement;", "Lorg/jetbrains/kotlin/fir/diagnostics/FirSimpleDiagnostic;", "resolve"})
public final class ErrorNodeDiagnosticCollectorComponent
extends AbstractDiagnosticCollectorComponent {
    @Override
    public void visitErrorLoop(@NotNull FirErrorLoop errorLoop) {
        Intrinsics.checkParameterIsNotNull(errorLoop, "errorLoop");
        FirSourceElement firSourceElement = errorLoop.getSource();
        if (firSourceElement == null) {
            return;
        }
        FirSourceElement source = firSourceElement;
        this.runCheck((Function1<? super DiagnosticReporter, Unit>)new Function1<DiagnosticReporter, Unit>(this, errorLoop, source){
            final /* synthetic */ ErrorNodeDiagnosticCollectorComponent this$0;
            final /* synthetic */ FirErrorLoop $errorLoop;
            final /* synthetic */ FirSourceElement $source;

            public final void invoke(@NotNull DiagnosticReporter it) {
                Intrinsics.checkParameterIsNotNull(it, "it");
                ErrorNodeDiagnosticCollectorComponent.access$reportFirDiagnostic(this.this$0, this.$errorLoop.getDiagnostic(), this.$source, it);
            }
            {
                this.this$0 = errorNodeDiagnosticCollectorComponent;
                this.$errorLoop = firErrorLoop;
                this.$source = firSourceElement;
                super(1);
            }
        });
    }

    @Override
    public void visitErrorTypeRef(@NotNull FirErrorTypeRef errorTypeRef) {
        Intrinsics.checkParameterIsNotNull(errorTypeRef, "errorTypeRef");
        FirSourceElement firSourceElement = errorTypeRef.getSource();
        if (firSourceElement == null) {
            return;
        }
        FirSourceElement source = firSourceElement;
        this.runCheck((Function1<? super DiagnosticReporter, Unit>)new Function1<DiagnosticReporter, Unit>(this, errorTypeRef, source){
            final /* synthetic */ ErrorNodeDiagnosticCollectorComponent this$0;
            final /* synthetic */ FirErrorTypeRef $errorTypeRef;
            final /* synthetic */ FirSourceElement $source;

            public final void invoke(@NotNull DiagnosticReporter it) {
                Intrinsics.checkParameterIsNotNull(it, "it");
                ErrorNodeDiagnosticCollectorComponent.access$reportFirDiagnostic(this.this$0, this.$errorTypeRef.getDiagnostic(), this.$source, it);
            }
            {
                this.this$0 = errorNodeDiagnosticCollectorComponent;
                this.$errorTypeRef = firErrorTypeRef;
                this.$source = firSourceElement;
                super(1);
            }
        });
    }

    @Override
    public void visitErrorNamedReference(@NotNull FirErrorNamedReference errorNamedReference) {
        Intrinsics.checkParameterIsNotNull(errorNamedReference, "errorNamedReference");
        FirSourceElement firSourceElement = errorNamedReference.getSource();
        if (firSourceElement == null) {
            return;
        }
        FirSourceElement source = firSourceElement;
        this.runCheck((Function1<? super DiagnosticReporter, Unit>)new Function1<DiagnosticReporter, Unit>(this, errorNamedReference, source){
            final /* synthetic */ ErrorNodeDiagnosticCollectorComponent this$0;
            final /* synthetic */ FirErrorNamedReference $errorNamedReference;
            final /* synthetic */ FirSourceElement $source;

            public final void invoke(@NotNull DiagnosticReporter it) {
                Intrinsics.checkParameterIsNotNull(it, "it");
                ErrorNodeDiagnosticCollectorComponent.access$reportFirDiagnostic(this.this$0, this.$errorNamedReference.getDiagnostic(), this.$source, it);
            }
            {
                this.this$0 = errorNodeDiagnosticCollectorComponent;
                this.$errorNamedReference = firErrorNamedReference;
                this.$source = firSourceElement;
                super(1);
            }
        });
    }

    @Override
    public void visitErrorExpression(@NotNull FirErrorExpression errorExpression) {
        Intrinsics.checkParameterIsNotNull(errorExpression, "errorExpression");
        FirSourceElement firSourceElement = errorExpression.getSource();
        if (firSourceElement == null) {
            return;
        }
        FirSourceElement source = firSourceElement;
        this.runCheck((Function1<? super DiagnosticReporter, Unit>)new Function1<DiagnosticReporter, Unit>(this, errorExpression, source){
            final /* synthetic */ ErrorNodeDiagnosticCollectorComponent this$0;
            final /* synthetic */ FirErrorExpression $errorExpression;
            final /* synthetic */ FirSourceElement $source;

            public final void invoke(@NotNull DiagnosticReporter it) {
                Intrinsics.checkParameterIsNotNull(it, "it");
                ErrorNodeDiagnosticCollectorComponent.access$reportFirDiagnostic(this.this$0, this.$errorExpression.getDiagnostic(), this.$source, it);
            }
            {
                this.this$0 = errorNodeDiagnosticCollectorComponent;
                this.$errorExpression = firErrorExpression;
                this.$source = firSourceElement;
                super(1);
            }
        });
    }

    @Override
    public void visitErrorFunction(@NotNull FirErrorFunction errorFunction) {
        Intrinsics.checkParameterIsNotNull(errorFunction, "errorFunction");
        FirSourceElement firSourceElement = errorFunction.getSource();
        if (firSourceElement == null) {
            return;
        }
        FirSourceElement source = firSourceElement;
        this.runCheck((Function1<? super DiagnosticReporter, Unit>)new Function1<DiagnosticReporter, Unit>(this, errorFunction, source){
            final /* synthetic */ ErrorNodeDiagnosticCollectorComponent this$0;
            final /* synthetic */ FirErrorFunction $errorFunction;
            final /* synthetic */ FirSourceElement $source;

            public final void invoke(@NotNull DiagnosticReporter it) {
                Intrinsics.checkParameterIsNotNull(it, "it");
                ErrorNodeDiagnosticCollectorComponent.access$reportFirDiagnostic(this.this$0, this.$errorFunction.getDiagnostic(), this.$source, it);
            }
            {
                this.this$0 = errorNodeDiagnosticCollectorComponent;
                this.$errorFunction = firErrorFunction;
                this.$source = firSourceElement;
                super(1);
            }
        });
    }

    /*
     * WARNING - void declaration
     */
    private final void reportFirDiagnostic(FirDiagnostic diagnostic, FirSourceElement source, DiagnosticReporter reporter) {
        DiagnosticFactoryWithPsiElement $this$onSource$iv;
        ConeDiagnostic coneDiagnostic;
        FirDiagnostic firDiagnostic = diagnostic;
        if (firDiagnostic instanceof FirUnresolvedReferenceError) {
            DiagnosticFactory1<KtElement, String> diagnosticFactory1 = FirErrors.INSTANCE.getUNRESOLVED_REFERENCE();
            Name name = ((FirUnresolvedReferenceError)diagnostic).getName();
            String a$iv = name != null ? name.asString() : null;
            boolean $i$f$onSource = false;
            PsiElement psiElement = FirSourceElementKt.getPsi(source);
            if (!(psiElement instanceof KtElement)) {
                psiElement = null;
            }
            PsiElement psiElement2 = (KtElement)psiElement;
            if (psiElement2 == null) {
                coneDiagnostic = null;
            } else {
                PsiElement psi$iv = psiElement2;
                ParametrizedDiagnostic<KtElement> parametrizedDiagnostic = ((DiagnosticFactory1)$this$onSource$iv).on((KtElement)psi$iv, (String)a$iv);
                Intrinsics.checkExpressionValueIsNotNull(parametrizedDiagnostic, "this.on(psi, a)");
                coneDiagnostic = new ConeDiagnostic(parametrizedDiagnostic, source);
            }
        } else if (firDiagnostic instanceof FirUnresolvedSymbolError) {
            $this$onSource$iv = FirErrors.INSTANCE.getUNRESOLVED_REFERENCE();
            String a$iv = ((FirUnresolvedSymbolError)diagnostic).getClassId().asString();
            boolean $i$f$onSource = false;
            PsiElement psiElement = FirSourceElementKt.getPsi(source);
            if (!(psiElement instanceof KtElement)) {
                psiElement = null;
            }
            PsiElement psiElement3 = (KtElement)psiElement;
            if (psiElement3 == null) {
                coneDiagnostic = null;
            } else {
                PsiElement psi$iv = psiElement3;
                ParametrizedDiagnostic<PsiElement> parametrizedDiagnostic = ((DiagnosticFactory1)$this$onSource$iv).on(psi$iv, a$iv);
                Intrinsics.checkExpressionValueIsNotNull(parametrizedDiagnostic, "this.on(psi, a)");
                coneDiagnostic = new ConeDiagnostic(parametrizedDiagnostic, source);
            }
        } else if (firDiagnostic instanceof FirUnresolvedNameError) {
            $this$onSource$iv = FirErrors.INSTANCE.getUNRESOLVED_REFERENCE();
            String a$iv = ((FirUnresolvedNameError)diagnostic).getName().asString();
            boolean $i$f$onSource = false;
            PsiElement psiElement = FirSourceElementKt.getPsi(source);
            if (!(psiElement instanceof KtElement)) {
                psiElement = null;
            }
            PsiElement psiElement4 = (KtElement)psiElement;
            if (psiElement4 == null) {
                coneDiagnostic = null;
            } else {
                PsiElement psi$iv = psiElement4;
                ParametrizedDiagnostic<KtElement> parametrizedDiagnostic = ((DiagnosticFactory1)$this$onSource$iv).on((KtElement)psi$iv, (String)a$iv);
                Intrinsics.checkExpressionValueIsNotNull(parametrizedDiagnostic, "this.on(psi, a)");
                coneDiagnostic = new ConeDiagnostic(parametrizedDiagnostic, source);
            }
        } else if (firDiagnostic instanceof FirInapplicableCandidateError) {
            void $this$mapTo$iv$iv;
            $this$onSource$iv = FirErrors.INSTANCE.getINAPPLICABLE_CANDIDATE();
            Iterable $this$map$iv = ((FirInapplicableCandidateError)diagnostic).getCandidates();
            boolean $i$f$map = false;
            Object psi$iv = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv, 10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void it;
                FirInapplicableCandidateError.CandidateInfo candidateInfo = (FirInapplicableCandidateError.CandidateInfo)item$iv$iv;
                Collection collection = destination$iv$iv;
                boolean bl = false;
                AbstractFirBasedSymbol<?> abstractFirBasedSymbol = it.getSymbol();
                collection.add(abstractFirBasedSymbol);
            }
            List a$iv = (List)destination$iv$iv;
            boolean $i$f$onSource = false;
            PsiElement psiElement = FirSourceElementKt.getPsi(source);
            if (!(psiElement instanceof KtElement)) {
                psiElement = null;
            }
            PsiElement psiElement5 = (KtElement)psiElement;
            if (psiElement5 == null) {
                coneDiagnostic = null;
            } else {
                psi$iv = psiElement5;
                ParametrizedDiagnostic<Object> parametrizedDiagnostic = ((DiagnosticFactory1)$this$onSource$iv).on(psi$iv, a$iv);
                Intrinsics.checkExpressionValueIsNotNull(parametrizedDiagnostic, "this.on(psi, a)");
                coneDiagnostic = new ConeDiagnostic(parametrizedDiagnostic, source);
            }
        } else if (firDiagnostic instanceof FirAmbiguityError) {
            $this$onSource$iv = FirErrors.INSTANCE.getAMBIGUITY();
            Collection<AbstractFirBasedSymbol<?>> a$iv = ((FirAmbiguityError)diagnostic).getCandidates();
            boolean $i$f$onSource = false;
            PsiElement psiElement = FirSourceElementKt.getPsi(source);
            if (!(psiElement instanceof KtElement)) {
                psiElement = null;
            }
            PsiElement psiElement6 = (KtElement)psiElement;
            if (psiElement6 == null) {
                coneDiagnostic = null;
            } else {
                PsiElement psi$iv = psiElement6;
                ParametrizedDiagnostic<PsiElement> parametrizedDiagnostic = ((DiagnosticFactory1)$this$onSource$iv).on(psi$iv, a$iv);
                Intrinsics.checkExpressionValueIsNotNull(parametrizedDiagnostic, "this.on(psi, a)");
                coneDiagnostic = new ConeDiagnostic(parametrizedDiagnostic, source);
            }
        } else if (firDiagnostic instanceof FirOperatorAmbiguityError) {
            $this$onSource$iv = FirErrors.INSTANCE.getASSIGN_OPERATOR_AMBIGUITY();
            Collection<AbstractFirBasedSymbol<?>> a$iv = ((FirOperatorAmbiguityError)diagnostic).getCandidates();
            boolean $i$f$onSource = false;
            PsiElement psiElement = FirSourceElementKt.getPsi(source);
            if (!(psiElement instanceof KtElement)) {
                psiElement = null;
            }
            PsiElement psiElement7 = (KtElement)psiElement;
            if (psiElement7 == null) {
                coneDiagnostic = null;
            } else {
                PsiElement psi$iv = psiElement7;
                ParametrizedDiagnostic<PsiElement> parametrizedDiagnostic = ((DiagnosticFactory1)$this$onSource$iv).on(psi$iv, a$iv);
                Intrinsics.checkExpressionValueIsNotNull(parametrizedDiagnostic, "this.on(psi, a)");
                coneDiagnostic = new ConeDiagnostic(parametrizedDiagnostic, source);
            }
        } else if (firDiagnostic instanceof FirVariableExpectedError) {
            DiagnosticFactory0<KtExpression> diagnosticFactory0 = Errors.VARIABLE_EXPECTED;
            Intrinsics.checkExpressionValueIsNotNull(diagnosticFactory0, "Errors.VARIABLE_EXPECTED");
            $this$onSource$iv = diagnosticFactory0;
            boolean $i$f$onSource = false;
            PsiElement psiElement = FirSourceElementKt.getPsi(source);
            if (!(psiElement instanceof KtExpression)) {
                psiElement = null;
            }
            PsiElement psiElement8 = (KtExpression)psiElement;
            if (psiElement8 == null) {
                coneDiagnostic = null;
            } else {
                PsiElement psi$iv = psiElement8;
                SimpleDiagnostic<PsiElement> simpleDiagnostic = ((DiagnosticFactory0)$this$onSource$iv).on(psi$iv);
                Intrinsics.checkExpressionValueIsNotNull(simpleDiagnostic, "this.on(psi)");
                coneDiagnostic = new ConeDiagnostic(simpleDiagnostic, source);
            }
        } else if (firDiagnostic instanceof FirTypeMismatchError) {
            $this$onSource$iv = FirErrors.INSTANCE.getTYPE_MISMATCH();
            ConeKotlinType $i$f$onSource = ((FirTypeMismatchError)diagnostic).getExpectedType();
            ConeKotlinType b$iv = ((FirTypeMismatchError)diagnostic).getActualType();
            boolean $i$f$onSource2 = false;
            PsiElement psiElement = FirSourceElementKt.getPsi(source);
            if (!(psiElement instanceof KtElement)) {
                psiElement = null;
            }
            PsiElement psiElement9 = (KtElement)psiElement;
            if (psiElement9 == null) {
                coneDiagnostic = null;
            } else {
                void a$iv;
                PsiElement psi$iv = psiElement9;
                ParametrizedDiagnostic<PsiElement> parametrizedDiagnostic = ((DiagnosticFactory2)$this$onSource$iv).on(psi$iv, a$iv, b$iv);
                Intrinsics.checkExpressionValueIsNotNull(parametrizedDiagnostic, "this.on(psi, a, b)");
                coneDiagnostic = new ConeDiagnostic(parametrizedDiagnostic, source);
            }
        } else if (firDiagnostic instanceof FirSimpleDiagnostic) {
            $this$onSource$iv = this.getFactory((FirSimpleDiagnostic)diagnostic);
            boolean $i$f$onSource = false;
            PsiElement psiElement = FirSourceElementKt.getPsi(source);
            if (!(psiElement instanceof PsiElement)) {
                psiElement = null;
            }
            if (psiElement == null) {
                coneDiagnostic = null;
            } else {
                PsiElement psi$iv = psiElement;
                SimpleDiagnostic<PsiElement> simpleDiagnostic = ((DiagnosticFactory0)$this$onSource$iv).on(psi$iv);
                Intrinsics.checkExpressionValueIsNotNull(simpleDiagnostic, "this.on(psi)");
                coneDiagnostic = new ConeDiagnostic(simpleDiagnostic, source);
            }
        } else if (firDiagnostic instanceof FirStubDiagnostic) {
            coneDiagnostic = null;
        } else {
            throw (Throwable)new IllegalArgumentException("Unsupported diagnostic type: " + diagnostic.getClass());
        }
        ConeDiagnostic coneDiagnostic2 = coneDiagnostic;
        reporter.report(coneDiagnostic2);
    }

    private final DiagnosticFactory0<PsiElement> getFactory(@NotNull FirSimpleDiagnostic $this$getFactory) {
        DiagnosticFactory0<PsiElement> diagnosticFactory0;
        switch (ErrorNodeDiagnosticCollectorComponent$WhenMappings.$EnumSwitchMapping$0[$this$getFactory.getKind().ordinal()]) {
            case 1: {
                diagnosticFactory0 = FirErrors.INSTANCE.getSYNTAX_ERROR();
                break;
            }
            case 2: {
                diagnosticFactory0 = Errors.RETURN_NOT_ALLOWED;
                break;
            }
            case 3: {
                diagnosticFactory0 = FirErrors.INSTANCE.getUNRESOLVED_LABEL();
                break;
            }
            case 4: {
                diagnosticFactory0 = FirErrors.INSTANCE.getILLEGAL_CONST_EXPRESSION();
                break;
            }
            case 5: {
                diagnosticFactory0 = Errors.CONSTRUCTOR_IN_OBJECT;
                break;
            }
            case 6: {
                diagnosticFactory0 = FirErrors.INSTANCE.getDESERIALIZATION_ERROR();
                break;
            }
            case 7: {
                diagnosticFactory0 = FirErrors.INSTANCE.getINFERENCE_ERROR();
                break;
            }
            case 8: {
                diagnosticFactory0 = FirErrors.INSTANCE.getNO_SUPERTYPE();
                break;
            }
            case 9: {
                diagnosticFactory0 = FirErrors.INSTANCE.getTYPE_PARAMETER_AS_SUPERTYPE();
                break;
            }
            case 10: {
                diagnosticFactory0 = FirErrors.INSTANCE.getENUM_AS_SUPERTYPE();
                break;
            }
            case 11: {
                diagnosticFactory0 = FirErrors.INSTANCE.getRECURSION_IN_SUPERTYPES();
                break;
            }
            case 12: {
                diagnosticFactory0 = FirErrors.INSTANCE.getRECURSION_IN_IMPLICIT_TYPES();
                break;
            }
            case 13: {
                diagnosticFactory0 = FirErrors.INSTANCE.getERROR_FROM_JAVA_RESOLUTION();
                break;
            }
            case 14: {
                diagnosticFactory0 = FirErrors.INSTANCE.getOTHER_ERROR();
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        if (diagnosticFactory0 == null) {
            throw new TypeCastException("null cannot be cast to non-null type org.jetbrains.kotlin.diagnostics.DiagnosticFactory0<com.intellij.psi.PsiElement>");
        }
        return diagnosticFactory0;
    }

    public ErrorNodeDiagnosticCollectorComponent(@NotNull AbstractDiagnosticCollector collector2) {
        Intrinsics.checkParameterIsNotNull(collector2, "collector");
        super(collector2);
    }

    public static final /* synthetic */ void access$reportFirDiagnostic(ErrorNodeDiagnosticCollectorComponent $this, FirDiagnostic diagnostic, FirSourceElement source, DiagnosticReporter reporter) {
        $this.reportFirDiagnostic(diagnostic, source, reporter);
    }
}

