/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.offroad.ui;

import java.awt.Point;
import net.osmand.data.LatLon;
import net.osmand.data.QuadPoint;
import net.osmand.data.RotatedTileBox;
import net.sourceforge.offroad.ui.OffRoadUIThread;
import net.sourceforge.offroad.ui.OsmBitmapPanel;

class ZoomAnimationThread
extends OffRoadUIThread {
    private final int mWheelRotation;
    private final Point mNewCenter;

    ZoomAnimationThread(OsmBitmapPanel pOsmBitmapPanel, int pWheelRotation, Point pNewCenter) {
        super(pOsmBitmapPanel, "ZoomAnimation");
        this.mWheelRotation = pWheelRotation;
        this.mNewCenter = pNewCenter;
    }

    @Override
    public void runAfterThreadsBeforeHaveFinished() {
        int it;
        RotatedTileBox tb = this.mOsmBitmapPanel.copyCurrentTileBox();
        int originalZoom = tb.getZoom();
        if (this.mNextThread == null) {
            it = 30;
            float v0 = 2.0f;
            float a = ((float)it * (1.0f - v0) + 2.0f * v0 - 2.0f) / ((float)it - 2.0f) / ((float)it - 2.0f);
            for (int i = 0; i < it - 1; ++i) {
                float zoom = v0 * (float)i + a * (float)i * (float)i;
                log.info((Object)("Zoom is " + zoom + " for step " + i + " and velocity " + v0 + " and acceleration " + a));
                tb = this.getDestinationTileBox(originalZoom, it, zoom);
                this.mOsmBitmapPanel.setCurrentTileBox(tb);
                log.debug((Object)("Set tile box " + tb + " and now repaint."));
                this.mOsmBitmapPanel.repaintAndWait(50);
                log.debug((Object)("Set tile box " + tb + " and now repaint. Done."));
            }
        } else {
            it = 10;
            for (int i = 0; i < it - 2; ++i) {
                tb = this.getDestinationTileBox(originalZoom, it, i);
                this.mOsmBitmapPanel.setCurrentTileBox(tb);
                log.debug((Object)("Set tile box " + tb + " and now repaint."));
                this.mOsmBitmapPanel.repaintAndWait(50);
                log.debug((Object)("Set tile box " + tb + " and now repaint. Done."));
            }
        }
        tb = this.getDestinationTileBox(originalZoom, it, it - 1);
        this.mOsmBitmapPanel.setCurrentTileBox(tb);
        log.debug((Object)("Set tile box " + tb + " and now repaint."));
        this.mOsmBitmapPanel.repaintAndWait(50);
        log.debug((Object)("Set tile box " + tb + " and now repaint. Done."));
    }

    public RotatedTileBox getDestinationTileBox(int originalZoom, float it, float i) {
        RotatedTileBox tb = this.mOsmBitmapPanel.copyCurrentTileBox();
        LatLon oldCenter = tb.getLatLonFromPixel(this.mNewCenter.x, this.mNewCenter.y);
        if (i < it - 1.0f) {
            float destZoom = this.mOsmBitmapPanel.checkZoom((float)originalZoom + (0.0f + i * (float)this.mWheelRotation) / it);
            int baseZoom = (int)Math.floor(destZoom);
            float fractZoom = destZoom - (float)baseZoom;
            tb.setZoomAndAnimation(baseZoom, 0.0, fractZoom);
        } else {
            tb.setZoomAndAnimation((int)this.mOsmBitmapPanel.checkZoom(originalZoom + this.mWheelRotation), 0.0, 0.0);
        }
        float oldCenterX = tb.getPixXFromLatLon(oldCenter);
        float oldCenterY = tb.getPixYFromLatLon(oldCenter);
        QuadPoint center = tb.getCenterPixelPoint();
        float originX = (float)this.mNewCenter.x - oldCenterX;
        float originY = (float)this.mNewCenter.y - oldCenterY;
        double newLat = tb.getLatFromPixel(center.x - originX, center.y - originY);
        double newLon = tb.getLonFromPixel(center.x - originX, center.y - originY);
        tb.setLatLonCenter(newLat, newLon);
        return tb;
    }
}

