/*
 * Decompiled with CFR 0.152.
 */
package org.directwebremoting.convert;

import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.SortedSet;
import java.util.StringTokenizer;
import java.util.TreeSet;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.directwebremoting.ConversionException;
import org.directwebremoting.extend.AbstractConverter;
import org.directwebremoting.extend.ArrayOutboundVariable;
import org.directwebremoting.extend.ConvertUtil;
import org.directwebremoting.extend.ConverterManager;
import org.directwebremoting.extend.ErrorOutboundVariable;
import org.directwebremoting.extend.InboundVariable;
import org.directwebremoting.extend.OutboundContext;
import org.directwebremoting.extend.OutboundVariable;
import org.directwebremoting.extend.Property;

public class CollectionConverter
extends AbstractConverter {
    private ConverterManager converterManager = null;
    private static final Log log = LogFactory.getLog(CollectionConverter.class);

    @Override
    public void setConverterManager(ConverterManager converterManager) {
        this.converterManager = converterManager;
    }

    @Override
    public Object convertInbound(Class<?> paramType, InboundVariable data) throws ConversionException {
        if (data.isNull()) {
            return null;
        }
        String value = data.getValue();
        if (value.trim().equals("null")) {
            return null;
        }
        if (!value.startsWith("[") || !value.endsWith("]")) {
            log.warn((Object)("Expected collection while converting data for " + paramType.getName() + " in " + data.getContext().getCurrentProperty() + ". Passed: " + value));
            throw new ConversionException(paramType, "Data conversion error. See logs for more details.");
        }
        value = value.substring(1, value.length() - 1);
        try {
            Collection<?> col;
            Property parent = data.getContext().getCurrentProperty();
            Property child = parent.createChild(0);
            child = this.converterManager.checkOverride(child);
            Class<?> subtype = child.getPropertyType();
            if (Iterator.class.isAssignableFrom(paramType)) {
                col = new ArrayList();
            } else if (!paramType.isInterface() && !Modifier.isAbstract(paramType.getModifiers())) {
                col = (Collection)paramType.newInstance();
            } else if (SortedSet.class.isAssignableFrom(paramType)) {
                col = new TreeSet();
            } else if (Set.class.isAssignableFrom(paramType)) {
                col = new HashSet();
            } else if (List.class.isAssignableFrom(paramType)) {
                col = new ArrayList();
            } else if (Collection.class.isAssignableFrom(paramType)) {
                col = new ArrayList();
            } else {
                throw new ConversionException(paramType);
            }
            data.getContext().addConverted(data, paramType, col);
            StringTokenizer st = new StringTokenizer(value, ",");
            int size = st.countTokens();
            for (int i = 0; i < size; ++i) {
                String token = st.nextToken();
                String[] split = ConvertUtil.splitInbound(token);
                String splitType = split[0];
                String splitValue = split[1];
                InboundVariable nested = new InboundVariable(data.getContext(), null, splitType, splitValue);
                nested.dereference();
                Object output = this.converterManager.convertInbound(subtype, nested, child);
                col.add(output);
            }
            if (Iterator.class.isAssignableFrom(paramType)) {
                return col.iterator();
            }
            return col;
        }
        catch (ConversionException ex) {
            throw ex;
        }
        catch (Exception ex) {
            throw new ConversionException(paramType, (Throwable)ex);
        }
    }

    @Override
    public OutboundVariable convertOutbound(Object data, OutboundContext outctx) throws ConversionException {
        Iterator it;
        if (data instanceof Collection) {
            Collection col = (Collection)data;
            it = col.iterator();
        } else if (data instanceof Iterator) {
            it = (Iterator)data;
        } else {
            throw new ConversionException(data.getClass());
        }
        ArrayOutboundVariable ov = new ArrayOutboundVariable(outctx);
        outctx.put(data, ov);
        ArrayList<OutboundVariable> ovs = new ArrayList<OutboundVariable>();
        while (it.hasNext()) {
            OutboundVariable nested;
            Object member = it.next();
            try {
                nested = this.converterManager.convertOutbound(member, outctx);
            }
            catch (Exception ex) {
                String errorMessage = "Conversion error for " + data.getClass().getName() + ".";
                log.warn((Object)errorMessage, (Throwable)ex);
                nested = new ErrorOutboundVariable(errorMessage);
            }
            ovs.add(nested);
        }
        ov.setChildren(ovs);
        return ov;
    }
}

