/*
 * Decompiled with CFR 0.152.
 */
package org.sunflow.core.display;

import java.awt.Container;
import java.awt.Dimension;
import java.awt.Toolkit;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import javax.swing.JFrame;
import org.sunflow.core.Display;
import org.sunflow.image.Color;
import org.sunflow.system.ImagePanel;

public class FrameDisplay
implements Display {
    private String filename;
    private RenderFrame frame;

    public FrameDisplay() {
        this(null);
    }

    public FrameDisplay(String string) {
        this.filename = string;
        this.frame = null;
    }

    public void imageBegin(int n, int n2, int n3) {
        if (this.frame == null) {
            this.frame = new RenderFrame();
            this.frame.imagePanel.imageBegin(n, n2, n3);
            Dimension dimension = Toolkit.getDefaultToolkit().getScreenSize();
            boolean bl = false;
            if ((double)n >= dimension.getWidth() - 200.0 || (double)n2 >= dimension.getHeight() - 200.0) {
                this.frame.imagePanel.setPreferredSize(new Dimension((int)dimension.getWidth() - 200, (int)dimension.getHeight() - 200));
                bl = true;
            } else {
                this.frame.imagePanel.setPreferredSize(new Dimension(n, n2));
            }
            this.frame.pack();
            this.frame.setLocationRelativeTo(null);
            this.frame.setVisible(true);
            if (bl) {
                this.frame.imagePanel.fit();
            }
        } else {
            this.frame.imagePanel.imageBegin(n, n2, n3);
        }
    }

    public void imagePrepare(int n, int n2, int n3, int n4, int n5) {
        this.frame.imagePanel.imagePrepare(n, n2, n3, n4, n5);
    }

    public void imageUpdate(int n, int n2, int n3, int n4, Color[] colorArray, float[] fArray) {
        this.frame.imagePanel.imageUpdate(n, n2, n3, n4, colorArray, fArray);
    }

    public void imageFill(int n, int n2, int n3, int n4, Color color, float f) {
        this.frame.imagePanel.imageFill(n, n2, n3, n4, color, f);
    }

    public void imageEnd() {
        this.frame.imagePanel.imageEnd();
        if (this.filename != null) {
            this.frame.imagePanel.save(this.filename);
        }
    }

    private static class RenderFrame
    extends JFrame {
        ImagePanel imagePanel;

        RenderFrame() {
            super("Sunflow v0.07.3");
            this.setDefaultCloseOperation(3);
            this.addKeyListener(new KeyAdapter(){

                public void keyPressed(KeyEvent keyEvent) {
                    if (keyEvent.getKeyCode() == 27) {
                        System.exit(0);
                    }
                }
            });
            this.imagePanel = new ImagePanel();
            this.setContentPane((Container)this.imagePanel);
            this.pack();
        }
    }
}

