/*
 * Decompiled with CFR 0.152.
 */
package processing.app;

import cc.arduino.packages.BoardPort;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.event.ActionListener;
import java.awt.event.KeyListener;
import java.awt.event.MouseWheelListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.StringTokenizer;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import javax.swing.border.EmptyBorder;
import javax.swing.text.DefaultCaret;
import javax.swing.text.DefaultEditorKit;
import processing.app.AbstractMonitor;
import processing.app.I18n;
import processing.app.PreferencesData;
import processing.app.TextAreaFIFO;
import processing.app.Theme;

public abstract class AbstractTextMonitor
extends AbstractMonitor {
    protected JLabel noLineEndingAlert;
    protected TextAreaFIFO textArea;
    protected JScrollPane scrollPane;
    protected JTextField textField;
    protected JButton sendButton;
    protected JButton clearButton;
    protected JCheckBox autoscrollBox;
    protected JCheckBox addTimeStampBox;
    protected JComboBox<String> lineEndings;
    protected JComboBox<String> serialRates;
    private static final String LINE_SEPARATOR = "\n";
    private boolean isStartingLine = true;

    public AbstractTextMonitor(BoardPort boardPort) {
        super(boardPort);
    }

    @Override
    public synchronized void addMouseWheelListener(MouseWheelListener l) {
        super.addMouseWheelListener(l);
        this.textArea.addMouseWheelListener(l);
    }

    @Override
    public synchronized void addKeyListener(KeyListener l) {
        super.addKeyListener(l);
        this.textArea.addKeyListener(l);
        this.textField.addKeyListener(l);
    }

    @Override
    protected void onCreateWindow(Container mainPane) {
        mainPane.setLayout(new BorderLayout());
        this.textArea = new TextAreaFIFO(8000000);
        this.textArea.setRows(16);
        this.textArea.setColumns(40);
        this.textArea.setEditable(false);
        ((DefaultCaret)this.textArea.getCaret()).setUpdatePolicy(1);
        this.scrollPane = new JScrollPane(this.textArea);
        mainPane.add((Component)this.scrollPane, "Center");
        JPanel upperPane = new JPanel();
        upperPane.setLayout(new BoxLayout(upperPane, 0));
        upperPane.setBorder(new EmptyBorder(4, 4, 4, 4));
        this.textField = new JTextField(40);
        this.addWindowFocusListener(new WindowAdapter(){

            @Override
            public void windowGainedFocus(WindowEvent e) {
                AbstractTextMonitor.this.textField.requestFocusInWindow();
            }
        });
        JPopupMenu menu = new JPopupMenu();
        DefaultEditorKit.CutAction cut = new DefaultEditorKit.CutAction();
        cut.putValue("Name", I18n.tr((String)"Cut"));
        menu.add(cut);
        DefaultEditorKit.CopyAction copy = new DefaultEditorKit.CopyAction();
        copy.putValue("Name", I18n.tr((String)"Copy"));
        menu.add(copy);
        DefaultEditorKit.PasteAction paste = new DefaultEditorKit.PasteAction();
        paste.putValue("Name", I18n.tr((String)"Paste"));
        menu.add(paste);
        this.textField.setComponentPopupMenu(menu);
        this.sendButton = new JButton(I18n.tr((String)"Send"));
        this.clearButton = new JButton(I18n.tr((String)"Clear output"));
        upperPane.add(this.textField);
        upperPane.add(Box.createRigidArea(new Dimension(4, 0)));
        upperPane.add(this.sendButton);
        mainPane.add((Component)upperPane, "North");
        JPanel pane = new JPanel();
        pane.setLayout(new BoxLayout(pane, 0));
        pane.setBorder(new EmptyBorder(4, 4, 4, 4));
        this.autoscrollBox = new JCheckBox(I18n.tr((String)"Autoscroll"), true);
        this.addTimeStampBox = new JCheckBox(I18n.tr((String)"Show timestamp"), false);
        this.noLineEndingAlert = new JLabel(I18n.format((String)I18n.tr((String)"You've pressed {0} but nothing was sent. Should you select a line ending?"), (Object[])new Object[]{I18n.tr((String)"Send")}));
        this.noLineEndingAlert.setToolTipText(this.noLineEndingAlert.getText());
        this.noLineEndingAlert.setForeground(pane.getBackground());
        Dimension minimumSize = new Dimension(this.noLineEndingAlert.getMinimumSize());
        minimumSize.setSize(minimumSize.getWidth() / 3.0, minimumSize.getHeight());
        this.noLineEndingAlert.setMinimumSize(minimumSize);
        this.lineEndings = new JComboBox<String>(new String[]{I18n.tr((String)"No line ending"), I18n.tr((String)"Newline"), I18n.tr((String)"Carriage return"), I18n.tr((String)"Both NL & CR")});
        this.lineEndings.addActionListener(event -> {
            PreferencesData.setInteger((String)"serial.line_ending", (int)this.lineEndings.getSelectedIndex());
            this.noLineEndingAlert.setForeground(pane.getBackground());
        });
        this.addTimeStampBox.addActionListener(event -> PreferencesData.setBoolean((String)"serial.show_timestamp", (boolean)this.addTimeStampBox.isSelected()));
        this.lineEndings.setMaximumSize(this.lineEndings.getMinimumSize());
        this.serialRates = new JComboBox();
        for (String rate : this.serialRateStrings) {
            this.serialRates.addItem(rate + " " + I18n.tr((String)"baud"));
        }
        this.serialRates.setMaximumSize(this.serialRates.getMinimumSize());
        pane.add(this.autoscrollBox);
        pane.add(this.addTimeStampBox);
        pane.add(Box.createHorizontalGlue());
        pane.add(this.noLineEndingAlert);
        pane.add(Box.createRigidArea(new Dimension(8, 0)));
        pane.add(this.lineEndings);
        pane.add(Box.createRigidArea(new Dimension(8, 0)));
        pane.add(this.serialRates);
        pane.add(Box.createRigidArea(new Dimension(8, 0)));
        pane.add(this.clearButton);
        this.applyPreferences();
        mainPane.add((Component)pane, "South");
    }

    @Override
    protected void onEnableWindow(boolean enable) {
        this.textArea.setEnabled(true);
        if (enable) {
            this.textArea.setForeground(Color.BLACK);
            this.textArea.setBackground(Color.WHITE);
        } else {
            this.textArea.setForeground(new Color(64, 64, 64));
            this.textArea.setBackground(new Color(238, 238, 238));
        }
        this.textArea.invalidate();
        this.clearButton.setEnabled(enable);
        this.scrollPane.setEnabled(enable);
        this.textField.setEnabled(enable);
        this.sendButton.setEnabled(enable);
        this.autoscrollBox.setEnabled(enable);
        this.addTimeStampBox.setEnabled(enable);
        this.lineEndings.setEnabled(enable);
        this.serialRates.setEnabled(enable);
    }

    public void onSendCommand(ActionListener listener) {
        this.textField.addActionListener(listener);
        this.sendButton.addActionListener(listener);
    }

    public void onClearCommand(ActionListener listener) {
        this.clearButton.addActionListener(listener);
    }

    public void onSerialRateChange(ActionListener listener) {
        this.serialRates.addActionListener(listener);
    }

    @Override
    public void message(String msg) {
        SwingUtilities.invokeLater(() -> this.updateTextArea(msg));
    }

    protected void updateTextArea(String msg) {
        if (this.addTimeStampBox.isSelected()) {
            this.textArea.append(this.addTimestamps(msg));
        } else {
            this.textArea.append(msg);
        }
        if (this.autoscrollBox.isSelected()) {
            this.textArea.setCaretPosition(this.textArea.getDocument().getLength());
        }
    }

    @Override
    public void applyPreferences() {
        Font consoleFont = Theme.getFont("console.font");
        Font editorFont = PreferencesData.getFont((String)"editor.font");
        this.textArea.setFont(Theme.scale(new Font(consoleFont.getName(), consoleFont.getStyle(), editorFont.getSize())));
        if (PreferencesData.get((String)"serial.line_ending") != null) {
            this.lineEndings.setSelectedIndex(PreferencesData.getInteger((String)"serial.line_ending"));
        }
        if (PreferencesData.get((String)"serial.show_timestamp") != null) {
            this.addTimeStampBox.setSelected(PreferencesData.getBoolean((String)"serial.show_timestamp"));
        }
    }

    private String addTimestamps(String text) {
        String now = new SimpleDateFormat("HH:mm:ss.SSS -> ").format(new Date());
        StringBuilder sb = new StringBuilder(text.length() + now.length());
        StringTokenizer tokenizer = new StringTokenizer(text, LINE_SEPARATOR, true);
        while (tokenizer.hasMoreTokens()) {
            if (this.isStartingLine) {
                sb.append(now);
            }
            String token = tokenizer.nextToken();
            sb.append(token);
            this.isStartingLine = token.equals(LINE_SEPARATOR);
        }
        return sb.toString();
    }
}

