﻿/*
* Copyright 2010-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
*
* Licensed under the Apache License, Version 2.0 (the "License").
* You may not use this file except in compliance with the License.
* A copy of the License is located at
*
*  http://aws.amazon.com/apache2.0
*
* or in the "license" file accompanying this file. This file is distributed
* on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either
* express or implied. See the License for the specific language governing
* permissions and limitations under the License.
*/

#pragma once
#include <aws/elasticmapreduce/EMR_EXPORTS.h>

namespace Aws
{
namespace Utils
{
namespace Json
{
  class JsonValue;
  class JsonView;
} // namespace Json
} // namespace Utils
namespace EMR
{
namespace Model
{

  /**
   * <p>A list of port ranges that are permitted to allow inbound traffic from all
   * public IP addresses. To specify a single port, use the same value for
   * <code>MinRange</code> and <code>MaxRange</code>.</p><p><h3>See Also:</h3>   <a
   * href="http://docs.aws.amazon.com/goto/WebAPI/elasticmapreduce-2009-03-31/PortRange">AWS
   * API Reference</a></p>
   */
  class AWS_EMR_API PortRange
  {
  public:
    PortRange();
    PortRange(Aws::Utils::Json::JsonView jsonValue);
    PortRange& operator=(Aws::Utils::Json::JsonView jsonValue);
    Aws::Utils::Json::JsonValue Jsonize() const;


    /**
     * <p>The smallest port number in a specified range of port numbers.</p>
     */
    inline int GetMinRange() const{ return m_minRange; }

    /**
     * <p>The smallest port number in a specified range of port numbers.</p>
     */
    inline bool MinRangeHasBeenSet() const { return m_minRangeHasBeenSet; }

    /**
     * <p>The smallest port number in a specified range of port numbers.</p>
     */
    inline void SetMinRange(int value) { m_minRangeHasBeenSet = true; m_minRange = value; }

    /**
     * <p>The smallest port number in a specified range of port numbers.</p>
     */
    inline PortRange& WithMinRange(int value) { SetMinRange(value); return *this;}


    /**
     * <p>The smallest port number in a specified range of port numbers.</p>
     */
    inline int GetMaxRange() const{ return m_maxRange; }

    /**
     * <p>The smallest port number in a specified range of port numbers.</p>
     */
    inline bool MaxRangeHasBeenSet() const { return m_maxRangeHasBeenSet; }

    /**
     * <p>The smallest port number in a specified range of port numbers.</p>
     */
    inline void SetMaxRange(int value) { m_maxRangeHasBeenSet = true; m_maxRange = value; }

    /**
     * <p>The smallest port number in a specified range of port numbers.</p>
     */
    inline PortRange& WithMaxRange(int value) { SetMaxRange(value); return *this;}

  private:

    int m_minRange;
    bool m_minRangeHasBeenSet;

    int m_maxRange;
    bool m_maxRangeHasBeenSet;
  };

} // namespace Model
} // namespace EMR
} // namespace Aws
