/*
 * Decompiled with CFR 0.152.
 */
package org.gephi.desktop.preview;

import java.awt.Graphics;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.awt.event.MouseWheelEvent;
import java.awt.event.MouseWheelListener;
import java.util.Timer;
import java.util.TimerTask;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import org.gephi.desktop.preview.PreviewTopComponent;
import org.gephi.preview.api.G2DTarget;
import org.gephi.preview.api.PreviewController;
import org.gephi.preview.api.PreviewMouseEvent;
import org.gephi.preview.api.Vector;
import org.openide.util.Lookup;

public class PreviewSketch
extends JPanel
implements MouseListener,
MouseWheelListener,
MouseMotionListener {
    private static final int WHEEL_TIMER = 500;
    private final PreviewController previewController;
    private final G2DTarget target;
    private final Vector ref = new Vector();
    private final Vector lastMove = new Vector();
    private final RefreshLoop refreshLoop = new RefreshLoop();
    private Timer wheelTimer;
    private boolean inited;
    private final boolean isRetina;

    public PreviewSketch(G2DTarget target) {
        this.target = target;
        this.previewController = (PreviewController)Lookup.getDefault().lookup(PreviewController.class);
        this.isRetina = PreviewTopComponent.isRetina();
    }

    @Override
    protected void paintComponent(Graphics g) {
        super.paintComponent(g);
        if (!this.inited) {
            this.addMouseListener(this);
            this.addMouseMotionListener(this);
            this.addMouseWheelListener(this);
            this.inited = true;
        }
        int width = (int)((double)this.getWidth() * (this.isRetina ? 2.0 : 1.0));
        int height = (int)((double)this.getHeight() * (this.isRetina ? 2.0 : 1.0));
        if (this.target.getWidth() != width || this.target.getHeight() != height) {
            this.target.resize(width, height);
        }
        g.drawImage(this.target.getImage(), 0, 0, this.getWidth(), this.getHeight(), this);
    }

    public void setMoving(boolean moving) {
        this.target.setMoving(moving);
    }

    @Override
    public void mouseClicked(MouseEvent e) {
        if (this.previewController.sendMouseEvent(this.buildPreviewMouseEvent(e, PreviewMouseEvent.Type.CLICKED))) {
            this.refreshLoop.refreshSketch();
        }
    }

    @Override
    public void mousePressed(MouseEvent e) {
        this.previewController.sendMouseEvent(this.buildPreviewMouseEvent(e, PreviewMouseEvent.Type.PRESSED));
        this.ref.set((float)e.getX(), (float)e.getY());
        this.lastMove.set(this.target.getTranslate());
        this.refreshLoop.refreshSketch();
    }

    @Override
    public void mouseReleased(MouseEvent e) {
        if (!this.previewController.sendMouseEvent(this.buildPreviewMouseEvent(e, PreviewMouseEvent.Type.RELEASED))) {
            this.setMoving(false);
        }
        this.refreshLoop.refreshSketch();
    }

    @Override
    public void mouseEntered(MouseEvent e) {
    }

    @Override
    public void mouseExited(MouseEvent e) {
    }

    @Override
    public void mouseWheelMoved(MouseWheelEvent e) {
        if (e.getUnitsToScroll() == 0) {
            return;
        }
        float way = -e.getUnitsToScroll() / Math.abs(e.getUnitsToScroll());
        this.target.setScaling(this.target.getScaling() * (way > 0.0f ? 2.0f : 0.5f));
        this.setMoving(true);
        if (this.wheelTimer != null) {
            this.wheelTimer.cancel();
            this.wheelTimer = null;
        }
        this.wheelTimer = new Timer();
        this.wheelTimer.schedule(new TimerTask(){

            @Override
            public void run() {
                PreviewSketch.this.setMoving(false);
                PreviewSketch.this.refreshLoop.refreshSketch();
                PreviewSketch.this.wheelTimer = null;
            }
        }, 500L);
        this.refreshLoop.refreshSketch();
    }

    @Override
    public void mouseDragged(MouseEvent e) {
        if (!this.previewController.sendMouseEvent(this.buildPreviewMouseEvent(e, PreviewMouseEvent.Type.DRAGGED))) {
            this.setMoving(true);
            Vector trans = this.target.getTranslate();
            trans.set((float)e.getX(), (float)e.getY());
            trans.sub(this.ref);
            trans.mult(this.isRetina ? 2.0f : 1.0f);
            trans.div(this.target.getScaling());
            trans.add(this.lastMove);
            this.refreshLoop.refreshSketch();
        }
    }

    @Override
    public void mouseMoved(MouseEvent e) {
    }

    public void zoomPlus() {
        this.target.setScaling(this.target.getScaling() * 2.0f);
        this.refreshLoop.refreshSketch();
    }

    public void zoomMinus() {
        this.target.setScaling(this.target.getScaling() / 2.0f);
        this.refreshLoop.refreshSketch();
    }

    public void resetZoom() {
        this.target.reset();
        this.refreshLoop.refreshSketch();
    }

    private Vector screenPositionToModelPosition(Vector screenPos) {
        Vector center = new Vector((float)this.getWidth() / 2.0f, (float)this.getHeight() / 2.0f);
        Vector scaledCenter = Vector.mult((Vector)center, (float)this.target.getScaling());
        Vector scaledTrans = Vector.sub((Vector)center, (Vector)scaledCenter);
        Vector modelPos = new Vector(screenPos.x, screenPos.y);
        modelPos.sub(scaledTrans);
        modelPos.div(this.target.getScaling());
        modelPos.sub(this.target.getTranslate());
        return modelPos;
    }

    private PreviewMouseEvent buildPreviewMouseEvent(MouseEvent evt, PreviewMouseEvent.Type type) {
        int mouseX = evt.getX();
        int mouseY = evt.getY();
        PreviewMouseEvent.Button button = PreviewMouseEvent.Button.LEFT;
        if (SwingUtilities.isMiddleMouseButton(evt)) {
            button = PreviewMouseEvent.Button.MIDDLE;
        } else if (SwingUtilities.isLeftMouseButton(evt)) {
            button = PreviewMouseEvent.Button.LEFT;
        } else if (SwingUtilities.isRightMouseButton(evt)) {
            button = PreviewMouseEvent.Button.RIGHT;
        }
        Vector pos = this.screenPositionToModelPosition(new Vector((float)mouseX, (float)mouseY));
        return new PreviewMouseEvent((int)pos.x, (int)pos.y, type, button, null);
    }

    private class RefreshLoop {
        private final long DELAY = 100L;
        private final AtomicBoolean running = new AtomicBoolean();
        private final AtomicBoolean refresh = new AtomicBoolean();
        private long timeout = 1000L;
        private Timer timer;

        public void refreshSketch() {
            this.refresh.set(true);
            if (!this.running.getAndSet(true)) {
                this.startTimer();
            }
        }

        private void startTimer() {
            this.timer = new Timer("PreviewRefreshLoop", true);
            this.timer.schedule(new TimerTask(){

                @Override
                public void run() {
                    if (RefreshLoop.this.refresh.getAndSet(false)) {
                        PreviewSketch.this.target.refresh();
                        PreviewSketch.this.repaint();
                    } else if (RefreshLoop.this.timeout == 0L) {
                        RefreshLoop.this.timeout = 1000L;
                        RefreshLoop.this.stopTimer();
                    } else {
                        RefreshLoop.this.timeout = RefreshLoop.this.timeout - 100L;
                    }
                }
            }, 0L, 100L);
        }

        private void stopTimer() {
            this.timer.cancel();
            this.running.set(false);
        }
    }
}

