/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.context;

import io.micronaut.context.ApplicationContextBuilder;
import io.micronaut.context.BeanContext;
import io.micronaut.context.DefaultApplicationContextBuilder;
import io.micronaut.context.LifeCycle;
import io.micronaut.context.Qualifier;
import io.micronaut.context.env.Environment;
import io.micronaut.context.env.PropertyPlaceholderResolver;
import io.micronaut.context.env.PropertySource;
import io.micronaut.core.convert.ConversionService;
import io.micronaut.core.util.ArgumentUtils;
import io.micronaut.core.util.StringUtils;
import io.micronaut.core.value.PropertyResolver;
import java.util.Collections;
import java.util.Map;
import java.util.function.Consumer;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.jetbrains.annotations.NotNull;

public interface ApplicationContext
extends BeanContext,
PropertyResolver,
PropertyPlaceholderResolver {
    @Nonnull
    public ConversionService<?> getConversionService();

    @Nonnull
    public Environment getEnvironment();

    @Override
    @Nonnull
    public ApplicationContext start();

    @Override
    @Nonnull
    public ApplicationContext stop();

    @Override
    @Nonnull
    public <T> ApplicationContext registerSingleton(@Nonnull Class<T> var1, @Nonnull T var2, @Nullable Qualifier<T> var3, boolean var4);

    @Override
    @Nonnull
    default public <T> ApplicationContext registerSingleton(@Nonnull Class<T> type, @Nonnull T singleton, @Nullable Qualifier<T> qualifier) {
        return this.registerSingleton((Class)type, (Object)singleton, (Qualifier)qualifier, true);
    }

    @Override
    @Nonnull
    default public <T> ApplicationContext registerSingleton(@Nonnull Class<T> type, @Nonnull T singleton) {
        return this.registerSingleton((Class)type, (Object)singleton, (Qualifier)null, true);
    }

    @Override
    @Nonnull
    @NotNull
    default public ApplicationContext registerSingleton(@NotNull Object singleton, boolean inject) {
        return (ApplicationContext)BeanContext.super.registerSingleton(singleton, inject);
    }

    @Nonnull
    default public ApplicationContext environment(@Nonnull Consumer<Environment> consumer) {
        ArgumentUtils.requireNonNull((String)"consumer", consumer);
        consumer.accept(this.getEnvironment());
        return this;
    }

    @Override
    @Nonnull
    default public ApplicationContext registerSingleton(@Nonnull Object singleton) {
        ArgumentUtils.requireNonNull((String)"singleton", (Object)singleton);
        Class<?> type = singleton.getClass();
        return this.registerSingleton((Class)type, singleton);
    }

    @Nonnull
    public static ApplicationContext run(String ... environments) {
        ArgumentUtils.requireNonNull((String)"environments", (Object)environments);
        return ApplicationContext.build(environments).start();
    }

    @Nonnull
    public static ApplicationContext run() {
        return ApplicationContext.run(StringUtils.EMPTY_STRING_ARRAY);
    }

    @Nonnull
    public static ApplicationContext run(@Nonnull Map<String, Object> properties, String ... environments) {
        ArgumentUtils.requireNonNull((String)"environments", (Object)environments);
        ArgumentUtils.requireNonNull((String)"properties", properties);
        PropertySource propertySource = PropertySource.of("context", properties, 0);
        return ApplicationContext.run(propertySource, environments);
    }

    @Nonnull
    public static ApplicationContext run(@Nonnull PropertySource properties, String ... environments) {
        ArgumentUtils.requireNonNull((String)"environments", (Object)environments);
        ArgumentUtils.requireNonNull((String)"properties", (Object)properties);
        return ApplicationContext.build(environments).propertySources(properties).start();
    }

    @Nonnull
    public static <T extends AutoCloseable> T run(@Nonnull Class<T> type, String ... environments) {
        ArgumentUtils.requireNonNull((String)"type", type);
        ArgumentUtils.requireNonNull((String)"environments", (Object)environments);
        return ApplicationContext.run(type, Collections.emptyMap(), environments);
    }

    @Nonnull
    public static <T extends AutoCloseable> T run(@Nonnull Class<T> type, @Nonnull Map<String, Object> properties, String ... environments) {
        ArgumentUtils.requireNonNull((String)"environments", (Object)environments);
        ArgumentUtils.requireNonNull((String)"properties", properties);
        ArgumentUtils.requireNonNull((String)"type", type);
        PropertySource propertySource = PropertySource.of("context", properties, 0);
        return ApplicationContext.run(type, propertySource, environments);
    }

    @Nonnull
    public static <T extends AutoCloseable> T run(@Nonnull Class<T> type, @Nonnull PropertySource propertySource, String ... environments) {
        LifeCycle lifeCycle;
        ArgumentUtils.requireNonNull((String)"propertySource", (Object)propertySource);
        ArgumentUtils.requireNonNull((String)"environments", (Object)environments);
        ArgumentUtils.requireNonNull((String)"type", type);
        AutoCloseable bean = (AutoCloseable)ApplicationContext.build(environments).mainClass(type).propertySources(propertySource).start().getBean(type);
        if (bean != null && bean instanceof LifeCycle && !(lifeCycle = (LifeCycle)bean).isRunning()) {
            lifeCycle.start();
        }
        return (T)bean;
    }

    @Nonnull
    public static ApplicationContextBuilder build(String ... environments) {
        ArgumentUtils.requireNonNull((String)"environments", (Object)environments);
        return new DefaultApplicationContextBuilder().environments(environments);
    }

    @Nonnull
    public static ApplicationContextBuilder build(@Nonnull Map<String, Object> properties, String ... environments) {
        ArgumentUtils.requireNonNull((String)"environments", (Object)environments);
        ArgumentUtils.requireNonNull((String)"properties", properties);
        return new DefaultApplicationContextBuilder().properties(properties).environments(environments);
    }

    @Nonnull
    public static ApplicationContextBuilder build() {
        return new DefaultApplicationContextBuilder();
    }

    @Nonnull
    public static ApplicationContext run(@Nonnull ClassLoader classLoader, String ... environments) {
        ArgumentUtils.requireNonNull((String)"environments", (Object)environments);
        ArgumentUtils.requireNonNull((String)"classLoader", (Object)classLoader);
        return ApplicationContext.build(classLoader, environments).start();
    }

    @Nonnull
    public static ApplicationContextBuilder build(@Nonnull ClassLoader classLoader, String ... environments) {
        ArgumentUtils.requireNonNull((String)"environments", (Object)environments);
        ArgumentUtils.requireNonNull((String)"classLoader", (Object)classLoader);
        return ApplicationContext.build(environments).classLoader(classLoader);
    }

    @Nonnull
    public static ApplicationContextBuilder build(@Nonnull Class mainClass, String ... environments) {
        ArgumentUtils.requireNonNull((String)"environments", (Object)environments);
        ArgumentUtils.requireNonNull((String)"mainClass", (Object)mainClass);
        return ApplicationContext.build(environments).mainClass(mainClass);
    }
}

