/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.jcs.utils.serialization;

import java.io.IOException;
import org.apache.commons.jcs.utils.serialization.StandardSerializer;
import org.apache.commons.jcs.utils.zip.CompressionUtil;

public class CompressingSerializer
extends StandardSerializer {
    @Override
    public <T> byte[] serialize(T obj) throws IOException {
        byte[] uncompressed = super.serialize(obj);
        byte[] compressed = CompressionUtil.compressByteArray(uncompressed);
        return compressed;
    }

    @Override
    public <T> T deSerialize(byte[] data, ClassLoader loader) throws IOException, ClassNotFoundException {
        if (data == null) {
            return null;
        }
        byte[] decompressedByteArray = CompressionUtil.decompressByteArray(data);
        return super.deSerialize(decompressedByteArray, loader);
    }
}

