/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.data.preferences;

import org.openstreetmap.josm.spi.preferences.Config;
import org.openstreetmap.josm.tools.Logging;

public abstract class ParametrizedEnumProperty<T extends Enum<T>> {
    protected final T defaultValue;
    protected final Class<T> enumClass;

    public ParametrizedEnumProperty(Class<T> enumClass, T defaultValue) {
        this.defaultValue = defaultValue;
        this.enumClass = enumClass;
    }

    protected abstract String getKey(String ... var1);

    public T get(String ... params) {
        return this.parse(Config.getPref().get(this.getKey(params), ((Enum)this.defaultValue).name()));
    }

    public boolean put(T value, String ... params) {
        return Config.getPref().put(this.getKey(params), ((Enum)value).name());
    }

    protected T parse(String s) {
        try {
            return Enum.valueOf(this.enumClass, s);
        }
        catch (IllegalArgumentException e) {
            Logging.trace(e);
            return this.defaultValue;
        }
    }
}

