/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.io.audio;

import java.io.IOException;
import java.net.URL;
import javax.sound.sampled.AudioFormat;
import javax.sound.sampled.AudioInputStream;
import javax.sound.sampled.AudioSystem;
import javax.sound.sampled.DataLine;
import javax.sound.sampled.LineUnavailableException;
import javax.sound.sampled.SourceDataLine;
import javax.sound.sampled.UnsupportedAudioFileException;
import org.openstreetmap.josm.io.audio.AudioException;
import org.openstreetmap.josm.io.audio.AudioListener;
import org.openstreetmap.josm.io.audio.AudioPlayer;
import org.openstreetmap.josm.io.audio.SoundPlayer;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.ListenerList;
import org.openstreetmap.josm.tools.Logging;
import org.openstreetmap.josm.tools.Utils;

class JavaSoundPlayer
implements SoundPlayer {
    private static int chunk = 4000;
    private AudioInputStream audioInputStream;
    private SourceDataLine audioOutputLine;
    private final double leadIn;
    private final double calibration;
    private double bytesPerSecond;
    private final byte[] abData = new byte[chunk];
    private double position;
    private double speed = 1.0;
    private final ListenerList<AudioListener> listeners = ListenerList.create();

    JavaSoundPlayer(double leadIn, double calibration) {
        this.leadIn = leadIn;
        this.calibration = calibration;
    }

    @Override
    public void play(AudioPlayer.Execute command, AudioPlayer.State stateChange, URL playingUrl) throws AudioException, IOException {
        URL url = command.url();
        double offset = command.offset();
        this.speed = command.speed();
        if (playingUrl != url || stateChange != AudioPlayer.State.PAUSED || offset != 0.0) {
            if (this.audioInputStream != null) {
                Utils.close(this.audioInputStream);
            }
            this.listeners.fireEvent(l -> l.playing(url));
            try {
                this.audioInputStream = AudioSystem.getAudioInputStream(url);
            }
            catch (UnsupportedAudioFileException e) {
                throw new AudioException(e);
            }
            AudioFormat audioFormat = this.audioInputStream.getFormat();
            this.position = 0.0;
            double calibratedOffset = (offset -= this.leadIn) * this.calibration;
            this.bytesPerSecond = audioFormat.getFrameRate() * (float)audioFormat.getFrameSize();
            if (this.speed * this.bytesPerSecond > 256000.0) {
                this.speed = 256000.0 / this.bytesPerSecond;
            }
            if (calibratedOffset > 0.0) {
                long bytesToSkip;
                long nBytesRead;
                for (bytesToSkip = (long)(calibratedOffset * this.bytesPerSecond); bytesToSkip > (long)chunk; bytesToSkip -= nBytesRead) {
                    nBytesRead = this.audioInputStream.skip(chunk);
                    if (nBytesRead > 0L) continue;
                    throw new IOException(I18n.tr("This is after the end of the recording", new Object[0]));
                }
                while (bytesToSkip > 0L) {
                    long skippedBytes = this.audioInputStream.skip(bytesToSkip);
                    bytesToSkip -= skippedBytes;
                    if (skippedBytes != 0L) continue;
                    Logging.warn("Unable to skip bytes from audio input stream");
                    bytesToSkip = 0L;
                }
                this.position = offset;
            }
            if (this.audioOutputLine != null) {
                this.audioOutputLine.close();
            }
            audioFormat = new AudioFormat(audioFormat.getEncoding(), audioFormat.getSampleRate() * (float)(this.speed * this.calibration), audioFormat.getSampleSizeInBits(), audioFormat.getChannels(), audioFormat.getFrameSize(), audioFormat.getFrameRate() * (float)(this.speed * this.calibration), audioFormat.isBigEndian());
            try {
                DataLine.Info info = new DataLine.Info(SourceDataLine.class, audioFormat);
                this.audioOutputLine = (SourceDataLine)AudioSystem.getLine(info);
                this.audioOutputLine.open(audioFormat);
                this.audioOutputLine.start();
            }
            catch (LineUnavailableException e) {
                throw new AudioException(e);
            }
        }
    }

    @Override
    public void pause(AudioPlayer.Execute command, AudioPlayer.State stateChange, URL playingUrl) throws AudioException, IOException {
    }

    @Override
    public boolean playing(AudioPlayer.Execute command) throws AudioException, IOException, InterruptedException {
        while (true) {
            int nBytesRead = 0;
            if (this.audioInputStream != null) {
                nBytesRead = this.audioInputStream.read(this.abData, 0, this.abData.length);
                this.position += (double)nBytesRead / this.bytesPerSecond;
            }
            command.possiblyInterrupt();
            if (nBytesRead < 0 || this.audioInputStream == null || this.audioOutputLine == null) break;
            this.audioOutputLine.write(this.abData, 0, nBytesRead);
            command.possiblyInterrupt();
        }
        if (this.audioOutputLine != null) {
            this.audioOutputLine.drain();
            this.audioOutputLine.close();
        }
        this.audioOutputLine = null;
        Utils.close(this.audioInputStream);
        this.audioInputStream = null;
        this.speed = 0.0;
        return true;
    }

    @Override
    public double position() {
        return this.position;
    }

    @Override
    public double speed() {
        return this.speed;
    }

    @Override
    public void addAudioListener(AudioListener listener) {
        this.listeners.addWeakListener(listener);
    }
}

