/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.backend.common.lower;

import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.backend.common.BackendContext;
import org.jetbrains.kotlin.backend.common.ClassLoweringPass;
import org.jetbrains.kotlin.backend.common.IrElementTransformerVoidWithContext;
import org.jetbrains.kotlin.backend.common.ScopeWithIr;
import org.jetbrains.kotlin.backend.common.lower.DeclarationIrBuilder;
import org.jetbrains.kotlin.backend.common.lower.InnerClassesLowering;
import org.jetbrains.kotlin.backend.common.lower.LowerUtilsKt;
import org.jetbrains.kotlin.backend.common.lower.VariableRemapper;
import org.jetbrains.kotlin.ir.IrElement;
import org.jetbrains.kotlin.ir.IrStatement;
import org.jetbrains.kotlin.ir.builders.ExpressionHelpersKt;
import org.jetbrains.kotlin.ir.builders.IrBuilderWithScope;
import org.jetbrains.kotlin.ir.declarations.IrClass;
import org.jetbrains.kotlin.ir.declarations.IrConstructor;
import org.jetbrains.kotlin.ir.declarations.IrDeclaration;
import org.jetbrains.kotlin.ir.declarations.IrDeclarationParent;
import org.jetbrains.kotlin.ir.declarations.IrDeclarationWithName;
import org.jetbrains.kotlin.ir.declarations.IrField;
import org.jetbrains.kotlin.ir.declarations.IrFile;
import org.jetbrains.kotlin.ir.declarations.IrFunction;
import org.jetbrains.kotlin.ir.declarations.IrValueParameter;
import org.jetbrains.kotlin.ir.expressions.IrBlockBody;
import org.jetbrains.kotlin.ir.expressions.IrBody;
import org.jetbrains.kotlin.ir.expressions.IrDelegatingConstructorCall;
import org.jetbrains.kotlin.ir.expressions.IrExpression;
import org.jetbrains.kotlin.ir.expressions.IrGetValue;
import org.jetbrains.kotlin.ir.expressions.IrInstanceInitializerCall;
import org.jetbrains.kotlin.ir.expressions.IrStatementOrigin;
import org.jetbrains.kotlin.ir.expressions.impl.IrGetFieldImpl;
import org.jetbrains.kotlin.ir.expressions.impl.IrGetValueImpl;
import org.jetbrains.kotlin.ir.symbols.IrClassSymbol;
import org.jetbrains.kotlin.ir.symbols.IrFieldSymbol;
import org.jetbrains.kotlin.ir.symbols.IrValueParameterSymbol;
import org.jetbrains.kotlin.ir.symbols.IrValueSymbol;
import org.jetbrains.kotlin.ir.types.IrTypesKt;
import org.jetbrains.kotlin.ir.util.DumpIrTreeKt;
import org.jetbrains.kotlin.ir.util.IrUtilsKt;
import org.jetbrains.kotlin.ir.util.PatchDeclarationParentsKt;
import org.jetbrains.kotlin.ir.util.TransformKt;
import org.jetbrains.kotlin.ir.visitors.IrElementTransformerVoidKt;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0010\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\bH\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006R\u001a\u0010\u0007\u001a\u0004\u0018\u00010\b*\u00020\t8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\n\u0010\u000b\u00a8\u0006\u000f"}, d2={"Lorg/jetbrains/kotlin/backend/common/lower/InnerClassesLowering;", "Lorg/jetbrains/kotlin/backend/common/ClassLoweringPass;", "context", "Lorg/jetbrains/kotlin/backend/common/BackendContext;", "(Lorg/jetbrains/kotlin/backend/common/BackendContext;)V", "getContext", "()Lorg/jetbrains/kotlin/backend/common/BackendContext;", "classForImplicitThis", "Lorg/jetbrains/kotlin/ir/declarations/IrClass;", "Lorg/jetbrains/kotlin/ir/symbols/IrValueSymbol;", "getClassForImplicitThis", "(Lorg/jetbrains/kotlin/ir/symbols/IrValueSymbol;)Lorg/jetbrains/kotlin/ir/declarations/IrClass;", "lower", "", "irClass", "ir.backend.common"})
public final class InnerClassesLowering
implements ClassLoweringPass {
    @NotNull
    private final BackendContext context;

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final IrClass getClassForImplicitThis(@NotNull IrValueSymbol $this$classForImplicitThis) {
        if (!($this$classForImplicitThis instanceof IrValueParameterSymbol)) return null;
        if (((IrValueParameter)((IrValueParameterSymbol)$this$classForImplicitThis).getOwner()).getIndex() != -1) return null;
        IrValueParameter irValueParameter = (IrValueParameter)((IrValueParameterSymbol)$this$classForImplicitThis).getOwner();
        IrDeclarationParent irDeclarationParent = ((IrValueParameter)((IrValueParameterSymbol)$this$classForImplicitThis).getOwner()).getParent();
        if (!(irDeclarationParent instanceof IrFunction)) {
            irDeclarationParent = null;
        }
        IrFunction irFunction = (IrFunction)irDeclarationParent;
        if (!Intrinsics.areEqual(irValueParameter, irFunction != null ? irFunction.getDispatchReceiverParameter() : null)) {
            IrValueParameter irValueParameter2 = (IrValueParameter)((IrValueParameterSymbol)$this$classForImplicitThis).getOwner();
            IrDeclarationParent irDeclarationParent2 = ((IrValueParameter)((IrValueParameterSymbol)$this$classForImplicitThis).getOwner()).getParent();
            if (!(irDeclarationParent2 instanceof IrClass)) {
                irDeclarationParent2 = null;
            }
            IrClass irClass = (IrClass)irDeclarationParent2;
            if (!Intrinsics.areEqual(irValueParameter2, irClass != null ? irClass.getThisReceiver() : null)) return null;
        }
        IrClassSymbol irClassSymbol = IrTypesKt.getClassOrNull(((IrValueParameter)((IrValueParameterSymbol)$this$classForImplicitThis).getOwner()).getType());
        if (irClassSymbol == null) return null;
        IrClass irClass = (IrClass)irClassSymbol.getOwner();
        return irClass;
    }

    @Override
    public void lower(@NotNull IrClass irClass) {
        Intrinsics.checkParameterIsNotNull(irClass, "irClass");
        if (!irClass.isInner()) {
            return;
        }
        IrField parentThisField = this.context.getDeclarationFactory().getOuterThisField(irClass);
        HashMap oldConstructorParameterToNew = new HashMap();
        Function1<IrConstructor, IrConstructor> $fun$lowerConstructor$1 = new Function1<IrConstructor, IrConstructor>(this, oldConstructorParameterToNew, irClass, parentThisField){
            final /* synthetic */ InnerClassesLowering this$0;
            final /* synthetic */ HashMap $oldConstructorParameterToNew;
            final /* synthetic */ IrClass $irClass;
            final /* synthetic */ IrField $parentThisField;

            @NotNull
            public final IrConstructor invoke(@NotNull IrConstructor irConstructor) {
                Object v6;
                IrBlockBody blockBody;
                IrValueParameter outerThisParameter;
                IrConstructor loweredConstructor;
                block8: {
                    Intrinsics.checkParameterIsNotNull(irConstructor, "irConstructor");
                    loweredConstructor = this.this$0.getContext().getDeclarationFactory().getInnerClassConstructorWithOuterThisParameter(irConstructor);
                    outerThisParameter = loweredConstructor.getValueParameters().get(0);
                    Iterable $this$forEach$iv = irConstructor.getValueParameters();
                    boolean $i$f$forEach22 = false;
                    for (T element$iv : $this$forEach$iv) {
                        IrValueParameter old = (IrValueParameter)element$iv;
                        boolean bl = false;
                        ((Map)this.$oldConstructorParameterToNew).put(old, loweredConstructor.getValueParameters().get(old.getIndex() + 1));
                    }
                    IrBody irBody = irConstructor.getBody();
                    if (!(irBody instanceof IrBlockBody)) {
                        irBody = null;
                    }
                    IrBlockBody irBlockBody2 = (IrBlockBody)irBody;
                    if (irBlockBody2 == null) {
                        throw (Throwable)((Object)new AssertionError((Object)("Unexpected constructor body: " + irConstructor.getBody())));
                    }
                    blockBody = irBlockBody2;
                    Object $i$f$forEach22 = LowerUtilsKt.createIrBuilder(this.this$0.getContext(), irConstructor.getSymbol(), irConstructor.getStartOffset(), irConstructor.getEndOffset());
                    boolean bl = false;
                    boolean bl2 = false;
                    DeclarationIrBuilder $this$apply = $i$f$forEach22;
                    boolean $i$a$-apply-InnerClassesLowering$lower$1$32 = false;
                    List<IrStatement> list2 = blockBody.getStatements();
                    IrBuilderWithScope irBuilderWithScope = $this$apply;
                    IrBuilderWithScope irBuilderWithScope2 = $this$apply;
                    IrValueParameter irValueParameter = this.$irClass.getThisReceiver();
                    if (irValueParameter == null) {
                        Intrinsics.throwNpe();
                    }
                    list2.add(0, ExpressionHelpersKt.irSetField(irBuilderWithScope, ExpressionHelpersKt.irGet(irBuilderWithScope2, irValueParameter), this.$parentThisField, ExpressionHelpersKt.irGet($this$apply, outerThisParameter)));
                    $i$f$forEach22 = blockBody.getStatements();
                    bl = false;
                    Object object = $i$f$forEach22;
                    boolean bl3 = false;
                    Iterator<T> $i$a$-apply-InnerClassesLowering$lower$1$32 = object.iterator();
                    while ($i$a$-apply-InnerClassesLowering$lower$1$32.hasNext()) {
                        T t = $i$a$-apply-InnerClassesLowering$lower$1$32.next();
                        IrStatement it = (IrStatement)t;
                        boolean bl4 = false;
                        if (!(it instanceof IrInstanceInitializerCall)) continue;
                        v6 = t;
                        break block8;
                    }
                    v6 = null;
                }
                if (v6 == null) {
                    Object v7;
                    boolean bl;
                    Object object;
                    block9: {
                        object = blockBody.getStatements();
                        bl = false;
                        Iterable iterable = object;
                        boolean $i$a$-apply-InnerClassesLowering$lower$1$32 = false;
                        for (E e : iterable) {
                            IrStatement it = (IrStatement)e;
                            boolean bl5 = false;
                            if (!(it instanceof IrDelegatingConstructorCall)) continue;
                            v7 = e;
                            break block9;
                        }
                        v7 = null;
                    }
                    IrDelegatingConstructorCall irDelegatingConstructorCall = v7;
                    if (irDelegatingConstructorCall == null) {
                        throw (Throwable)((Object)new AssertionError((Object)("Delegating constructor call expected: " + DumpIrTreeKt.dump$default(irConstructor, false, 1, null))));
                    }
                    IrDelegatingConstructorCall delegatingConstructorCall = irDelegatingConstructorCall;
                    object = delegatingConstructorCall;
                    bl = false;
                    boolean bl6 = false;
                    Object $this$apply = object;
                    boolean bl7 = false;
                    $this$apply.setDispatchReceiver(new IrGetValueImpl($this$apply.getStartOffset(), $this$apply.getEndOffset(), (IrValueSymbol)outerThisParameter.getSymbol(), null, 8, null));
                }
                PatchDeclarationParentsKt.patchDeclarationParents((IrElement)blockBody, loweredConstructor);
                loweredConstructor.setBody(blockBody);
                return loweredConstructor;
            }
            {
                this.this$0 = innerClassesLowering;
                this.$oldConstructorParameterToNew = hashMap;
                this.$irClass = irClass;
                this.$parentThisField = irField;
                super(1);
            }
        };
        Collection collection = irClass.getDeclarations();
        boolean bl = false;
        collection.add(parentThisField);
        TransformKt.transformDeclarationsFlat(irClass, (Function1<? super IrDeclaration, ? extends List<? extends IrDeclaration>>)new Function1<IrDeclaration, List<? extends IrDeclaration>>($fun$lowerConstructor$1){
            final /* synthetic */ lower.1 $lowerConstructor$1;

            @Nullable
            public final List<IrDeclaration> invoke(@NotNull IrDeclaration irMember) {
                List<IrConstructor> list2;
                Intrinsics.checkParameterIsNotNull(irMember, "irMember");
                IrDeclaration irDeclaration2 = irMember;
                if (!(irDeclaration2 instanceof IrConstructor)) {
                    irDeclaration2 = null;
                }
                IrConstructor irConstructor = (IrConstructor)irDeclaration2;
                if (irConstructor != null) {
                    IrConstructor irConstructor2 = irConstructor;
                    boolean bl = false;
                    boolean bl2 = false;
                    IrConstructor it = irConstructor2;
                    boolean bl3 = false;
                    list2 = CollectionsKt.listOf(this.$lowerConstructor$1.invoke(it));
                } else {
                    list2 = null;
                }
                return list2;
            }
            {
                this.$lowerConstructor$1 = var1_1;
                super(1);
            }
        });
        IrElementTransformerVoidKt.transformChildrenVoid(irClass, new VariableRemapper(oldConstructorParameterToNew));
        IrElementTransformerVoidKt.transformChildrenVoid(irClass, new IrElementTransformerVoidWithContext(this, irClass){
            final /* synthetic */ InnerClassesLowering this$0;
            final /* synthetic */ IrClass $irClass;

            @NotNull
            public IrStatement visitClassNew(@NotNull IrClass declaration2) {
                Intrinsics.checkParameterIsNotNull(declaration2, "declaration");
                return declaration2;
            }

            @NotNull
            public IrExpression visitGetValue(@NotNull IrGetValue expression2) {
                IrFunction function2;
                IrDeclarationWithName irDeclarationWithName;
                Intrinsics.checkParameterIsNotNull(expression2, "expression");
                IrElementTransformerVoidKt.transformChildrenVoid(expression2, this);
                IrClass implicitThisClass = InnerClassesLowering.access$getClassForImplicitThis$p(this.this$0, expression2.getSymbol());
                if (implicitThisClass == null || Intrinsics.areEqual(implicitThisClass, this.$irClass)) {
                    return expression2;
                }
                int startOffset = expression2.getStartOffset();
                int endOffset = expression2.getEndOffset();
                IrStatementOrigin origin = expression2.getOrigin();
                ScopeWithIr scopeWithIr = this.getCurrentFunction();
                IrElement irElement = scopeWithIr != null ? scopeWithIr.getIrElement() : null;
                if (!(irElement instanceof IrFunction)) {
                    irElement = null;
                }
                if (((irDeclarationWithName = (function2 = (IrFunction)irElement)) == null || (irDeclarationWithName = irDeclarationWithName.getDispatchReceiverParameter()) == null) && (irDeclarationWithName = this.$irClass.getThisReceiver()) == null) {
                    Intrinsics.throwNpe();
                }
                IrDeclarationWithName enclosingThisReceiver = irDeclarationWithName;
                IrExpression irThis = new IrGetValueImpl(startOffset, endOffset, (IrValueSymbol)enclosingThisReceiver.getSymbol(), origin);
                IrClass innerClass = this.$irClass;
                while (Intrinsics.areEqual(innerClass, implicitThisClass) ^ true) {
                    IrExpression irExpression;
                    if (!innerClass.isInner()) {
                        return expression2;
                    }
                    if (function2 instanceof IrConstructor && Intrinsics.areEqual(this.$irClass, innerClass)) {
                        irExpression = new IrGetValueImpl(startOffset, endOffset, (IrValueSymbol)function2.getValueParameters().get(0).getSymbol(), origin);
                    } else {
                        IrField outerThisField = this.this$0.getContext().getDeclarationFactory().getOuterThisField(innerClass);
                        irExpression = new IrGetFieldImpl(startOffset, endOffset, (IrFieldSymbol)outerThisField.getSymbol(), outerThisField.getType(), irThis, origin, null, 64, null);
                    }
                    irThis = irExpression;
                    innerClass = IrUtilsKt.getParentAsClass(innerClass);
                }
                return irThis;
            }
            {
                this.this$0 = $outer;
                this.$irClass = $captured_local_variable$1;
            }
        });
    }

    @NotNull
    public final BackendContext getContext() {
        return this.context;
    }

    public InnerClassesLowering(@NotNull BackendContext context2) {
        Intrinsics.checkParameterIsNotNull(context2, "context");
        this.context = context2;
    }

    @Override
    public void lower(@NotNull IrFile irFile) {
        Intrinsics.checkParameterIsNotNull(irFile, "irFile");
        ClassLoweringPass.DefaultImpls.lower(this, irFile);
    }

    public static final /* synthetic */ IrClass access$getClassForImplicitThis$p(InnerClassesLowering $this, IrValueSymbol $this$access_u24classForImplicitThis_u24p) {
        return $this.getClassForImplicitThis($this$access_u24classForImplicitThis_u24p);
    }
}

