/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.backend.jvm.lower;

import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.backend.common.FileLoweringPass;
import org.jetbrains.kotlin.backend.common.lower.DeclarationIrBuilder;
import org.jetbrains.kotlin.backend.common.lower.LowerUtilsKt;
import org.jetbrains.kotlin.backend.jvm.JvmBackendContext;
import org.jetbrains.kotlin.backend.jvm.codegen.IrTypeMappingKt;
import org.jetbrains.kotlin.backend.jvm.ir.IrInlineReferenceLocator;
import org.jetbrains.kotlin.ir.IrStatement;
import org.jetbrains.kotlin.ir.builders.ExpressionHelpersKt;
import org.jetbrains.kotlin.ir.builders.IrBlockBodyBuilder;
import org.jetbrains.kotlin.ir.builders.IrBuilderWithScope;
import org.jetbrains.kotlin.ir.builders.IrBuildersKt;
import org.jetbrains.kotlin.ir.declarations.IrDeclaration;
import org.jetbrains.kotlin.ir.declarations.IrDeclarationOrigin;
import org.jetbrains.kotlin.ir.declarations.IrFile;
import org.jetbrains.kotlin.ir.declarations.IrFunction;
import org.jetbrains.kotlin.ir.expressions.IrBlockBody;
import org.jetbrains.kotlin.ir.expressions.IrBody;
import org.jetbrains.kotlin.ir.expressions.IrCallableReference;
import org.jetbrains.kotlin.ir.expressions.IrExpression;
import org.jetbrains.kotlin.ir.expressions.IrExpressionBody;
import org.jetbrains.kotlin.ir.util.IrUtilsKt;
import org.jetbrains.kotlin.ir.visitors.IrElementVisitorVoidKt;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u000e\n\u0000\b\u0000\u0018\u00002\u00020\u00012\u00020\u0002B\r\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\u0005J\u0010\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0016J\"\u0010\f\u001a\u00020\t2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u000e2\b\u0010\u0010\u001a\u0004\u0018\u00010\u0011H\u0016J\u0010\u0010\u0012\u001a\u00020\t2\u0006\u0010\u0013\u001a\u00020\u0014H\u0016J\u0010\u0010\u0015\u001a\u00020\t2\u0006\u0010\u0016\u001a\u00020\u000eH\u0016J\f\u0010\u0017\u001a\u00020\t*\u00020\u000eH\u0002J\u0014\u0010\u0018\u001a\u00020\t*\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u000eH\u0002J\u0014\u0010\u0019\u001a\u00020\t*\u00020\u000e2\u0006\u0010\u001a\u001a\u00020\u001bH\u0002R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\u001c"}, d2={"Lorg/jetbrains/kotlin/backend/jvm/lower/FakeInliningLocalVariablesLowering;", "Lorg/jetbrains/kotlin/backend/jvm/ir/IrInlineReferenceLocator;", "Lorg/jetbrains/kotlin/backend/common/FileLoweringPass;", "context", "Lorg/jetbrains/kotlin/backend/jvm/JvmBackendContext;", "(Lorg/jetbrains/kotlin/backend/jvm/JvmBackendContext;)V", "getContext", "()Lorg/jetbrains/kotlin/backend/jvm/JvmBackendContext;", "handleInlineFunctionCallableReferenceParam", "", "valueArgument", "Lorg/jetbrains/kotlin/ir/expressions/IrCallableReference;", "handleInlineFunctionLambdaParam", "lambda", "Lorg/jetbrains/kotlin/ir/declarations/IrFunction;", "callee", "callSite", "Lorg/jetbrains/kotlin/ir/declarations/IrDeclaration;", "lower", "irFile", "Lorg/jetbrains/kotlin/ir/declarations/IrFile;", "visitFunctionNew", "declaration", "addFakeInliningLocalVariables", "addFakeInliningLocalVariablesForArguments", "addFakeLocalVariable", "name", "", "backend.jvm"})
public final class FakeInliningLocalVariablesLowering
extends IrInlineReferenceLocator
implements FileLoweringPass {
    @NotNull
    private final JvmBackendContext context;

    @Override
    public void lower(@NotNull IrFile irFile) {
        Intrinsics.checkParameterIsNotNull(irFile, "irFile");
        IrElementVisitorVoidKt.acceptVoid(irFile, this);
    }

    @Override
    public void visitFunctionNew(@NotNull IrFunction declaration2) {
        Intrinsics.checkParameterIsNotNull(declaration2, "declaration");
        IrElementVisitorVoidKt.acceptChildrenVoid(declaration2, this);
        if (declaration2.isInline() && !declaration2.getOrigin().isSynthetic() && declaration2.getBody() != null) {
            this.addFakeInliningLocalVariables(declaration2);
        }
    }

    @Override
    public void handleInlineFunctionCallableReferenceParam(@NotNull IrCallableReference valueArgument) {
        Intrinsics.checkParameterIsNotNull(valueArgument, "valueArgument");
    }

    @Override
    public void handleInlineFunctionLambdaParam(@NotNull IrFunction lambda2, @NotNull IrFunction callee, @Nullable IrDeclaration callSite) {
        Intrinsics.checkParameterIsNotNull(lambda2, "lambda");
        Intrinsics.checkParameterIsNotNull(callee, "callee");
        if (Intrinsics.areEqual(lambda2.getOrigin(), IrDeclarationOrigin.LOCAL_FUNCTION_FOR_LAMBDA.INSTANCE)) {
            this.addFakeInliningLocalVariablesForArguments(lambda2, callee);
        }
    }

    private final void addFakeInliningLocalVariables(@NotNull IrFunction $this$addFakeInliningLocalVariables) {
        String currentFunctionName = this.context.getMethodSignatureMapper().mapFunctionName($this$addFakeInliningLocalVariables);
        String localName = "$i$f$" + currentFunctionName;
        this.addFakeLocalVariable($this$addFakeInliningLocalVariables, localName);
    }

    private final void addFakeInliningLocalVariablesForArguments(@NotNull IrFunction $this$addFakeInliningLocalVariablesForArguments, IrFunction callee) {
        String internalName;
        String currentFunctionName = this.context.getMethodSignatureMapper().mapFunctionName($this$addFakeInliningLocalVariablesForArguments);
        String argumentToFunctionName = this.context.getMethodSignatureMapper().mapFunctionName(callee);
        String string2 = internalName = IrTypeMappingKt.mapClass(this.context.getTypeMapper(), IrUtilsKt.getParentAsClass($this$addFakeInliningLocalVariablesForArguments)).getInternalName();
        Intrinsics.checkExpressionValueIsNotNull(string2, "internalName");
        String thisType = StringsKt.substringAfterLast(string2, '/', internalName);
        String lambdaReference = thisType + '$' + currentFunctionName;
        String localName = "$i$a$-" + argumentToFunctionName + '-' + lambdaReference;
        this.addFakeLocalVariable($this$addFakeInliningLocalVariablesForArguments, localName);
    }

    /*
     * WARNING - void declaration
     */
    private final void addFakeLocalVariable(@NotNull IrFunction $this$addFakeLocalVariable, String name) {
        void $this$irBlockBody$iv;
        DeclarationIrBuilder declarationIrBuilder = LowerUtilsKt.createIrBuilder$default(this.context, $this$addFakeLocalVariable.getSymbol(), 0, 0, 6, null);
        boolean bl = false;
        boolean bl2 = false;
        DeclarationIrBuilder $this$run = declarationIrBuilder;
        boolean bl3 = false;
        IrBuilderWithScope irBuilderWithScope = $this$run;
        IrFunction irFunction = $this$addFakeLocalVariable;
        int startOffset$iv = $this$irBlockBody$iv.getStartOffset();
        int endOffset$iv = $this$irBlockBody$iv.getEndOffset();
        boolean $i$f$irBlockBody = false;
        IrBlockBodyBuilder this_$iv$iv = new IrBlockBodyBuilder($this$irBlockBody$iv.getContext(), $this$irBlockBody$iv.getScope(), startOffset$iv, endOffset$iv);
        boolean $i$f$blockBody = false;
        IrBlockBodyBuilder $this$irBlockBody = this_$iv$iv;
        boolean bl4 = false;
        IrBuildersKt.createTmpVariable$default($this$irBlockBody, (IrExpression)ExpressionHelpersKt.irInt($this$irBlockBody, 0), name, false, (IrDeclarationOrigin)IrDeclarationOrigin.DEFINED.INSTANCE, null, 20, null);
        if ($this$addFakeLocalVariable.getBody() instanceof IrExpressionBody) {
            IrBody irBody = $this$addFakeLocalVariable.getBody();
            if (irBody == null) {
                throw new TypeCastException("null cannot be cast to non-null type org.jetbrains.kotlin.ir.expressions.IrExpressionBody");
            }
            $this$irBlockBody.unaryPlus(ExpressionHelpersKt.irReturn($this$irBlockBody, ((IrExpressionBody)irBody).getExpression()));
        } else {
            IrBody irBody = $this$addFakeLocalVariable.getBody();
            if (irBody == null) {
                throw new TypeCastException("null cannot be cast to non-null type org.jetbrains.kotlin.ir.expressions.IrBlockBody");
            }
            Iterable $this$forEach$iv = ((IrBlockBody)irBody).getStatements();
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                IrStatement it = (IrStatement)element$iv;
                boolean bl5 = false;
                $this$irBlockBody.unaryPlus(it);
            }
        }
        IrBlockBody irBlockBody2 = this_$iv$iv.doBuild();
        irFunction.setBody(irBlockBody2);
    }

    @NotNull
    public final JvmBackendContext getContext() {
        return this.context;
    }

    public FakeInliningLocalVariablesLowering(@NotNull JvmBackendContext context2) {
        Intrinsics.checkParameterIsNotNull(context2, "context");
        super(context2);
        this.context = context2;
    }
}

