/*
 * Decompiled with CFR 0.152.
 */
package org.protege.xmlcatalog.write;

import java.net.URI;
import org.protege.xmlcatalog.CatalogUtilities;
import org.protege.xmlcatalog.EntryVisitor;
import org.protege.xmlcatalog.XmlBaseContext;
import org.protege.xmlcatalog.entry.AbstractDelegateEntry;
import org.protege.xmlcatalog.entry.DelegatePublicEntry;
import org.protege.xmlcatalog.entry.DelegateSystemEntry;
import org.protege.xmlcatalog.entry.DelegateUriEntry;
import org.protege.xmlcatalog.entry.Entry;
import org.protege.xmlcatalog.entry.GroupEntry;
import org.protege.xmlcatalog.entry.NextCatalogEntry;
import org.protege.xmlcatalog.entry.PublicEntry;
import org.protege.xmlcatalog.entry.RewriteSystemEntry;
import org.protege.xmlcatalog.entry.RewriteUriEntry;
import org.protege.xmlcatalog.entry.SystemEntry;
import org.protege.xmlcatalog.entry.UriEntry;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class XMLRenderingVisitor
implements EntryVisitor {
    private Document document;
    private Element parent;

    public XMLRenderingVisitor(Document document, Element parent, URI xmlbase) {
        this.document = document;
        this.parent = parent;
    }

    @Override
    public void visit(GroupEntry entry) {
        Element groupElement = this.document.createElement("group");
        this.addId(groupElement, entry);
        this.addXmlBase(groupElement, entry);
        if (entry.getPrefer() != null) {
            groupElement.setAttribute("prefer", entry.getPrefer().getName());
        }
        this.parent.appendChild(groupElement);
        XMLRenderingVisitor subEntryVisitor = new XMLRenderingVisitor(this.document, groupElement, CatalogUtilities.resolveXmlBase(entry));
        for (Entry subEntry : entry.getEntries()) {
            subEntry.accept(subEntryVisitor);
        }
    }

    @Override
    public void visit(PublicEntry entry) {
        Element publicElement = this.document.createElement("public");
        this.addId(publicElement, entry);
        this.addXmlBase(publicElement, entry);
        publicElement.setAttribute("publicId", entry.getPublicId());
        publicElement.setAttribute("uri", entry.getUri().toString());
        this.parent.appendChild(publicElement);
    }

    @Override
    public void visit(SystemEntry entry) {
        Element systemElement = this.document.createElement("system");
        this.addId(systemElement, entry);
        this.addXmlBase(systemElement, entry);
        systemElement.setAttribute("systemId", entry.getSystemId());
        systemElement.setAttribute("uri", entry.getUri().toString());
        this.parent.appendChild(systemElement);
    }

    @Override
    public void visit(RewriteSystemEntry entry) {
        Element rewriteSystemElement = this.document.createElement("rewriteSystem");
        this.addId(rewriteSystemElement, entry);
        rewriteSystemElement.setAttribute("systemIdStartString", entry.getSystemIdStartString());
        rewriteSystemElement.setAttribute("rewritePrefix", entry.getRewritePrefix().toString());
        this.parent.appendChild(rewriteSystemElement);
    }

    @Override
    public void visit(DelegatePublicEntry entry) {
        Element delgatePublicElement = this.document.createElement("delegatePublic");
        this.addId(delgatePublicElement, entry);
        this.addDelegate(delgatePublicElement, entry);
        delgatePublicElement.setAttribute("publicIdStartString", entry.getPublicIdStartString());
        this.parent.appendChild(delgatePublicElement);
    }

    @Override
    public void visit(DelegateSystemEntry entry) {
        Element delegateSystemElement = this.document.createElement("delegateSystem");
        this.addId(delegateSystemElement, entry);
        this.addDelegate(delegateSystemElement, entry);
        delegateSystemElement.setAttribute("systemIdStartString", entry.getSystemIdStartString());
        this.parent.appendChild(delegateSystemElement);
    }

    @Override
    public void visit(UriEntry entry) {
        Element uriElement = this.document.createElement("uri");
        this.addId(uriElement, entry);
        this.addXmlBase(uriElement, entry);
        uriElement.setAttribute("name", entry.getName());
        uriElement.setAttribute("uri", entry.getUri().toString());
        this.parent.appendChild(uriElement);
    }

    @Override
    public void visit(RewriteUriEntry entry) {
        Element rewriteElement = this.document.createElement("rewriteURI");
        this.addId(rewriteElement, entry);
        rewriteElement.setAttribute("uriStartString", entry.getUriStartString());
        rewriteElement.setAttribute("rewritePrefix", entry.getRewritePrefix().toString());
        this.parent.appendChild(rewriteElement);
    }

    @Override
    public void visit(DelegateUriEntry entry) {
        Element delegateUriElement = this.document.createElement("delegateURI");
        this.addId(delegateUriElement, entry);
        this.addXmlBase(delegateUriElement, entry);
        delegateUriElement.setAttribute("uriStartString", entry.getUriStartString());
        delegateUriElement.setAttribute("catalog", entry.getCatalog().toString());
        this.parent.appendChild(delegateUriElement);
    }

    @Override
    public void visit(NextCatalogEntry entry) {
        Element nextCatalogElement = this.document.createElement("nextCatalog");
        this.addId(nextCatalogElement, entry);
        this.addXmlBase(nextCatalogElement, entry);
        nextCatalogElement.setAttribute("catalog", entry.getCatalog().toString());
        this.parent.appendChild(nextCatalogElement);
    }

    private void addId(Element entryElement, Entry entry) {
        if (entry.getId() != null) {
            entryElement.setAttribute("id", entry.getId());
        }
    }

    private void addXmlBase(Element element, XmlBaseContext entry) {
        URI xmlbase = entry.getXmlBase();
        if (xmlbase != null) {
            URI parentBase;
            if (entry.getXmlBaseContext() != null && (parentBase = CatalogUtilities.resolveXmlBase(entry.getXmlBaseContext())) != null) {
                xmlbase = parentBase.relativize(xmlbase);
            }
            element.setAttribute("xml:base", xmlbase.toString());
        }
    }

    private void addDelegate(Element entryElement, AbstractDelegateEntry delegateEntry) {
        this.addXmlBase(entryElement, delegateEntry);
        entryElement.setAttribute("catalog", delegateEntry.getCatalog().toString());
    }
}

