/*
 * Decompiled with CFR 0.152.
 */
package org.freehep.graphicsio.font.truetype;

import java.awt.Rectangle;
import java.io.IOException;
import org.freehep.graphicsio.font.truetype.TTFVersionTable;

public class TTFHeadTable
extends TTFVersionTable {
    public static final int FDH_MIXED = 0;
    public static final int FDH_LEFT_TO_RIGHT = 1;
    public static final int FDH_LEFT_TO_RIGHT_NEUTRAL = 2;
    public static final int FDH_RIGHT_TO_LEFT = -1;
    public static final int FDH_RIGHT_TO_LEFT_NEUTRAL = -2;
    public static final int ITLF_SHORT = 0;
    public static final int ITLF_LONG = 1;
    public int fontRevisionMinor;
    public int fontRevisionMajor;
    public long checkSumAdjustment;
    public long magicNumber;
    public boolean baseline0;
    public boolean sidebearing0;
    public boolean instrDependOnSize;
    public boolean forcePPEM2Int;
    public boolean instrAlterAdvance;
    public int unitsPerEm;
    public byte[] created = new byte[8];
    public byte[] modified = new byte[8];
    public short xMin;
    public short yMin;
    public short xMax;
    public short yMax;
    public boolean macBold;
    public boolean macItalic;
    public int lowestRecPPEM;
    public short fontDirectionHint;
    public short indexToLocFormat;
    public short glyphDataFormat;

    public String getTag() {
        return "head";
    }

    public void readTable() throws IOException {
        this.readVersion();
        this.fontRevisionMajor = this.ttf.readUShort();
        this.fontRevisionMinor = this.ttf.readUShort();
        this.checkSumAdjustment = this.ttf.readULong();
        this.magicNumber = this.ttf.readULong();
        this.ttf.readUShortFlags();
        this.baseline0 = this.ttf.flagBit(0);
        this.sidebearing0 = this.ttf.flagBit(1);
        this.instrDependOnSize = this.ttf.flagBit(2);
        this.forcePPEM2Int = this.ttf.flagBit(3);
        this.instrAlterAdvance = this.ttf.flagBit(4);
        this.unitsPerEm = this.ttf.readUShort();
        this.ttf.readFully(this.created);
        this.ttf.readFully(this.modified);
        this.xMin = this.ttf.readShort();
        this.yMin = this.ttf.readShort();
        this.xMax = this.ttf.readShort();
        this.yMax = this.ttf.readShort();
        this.ttf.readUShortFlags();
        this.macBold = this.ttf.flagBit(0);
        this.macItalic = this.ttf.flagBit(1);
        this.lowestRecPPEM = this.ttf.readUShort();
        this.fontDirectionHint = this.ttf.readShort();
        this.indexToLocFormat = this.ttf.readShort();
        if (this.indexToLocFormat != 1 && this.indexToLocFormat != 0) {
            System.err.println("Unknown value for indexToLocFormat: " + this.indexToLocFormat);
        }
        this.glyphDataFormat = this.ttf.readShort();
    }

    public String toString() {
        String str = super.toString() + "\n" + "  magicNumber: 0x" + Integer.toHexString((int)this.magicNumber) + " (" + (this.magicNumber == 1594834165L ? "ok" : "wrong") + ")\n";
        str = str + "  indexToLocFormat: " + this.indexToLocFormat + " ";
        str = this.indexToLocFormat == 1 ? str + " (long)\n" : (this.indexToLocFormat == 0 ? str + "(short)\n" : str + "(illegal value)\n");
        str = str + "  bbox: (" + this.xMin + "," + this.yMin + ") : (" + this.xMax + "," + this.yMax + ")";
        return str;
    }

    public Rectangle getMaxCharBounds() {
        return new Rectangle(this.xMin, this.yMin, this.xMax - this.xMin, this.yMax - this.yMin);
    }
}

