/*
 * Decompiled with CFR 0.152.
 */
package org.freehep.graphicsio.gif;

import java.awt.Component;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Properties;
import javax.imageio.spi.IIORegistry;
import javax.imageio.spi.ImageWriterSpi;
import javax.swing.JLabel;
import javax.swing.JPanel;
import org.freehep.graphics2d.VectorGraphics;
import org.freehep.graphicsbase.util.UserProperties;
import org.freehep.graphicsio.exportchooser.ImageExportFileType;
import org.freehep.graphicsio.exportchooser.OptionCheckBox;
import org.freehep.graphicsio.exportchooser.OptionComboBox;
import org.freehep.graphicsio.gif.GIFGraphics2D;
import org.freehep.graphicsio.gif.GIFImageWriterSpi;

public class GIFExportFileType
extends ImageExportFileType {
    public static final String[] quantizeModes;

    public GIFExportFileType() {
        super(new GIFImageWriterSpi());
    }

    public boolean hasOptionPanel() {
        return true;
    }

    public JPanel createOptionPanel(Properties user) {
        UserProperties options = new UserProperties(user, GIFGraphics2D.getDefaultProperties());
        JPanel panel = super.createOptionPanel(options);
        OptionCheckBox quantize = new OptionCheckBox(options, GIFGraphics2D.QUANTIZE_COLORS, "Quantize Colors");
        panel.add("0 * * 1 [5 15 5 15] w", quantize);
        JLabel quantizeModeLabel = new JLabel("Quantize using ");
        panel.add("0 * [5 15 5 15] r", quantizeModeLabel);
        quantize.enables(quantizeModeLabel);
        OptionComboBox quantizeMode = new OptionComboBox(options, GIFGraphics2D.QUANTIZE_MODE, quantizeModes);
        panel.add("1 * [5 15 5 15] lw", quantizeMode);
        quantize.enables(quantizeMode);
        quantize.setEnabled(false);
        quantizeModeLabel.setEnabled(false);
        quantizeMode.setEnabled(false);
        return panel;
    }

    public VectorGraphics getGraphics(OutputStream os, Component target) throws IOException {
        return new GIFGraphics2D(os, target.getSize());
    }

    static {
        try {
            Class<?> clazz = Class.forName("org.freehep.graphicsio.gif.GIFImageWriterSpi");
            IIORegistry.getDefaultInstance().registerServiceProvider((ImageWriterSpi)clazz.newInstance(), ImageWriterSpi.class);
        }
        catch (Exception e) {
            System.out.println(e);
        }
        quantizeModes = new String[]{"NeuQuant"};
    }
}

