/*
 * Decompiled with CFR 0.152.
 */
package javax.media.j3d;

import javax.media.j3d.InputDevice;

class InputDeviceBlockingThread
extends Thread {
    private static final int WAIT = 0;
    private static final int NOTIFY = 1;
    private static final int STOP = 2;
    private InputDevice device;
    private volatile boolean running = true;
    private volatile boolean stop = false;
    private boolean waiting = false;
    private boolean ready = false;
    private static int numInstances = 0;
    private int instanceNum = -1;

    InputDeviceBlockingThread(ThreadGroup threadGroup, InputDevice inputDevice) {
        super(threadGroup, "");
        this.setName("J3D-InputDeviceBlockingThread-" + this.getInstanceNum());
        this.device = inputDevice;
    }

    private synchronized int newInstanceNum() {
        return ++numInstances;
    }

    private int getInstanceNum() {
        if (this.instanceNum == -1) {
            this.instanceNum = this.newInstanceNum();
        }
        return this.instanceNum;
    }

    @Override
    public void run() {
        while (this.running) {
            while (!this.stop) {
                this.device.pollAndProcessInput();
                Thread.yield();
            }
            this.runMonitor(0);
        }
    }

    void sleep() {
        this.stop = true;
    }

    void restart() {
        this.stop = false;
        this.runMonitor(1);
    }

    void finish() {
        this.stop = true;
        this.runMonitor(2);
    }

    synchronized void runMonitor(int n) {
        switch (n) {
            case 0: {
                while (this.running && !this.ready) {
                    this.waiting = true;
                    try {
                        this.wait();
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                    this.waiting = false;
                }
                this.ready = false;
                break;
            }
            case 1: {
                this.ready = true;
                if (!this.waiting) break;
                this.notify();
                break;
            }
            case 2: {
                this.running = false;
                if (!this.waiting) break;
                this.notify();
            }
        }
    }
}

