/*
 * Decompiled with CFR 0.152.
 */
package com.sun.media.vfw;

import com.sun.media.format.AviVideoFormat;
import java.awt.Dimension;
import javax.media.Format;
import javax.media.format.RGBFormat;
import javax.media.format.VideoFormat;
import javax.media.format.YUVFormat;

public class BitMapInfo {
    public int biWidth = 0;
    public int biHeight = 0;
    public int biPlanes = 1;
    public int biBitCount = 24;
    public String fourcc = "";
    public int biSizeImage = 0;
    public int biXPelsPerMeter = 0;
    public int biYPelsPerMeter = 0;
    public int biClrUsed = 0;
    public int biClrImportant = 0;
    public int extraSize = 0;
    public byte[] extraBytes = null;
    static /* synthetic */ Class array$B;

    public BitMapInfo() {
    }

    public BitMapInfo(String fourcc, int width, int height) {
        this.biWidth = width;
        this.biHeight = height;
        this.fourcc = fourcc;
        if (fourcc.equals("RGB")) {
            this.biSizeImage = width * height * 3;
        }
        if (fourcc.equals("MSVC")) {
            this.fourcc = "CRAM";
        }
    }

    public BitMapInfo(String fourcc, int width, int height, int planes, int bitcount, int sizeImage, int clrused, int clrimportant) {
        this(fourcc, width, height);
        this.biPlanes = planes;
        this.biBitCount = bitcount;
        this.biSizeImage = sizeImage;
        this.biClrUsed = clrused;
        this.biClrImportant = clrimportant;
    }

    public BitMapInfo(VideoFormat format) {
        Class arrayType;
        Dimension size = format.getSize();
        if (size == null) {
            size = new Dimension(320, 240);
        }
        int elSize = (arrayType = format.getDataType()) == Format.byteArray ? 1 : (arrayType == Format.intArray ? 4 : 2);
        this.biWidth = size.width;
        this.biHeight = size.height;
        this.biPlanes = 1;
        this.biSizeImage = format.getMaxDataLength() * elSize;
        this.fourcc = format.getEncoding();
        if (this.fourcc.equalsIgnoreCase("msvc")) {
            this.fourcc = "CRAM";
        }
        if (format instanceof AviVideoFormat) {
            AviVideoFormat avif = (AviVideoFormat)format;
            this.biPlanes = avif.getPlanes();
            this.biBitCount = avif.getBitsPerPixel();
            this.biXPelsPerMeter = avif.getXPelsPerMeter();
            this.biYPelsPerMeter = avif.getYPelsPerMeter();
            this.biClrUsed = avif.getClrUsed();
            this.biClrImportant = avif.getClrImportant();
            this.extraBytes = avif.getCodecSpecificHeader();
            if (this.extraBytes != null) {
                this.extraSize = this.extraBytes.length;
            }
        } else if (format instanceof RGBFormat) {
            RGBFormat rgb = (RGBFormat)format;
            this.fourcc = "RGB";
            this.biBitCount = rgb.getBitsPerPixel();
            if (rgb.getFlipped() == 0) {
                this.biHeight = -this.biHeight;
            }
        } else if (format instanceof YUVFormat) {
            YUVFormat yuv = (YUVFormat)format;
            switch (yuv.getYuvType()) {
                case 2: {
                    this.fourcc = yuv.getOffsetU() < yuv.getOffsetV() ? "I420" : "YV12";
                }
                case 32: {
                    if (yuv.getOffsetY() == 0 && yuv.getOffsetU() == 1) {
                        this.fourcc = "YUY2";
                        break;
                    }
                    if (yuv.getOffsetY() == 0 && yuv.getOffsetU() == 3) {
                        this.fourcc = "YVYU";
                        break;
                    }
                    if (yuv.getOffsetU() != 0) break;
                    this.fourcc = "UYVY";
                }
            }
            if (this.fourcc.equalsIgnoreCase("yv12") || this.fourcc.equalsIgnoreCase("i420") || this.fourcc.equalsIgnoreCase("y411")) {
                this.biBitCount = 12;
            } else if (this.fourcc.equalsIgnoreCase("yuy2")) {
                this.biBitCount = 16;
            }
        }
    }

    public VideoFormat createVideoFormat(Class arrayType) {
        return this.createVideoFormat(arrayType, -1.0f);
    }

    public VideoFormat createVideoFormat(Class arrayType, float frameRate) {
        VideoFormat format;
        if (this.fourcc.equalsIgnoreCase("rgb")) {
            int elSize = arrayType == Format.byteArray ? 1 : (arrayType == Format.intArray ? 4 : 2);
            int maxDataLength = this.biSizeImage / elSize;
            int rm = -1;
            int gm = -1;
            int bm = -1;
            if (this.biBitCount == 16) {
                rm = 31744;
                gm = 992;
                bm = 31;
            } else if (this.biBitCount == 32) {
                if (elSize == 4) {
                    rm = 0xFF0000;
                    gm = 65280;
                    bm = 255;
                } else {
                    rm = 3;
                    gm = 2;
                    bm = 1;
                }
            } else if (this.biBitCount == 24) {
                rm = 3;
                gm = 2;
                bm = 1;
            }
            int bytesPerLine = this.biWidth * this.biBitCount / 8;
            int lineStride = bytesPerLine / elSize;
            int pixelStride = lineStride / this.biWidth;
            int actualHeight = this.biHeight;
            int flipped = 1;
            if (this.biHeight < 0) {
                actualHeight = -actualHeight;
                flipped = 0;
            }
            format = new RGBFormat(new Dimension(this.biWidth, actualHeight), maxDataLength, arrayType, frameRate, this.biBitCount, rm, gm, bm, pixelStride, lineStride, flipped, 1);
        } else if (this.fourcc.equalsIgnoreCase("yuy2")) {
            int ySize = this.biWidth * this.biHeight;
            format = new YUVFormat(new Dimension(this.biWidth, this.biHeight), this.biSizeImage, array$B == null ? (array$B = BitMapInfo.class$("[B")) : array$B, frameRate, 32, this.biWidth * 2, this.biWidth * 2, 0, 1, 3);
        } else if (this.fourcc.equalsIgnoreCase("i420")) {
            int ySize = this.biWidth * this.biHeight;
            format = new YUVFormat(new Dimension(this.biWidth, this.biHeight), this.biSizeImage, array$B == null ? (array$B = BitMapInfo.class$("[B")) : array$B, frameRate, 2, this.biWidth, this.biWidth / 2, 0, ySize, ySize + ySize / 4);
        } else if (this.fourcc.equalsIgnoreCase("yv12")) {
            int ySize = this.biWidth * this.biHeight;
            format = new YUVFormat(new Dimension(this.biWidth, this.biHeight), this.biSizeImage, array$B == null ? (array$B = BitMapInfo.class$("[B")) : array$B, frameRate, 2, this.biWidth, this.biWidth / 2, 0, ySize + ySize / 4, ySize);
        } else {
            format = new AviVideoFormat(this.fourcc, new Dimension(this.biWidth, this.biHeight), this.biSizeImage, arrayType, frameRate, this.biPlanes, this.biBitCount, this.biSizeImage, this.biXPelsPerMeter, this.biYPelsPerMeter, this.biClrUsed, this.biClrImportant, this.extraBytes);
        }
        return format;
    }

    public String toString() {
        String s = "Size = " + this.biWidth + " x " + this.biHeight + "\t" + "Planes = " + this.biPlanes + "\t" + "BitCount = " + this.biBitCount + "\t" + "FourCC = " + this.fourcc + "\t" + "SizeImage = " + this.biSizeImage + "\n" + "ClrUsed = " + this.biClrUsed + "\n" + "ClrImportant = " + this.biClrImportant + "\n" + "ExtraSize = " + this.extraSize + "\n";
        if (this.extraSize > 0) {
            int i = 0;
            while (i < this.extraSize) {
                s = s + "\t" + i + " = " + this.extraBytes[i] + "\n";
                ++i;
            }
        }
        return s;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

