/*
 * Decompiled with CFR 0.152.
 */
package org.hsqldb.jdbc;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.io.Reader;
import java.io.StringReader;
import java.math.BigDecimal;
import java.net.URL;
import java.sql.Array;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.Date;
import java.sql.NClob;
import java.sql.Ref;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.RowId;
import java.sql.SQLException;
import java.sql.SQLType;
import java.sql.SQLWarning;
import java.sql.SQLXML;
import java.sql.Statement;
import java.sql.Time;
import java.sql.Timestamp;
import java.time.Duration;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.OffsetDateTime;
import java.time.OffsetTime;
import java.time.Period;
import java.time.ZoneOffset;
import java.util.Calendar;
import java.util.Map;
import org.hsqldb.ColumnBase;
import org.hsqldb.HsqlDateTime;
import org.hsqldb.HsqlException;
import org.hsqldb.SessionInterface;
import org.hsqldb.jdbc.JDBCArray;
import org.hsqldb.jdbc.JDBCBlob;
import org.hsqldb.jdbc.JDBCBlobClient;
import org.hsqldb.jdbc.JDBCClob;
import org.hsqldb.jdbc.JDBCClobClient;
import org.hsqldb.jdbc.JDBCConnection;
import org.hsqldb.jdbc.JDBCNClob;
import org.hsqldb.jdbc.JDBCPreparedStatement;
import org.hsqldb.jdbc.JDBCResultSetMetaData;
import org.hsqldb.jdbc.JDBCSQLXML;
import org.hsqldb.jdbc.JDBCStatementBase;
import org.hsqldb.jdbc.JDBCUtil;
import org.hsqldb.lib.IntValueHashMap;
import org.hsqldb.lib.StringInputStream;
import org.hsqldb.lib.java.JavaSystem;
import org.hsqldb.navigator.RowSetNavigator;
import org.hsqldb.result.Result;
import org.hsqldb.result.ResultMetaData;
import org.hsqldb.result.ResultProperties;
import org.hsqldb.types.BinaryData;
import org.hsqldb.types.BinaryUUIDType;
import org.hsqldb.types.BlobDataID;
import org.hsqldb.types.ClobDataID;
import org.hsqldb.types.DateTimeType;
import org.hsqldb.types.IntervalMonthData;
import org.hsqldb.types.IntervalSecondData;
import org.hsqldb.types.IntervalType;
import org.hsqldb.types.JavaObjectData;
import org.hsqldb.types.TimeData;
import org.hsqldb.types.TimestampData;
import org.hsqldb.types.Type;
import org.hsqldb.types.Types;

public class JDBCResultSet
implements ResultSet {
    private RowSetNavigator navigator;
    protected ResultMetaData resultMetaData;
    private boolean translateTTIType;
    private int columnCount;
    private boolean wasNullValue;
    private ResultSetMetaData resultSetMetaData;
    private IntValueHashMap columnMap;
    private SQLWarning rootWarning;
    private boolean memoryLobs;
    JDBCStatementBase statement;
    SessionInterface session;
    JDBCConnection connection;
    boolean isScrollable;
    boolean isUpdatable;
    boolean isInsertable;
    int rsProperties;
    int fetchSize;
    boolean autoClose;
    public Result result;
    JDBCPreparedStatement preparedStatement;
    boolean isRowUpdated;
    boolean isOnInsertRow;
    int currentUpdateRowNumber;

    @Override
    public boolean next() throws SQLException {
        this.checkClosed();
        this.rootWarning = null;
        return this.navigator.next();
    }

    @Override
    public void close() throws SQLException {
        if (this.navigator == null) {
            return;
        }
        if (ResultProperties.isHeld(this.rsProperties)) {
            this.session.closeNavigator(this.navigator.getId());
        } else {
            this.navigator.release();
        }
        this.navigator = null;
        if (this.autoClose && this.statement != null) {
            this.statement.close();
        }
    }

    @Override
    public boolean wasNull() throws SQLException {
        this.checkClosed();
        return this.wasNullValue;
    }

    @Override
    public String getString(int n) throws SQLException {
        this.checkColumn(n);
        Type type = this.resultMetaData.columnTypes[n - 1];
        if (type.typeCode == 40) {
            ClobDataID clobDataID = (ClobDataID)this.getColumnInType(n, type);
            if (clobDataID == null) {
                return null;
            }
            long l = clobDataID.length(this.session);
            if (l > Integer.MAX_VALUE) {
                throw JDBCUtil.sqlException(5561);
            }
            return clobDataID.getSubString(this.session, 0L, (int)l);
        }
        return (String)this.getColumnInType(n, Type.SQL_VARCHAR);
    }

    @Override
    public boolean getBoolean(int n) throws SQLException {
        Object object = this.getColumnInType(n, Type.SQL_BOOLEAN);
        return object == null ? false : (Boolean)object;
    }

    @Override
    public byte getByte(int n) throws SQLException {
        Object object = this.getColumnInType(n, Type.TINYINT);
        return object == null ? (byte)0 : ((Number)object).byteValue();
    }

    @Override
    public short getShort(int n) throws SQLException {
        Object object = this.getColumnInType(n, Type.SQL_SMALLINT);
        return object == null ? (short)0 : ((Number)object).shortValue();
    }

    @Override
    public int getInt(int n) throws SQLException {
        Object object = this.getColumnInType(n, Type.SQL_INTEGER);
        return object == null ? 0 : ((Number)object).intValue();
    }

    @Override
    public long getLong(int n) throws SQLException {
        Object object = this.getColumnInType(n, Type.SQL_BIGINT);
        return object == null ? 0L : ((Number)object).longValue();
    }

    @Override
    public float getFloat(int n) throws SQLException {
        Object object = this.getColumnInType(n, Type.SQL_DOUBLE);
        return object == null ? 0.0f : ((Number)object).floatValue();
    }

    @Override
    public double getDouble(int n) throws SQLException {
        Object object = this.getColumnInType(n, Type.SQL_DOUBLE);
        return object == null ? 0.0 : ((Number)object).doubleValue();
    }

    @Override
    @Deprecated
    public BigDecimal getBigDecimal(int n, int n2) throws SQLException {
        if (n2 < 0) {
            throw JDBCUtil.outOfRangeArgument();
        }
        BigDecimal bigDecimal = this.getBigDecimal(n);
        if (bigDecimal != null) {
            bigDecimal = bigDecimal.setScale(n2, 1);
        }
        return bigDecimal;
    }

    @Override
    public byte[] getBytes(int n) throws SQLException {
        this.checkColumn(n);
        Type type = this.resultMetaData.columnTypes[n - 1];
        if (type.typeCode == 30) {
            BlobDataID blobDataID = (BlobDataID)this.getColumnInType(n, type);
            if (blobDataID == null) {
                return null;
            }
            long l = blobDataID.length(this.session);
            if (l > Integer.MAX_VALUE) {
                throw JDBCUtil.sqlException(5561);
            }
            return blobDataID.getBytes(this.session, 0L, (int)l);
        }
        Object object = this.getColumnInType(n, Type.SQL_VARBINARY);
        if (object == null) {
            return null;
        }
        return ((BinaryData)object).getBytes();
    }

    @Override
    public Date getDate(int n) throws SQLException {
        Object object = this.getColumnInType(n, Type.SQL_DATE);
        if (object == null) {
            return null;
        }
        return (Date)Type.SQL_DATE.convertSQLToJava(this.session, object);
    }

    @Override
    public Time getTime(int n) throws SQLException {
        Object object = this.getColumnInType(n, Type.SQL_TIME);
        if (object == null) {
            return null;
        }
        return (Time)Type.SQL_TIME.convertSQLToJava(this.session, object);
    }

    @Override
    public Timestamp getTimestamp(int n) throws SQLException {
        Object object = this.getColumnInType(n, Type.SQL_TIMESTAMP);
        if (object == null) {
            return null;
        }
        return (Timestamp)Type.SQL_TIMESTAMP.convertSQLToJava(this.session, object);
    }

    @Override
    public InputStream getAsciiStream(int n) throws SQLException {
        String string = this.getString(n);
        if (string == null) {
            return null;
        }
        try {
            return new ByteArrayInputStream(string.getBytes(JavaSystem.CS_US_ASCII));
        }
        catch (Throwable throwable) {
            throw JDBCUtil.sqlException(throwable);
        }
    }

    @Override
    @Deprecated
    public InputStream getUnicodeStream(int n) throws SQLException {
        String string = this.getString(n);
        if (string == null) {
            return null;
        }
        return new StringInputStream(string);
    }

    @Override
    public InputStream getBinaryStream(int n) throws SQLException {
        this.checkColumn(n);
        Type type = this.resultMetaData.columnTypes[n - 1];
        Object object = this.getColumnInType(n, type);
        if (object == null) {
            return null;
        }
        if (object instanceof BlobDataID) {
            return ((BlobDataID)object).getBinaryStream(this.session);
        }
        if (object instanceof Blob) {
            return ((Blob)object).getBinaryStream();
        }
        if (object instanceof BinaryData) {
            byte[] byArray = this.getBytes(n);
            return new ByteArrayInputStream(byArray);
        }
        throw JDBCUtil.sqlException(5561);
    }

    @Override
    public String getString(String string) throws SQLException {
        return this.getString(this.findColumn(string));
    }

    @Override
    public boolean getBoolean(String string) throws SQLException {
        return this.getBoolean(this.findColumn(string));
    }

    @Override
    public byte getByte(String string) throws SQLException {
        return this.getByte(this.findColumn(string));
    }

    @Override
    public short getShort(String string) throws SQLException {
        return this.getShort(this.findColumn(string));
    }

    @Override
    public int getInt(String string) throws SQLException {
        return this.getInt(this.findColumn(string));
    }

    @Override
    public long getLong(String string) throws SQLException {
        return this.getLong(this.findColumn(string));
    }

    @Override
    public float getFloat(String string) throws SQLException {
        return this.getFloat(this.findColumn(string));
    }

    @Override
    public double getDouble(String string) throws SQLException {
        return this.getDouble(this.findColumn(string));
    }

    @Override
    @Deprecated
    public BigDecimal getBigDecimal(String string, int n) throws SQLException {
        return this.getBigDecimal(this.findColumn(string), n);
    }

    @Override
    public byte[] getBytes(String string) throws SQLException {
        return this.getBytes(this.findColumn(string));
    }

    @Override
    public Date getDate(String string) throws SQLException {
        return this.getDate(this.findColumn(string));
    }

    @Override
    public Time getTime(String string) throws SQLException {
        return this.getTime(this.findColumn(string));
    }

    @Override
    public Timestamp getTimestamp(String string) throws SQLException {
        return this.getTimestamp(this.findColumn(string));
    }

    @Override
    public InputStream getAsciiStream(String string) throws SQLException {
        return this.getAsciiStream(this.findColumn(string));
    }

    @Override
    @Deprecated
    public InputStream getUnicodeStream(String string) throws SQLException {
        return this.getUnicodeStream(this.findColumn(string));
    }

    @Override
    public InputStream getBinaryStream(String string) throws SQLException {
        return this.getBinaryStream(this.findColumn(string));
    }

    @Override
    public SQLWarning getWarnings() throws SQLException {
        this.checkClosed();
        return this.rootWarning;
    }

    @Override
    public void clearWarnings() throws SQLException {
        this.checkClosed();
        this.rootWarning = null;
    }

    @Override
    public String getCursorName() throws SQLException {
        this.checkClosed();
        if (this.result == null) {
            return "";
        }
        return this.result.getMainString();
    }

    @Override
    public ResultSetMetaData getMetaData() throws SQLException {
        this.checkClosed();
        if (this.resultSetMetaData == null) {
            this.resultSetMetaData = new JDBCResultSetMetaData(this.resultMetaData, this.isUpdatable, this.isInsertable, this.connection);
        }
        return this.resultSetMetaData;
    }

    @Override
    public Object getObject(int n) throws SQLException {
        this.checkColumn(n);
        Type type = this.resultMetaData.columnTypes[n - 1];
        switch (type.typeCode) {
            case 50: {
                return this.getArray(n);
            }
            case 91: {
                return this.getDate(n);
            }
            case 92: {
                return this.getTime(n);
            }
            case 94: {
                return this.getTimeWithZone(n);
            }
            case 93: {
                return this.getTimestamp(n);
            }
            case 95: {
                return this.getTimestampWithZone(n);
            }
            case 60: 
            case 61: {
                return this.getBytes(n);
            }
            case -11: {
                BinaryData binaryData = (BinaryData)this.getColumnValue(n);
                return BinaryUUIDType.getJavaUUID(binaryData);
            }
            case 14: {
                BinaryData binaryData = (BinaryData)this.getColumnValue(n);
                if (this.wasNull()) {
                    return null;
                }
                byte[] byArray = binaryData.getBytes();
                if (byArray.length == 0) {
                    return false;
                }
                return byArray[0] == 0 ? Boolean.FALSE : Boolean.TRUE;
            }
            case 40: {
                return this.getClob(n);
            }
            case 30: {
                return this.getBlob(n);
            }
            case 1111: 
            case 2000: {
                Object object = this.getColumnInType(n, type);
                if (object == null) {
                    return null;
                }
                try {
                    return ((JavaObjectData)object).getObject();
                }
                catch (HsqlException hsqlException) {
                    throw JDBCUtil.sqlException(hsqlException);
                }
            }
        }
        return this.getColumnInType(n, type);
    }

    @Override
    public Object getObject(String string) throws SQLException {
        return this.getObject(this.findColumn(string));
    }

    @Override
    public int findColumn(String string) throws SQLException {
        int n;
        int n2;
        this.checkClosed();
        if (string == null) {
            throw JDBCUtil.nullArgument();
        }
        if (this.columnMap != null && (n2 = this.columnMap.get((Object)string, -1)) != -1) {
            return n2;
        }
        String[] stringArray = this.resultMetaData.columnLabels;
        n2 = -1;
        for (int i = 0; i < this.columnCount; ++i) {
            if (!string.equalsIgnoreCase(stringArray[i])) continue;
            n2 = i;
            break;
        }
        ColumnBase[] columnBaseArray = this.resultMetaData.columns;
        if (n2 < 0) {
            for (n = 0; n < this.columnCount; ++n) {
                if (!string.equalsIgnoreCase(columnBaseArray[n].getNameString())) continue;
                n2 = n;
                break;
            }
        }
        if (n2 < 0) {
            n = string.indexOf(46);
            if (n < 0) {
                throw JDBCUtil.sqlException(421, string);
            }
            for (int i = 0; i < this.columnCount; ++i) {
                String string2;
                String string3 = columnBaseArray[i].getTableNameString();
                if (string3 == null || string3.length() == 0) continue;
                String string4 = columnBaseArray[i].getNameString();
                if (string.equalsIgnoreCase(string3 + '.' + string4)) {
                    n2 = i;
                    break;
                }
                String string5 = columnBaseArray[i].getSchemaNameString();
                if (string5 == null || string5.length() == 0 || !string.equalsIgnoreCase(string2 = string5 + '.' + string3 + '.' + string4)) continue;
                n2 = i;
                break;
            }
        }
        if (n2 < 0) {
            throw JDBCUtil.sqlException(421, string);
        }
        ++n2;
        if (this.columnMap == null) {
            this.columnMap = new IntValueHashMap();
        }
        this.columnMap.put(string, n2);
        return n2;
    }

    @Override
    public Reader getCharacterStream(int n) throws SQLException {
        this.checkColumn(n);
        Type type = this.resultMetaData.columnTypes[n - 1];
        Object object = this.getColumnInType(n, type);
        if (object == null) {
            return null;
        }
        if (object instanceof ClobDataID) {
            return ((ClobDataID)object).getCharacterStream(this.session);
        }
        if (object instanceof Clob) {
            return ((Clob)object).getCharacterStream();
        }
        if (object instanceof String) {
            return new StringReader((String)object);
        }
        throw JDBCUtil.sqlException(5561);
    }

    @Override
    public Reader getCharacterStream(String string) throws SQLException {
        return this.getCharacterStream(this.findColumn(string));
    }

    @Override
    public BigDecimal getBigDecimal(int n) throws SQLException {
        this.checkColumn(n);
        Type type = this.resultMetaData.columnTypes[n - 1];
        switch (type.typeCode) {
            case 2: 
            case 3: {
                break;
            }
            case -6: 
            case 4: 
            case 5: 
            case 25: {
                type = Type.SQL_DECIMAL;
                break;
            }
            default: {
                type = Type.SQL_DECIMAL_DEFAULT;
            }
        }
        return (BigDecimal)this.getColumnInType(n, type);
    }

    @Override
    public BigDecimal getBigDecimal(String string) throws SQLException {
        return this.getBigDecimal(this.findColumn(string));
    }

    @Override
    public boolean isBeforeFirst() throws SQLException {
        this.checkClosed();
        if (this.isOnInsertRow) {
            return false;
        }
        return this.navigator.isBeforeFirst();
    }

    @Override
    public boolean isAfterLast() throws SQLException {
        this.checkClosed();
        if (this.isOnInsertRow) {
            return false;
        }
        return this.navigator.isAfterLast();
    }

    @Override
    public boolean isFirst() throws SQLException {
        this.checkClosed();
        if (this.isOnInsertRow) {
            return false;
        }
        return this.navigator.isFirst();
    }

    @Override
    public boolean isLast() throws SQLException {
        this.checkClosed();
        if (this.isOnInsertRow) {
            return false;
        }
        return this.navigator.isLast();
    }

    @Override
    public void beforeFirst() throws SQLException {
        this.checkClosed();
        this.checkNotForwardOnly();
        if (this.isOnInsertRow || this.isRowUpdated) {
            throw JDBCUtil.sqlExceptionSQL(3604);
        }
        this.navigator.beforeFirst();
    }

    @Override
    public void afterLast() throws SQLException {
        this.checkClosed();
        this.checkNotForwardOnly();
        if (this.isOnInsertRow || this.isRowUpdated) {
            throw JDBCUtil.sqlExceptionSQL(3604);
        }
        this.navigator.afterLast();
    }

    @Override
    public boolean first() throws SQLException {
        this.checkClosed();
        this.checkNotForwardOnly();
        if (this.isOnInsertRow || this.isRowUpdated) {
            throw JDBCUtil.sqlExceptionSQL(3604);
        }
        return this.navigator.first();
    }

    @Override
    public boolean last() throws SQLException {
        this.checkClosed();
        this.checkNotForwardOnly();
        if (this.isOnInsertRow || this.isRowUpdated) {
            throw JDBCUtil.sqlExceptionSQL(3604);
        }
        return this.navigator.last();
    }

    @Override
    public int getRow() throws SQLException {
        this.checkClosed();
        if (this.navigator.isAfterLast()) {
            return 0;
        }
        return this.navigator.getRowNumber() + 1;
    }

    @Override
    public boolean absolute(int n) throws SQLException {
        this.checkClosed();
        this.checkNotForwardOnly();
        if (this.isOnInsertRow || this.isRowUpdated) {
            throw JDBCUtil.sqlExceptionSQL(3604);
        }
        if (n > 0) {
            --n;
        } else {
            if (n == 0) {
                return this.navigator.beforeFirst();
            }
            if ((n += this.navigator.getSize()) < 0) {
                this.navigator.beforeFirst();
                return false;
            }
        }
        return this.navigator.absolute(n);
    }

    @Override
    public boolean relative(int n) throws SQLException {
        this.checkClosed();
        this.checkNotForwardOnly();
        if (this.isOnInsertRow || this.isRowUpdated) {
            throw JDBCUtil.sqlExceptionSQL(3604);
        }
        return this.navigator.relative(n);
    }

    @Override
    public boolean previous() throws SQLException {
        this.checkClosed();
        this.checkNotForwardOnly();
        if (this.isOnInsertRow || this.isRowUpdated) {
            throw JDBCUtil.sqlExceptionSQL(3604);
        }
        this.rootWarning = null;
        return this.navigator.previous();
    }

    @Override
    public void setFetchDirection(int n) throws SQLException {
        this.checkClosed();
        switch (n) {
            case 1000: {
                break;
            }
            case 1001: {
                this.checkNotForwardOnly();
                break;
            }
            case 1002: {
                this.checkNotForwardOnly();
                break;
            }
            default: {
                throw JDBCUtil.notSupported();
            }
        }
    }

    @Override
    public int getFetchDirection() throws SQLException {
        this.checkClosed();
        return 1000;
    }

    @Override
    public void setFetchSize(int n) throws SQLException {
        if (n < 0) {
            throw JDBCUtil.outOfRangeArgument();
        }
    }

    @Override
    public int getFetchSize() throws SQLException {
        this.checkClosed();
        return this.fetchSize;
    }

    @Override
    public int getType() throws SQLException {
        this.checkClosed();
        return ResultProperties.getJDBCScrollability(this.rsProperties);
    }

    @Override
    public int getConcurrency() throws SQLException {
        this.checkClosed();
        return ResultProperties.getJDBCConcurrency(this.rsProperties);
    }

    @Override
    public boolean rowUpdated() throws SQLException {
        this.checkClosed();
        return this.isRowUpdated;
    }

    @Override
    public boolean rowInserted() throws SQLException {
        this.checkClosed();
        return false;
    }

    @Override
    public boolean rowDeleted() throws SQLException {
        this.checkClosed();
        return false;
    }

    @Override
    public void updateNull(int n) throws SQLException {
        this.startUpdate(n);
        this.preparedStatement.setParameter(n, null);
    }

    @Override
    public void updateBoolean(int n, boolean bl) throws SQLException {
        Boolean bl2 = bl ? Boolean.TRUE : Boolean.FALSE;
        this.startUpdate(n);
        this.preparedStatement.setParameter(n, bl2);
    }

    @Override
    public void updateByte(int n, byte by) throws SQLException {
        this.startUpdate(n);
        this.preparedStatement.setIntParameter(n, by);
    }

    @Override
    public void updateShort(int n, short s) throws SQLException {
        this.startUpdate(n);
        this.preparedStatement.setIntParameter(n, s);
    }

    @Override
    public void updateInt(int n, int n2) throws SQLException {
        this.startUpdate(n);
        this.preparedStatement.setIntParameter(n, n2);
    }

    @Override
    public void updateLong(int n, long l) throws SQLException {
        this.startUpdate(n);
        this.preparedStatement.setLongParameter(n, l);
    }

    @Override
    public void updateFloat(int n, float f) throws SQLException {
        Double d = f;
        this.startUpdate(n);
        this.preparedStatement.setParameter(n, d);
    }

    @Override
    public void updateDouble(int n, double d) throws SQLException {
        Double d2 = d;
        this.startUpdate(n);
        this.preparedStatement.setParameter(n, d2);
    }

    @Override
    public void updateBigDecimal(int n, BigDecimal bigDecimal) throws SQLException {
        this.startUpdate(n);
        this.preparedStatement.setParameter(n, bigDecimal);
    }

    @Override
    public void updateString(int n, String string) throws SQLException {
        this.startUpdate(n);
        this.preparedStatement.setParameter(n, string);
    }

    @Override
    public void updateBytes(int n, byte[] byArray) throws SQLException {
        this.startUpdate(n);
        this.preparedStatement.setParameter(n, byArray);
    }

    @Override
    public void updateDate(int n, Date date) throws SQLException {
        this.startUpdate(n);
        this.preparedStatement.setParameter(n, date);
    }

    @Override
    public void updateTime(int n, Time time) throws SQLException {
        this.startUpdate(n);
        this.preparedStatement.setParameter(n, time);
    }

    @Override
    public void updateTimestamp(int n, Timestamp timestamp) throws SQLException {
        this.startUpdate(n);
        this.preparedStatement.setParameter(n, timestamp);
    }

    @Override
    public void updateAsciiStream(int n, InputStream inputStream, int n2) throws SQLException {
        this.startUpdate(n);
        this.preparedStatement.setAsciiStream(n, inputStream, n2);
    }

    @Override
    public void updateBinaryStream(int n, InputStream inputStream, int n2) throws SQLException {
        this.startUpdate(n);
        this.preparedStatement.setBinaryStream(n, inputStream, n2);
    }

    @Override
    public void updateCharacterStream(int n, Reader reader, int n2) throws SQLException {
        this.startUpdate(n);
        this.preparedStatement.setCharacterStream(n, reader, n2);
    }

    @Override
    public void updateObject(int n, Object object, int n2) throws SQLException {
        this.startUpdate(n);
        this.preparedStatement.setObject(n, object, 0, n2);
    }

    @Override
    public void updateObject(int n, Object object) throws SQLException {
        this.startUpdate(n);
        this.preparedStatement.setParameter(n, object);
    }

    @Override
    public void updateNull(String string) throws SQLException {
        this.updateNull(this.findColumn(string));
    }

    @Override
    public void updateBoolean(String string, boolean bl) throws SQLException {
        this.updateBoolean(this.findColumn(string), bl);
    }

    @Override
    public void updateByte(String string, byte by) throws SQLException {
        this.updateByte(this.findColumn(string), by);
    }

    @Override
    public void updateShort(String string, short s) throws SQLException {
        this.updateShort(this.findColumn(string), s);
    }

    @Override
    public void updateInt(String string, int n) throws SQLException {
        this.updateInt(this.findColumn(string), n);
    }

    @Override
    public void updateLong(String string, long l) throws SQLException {
        this.updateLong(this.findColumn(string), l);
    }

    @Override
    public void updateFloat(String string, float f) throws SQLException {
        this.updateFloat(this.findColumn(string), f);
    }

    @Override
    public void updateDouble(String string, double d) throws SQLException {
        this.updateDouble(this.findColumn(string), d);
    }

    @Override
    public void updateBigDecimal(String string, BigDecimal bigDecimal) throws SQLException {
        this.updateBigDecimal(this.findColumn(string), bigDecimal);
    }

    @Override
    public void updateString(String string, String string2) throws SQLException {
        this.updateString(this.findColumn(string), string2);
    }

    @Override
    public void updateBytes(String string, byte[] byArray) throws SQLException {
        this.updateBytes(this.findColumn(string), byArray);
    }

    @Override
    public void updateDate(String string, Date date) throws SQLException {
        this.updateDate(this.findColumn(string), date);
    }

    @Override
    public void updateTime(String string, Time time) throws SQLException {
        this.updateTime(this.findColumn(string), time);
    }

    @Override
    public void updateTimestamp(String string, Timestamp timestamp) throws SQLException {
        this.updateTimestamp(this.findColumn(string), timestamp);
    }

    @Override
    public void updateAsciiStream(String string, InputStream inputStream, int n) throws SQLException {
        this.updateAsciiStream(this.findColumn(string), inputStream, n);
    }

    @Override
    public void updateBinaryStream(String string, InputStream inputStream, int n) throws SQLException {
        this.updateBinaryStream(this.findColumn(string), inputStream, n);
    }

    @Override
    public void updateCharacterStream(String string, Reader reader, int n) throws SQLException {
        this.updateCharacterStream(this.findColumn(string), reader, n);
    }

    @Override
    public void updateObject(String string, Object object, int n) throws SQLException {
        this.updateObject(this.findColumn(string), object, n);
    }

    @Override
    public void updateObject(String string, Object object) throws SQLException {
        this.updateObject(this.findColumn(string), object);
    }

    @Override
    public void insertRow() throws SQLException {
        this.performInsert();
    }

    @Override
    public void updateRow() throws SQLException {
        this.performUpdate();
    }

    @Override
    public void deleteRow() throws SQLException {
        this.performDelete();
    }

    @Override
    public void refreshRow() throws SQLException {
        this.clearUpdates();
    }

    @Override
    public void cancelRowUpdates() throws SQLException {
        this.clearUpdates();
    }

    @Override
    public void moveToInsertRow() throws SQLException {
        this.startInsert();
    }

    @Override
    public void moveToCurrentRow() throws SQLException {
        this.endInsert();
    }

    @Override
    public Statement getStatement() throws SQLException {
        this.checkClosed();
        return (Statement)((Object)this.statement);
    }

    public Object getObject(int n, Map map) throws SQLException {
        return this.getObject(n);
    }

    @Override
    public Ref getRef(int n) throws SQLException {
        throw JDBCUtil.notSupported();
    }

    @Override
    public Blob getBlob(int n) throws SQLException {
        this.checkColumn(n);
        Type type = this.resultMetaData.columnTypes[n - 1];
        Object object = this.getColumnInType(n, type);
        if (object == null) {
            return null;
        }
        if (object instanceof BlobDataID) {
            if (this.memoryLobs) {
                long l = ((BlobDataID)object).length(this.session);
                if (l > Integer.MAX_VALUE) {
                    throw JDBCUtil.sqlException(3401);
                }
                byte[] byArray = ((BlobDataID)object).getBytes(this.session, 0L, (int)l);
                JDBCBlob jDBCBlob = new JDBCBlob(byArray);
                return jDBCBlob;
            }
            JDBCBlobClient jDBCBlobClient = new JDBCBlobClient(this.session, (BlobDataID)object);
            if (this.isUpdatable && this.resultMetaData.colIndexes[n - 1] > 0 && this.resultMetaData.columns[n - 1].isWriteable()) {
                jDBCBlobClient.setWritable(this, n - 1);
            }
            return jDBCBlobClient;
        }
        if (object instanceof Blob) {
            return (Blob)object;
        }
        if (object instanceof BinaryData) {
            byte[] byArray = this.getBytes(n);
            return new JDBCBlob(byArray);
        }
        throw JDBCUtil.sqlException(5561);
    }

    @Override
    public Clob getClob(int n) throws SQLException {
        this.checkColumn(n);
        Type type = this.resultMetaData.columnTypes[n - 1];
        Object object = this.getColumnInType(n, type);
        if (object == null) {
            return null;
        }
        if (object instanceof ClobDataID) {
            if (this.memoryLobs) {
                long l = ((ClobDataID)object).length(this.session);
                if (l > Integer.MAX_VALUE) {
                    throw JDBCUtil.sqlException(3401);
                }
                String string = ((ClobDataID)object).getSubString(this.session, 0L, (int)l);
                JDBCClob jDBCClob = new JDBCClob(string);
                return jDBCClob;
            }
            JDBCClobClient jDBCClobClient = new JDBCClobClient(this.session, (ClobDataID)object);
            if (this.isUpdatable && this.resultMetaData.colIndexes[n - 1] > 0 && this.resultMetaData.columns[n - 1].isWriteable()) {
                jDBCClobClient.setWritable(this, n - 1);
            }
            return jDBCClobClient;
        }
        if (object instanceof Clob) {
            return (Clob)object;
        }
        if (object instanceof String) {
            return new JDBCClob((String)object);
        }
        throw JDBCUtil.sqlException(5561);
    }

    @Override
    public Array getArray(int n) throws SQLException {
        this.checkColumn(n);
        Type type = this.resultMetaData.columnTypes[n - 1];
        Object[] objectArray = (Object[])this.getCurrent()[n - 1];
        if (!type.isArrayType()) {
            throw JDBCUtil.sqlException(5561);
        }
        if (this.trackNull(objectArray)) {
            return null;
        }
        return new JDBCArray(objectArray, type.collectionBaseType(), type, this.connection);
    }

    public Object getObject(String string, Map map) throws SQLException {
        return this.getObject(this.findColumn(string), map);
    }

    @Override
    public Ref getRef(String string) throws SQLException {
        return this.getRef(this.findColumn(string));
    }

    @Override
    public Blob getBlob(String string) throws SQLException {
        return this.getBlob(this.findColumn(string));
    }

    @Override
    public Clob getClob(String string) throws SQLException {
        return this.getClob(this.findColumn(string));
    }

    @Override
    public Array getArray(String string) throws SQLException {
        return this.getArray(this.findColumn(string));
    }

    @Override
    public Date getDate(int n, Calendar calendar) throws SQLException {
        TimestampData timestampData = (TimestampData)this.getColumnInType(n, Type.SQL_DATE);
        if (timestampData == null) {
            return null;
        }
        long l = timestampData.getSeconds() * 1000L;
        if (calendar != null) {
            l = HsqlDateTime.convertMillisToCalendar(calendar, l);
        }
        return new Date(l);
    }

    @Override
    public Date getDate(String string, Calendar calendar) throws SQLException {
        return this.getDate(this.findColumn(string), calendar);
    }

    @Override
    public Time getTime(int n, Calendar calendar) throws SQLException {
        TimeData timeData = (TimeData)this.getColumnInType(n, Type.SQL_TIME);
        if (timeData == null) {
            return null;
        }
        long l = (long)DateTimeType.normaliseTime(timeData.getSeconds()) * 1000L;
        if (!this.resultMetaData.columnTypes[--n].isDateTimeTypeWithZone()) {
            Calendar calendar2 = calendar == null ? this.session.getCalendar() : calendar;
            l = HsqlDateTime.convertMillisToCalendar(calendar2, l);
            l = HsqlDateTime.getNormalisedTime(l);
        }
        return new Time(l);
    }

    @Override
    public Time getTime(String string, Calendar calendar) throws SQLException {
        return this.getTime(this.findColumn(string), calendar);
    }

    @Override
    public Timestamp getTimestamp(int n, Calendar calendar) throws SQLException {
        Comparable<Calendar> comparable;
        TimestampData timestampData = (TimestampData)this.getColumnInType(n, Type.SQL_TIMESTAMP);
        if (timestampData == null) {
            return null;
        }
        long l = timestampData.getSeconds() * 1000L;
        if (!this.resultMetaData.columnTypes[--n].isDateTimeTypeWithZone()) {
            Comparable<Calendar> comparable2 = comparable = calendar == null ? this.session.getCalendar() : calendar;
            if (calendar != null) {
                l = HsqlDateTime.convertMillisToCalendar((Calendar)comparable, l);
            }
        }
        comparable = new Timestamp(l);
        ((Timestamp)comparable).setNanos(timestampData.getNanos());
        return comparable;
    }

    @Override
    public Timestamp getTimestamp(String string, Calendar calendar) throws SQLException {
        return this.getTimestamp(this.findColumn(string), calendar);
    }

    @Override
    public URL getURL(int n) throws SQLException {
        throw JDBCUtil.notSupported();
    }

    @Override
    public URL getURL(String string) throws SQLException {
        throw JDBCUtil.notSupported();
    }

    @Override
    public void updateRef(int n, Ref ref) throws SQLException {
        throw JDBCUtil.notSupported();
    }

    @Override
    public void updateRef(String string, Ref ref) throws SQLException {
        throw JDBCUtil.notSupported();
    }

    @Override
    public void updateBlob(int n, Blob blob) throws SQLException {
        this.startUpdate(n);
        this.preparedStatement.setBlobParameter(n, blob);
    }

    @Override
    public void updateBlob(String string, Blob blob) throws SQLException {
        int n = this.findColumn(string);
        this.updateBlob(n, blob);
    }

    @Override
    public void updateClob(int n, Clob clob) throws SQLException {
        this.startUpdate(n);
        this.preparedStatement.setClobParameter(n, clob);
    }

    @Override
    public void updateClob(String string, Clob clob) throws SQLException {
        int n = this.findColumn(string);
        this.updateClob(n, clob);
    }

    @Override
    public void updateArray(int n, Array array) throws SQLException {
        this.startUpdate(n);
        this.preparedStatement.setParameter(n, array);
    }

    @Override
    public void updateArray(String string, Array array) throws SQLException {
        int n = this.findColumn(string);
        this.updateArray(n, array);
    }

    @Override
    public RowId getRowId(int n) throws SQLException {
        throw JDBCUtil.notSupported();
    }

    @Override
    public RowId getRowId(String string) throws SQLException {
        throw JDBCUtil.notSupported();
    }

    @Override
    public void updateRowId(int n, RowId rowId) throws SQLException {
        throw JDBCUtil.notSupported();
    }

    @Override
    public void updateRowId(String string, RowId rowId) throws SQLException {
        throw JDBCUtil.notSupported();
    }

    @Override
    public int getHoldability() throws SQLException {
        this.checkClosed();
        return ResultProperties.getJDBCHoldability(this.rsProperties);
    }

    @Override
    public boolean isClosed() throws SQLException {
        return this.navigator == null;
    }

    @Override
    public void updateNString(int n, String string) throws SQLException {
        this.updateString(n, string);
    }

    @Override
    public void updateNString(String string, String string2) throws SQLException {
        this.updateString(string, string2);
    }

    @Override
    public void updateNClob(int n, NClob nClob) throws SQLException {
        this.updateClob(n, (Clob)nClob);
    }

    @Override
    public void updateNClob(String string, NClob nClob) throws SQLException {
        this.updateClob(string, (Clob)nClob);
    }

    @Override
    public NClob getNClob(int n) throws SQLException {
        String string = this.getString(n);
        return string == null ? null : new JDBCNClob(string);
    }

    @Override
    public NClob getNClob(String string) throws SQLException {
        return this.getNClob(this.findColumn(string));
    }

    @Override
    public SQLXML getSQLXML(int n) throws SQLException {
        SQLXML sQLXML;
        this.checkColumn(n);
        int n2 = this.resultMetaData.columnTypes[n - 1].typeCode;
        switch (n2) {
            case 137: {
                Object object = this.getObject(n);
                if (object == null) {
                    sQLXML = null;
                    break;
                }
                if (object instanceof SQLXML) {
                    sQLXML = (SQLXML)object;
                    break;
                }
                throw JDBCUtil.notSupported();
            }
            case 40: {
                Clob clob = this.getClob(n);
                if (clob == null) {
                    sQLXML = null;
                    break;
                }
                sQLXML = new JDBCSQLXML(clob.getCharacterStream());
                break;
            }
            case 1: 
            case 12: {
                Reader reader = this.getCharacterStream(n);
                if (reader == null) {
                    sQLXML = null;
                    break;
                }
                sQLXML = new JDBCSQLXML(reader);
                break;
            }
            case -9: 
            case -8: {
                Reader reader = this.getNCharacterStream(n);
                if (reader == null) {
                    sQLXML = null;
                    break;
                }
                sQLXML = new JDBCSQLXML(reader);
                break;
            }
            case 30: {
                Blob blob = this.getBlob(n);
                if (blob == null) {
                    sQLXML = null;
                    break;
                }
                sQLXML = new JDBCSQLXML(blob.getBinaryStream());
                break;
            }
            case 60: 
            case 61: {
                InputStream inputStream = this.getBinaryStream(n);
                if (inputStream == null) {
                    sQLXML = null;
                    break;
                }
                sQLXML = new JDBCSQLXML(inputStream);
                break;
            }
            case 1111: 
            case 2000: {
                Object object = this.getObject(n);
                if (object == null) {
                    sQLXML = null;
                    break;
                }
                if (object instanceof SQLXML) {
                    sQLXML = (SQLXML)object;
                    break;
                }
                if (object instanceof String) {
                    sQLXML = new JDBCSQLXML((String)object);
                    break;
                }
                if (object instanceof byte[]) {
                    sQLXML = new JDBCSQLXML((byte[])object);
                    break;
                }
                if (object instanceof Blob) {
                    Blob blob = (Blob)object;
                    sQLXML = new JDBCSQLXML(blob.getBinaryStream());
                    break;
                }
                if (object instanceof Clob) {
                    Clob clob = (Clob)object;
                    sQLXML = new JDBCSQLXML(clob.getCharacterStream());
                    break;
                }
                throw JDBCUtil.notSupported();
            }
            default: {
                throw JDBCUtil.notSupported();
            }
        }
        return sQLXML;
    }

    @Override
    public SQLXML getSQLXML(String string) throws SQLException {
        return this.getSQLXML(this.findColumn(string));
    }

    @Override
    public void updateSQLXML(int n, SQLXML sQLXML) throws SQLException {
        this.startUpdate(n);
        this.preparedStatement.setSQLXML(n, sQLXML);
    }

    @Override
    public void updateSQLXML(String string, SQLXML sQLXML) throws SQLException {
        this.updateSQLXML(this.findColumn(string), sQLXML);
    }

    @Override
    public String getNString(int n) throws SQLException {
        return this.getString(n);
    }

    @Override
    public String getNString(String string) throws SQLException {
        return this.getString(this.findColumn(string));
    }

    @Override
    public Reader getNCharacterStream(int n) throws SQLException {
        return this.getCharacterStream(n);
    }

    @Override
    public Reader getNCharacterStream(String string) throws SQLException {
        return this.getCharacterStream(this.findColumn(string));
    }

    @Override
    public void updateNCharacterStream(int n, Reader reader, long l) throws SQLException {
        this.startUpdate(n);
        this.preparedStatement.setCharacterStream(n, reader, l);
    }

    @Override
    public void updateNCharacterStream(String string, Reader reader, long l) throws SQLException {
        this.updateCharacterStream(string, reader, l);
    }

    @Override
    public void updateAsciiStream(int n, InputStream inputStream, long l) throws SQLException {
        this.startUpdate(n);
        this.preparedStatement.setAsciiStream(n, inputStream, l);
    }

    @Override
    public void updateBinaryStream(int n, InputStream inputStream, long l) throws SQLException {
        this.startUpdate(n);
        this.preparedStatement.setBinaryStream(n, inputStream, l);
    }

    @Override
    public void updateCharacterStream(int n, Reader reader, long l) throws SQLException {
        this.startUpdate(n);
        this.preparedStatement.setCharacterStream(n, reader, l);
    }

    @Override
    public void updateAsciiStream(String string, InputStream inputStream, long l) throws SQLException {
        int n = this.findColumn(string);
        this.startUpdate(n);
        this.preparedStatement.setAsciiStream(n, inputStream, l);
    }

    @Override
    public void updateBinaryStream(String string, InputStream inputStream, long l) throws SQLException {
        int n = this.findColumn(string);
        this.startUpdate(n);
        this.preparedStatement.setBinaryStream(n, inputStream, l);
    }

    @Override
    public void updateCharacterStream(String string, Reader reader, long l) throws SQLException {
        int n = this.findColumn(string);
        this.startUpdate(n);
        this.preparedStatement.setCharacterStream(n, reader, l);
    }

    @Override
    public void updateBlob(int n, InputStream inputStream, long l) throws SQLException {
        this.startUpdate(n);
        this.preparedStatement.setBlob(n, inputStream, l);
    }

    @Override
    public void updateBlob(String string, InputStream inputStream, long l) throws SQLException {
        int n = this.findColumn(string);
        this.startUpdate(n);
        this.preparedStatement.setBlob(n, inputStream, l);
    }

    @Override
    public void updateClob(int n, Reader reader, long l) throws SQLException {
        this.startUpdate(n);
        this.preparedStatement.setClob(n, reader, l);
    }

    @Override
    public void updateClob(String string, Reader reader, long l) throws SQLException {
        int n = this.findColumn(string);
        this.startUpdate(n);
        this.preparedStatement.setClob(n, reader, l);
    }

    @Override
    public void updateNClob(int n, Reader reader, long l) throws SQLException {
        this.startUpdate(n);
        this.preparedStatement.setClob(n, reader, l);
    }

    @Override
    public void updateNClob(String string, Reader reader, long l) throws SQLException {
        int n = this.findColumn(string);
        this.startUpdate(n);
        this.preparedStatement.setClob(n, reader, l);
    }

    @Override
    public void updateNCharacterStream(int n, Reader reader) throws SQLException {
        this.startUpdate(n);
        this.preparedStatement.setCharacterStream(n, reader);
    }

    @Override
    public void updateNCharacterStream(String string, Reader reader) throws SQLException {
        int n = this.findColumn(string);
        this.startUpdate(n);
        this.preparedStatement.setCharacterStream(n, reader);
    }

    @Override
    public void updateAsciiStream(int n, InputStream inputStream) throws SQLException {
        this.startUpdate(n);
        this.preparedStatement.setAsciiStream(n, inputStream);
    }

    @Override
    public void updateBinaryStream(int n, InputStream inputStream) throws SQLException {
        this.startUpdate(n);
        this.preparedStatement.setBinaryStream(n, inputStream);
    }

    @Override
    public void updateCharacterStream(int n, Reader reader) throws SQLException {
        this.startUpdate(n);
        this.preparedStatement.setCharacterStream(n, reader);
    }

    @Override
    public void updateAsciiStream(String string, InputStream inputStream) throws SQLException {
        int n = this.findColumn(string);
        this.startUpdate(n);
        this.preparedStatement.setAsciiStream(n, inputStream);
    }

    @Override
    public void updateBinaryStream(String string, InputStream inputStream) throws SQLException {
        int n = this.findColumn(string);
        this.startUpdate(n);
        this.preparedStatement.setBinaryStream(n, inputStream);
    }

    @Override
    public void updateCharacterStream(String string, Reader reader) throws SQLException {
        int n = this.findColumn(string);
        this.startUpdate(n);
        this.preparedStatement.setCharacterStream(n, reader);
    }

    @Override
    public void updateBlob(int n, InputStream inputStream) throws SQLException {
        this.startUpdate(n);
        this.preparedStatement.setBlob(n, inputStream);
    }

    @Override
    public void updateBlob(String string, InputStream inputStream) throws SQLException {
        int n = this.findColumn(string);
        this.startUpdate(n);
        this.preparedStatement.setBlob(n, inputStream);
    }

    @Override
    public void updateClob(int n, Reader reader) throws SQLException {
        this.startUpdate(n);
        this.preparedStatement.setClob(n, reader);
    }

    @Override
    public void updateClob(String string, Reader reader) throws SQLException {
        int n = this.findColumn(string);
        this.startUpdate(n);
        this.preparedStatement.setClob(n, reader);
    }

    @Override
    public void updateNClob(int n, Reader reader) throws SQLException {
        this.startUpdate(n);
        this.preparedStatement.setClob(n, reader);
    }

    @Override
    public void updateNClob(String string, Reader reader) throws SQLException {
        int n = this.findColumn(string);
        this.startUpdate(n);
        this.preparedStatement.setClob(n, reader);
    }

    @Override
    public <T> T unwrap(Class<T> clazz) throws SQLException {
        if (this.isWrapperFor(clazz)) {
            return (T)this;
        }
        throw JDBCUtil.invalidArgument("iface: " + clazz);
    }

    @Override
    public boolean isWrapperFor(Class<?> clazz) throws SQLException {
        return clazz != null && clazz.isAssignableFrom(this.getClass());
    }

    @Override
    public <T> T getObject(int n, Class<T> clazz) throws SQLException {
        if (clazz == null) {
            throw JDBCUtil.nullArgument();
        }
        Type type = Types.getParameterSQLType(clazz);
        if (type == null) {
            throw JDBCUtil.sqlException(5561);
        }
        Object object = this.getColumnValue(n);
        if (this.wasNullValue) {
            return null;
        }
        Object object2 = null;
        switch (clazz.getName()) {
            case "int": 
            case "java.lang.Integer": {
                object2 = this.getInt(n);
                break;
            }
            case "double": 
            case "java.lang.Double": {
                object2 = this.getDouble(n);
                break;
            }
            case "boolean": 
            case "java.lang.Boolean": {
                object2 = this.getBoolean(n);
                break;
            }
            case "byte": 
            case "java.lang.Byte": {
                object2 = this.getByte(n);
                break;
            }
            case "short": 
            case "java.lang.Short": {
                object2 = this.getShort(n);
                break;
            }
            case "long": 
            case "java.lang.Long": {
                object2 = this.getLong(n);
                break;
            }
            case "[B": {
                object2 = this.getBytes(n);
                break;
            }
            case "java.lang.Object": {
                object2 = this.getObject(n);
                break;
            }
            case "java.math.BigDecimal": {
                object2 = this.getBigDecimal(n);
                break;
            }
            case "java.sql.Blob": {
                object2 = this.getBlob(n);
                break;
            }
            case "java.sql.Clob": {
                object2 = this.getClob(n);
                break;
            }
            case "java.lang.String": 
            case "java.lang.CharSequence": {
                object2 = this.getString(n);
                break;
            }
            case "java.sql.Date": {
                object2 = this.getDate(n);
                break;
            }
            case "java.sql.Time": {
                object2 = this.getTime(n);
                break;
            }
            case "java.sql.Timestamp": {
                object2 = this.getTimestamp(n);
                break;
            }
            case "java.util.UUID": {
                object = this.getColumnInType(n, type);
                object2 = Type.SQL_GUID.convertSQLToJava(this.session, object);
                break;
            }
            case "java.time.LocalDate": {
                object = this.getColumnInType(n, type);
                TimestampData timestampData = (TimestampData)object;
                long l = timestampData.getMillis();
                Calendar calendar = this.session.getCalendarGMT();
                calendar.setTimeInMillis(l);
                object2 = LocalDate.of(calendar.get(1), calendar.get(2) + 1, calendar.get(5));
                break;
            }
            case "java.time.LocalTime": {
                object = this.getColumnInType(n, type);
                TimeData timeData = (TimeData)object;
                object2 = LocalTime.ofNanoOfDay((long)timeData.getSeconds() * 1000000000L + (long)timeData.getNanos());
                break;
            }
            case "java.time.LocalDateTime": {
                object = this.getColumnInType(n, type);
                TimestampData timestampData = (TimestampData)object;
                object2 = LocalDateTime.ofEpochSecond(timestampData.getSeconds(), timestampData.getNanos(), ZoneOffset.UTC);
                break;
            }
            case "java.time.OffsetTime": {
                object2 = this.getTimeWithZone(n);
                break;
            }
            case "java.time.OffsetDateTime": {
                object2 = this.getTimestampWithZone(n);
                break;
            }
            case "java.time.Duration": {
                Type type2 = this.resultMetaData.columnTypes[n - 1];
                if (!type2.isIntervalDaySecondType()) break;
                object = this.getColumnValue(n);
                IntervalSecondData intervalSecondData = (IntervalSecondData)object;
                object2 = Duration.ofSeconds(intervalSecondData.getSeconds(), intervalSecondData.getNanos());
                break;
            }
            case "java.time.Period": {
                Type type3 = this.resultMetaData.columnTypes[n - 1];
                if (!type3.isIntervalYearMonthType()) break;
                object = this.getColumnValue(n);
                IntervalMonthData intervalMonthData = (IntervalMonthData)object;
                int n2 = intervalMonthData.getMonths();
                if (type3.typeCode == 102) {
                    object2 = Period.ofMonths(n2);
                    break;
                }
                object2 = Period.of(n2 / 12, n2 % 12, 0);
                break;
            }
            case "java.sql.Array": {
                object2 = this.getArray(n);
            }
        }
        if (object2 == null) {
            throw JDBCUtil.sqlException(5561);
        }
        return (T)object2;
    }

    @Override
    public <T> T getObject(String string, Class<T> clazz) throws SQLException {
        return this.getObject(this.findColumn(string), clazz);
    }

    @Override
    public void updateObject(int n, Object object, SQLType sQLType, int n2) throws SQLException {
        this.startUpdate(n);
        this.preparedStatement.setObject(n, object, sQLType, n2);
    }

    @Override
    public void updateObject(String string, Object object, SQLType sQLType, int n) throws SQLException {
        this.updateObject(this.findColumn(string), object, sQLType, n);
    }

    @Override
    public void updateObject(int n, Object object, SQLType sQLType) throws SQLException {
        this.preparedStatement.setObject(n, object, sQLType);
    }

    @Override
    public void updateObject(String string, Object object, SQLType sQLType) throws SQLException {
        this.updateObject(this.findColumn(string), object, sQLType);
    }

    private Object getTimestampWithZone(int n) throws SQLException {
        TimestampData timestampData = (TimestampData)this.getColumnInType(n, Type.SQL_TIMESTAMP_WITH_TIME_ZONE);
        if (timestampData == null) {
            return null;
        }
        ZoneOffset zoneOffset = ZoneOffset.ofTotalSeconds(timestampData.getZone());
        LocalDateTime localDateTime = LocalDateTime.ofEpochSecond(timestampData.getSeconds(), timestampData.getNanos(), zoneOffset);
        return OffsetDateTime.of(localDateTime, zoneOffset);
    }

    private Object getTimeWithZone(int n) throws SQLException {
        TimeData timeData = (TimeData)this.getColumnInType(n, Type.SQL_TIME_WITH_TIME_ZONE);
        if (timeData == null) {
            return null;
        }
        long l = timeData.getSeconds() + timeData.getZone();
        if (l < 0L) {
            l += 86400L;
        }
        ZoneOffset zoneOffset = ZoneOffset.ofTotalSeconds(timeData.getZone());
        LocalTime localTime = LocalTime.ofNanoOfDay((l %= 86400L) * 1000000000L + (long)timeData.getNanos());
        return OffsetTime.of(localTime, zoneOffset);
    }

    protected Object[] getCurrent() throws SQLException {
        RowSetNavigator rowSetNavigator = this.navigator;
        if (rowSetNavigator == null) {
            throw JDBCUtil.sqlException(3601);
        }
        if (rowSetNavigator.isEmpty()) {
            throw JDBCUtil.sqlException(3603, 70);
        }
        if (rowSetNavigator.isBeforeFirst()) {
            throw JDBCUtil.sqlException(3603, 71);
        }
        if (rowSetNavigator.isAfterLast()) {
            throw JDBCUtil.sqlException(3603, 72);
        }
        Object[] objectArray = rowSetNavigator.getCurrent();
        if (objectArray == null) {
            throw JDBCUtil.sqlException(3601);
        }
        return objectArray;
    }

    private void checkClosed() throws SQLException {
        if (this.navigator == null) {
            throw JDBCUtil.sqlException(3601);
        }
    }

    protected void checkColumn(int n) throws SQLException {
        if (this.navigator == null) {
            throw JDBCUtil.sqlException(3601);
        }
        if (n < 1 || n > this.columnCount) {
            throw JDBCUtil.sqlException(421, String.valueOf(n));
        }
    }

    protected boolean trackNull(Object object) {
        this.wasNullValue = object == null;
        return this.wasNullValue;
    }

    protected Object getColumnValue(int n) throws SQLException {
        Object[] objectArray = this.getCurrent();
        this.checkColumn(n);
        Object object = objectArray[n - 1];
        this.trackNull(object);
        return object;
    }

    protected Object getColumnInType(int n, Type type) throws SQLException {
        Object object = this.getColumnValue(n);
        if (object == null) {
            return null;
        }
        Type type2 = this.resultMetaData.columnTypes[n - 1];
        if (this.translateTTIType && type.isIntervalType()) {
            type = ((IntervalType)type).getCharacterType();
        }
        if (type2.typeCode != type.typeCode) {
            try {
                object = type.convertToTypeJDBC(this.session, object, type2);
            }
            catch (Exception exception) {
                String string = object instanceof Number || object instanceof String ? object.toString() : "instance of " + object.getClass().getName();
                String string2 = "from SQL type " + type2.getNameString() + " to " + type.getJDBCClassName() + ", value: " + string;
                throw JDBCUtil.sqlException(5561, string2);
            }
        }
        return object;
    }

    private void checkNotForwardOnly() throws SQLException {
        if (!this.isScrollable) {
            throw JDBCUtil.notSupported();
        }
    }

    private void checkUpdatable() throws SQLException {
        this.checkClosed();
        if (!this.isUpdatable) {
            throw JDBCUtil.notUpdatableColumn();
        }
    }

    private void checkUpdatable(int n) throws SQLException {
        this.checkClosed();
        this.checkColumn(n);
        if (!this.isUpdatable) {
            throw JDBCUtil.notUpdatableColumn();
        }
        if (this.resultMetaData.colIndexes[--n] == -1) {
            throw JDBCUtil.notUpdatableColumn();
        }
        if (!this.resultMetaData.columns[n].isWriteable()) {
            throw JDBCUtil.notUpdatableColumn();
        }
    }

    void startUpdate(int n) throws SQLException {
        this.checkUpdatable(n);
        if (this.currentUpdateRowNumber != this.navigator.getRowNumber()) {
            this.preparedStatement.clearParameters();
        }
        this.currentUpdateRowNumber = this.navigator.getRowNumber();
        this.isRowUpdated = true;
    }

    private void clearUpdates() throws SQLException {
        this.checkUpdatable();
        this.preparedStatement.clearParameters();
        this.isRowUpdated = false;
    }

    private void startInsert() throws SQLException {
        this.checkUpdatable();
        this.isOnInsertRow = true;
    }

    private void endInsert() throws SQLException {
        this.checkUpdatable();
        this.preparedStatement.clearParameters();
        this.isOnInsertRow = false;
    }

    private void performUpdate() throws SQLException {
        this.preparedStatement.parameterValues[this.columnCount] = this.getCurrent()[this.columnCount];
        for (int i = 0; i < this.columnCount; ++i) {
            boolean bl = this.preparedStatement.parameterSet[i] != null;
            this.preparedStatement.resultOut.metaData.columnTypes[i] = bl ? this.preparedStatement.parameterTypes[i] : Type.SQL_ALL_TYPES;
        }
        this.preparedStatement.resultOut.setActionType(91);
        this.preparedStatement.fetchResult();
        this.preparedStatement.clearParameters();
        this.rootWarning = this.preparedStatement.getWarnings();
        this.preparedStatement.clearWarnings();
        this.isRowUpdated = false;
    }

    private void performInsert() throws SQLException {
        this.checkUpdatable();
        for (int i = 0; i < this.columnCount; ++i) {
            boolean bl;
            boolean bl2 = bl = this.preparedStatement.parameterSet[i] != null;
            if (!bl) {
                throw JDBCUtil.sqlException(3606);
            }
            this.preparedStatement.resultOut.metaData.columnTypes[i] = this.preparedStatement.parameterTypes[i];
        }
        this.preparedStatement.resultOut.setActionType(55);
        this.preparedStatement.fetchResult();
        this.preparedStatement.clearParameters();
        this.rootWarning = this.preparedStatement.getWarnings();
        this.preparedStatement.clearWarnings();
    }

    private void performDelete() throws SQLException {
        this.checkUpdatable();
        this.preparedStatement.parameterValues[this.columnCount] = this.getCurrent()[this.columnCount];
        this.preparedStatement.resultOut.metaData.columnTypes[this.columnCount] = this.resultMetaData.columnTypes[this.columnCount];
        this.preparedStatement.resultOut.setActionType(18);
        this.preparedStatement.fetchResult();
        this.preparedStatement.clearParameters();
        this.rootWarning = this.preparedStatement.getWarnings();
        this.preparedStatement.clearWarnings();
    }

    RowSetNavigator getNavigator() {
        return this.navigator;
    }

    void setNavigator(RowSetNavigator rowSetNavigator) {
        this.navigator = rowSetNavigator;
    }

    public JDBCResultSet(JDBCConnection jDBCConnection, JDBCStatementBase jDBCStatementBase, Result result, ResultMetaData resultMetaData) {
        this(jDBCConnection, result, resultMetaData);
        this.statement = jDBCStatementBase;
        this.isScrollable = ResultProperties.isScrollable(this.rsProperties);
        if (ResultProperties.isUpdatable(this.rsProperties)) {
            this.isUpdatable = true;
            this.isInsertable = true;
            for (int i = 0; i < resultMetaData.colIndexes.length; ++i) {
                if (resultMetaData.colIndexes[i] >= 0) continue;
                this.isInsertable = false;
                break;
            }
            this.preparedStatement = new JDBCPreparedStatement(jDBCStatementBase.connection, this.result);
        }
    }

    public JDBCResultSet(JDBCConnection jDBCConnection, Result result, ResultMetaData resultMetaData) {
        this.session = jDBCConnection == null ? null : jDBCConnection.sessionProxy;
        this.result = result;
        this.connection = jDBCConnection;
        this.rsProperties = result.rsProperties;
        this.navigator = result.getNavigator();
        this.resultMetaData = resultMetaData;
        this.columnCount = this.resultMetaData.getColumnCount();
        if (jDBCConnection != null) {
            this.translateTTIType = jDBCConnection.isTranslateTTIType;
            if (jDBCConnection.connProperties != null) {
                this.memoryLobs = jDBCConnection.connProperties.isPropertyTrue("memory_lobs", false);
            }
        }
    }

    public static JDBCResultSet newJDBCResultSet(Result result, ResultMetaData resultMetaData) {
        return new JDBCResultSetBasic(result, resultMetaData);
    }

    public static JDBCResultSet newEmptyResultSet() {
        ResultMetaData resultMetaData = ResultMetaData.newResultMetaData(1);
        ColumnBase columnBase = new ColumnBase(null, null, null, "C1");
        columnBase.setType(Type.SQL_INTEGER);
        resultMetaData.columnTypes[0] = Type.SQL_INTEGER;
        resultMetaData.columns[0] = columnBase;
        Result result = Result.newSingleColumnResult(resultMetaData);
        return JDBCResultSet.newJDBCResultSet(result, resultMetaData);
    }

    static class JDBCResultSetBasic
    extends JDBCResultSet {
        JDBCResultSetBasic(Result result, ResultMetaData resultMetaData) {
            super(null, result, resultMetaData);
        }

        @Override
        protected Object getColumnInType(int n, Type type) throws SQLException {
            Object[] objectArray = this.getCurrent();
            this.checkColumn(n);
            Type type2 = this.resultMetaData.columnTypes[--n];
            Object object = objectArray[n];
            if (this.trackNull(object)) {
                return null;
            }
            if (type2.typeCode != type.typeCode) {
                throw JDBCUtil.sqlException(5561);
            }
            return object;
        }

        @Override
        public Date getDate(int n) throws SQLException {
            return (Date)this.getColumnInType(n, Type.SQL_DATE);
        }

        @Override
        public Time getTime(int n) throws SQLException {
            return (Time)this.getColumnInType(n, Type.SQL_DATE);
        }

        @Override
        public Timestamp getTimestamp(int n) throws SQLException {
            return (Timestamp)this.getColumnInType(n, Type.SQL_DATE);
        }

        @Override
        public InputStream getBinaryStream(int n) throws SQLException {
            throw JDBCUtil.notSupported();
        }

        @Override
        public Reader getCharacterStream(int n) throws SQLException {
            throw JDBCUtil.notSupported();
        }

        @Override
        public Blob getBlob(int n) throws SQLException {
            this.checkColumn(n);
            Type type = this.resultMetaData.columnTypes[n - 1];
            Object object = this.getColumnInType(n, type);
            if (object == null) {
                return null;
            }
            if (object instanceof Blob) {
                return (Blob)object;
            }
            if (object instanceof byte[]) {
                return new JDBCBlob((byte[])object);
            }
            throw JDBCUtil.sqlException(5561);
        }

        @Override
        public Clob getClob(int n) throws SQLException {
            this.checkColumn(n);
            Type type = this.resultMetaData.columnTypes[n - 1];
            Object object = this.getColumnInType(n, type);
            if (object == null) {
                return null;
            }
            if (object instanceof Clob) {
                return (Clob)object;
            }
            if (object instanceof String) {
                return new JDBCClob((String)object);
            }
            throw JDBCUtil.sqlException(5561);
        }

        @Override
        public Time getTime(int n, Calendar calendar) throws SQLException {
            throw JDBCUtil.notSupported();
        }

        @Override
        public Timestamp getTimestamp(int n, Calendar calendar) throws SQLException {
            throw JDBCUtil.notSupported();
        }
    }
}

