/*
 * Decompiled with CFR 0.152.
 */
package org.zaproxy.zap.extension.ascan;

import java.util.ArrayList;
import java.util.List;
import javax.swing.ImageIcon;
import javax.swing.SwingUtilities;
import org.apache.log4j.Logger;
import org.parosproxy.paros.Constant;
import org.parosproxy.paros.control.Control;
import org.parosproxy.paros.core.scanner.Alert;
import org.parosproxy.paros.core.scanner.HostProcess;
import org.parosproxy.paros.core.scanner.Scanner;
import org.parosproxy.paros.core.scanner.ScannerListener;
import org.parosproxy.paros.model.Model;
import org.parosproxy.paros.model.Session;
import org.parosproxy.paros.model.SiteMapEventPublisher;
import org.parosproxy.paros.model.SiteNode;
import org.parosproxy.paros.network.HttpMessage;
import org.parosproxy.paros.view.View;
import org.zaproxy.zap.ZAP;
import org.zaproxy.zap.eventBus.Event;
import org.zaproxy.zap.eventBus.EventConsumer;
import org.zaproxy.zap.extension.alert.ExtensionAlert;
import org.zaproxy.zap.extension.ascan.AttackScan;
import org.zaproxy.zap.extension.ascan.ExtensionActiveScan;
import org.zaproxy.zap.extension.log4j.ExtensionLog4j;
import org.zaproxy.zap.extension.ruleconfig.ExtensionRuleConfig;
import org.zaproxy.zap.extension.ruleconfig.RuleConfigParam;
import org.zaproxy.zap.model.Context;
import org.zaproxy.zap.view.ScanStatus;

public class AttackModeScanner
implements EventConsumer {
    private static final String ATTACK_ICON_RESOURCE = "/resource/icon/16/093.png";
    private ExtensionActiveScan extension;
    private long lastUpdated;
    private ScanStatus scanStatus;
    private ExtensionAlert extAlert = null;
    private AttackModeThread attackModeThread = null;
    private boolean rescanOnChange = false;
    private Logger log = Logger.getLogger(AttackModeScanner.class);
    private List<SiteNode> nodeStack = new ArrayList<SiteNode>();

    public AttackModeScanner(ExtensionActiveScan extension) {
        this.extension = extension;
        ZAP.getEventBus().registerConsumer(this, SiteMapEventPublisher.class.getCanonicalName());
        if (extension.getView() != null) {
            this.lastUpdated = System.currentTimeMillis();
            this.scanStatus = new ScanStatus(new ImageIcon(ExtensionLog4j.class.getResource("/resource/icon/fugue/target.png")), Constant.messages.getString("ascan.attack.icon.title"));
        }
    }

    public void start() {
        this.log.debug((Object)"Starting");
        this.nodeStack.clear();
        this.addAllInScope();
        if (this.attackModeThread != null) {
            this.attackModeThread.shutdown();
        }
        this.attackModeThread = new AttackModeThread();
        Thread t = new Thread((Runnable)this.attackModeThread, "ZAP-AttackMode");
        t.setDaemon(true);
        t.start();
    }

    private void addAllInScope() {
        if (this.rescanOnChange) {
            this.nodeStack.addAll(Model.getSingleton().getSession().getNodesInScopeFromSiteTree());
            this.log.debug((Object)("Added existing in scope nodes to attack mode stack " + this.nodeStack.size()));
            this.updateCount();
        }
    }

    public void stop() {
        this.log.debug((Object)"Stopping");
        if (this.attackModeThread != null) {
            this.attackModeThread.shutdown();
        }
        this.nodeStack.clear();
        this.updateCount();
    }

    @Override
    public void eventReceived(Event event) {
        if (this.attackModeThread != null && this.attackModeThread.isRunning()) {
            if (event.getEventType().equals("siteNode.added") && event.getTarget().getStartNode().isIncludedInScope()) {
                if (event.getTarget().getStartNode().getHistoryReference().getHistoryType() != 0) {
                    this.log.debug((Object)("Adding node to attack mode stack " + event.getTarget().getStartNode()));
                    this.nodeStack.add(event.getTarget().getStartNode());
                    this.updateCount();
                }
            } else if (event.getEventType().equals("siteNode.removed") && this.nodeStack.contains(event.getTarget().getStartNode())) {
                this.nodeStack.remove(event.getTarget().getStartNode());
            }
        }
    }

    public ScanStatus getScanStatus() {
        return this.scanStatus;
    }

    public void sessionScopeChanged(Session session) {
        this.addAllInScope();
    }

    public void sessionModeChanged(Control.Mode mode) {
        if (mode.equals((Object)Control.Mode.attack)) {
            if (View.isInitialised() && View.getSingleton().isCanGetFocus() && this.extension.getScannerParam().isPromptInAttackMode()) {
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        boolean anyInScope = false;
                        for (Context ctx : Model.getSingleton().getSession().getContexts()) {
                            if (!ctx.isInScope() || ctx.getIncludeInContextRegexs() == null || ctx.getIncludeInContextRegexs().isEmpty()) continue;
                            anyInScope = true;
                            break;
                        }
                        String promptMsg = anyInScope ? Constant.messages.getString("ascan.attack.prompt") : Constant.messages.getString("ascan.attack.prompt") + Constant.messages.getString("ascan.attack.prompt.no.scope", Constant.messages.getString("view.toolbar.mode.attack.select"));
                        int res = View.getSingleton().showYesNoRememberDialog(View.getSingleton().getMainFrame(), promptMsg);
                        if (View.getSingleton().isRememberLastDialogChosen()) {
                            AttackModeScanner.this.extension.getScannerParam().setPromptInAttackMode(false);
                            AttackModeScanner.this.extension.getScannerParam().setRescanInAttackMode(res == 0);
                        }
                        AttackModeScanner.this.rescanOnChange = res == 0;
                        AttackModeScanner.this.start();
                    }
                });
            } else {
                this.rescanOnChange = this.extension.getScannerParam().isRescanInAttackMode();
                this.start();
            }
        } else {
            this.stop();
        }
    }

    private void updateCount() {
        if (this.scanStatus == null) {
            return;
        }
        long now = System.currentTimeMillis();
        if (now - this.lastUpdated > 200L) {
            this.lastUpdated = now;
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    AttackModeScanner.this.scanStatus.setScanCount(AttackModeScanner.this.nodeStack.size());
                }
            });
        }
    }

    public int getStackSize() {
        int count = this.nodeStack.size();
        if (count > 0) {
            return count;
        }
        if (this.attackModeThread != null && this.attackModeThread.isActive()) {
            return 0;
        }
        return -1;
    }

    public boolean isRescanOnChange() {
        return this.rescanOnChange;
    }

    public void setRescanOnChange(boolean rescanOnChange) {
        this.rescanOnChange = rescanOnChange;
    }

    private ExtensionAlert getExtensionAlert() {
        if (this.extAlert == null) {
            this.extAlert = Control.getSingleton().getExtensionLoader().getExtension(ExtensionAlert.class);
        }
        return this.extAlert;
    }

    static interface AttackModeScannerThread {
        public boolean isRunning();

        public boolean isActive();
    }

    private class AttackModeThread
    implements Runnable,
    ScannerListener,
    AttackModeScannerThread {
        private int scannerCount = 4;
        private List<Scanner> scanners = new ArrayList<Scanner>();
        private AttackScan ascanWrapper;
        private boolean running = false;

        private AttackModeThread() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            AttackModeScanner.this.log.debug((Object)"Starting attack thread");
            this.running = true;
            RuleConfigParam ruleConfigParam = null;
            ExtensionRuleConfig extRC = Control.getSingleton().getExtensionLoader().getExtension(ExtensionRuleConfig.class);
            if (extRC != null) {
                ruleConfigParam = extRC.getRuleConfigParam();
            }
            this.ascanWrapper = new AttackScan(Constant.messages.getString("ascan.attack.scan"), AttackModeScanner.this.extension.getScannerParam(), AttackModeScanner.this.extension.getModel().getOptionsParam().getConnectionParam(), AttackModeScanner.this.extension.getPolicyManager().getAttackScanPolicy(), ruleConfigParam, this);
            AttackModeScanner.this.extension.registerScan(this.ascanWrapper);
            while (this.running) {
                if (AttackModeScanner.this.scanStatus != null && AttackModeScanner.this.scanStatus.getScanCount() != AttackModeScanner.this.nodeStack.size()) {
                    AttackModeScanner.this.updateCount();
                }
                if (AttackModeScanner.this.nodeStack.size() == 0 || this.scanners.size() == this.scannerCount) {
                    if (this.scanners.size() > 0) {
                        this.scannerComplete(-1);
                    }
                    try {
                        Thread.sleep(500L);
                    }
                    catch (InterruptedException interruptedException) {}
                    continue;
                }
                while (AttackModeScanner.this.nodeStack.size() > 0 && this.scanners.size() < this.scannerCount) {
                    SiteNode node = (SiteNode)AttackModeScanner.this.nodeStack.remove(0);
                    AttackModeScanner.this.log.debug((Object)("Attacking node " + node.getNodeName()));
                    Scanner scanner = new Scanner(AttackModeScanner.this.extension.getScannerParam(), AttackModeScanner.this.extension.getModel().getOptionsParam().getConnectionParam(), AttackModeScanner.this.extension.getPolicyManager().getAttackScanPolicy(), ruleConfigParam);
                    scanner.setStartNode(node);
                    scanner.setScanChildren(false);
                    scanner.addScannerListener(this);
                    List<Scanner> list = this.scanners;
                    synchronized (list) {
                        this.scanners.add(scanner);
                    }
                    if (View.isInitialised()) {
                        node.addCustomIcon(AttackModeScanner.ATTACK_ICON_RESOURCE, false);
                    }
                    scanner.start(node);
                }
            }
            List<Scanner> list = this.scanners;
            synchronized (list) {
                for (Scanner scanner : this.scanners) {
                    scanner.stop();
                }
            }
            AttackModeScanner.this.log.debug((Object)"Attack thread finished");
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void scannerComplete(int id) {
            ArrayList<Scanner> stoppedScanners = new ArrayList<Scanner>();
            List<Scanner> list = this.scanners;
            synchronized (list) {
                for (Scanner scanner : this.scanners) {
                    if (!scanner.isStop()) continue;
                    SiteNode node = scanner.getStartNode();
                    if (node != null) {
                        AttackModeScanner.this.log.debug((Object)("Finished attacking node " + node.getNodeName()));
                        if (View.isInitialised()) {
                            node.removeCustomIcon(AttackModeScanner.ATTACK_ICON_RESOURCE);
                        }
                    }
                    stoppedScanners.add(scanner);
                }
                for (Scanner scanner : stoppedScanners) {
                    this.scanners.remove(scanner);
                }
            }
            AttackModeScanner.this.updateCount();
        }

        @Override
        public void hostNewScan(int id, String hostAndPort, HostProcess hostThread) {
        }

        @Override
        public void hostProgress(int id, String hostAndPort, String msg, int percentage) {
        }

        @Override
        public void hostComplete(int id, String hostAndPort) {
        }

        @Override
        public void alertFound(Alert alert) {
            alert.setSource(Alert.Source.ACTIVE);
            AttackModeScanner.this.getExtensionAlert().alertFound(alert, alert.getHistoryRef());
        }

        @Override
        public void notifyNewMessage(HttpMessage msg) {
            this.ascanWrapper.notifyNewMessage(msg);
        }

        public void shutdown() {
            this.running = false;
        }

        @Override
        public boolean isRunning() {
            return this.running;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean isActive() {
            List<Scanner> list = this.scanners;
            synchronized (list) {
                for (Scanner scanner : this.scanners) {
                    if (scanner.isStop()) continue;
                    return true;
                }
            }
            return false;
        }
    }
}

