/*
 * Decompiled with CFR 0.152.
 */
package org.zaproxy.zap.model;

import java.awt.EventQueue;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.LinkedList;
import java.util.List;
import java.util.regex.Pattern;
import javax.swing.tree.TreeNode;
import org.apache.log4j.Logger;
import org.parosproxy.paros.core.scanner.Alert;
import org.parosproxy.paros.model.HistoryReference;
import org.parosproxy.paros.model.Session;
import org.parosproxy.paros.model.SiteMap;
import org.parosproxy.paros.model.SiteNode;
import org.parosproxy.paros.view.View;
import org.zaproxy.zap.authentication.AuthenticationMethod;
import org.zaproxy.zap.authentication.ManualAuthenticationMethodType;
import org.zaproxy.zap.extension.authorization.AuthorizationDetectionMethod;
import org.zaproxy.zap.extension.authorization.BasicAuthorizationDetectionMethod;
import org.zaproxy.zap.model.IllegalContextNameException;
import org.zaproxy.zap.model.ParameterParser;
import org.zaproxy.zap.model.StandardParameterParser;
import org.zaproxy.zap.model.StructuralNode;
import org.zaproxy.zap.model.StructuralNodeModifier;
import org.zaproxy.zap.model.StructuralSiteNode;
import org.zaproxy.zap.model.Tech;
import org.zaproxy.zap.model.TechSet;
import org.zaproxy.zap.session.CookieBasedSessionManagementMethodType;
import org.zaproxy.zap.session.SessionManagementMethod;

public class Context {
    public static final String CONTEXT_CONFIG = "context";
    public static final String CONTEXT_CONFIG_NAME = "context.name";
    public static final String CONTEXT_CONFIG_DESC = "context.desc";
    public static final String CONTEXT_CONFIG_INSCOPE = "context.inscope";
    public static final String CONTEXT_CONFIG_INC_REGEXES = "context.incregexes";
    public static final String CONTEXT_CONFIG_EXC_REGEXES = "context.excregexes";
    public static final String CONTEXT_CONFIG_TECH = "context.tech";
    public static final String CONTEXT_CONFIG_TECH_INCLUDE = "context.tech.include";
    public static final String CONTEXT_CONFIG_TECH_EXCLUDE = "context.tech.exclude";
    public static final String CONTEXT_CONFIG_URLPARSER = "context.urlparser";
    public static final String CONTEXT_CONFIG_URLPARSER_CLASS = "context.urlparser.class";
    public static final String CONTEXT_CONFIG_URLPARSER_CONFIG = "context.urlparser.config";
    public static final String CONTEXT_CONFIG_POSTPARSER = "context.postparser";
    public static final String CONTEXT_CONFIG_POSTPARSER_CLASS = "context.postparser.class";
    public static final String CONTEXT_CONFIG_POSTPARSER_CONFIG = "context.postparser.config";
    public static final String CONTEXT_CONFIG_DATA_DRIVEN_NODES = "context.ddns";
    private static Logger log = Logger.getLogger(Context.class);
    private Session session;
    private int id;
    private String name;
    private String description = "";
    private List<String> includeInRegexs = new ArrayList<String>();
    private List<String> excludeFromRegexs = new ArrayList<String>();
    private List<Pattern> includeInPatterns = new ArrayList<Pattern>();
    private List<Pattern> excludeFromPatterns = new ArrayList<Pattern>();
    private List<StructuralNodeModifier> dataDrivenNodes = new ArrayList<StructuralNodeModifier>();
    private AuthenticationMethod authenticationMethod = null;
    private SessionManagementMethod sessionManagementMethod;
    private AuthorizationDetectionMethod authorizationDetectionMethod;
    private TechSet techSet = new TechSet(Tech.builtInTech);
    private boolean inScope = true;
    private ParameterParser urlParamParser = new StandardParameterParser();
    private ParameterParser postParamParser = new StandardParameterParser();

    public Context(Session session, int id) {
        this.session = session;
        this.id = id;
        this.name = String.valueOf(id);
        this.sessionManagementMethod = new CookieBasedSessionManagementMethodType.CookieBasedSessionManagementMethod(id);
        this.authenticationMethod = new ManualAuthenticationMethodType.ManualAuthenticationMethod(id);
        this.authorizationDetectionMethod = new BasicAuthorizationDetectionMethod(null, null, null, BasicAuthorizationDetectionMethod.LogicalOperator.AND);
        this.urlParamParser.setContext(this);
        this.postParamParser.setContext(this);
    }

    public boolean isIncludedInScope(SiteNode sn) {
        if (!this.inScope) {
            return false;
        }
        return this.isIncluded(sn);
    }

    public boolean isIncluded(SiteNode sn) {
        if (sn == null) {
            return false;
        }
        return this.isIncluded(sn.getHierarchicNodeName());
    }

    public boolean isIncluded(String url) {
        if (url == null) {
            return false;
        }
        if (url.indexOf("?") > 0) {
            url = url.substring(0, url.indexOf("?"));
        }
        for (Pattern p : this.includeInPatterns) {
            if (!p.matcher(url).matches()) continue;
            return true;
        }
        return false;
    }

    public boolean isExcludedFromScope(SiteNode sn) {
        if (!this.inScope) {
            return false;
        }
        return this.isExcluded(sn);
    }

    public boolean isExcluded(SiteNode sn) {
        if (sn == null) {
            return false;
        }
        return this.isExcluded(sn.getHierarchicNodeName());
    }

    public boolean isExcluded(String url) {
        if (url == null) {
            return false;
        }
        if (url.indexOf("?") > 0) {
            url = url.substring(0, url.indexOf("?"));
        }
        for (Pattern p : this.excludeFromPatterns) {
            if (!p.matcher(url).matches()) continue;
            return true;
        }
        return false;
    }

    public boolean isInContext(HistoryReference href) {
        if (href == null) {
            return false;
        }
        if (href.getSiteNode() != null) {
            return this.isInContext(href.getSiteNode());
        }
        try {
            return this.isInContext(href.getURI().toString());
        }
        catch (Exception e) {
            log.error((Object)e.getMessage(), (Throwable)e);
            return false;
        }
    }

    public boolean isInContext(SiteNode sn) {
        if (sn == null) {
            return false;
        }
        return this.isInContext(sn.getHierarchicNodeName());
    }

    public boolean isInContext(String url) {
        if (url.indexOf("?") > 0) {
            url = url.substring(0, url.indexOf("?"));
        }
        if (!this.isIncluded(url)) {
            return false;
        }
        return !this.isExcluded(url);
    }

    public List<SiteNode> getNodesInContextFromSiteTree() {
        LinkedList<SiteNode> nodes = new LinkedList<SiteNode>();
        SiteNode rootNode = this.session.getSiteTree().getRoot();
        this.fillNodesInContext(rootNode, nodes);
        return nodes;
    }

    public boolean hasNodesInContextFromSiteTree() {
        return this.hasNodesInContext(this.session.getSiteTree().getRoot());
    }

    private boolean hasNodesInContext(SiteNode node) {
        Enumeration<TreeNode> en = node.children();
        while (en.hasMoreElements()) {
            SiteNode sn = (SiteNode)en.nextElement();
            if (this.isInContext(sn)) {
                return true;
            }
            if (!this.hasNodesInContext(sn)) continue;
            return true;
        }
        return false;
    }

    public List<SiteNode> getTopNodesInContextFromSiteTree() {
        LinkedList<SiteNode> nodes = new LinkedList<SiteNode>();
        SiteNode rootNode = this.session.getSiteTree().getRoot();
        Enumeration<TreeNode> en = rootNode.children();
        while (en.hasMoreElements()) {
            SiteNode sn = (SiteNode)en.nextElement();
            if (!this.isContainsNodesInContext(sn)) continue;
            nodes.add(sn);
        }
        return nodes;
    }

    private void fillNodesInContext(SiteNode rootNode, List<SiteNode> nodesList) {
        Enumeration<TreeNode> en = rootNode.children();
        while (en.hasMoreElements()) {
            SiteNode sn = (SiteNode)en.nextElement();
            if (this.isInContext(sn)) {
                nodesList.add(sn);
            }
            this.fillNodesInContext(sn, nodesList);
        }
    }

    private boolean isContainsNodesInContext(SiteNode node) {
        if (this.isInContext(node)) {
            return true;
        }
        Enumeration<TreeNode> en = node.children();
        while (en.hasMoreElements()) {
            SiteNode sn = (SiteNode)en.nextElement();
            if (!this.isContainsNodesInContext(sn)) continue;
            return true;
        }
        return false;
    }

    public List<String> getIncludeInContextRegexs() {
        return Collections.unmodifiableList(this.includeInRegexs);
    }

    private static void validateRegexs(List<String> regexs) {
        for (String regex : regexs) {
            Context.validateRegex(regex);
        }
    }

    private static void validateRegex(String regex) {
        if (regex == null) {
            throw new IllegalArgumentException("The regular expression must not be null.");
        }
        String trimmedRegex = regex.trim();
        if (!trimmedRegex.isEmpty()) {
            Pattern.compile(trimmedRegex, 2);
        }
    }

    public void setIncludeInContextRegexs(List<String> includeRegexs) {
        Context.validateRegexs(includeRegexs);
        if (this.includeInRegexs.size() == includeRegexs.size()) {
            boolean changed = false;
            for (int i = 0; i < this.includeInRegexs.size(); ++i) {
                if (this.includeInRegexs.get(i).equals(includeRegexs.get(i))) continue;
                changed = true;
                break;
            }
            if (!changed) {
                return;
            }
        }
        this.includeInRegexs.clear();
        this.includeInPatterns.clear();
        for (String url : includeRegexs) {
            if ((url = url.trim()).length() <= 0) continue;
            Pattern p = Pattern.compile(url, 2);
            this.includeInRegexs.add(url);
            this.includeInPatterns.add(p);
        }
    }

    public void excludeFromContext(SiteNode sn, boolean recurse) throws Exception {
        this.excludeFromContext(new StructuralSiteNode(sn), recurse);
    }

    public void excludeFromContext(StructuralNode sn, boolean recurse) throws Exception {
        this.addExcludeFromContextRegex(sn.getRegexPattern(recurse));
    }

    public void addIncludeInContextRegex(String includeRegex) {
        Context.validateRegex(includeRegex);
        this.includeInPatterns.add(Pattern.compile(includeRegex, 2));
        this.includeInRegexs.add(includeRegex);
    }

    public List<String> getExcludeFromContextRegexs() {
        return Collections.unmodifiableList(this.excludeFromRegexs);
    }

    public void setExcludeFromContextRegexs(List<String> excludeRegexs) {
        Context.validateRegexs(excludeRegexs);
        if (this.excludeFromRegexs.size() == excludeRegexs.size()) {
            boolean changed = false;
            for (int i = 0; i < this.excludeFromRegexs.size(); ++i) {
                if (this.excludeFromRegexs.get(i).equals(excludeRegexs.get(i))) continue;
                changed = true;
                break;
            }
            if (!changed) {
                return;
            }
        }
        this.excludeFromRegexs.clear();
        this.excludeFromPatterns.clear();
        for (String url : excludeRegexs) {
            if ((url = url.trim()).length() <= 0) continue;
            Pattern p = Pattern.compile(url, 2);
            this.excludeFromPatterns.add(p);
            this.excludeFromRegexs.add(url);
        }
    }

    public void addExcludeFromContextRegex(String excludeRegex) {
        Context.validateRegex(excludeRegex);
        this.excludeFromPatterns.add(Pattern.compile(excludeRegex, 2));
        this.excludeFromRegexs.add(excludeRegex);
    }

    public void save() {
        this.session.saveContext(this);
    }

    public TechSet getTechSet() {
        return this.techSet;
    }

    public void setTechSet(TechSet techSet) {
        this.techSet = techSet;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        if (name == null || name.isEmpty()) {
            throw new IllegalContextNameException(IllegalContextNameException.Reason.EMPTY_NAME, "The context name must not be null nor empty.");
        }
        this.name = name;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    @Deprecated
    public int getIndex() {
        return this.getId();
    }

    public int getId() {
        return this.id;
    }

    public boolean isInScope() {
        return this.inScope;
    }

    public void setInScope(boolean inScope) {
        this.inScope = inScope;
    }

    public AuthenticationMethod getAuthenticationMethod() {
        return this.authenticationMethod;
    }

    public void setAuthenticationMethod(AuthenticationMethod authenticationMethod) {
        this.authenticationMethod = authenticationMethod;
    }

    public SessionManagementMethod getSessionManagementMethod() {
        return this.sessionManagementMethod;
    }

    public void setSessionManagementMethod(SessionManagementMethod sessionManagementMethod) {
        this.sessionManagementMethod = sessionManagementMethod;
    }

    public AuthorizationDetectionMethod getAuthorizationDetectionMethod() {
        return this.authorizationDetectionMethod;
    }

    public void setAuthorizationDetectionMethod(AuthorizationDetectionMethod authorizationDetectionMethod) {
        this.authorizationDetectionMethod = authorizationDetectionMethod;
    }

    public ParameterParser getUrlParamParser() {
        return this.urlParamParser;
    }

    public void setUrlParamParser(ParameterParser paramParser) {
        this.urlParamParser = paramParser;
    }

    public ParameterParser getPostParamParser() {
        return this.postParamParser;
    }

    public void setPostParamParser(ParameterParser postParamParser) {
        this.postParamParser = postParamParser;
    }

    public void restructureSiteTree() {
        if (!View.isInitialised() || EventQueue.isDispatchThread()) {
            this.restructureSiteTreeEventHandler();
        } else {
            try {
                EventQueue.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        Context.this.restructureSiteTreeEventHandler();
                    }
                });
            }
            catch (Exception e) {
                log.error((Object)e.getMessage(), (Throwable)e);
            }
        }
    }

    private void restructureSiteTreeEventHandler() {
        log.debug((Object)("Restructure site tree for context: " + this.getName()));
        List<SiteNode> nodes = this.getTopNodesInContextFromSiteTree();
        for (SiteNode sn : nodes) {
            this.checkNode(sn);
        }
    }

    private boolean checkNode(SiteNode sn) {
        int origChildren = sn.getChildCount();
        int movedChildren = 0;
        for (SiteNode childNode : this.getChildren(sn)) {
            if (!this.checkNode(childNode)) continue;
            ++movedChildren;
        }
        if (this.isInContext(sn)) {
            SiteMap sitesTree = this.session.getSiteTree();
            HistoryReference href = sn.getHistoryReference();
            try {
                SiteNode sn2 = "POST".equals(href.getMethod()) ? sitesTree.findNode(href.getHttpMessage()) : sitesTree.findNode(href.getURI());
                if (!(sn2 != null && sn.getHierarchicNodeName().equals(sn2.getHierarchicNodeName()) || sn.isDataDriven())) {
                    this.moveNode(sitesTree, sn);
                    return true;
                }
                if (movedChildren > 0 && movedChildren == origChildren && sn.getChildCount() == 0 && href.getHistoryType() == 0) {
                    this.deleteNode(sitesTree, sn);
                    return true;
                }
            }
            catch (Exception e) {
                log.error((Object)e.getMessage(), (Throwable)e);
            }
        }
        return false;
    }

    private List<SiteNode> getChildren(SiteNode siteNode) {
        int childCount = siteNode.getChildCount();
        if (childCount == 0) {
            return Collections.emptyList();
        }
        ArrayList<SiteNode> children = new ArrayList<SiteNode>(childCount);
        for (int i = 0; i < childCount; ++i) {
            children.add((SiteNode)siteNode.getChildAt(i));
        }
        return children;
    }

    private void moveNode(SiteMap sitesTree, SiteNode sn) {
        List<Alert> alerts = sn.getAlerts();
        this.deleteNode(sitesTree, sn);
        SiteNode sn2 = sitesTree.addPath(sn.getHistoryReference());
        log.debug((Object)("Moved node " + sn.getHierarchicNodeName() + " to " + sn2.getHierarchicNodeName()));
        for (Alert alert : alerts) {
            sn2.addAlert(alert);
        }
    }

    private void deleteNode(SiteMap sitesTree, SiteNode sn) {
        log.debug((Object)("Deleting node " + sn.getHierarchicNodeName()));
        sn.deleteAlerts(sn.getAlerts());
        sitesTree.removeNodeFromParent(sn);
        sitesTree.removeHistoryReference(sn.getHistoryReference().getHistoryId());
    }

    public List<StructuralNodeModifier> getDataDrivenNodes() {
        ArrayList<StructuralNodeModifier> ddns = new ArrayList<StructuralNodeModifier>(this.dataDrivenNodes.size());
        for (StructuralNodeModifier ddn : this.dataDrivenNodes) {
            ddns.add(ddn.clone());
        }
        return ddns;
    }

    public void setDataDrivenNodes(List<StructuralNodeModifier> dataDrivenNodes) {
        this.dataDrivenNodes = dataDrivenNodes;
    }

    public void addDataDrivenNodes(StructuralNodeModifier ddn) {
        this.dataDrivenNodes.add(ddn.clone());
    }

    public String getDefaultDDNName() {
        int i = 1;
        while (true) {
            boolean found = false;
            String name = "DDN" + i;
            for (StructuralNodeModifier ddn : this.dataDrivenNodes) {
                if (!ddn.getName().equals(name)) continue;
                found = true;
                break;
            }
            if (!found) {
                return name;
            }
            ++i;
        }
    }

    public Context duplicate() {
        Context newContext = new Context(this.session, this.getId());
        newContext.description = this.description;
        newContext.name = this.name;
        newContext.includeInRegexs = new ArrayList<String>(this.includeInRegexs);
        newContext.includeInPatterns = new ArrayList<Pattern>(this.includeInPatterns);
        newContext.excludeFromRegexs = new ArrayList<String>(this.excludeFromRegexs);
        newContext.excludeFromPatterns = new ArrayList<Pattern>(this.excludeFromPatterns);
        newContext.inScope = this.inScope;
        newContext.techSet = new TechSet(this.techSet);
        newContext.authenticationMethod = this.authenticationMethod.clone();
        newContext.sessionManagementMethod = this.sessionManagementMethod.clone();
        newContext.urlParamParser = this.urlParamParser.clone();
        newContext.postParamParser = this.postParamParser.clone();
        newContext.authorizationDetectionMethod = this.authorizationDetectionMethod.clone();
        newContext.dataDrivenNodes = this.getDataDrivenNodes();
        return newContext;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + this.id;
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Context other = (Context)obj;
        return this.id == other.id;
    }
}

