﻿/*
* Copyright 2010-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
*
* Licensed under the Apache License, Version 2.0 (the "License").
* You may not use this file except in compliance with the License.
* A copy of the License is located at
*
*  http://aws.amazon.com/apache2.0
*
* or in the "license" file accompanying this file. This file is distributed
* on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either
* express or implied. See the License for the specific language governing
* permissions and limitations under the License.
*/

#pragma once
#include <aws/managedblockchain/ManagedBlockchain_EXPORTS.h>
#include <aws/managedblockchain/model/LogConfiguration.h>
#include <utility>

namespace Aws
{
namespace Utils
{
namespace Json
{
  class JsonValue;
  class JsonView;
} // namespace Json
} // namespace Utils
namespace ManagedBlockchain
{
namespace Model
{

  /**
   * <p>A collection of log configurations.</p><p><h3>See Also:</h3>   <a
   * href="http://docs.aws.amazon.com/goto/WebAPI/managedblockchain-2018-09-24/LogConfigurations">AWS
   * API Reference</a></p>
   */
  class AWS_MANAGEDBLOCKCHAIN_API LogConfigurations
  {
  public:
    LogConfigurations();
    LogConfigurations(Aws::Utils::Json::JsonView jsonValue);
    LogConfigurations& operator=(Aws::Utils::Json::JsonView jsonValue);
    Aws::Utils::Json::JsonValue Jsonize() const;


    /**
     * <p>Parameters for publishing logs to Amazon CloudWatch Logs.</p>
     */
    inline const LogConfiguration& GetCloudwatch() const{ return m_cloudwatch; }

    /**
     * <p>Parameters for publishing logs to Amazon CloudWatch Logs.</p>
     */
    inline bool CloudwatchHasBeenSet() const { return m_cloudwatchHasBeenSet; }

    /**
     * <p>Parameters for publishing logs to Amazon CloudWatch Logs.</p>
     */
    inline void SetCloudwatch(const LogConfiguration& value) { m_cloudwatchHasBeenSet = true; m_cloudwatch = value; }

    /**
     * <p>Parameters for publishing logs to Amazon CloudWatch Logs.</p>
     */
    inline void SetCloudwatch(LogConfiguration&& value) { m_cloudwatchHasBeenSet = true; m_cloudwatch = std::move(value); }

    /**
     * <p>Parameters for publishing logs to Amazon CloudWatch Logs.</p>
     */
    inline LogConfigurations& WithCloudwatch(const LogConfiguration& value) { SetCloudwatch(value); return *this;}

    /**
     * <p>Parameters for publishing logs to Amazon CloudWatch Logs.</p>
     */
    inline LogConfigurations& WithCloudwatch(LogConfiguration&& value) { SetCloudwatch(std::move(value)); return *this;}

  private:

    LogConfiguration m_cloudwatch;
    bool m_cloudwatchHasBeenSet;
  };

} // namespace Model
} // namespace ManagedBlockchain
} // namespace Aws
