﻿/*
* Copyright 2010-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
*
* Licensed under the Apache License, Version 2.0 (the "License").
* You may not use this file except in compliance with the License.
* A copy of the License is located at
*
*  http://aws.amazon.com/apache2.0
*
* or in the "license" file accompanying this file. This file is distributed
* on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either
* express or implied. See the License for the specific language governing
* permissions and limitations under the License.
*/

#pragma once
#include <aws/ssm/SSM_EXPORTS.h>
#include <aws/ssm/model/CalendarState.h>
#include <aws/core/utils/memory/stl/AWSString.h>
#include <utility>

namespace Aws
{
template<typename RESULT_TYPE>
class AmazonWebServiceResult;

namespace Utils
{
namespace Json
{
  class JsonValue;
} // namespace Json
} // namespace Utils
namespace SSM
{
namespace Model
{
  class AWS_SSM_API GetCalendarStateResult
  {
  public:
    GetCalendarStateResult();
    GetCalendarStateResult(const Aws::AmazonWebServiceResult<Aws::Utils::Json::JsonValue>& result);
    GetCalendarStateResult& operator=(const Aws::AmazonWebServiceResult<Aws::Utils::Json::JsonValue>& result);


    /**
     * <p>The state of the calendar. An <code>OPEN</code> calendar indicates that
     * actions are allowed to proceed, and a <code>CLOSED</code> calendar indicates
     * that actions are not allowed to proceed.</p>
     */
    inline const CalendarState& GetState() const{ return m_state; }

    /**
     * <p>The state of the calendar. An <code>OPEN</code> calendar indicates that
     * actions are allowed to proceed, and a <code>CLOSED</code> calendar indicates
     * that actions are not allowed to proceed.</p>
     */
    inline void SetState(const CalendarState& value) { m_state = value; }

    /**
     * <p>The state of the calendar. An <code>OPEN</code> calendar indicates that
     * actions are allowed to proceed, and a <code>CLOSED</code> calendar indicates
     * that actions are not allowed to proceed.</p>
     */
    inline void SetState(CalendarState&& value) { m_state = std::move(value); }

    /**
     * <p>The state of the calendar. An <code>OPEN</code> calendar indicates that
     * actions are allowed to proceed, and a <code>CLOSED</code> calendar indicates
     * that actions are not allowed to proceed.</p>
     */
    inline GetCalendarStateResult& WithState(const CalendarState& value) { SetState(value); return *this;}

    /**
     * <p>The state of the calendar. An <code>OPEN</code> calendar indicates that
     * actions are allowed to proceed, and a <code>CLOSED</code> calendar indicates
     * that actions are not allowed to proceed.</p>
     */
    inline GetCalendarStateResult& WithState(CalendarState&& value) { SetState(std::move(value)); return *this;}


    /**
     * <p>The time, as an <a href="https://en.wikipedia.org/wiki/ISO_8601">ISO 8601</a>
     * string, that you specified in your command. If you did not specify a time,
     * <code>GetCalendarState</code> uses the current time.</p>
     */
    inline const Aws::String& GetAtTime() const{ return m_atTime; }

    /**
     * <p>The time, as an <a href="https://en.wikipedia.org/wiki/ISO_8601">ISO 8601</a>
     * string, that you specified in your command. If you did not specify a time,
     * <code>GetCalendarState</code> uses the current time.</p>
     */
    inline void SetAtTime(const Aws::String& value) { m_atTime = value; }

    /**
     * <p>The time, as an <a href="https://en.wikipedia.org/wiki/ISO_8601">ISO 8601</a>
     * string, that you specified in your command. If you did not specify a time,
     * <code>GetCalendarState</code> uses the current time.</p>
     */
    inline void SetAtTime(Aws::String&& value) { m_atTime = std::move(value); }

    /**
     * <p>The time, as an <a href="https://en.wikipedia.org/wiki/ISO_8601">ISO 8601</a>
     * string, that you specified in your command. If you did not specify a time,
     * <code>GetCalendarState</code> uses the current time.</p>
     */
    inline void SetAtTime(const char* value) { m_atTime.assign(value); }

    /**
     * <p>The time, as an <a href="https://en.wikipedia.org/wiki/ISO_8601">ISO 8601</a>
     * string, that you specified in your command. If you did not specify a time,
     * <code>GetCalendarState</code> uses the current time.</p>
     */
    inline GetCalendarStateResult& WithAtTime(const Aws::String& value) { SetAtTime(value); return *this;}

    /**
     * <p>The time, as an <a href="https://en.wikipedia.org/wiki/ISO_8601">ISO 8601</a>
     * string, that you specified in your command. If you did not specify a time,
     * <code>GetCalendarState</code> uses the current time.</p>
     */
    inline GetCalendarStateResult& WithAtTime(Aws::String&& value) { SetAtTime(std::move(value)); return *this;}

    /**
     * <p>The time, as an <a href="https://en.wikipedia.org/wiki/ISO_8601">ISO 8601</a>
     * string, that you specified in your command. If you did not specify a time,
     * <code>GetCalendarState</code> uses the current time.</p>
     */
    inline GetCalendarStateResult& WithAtTime(const char* value) { SetAtTime(value); return *this;}


    /**
     * <p>The time, as an <a href="https://en.wikipedia.org/wiki/ISO_8601">ISO 8601</a>
     * string, that the calendar state will change. If the current calendar state is
     * <code>OPEN</code>, <code>NextTransitionTime</code> indicates when the calendar
     * state changes to <code>CLOSED</code>, and vice-versa.</p>
     */
    inline const Aws::String& GetNextTransitionTime() const{ return m_nextTransitionTime; }

    /**
     * <p>The time, as an <a href="https://en.wikipedia.org/wiki/ISO_8601">ISO 8601</a>
     * string, that the calendar state will change. If the current calendar state is
     * <code>OPEN</code>, <code>NextTransitionTime</code> indicates when the calendar
     * state changes to <code>CLOSED</code>, and vice-versa.</p>
     */
    inline void SetNextTransitionTime(const Aws::String& value) { m_nextTransitionTime = value; }

    /**
     * <p>The time, as an <a href="https://en.wikipedia.org/wiki/ISO_8601">ISO 8601</a>
     * string, that the calendar state will change. If the current calendar state is
     * <code>OPEN</code>, <code>NextTransitionTime</code> indicates when the calendar
     * state changes to <code>CLOSED</code>, and vice-versa.</p>
     */
    inline void SetNextTransitionTime(Aws::String&& value) { m_nextTransitionTime = std::move(value); }

    /**
     * <p>The time, as an <a href="https://en.wikipedia.org/wiki/ISO_8601">ISO 8601</a>
     * string, that the calendar state will change. If the current calendar state is
     * <code>OPEN</code>, <code>NextTransitionTime</code> indicates when the calendar
     * state changes to <code>CLOSED</code>, and vice-versa.</p>
     */
    inline void SetNextTransitionTime(const char* value) { m_nextTransitionTime.assign(value); }

    /**
     * <p>The time, as an <a href="https://en.wikipedia.org/wiki/ISO_8601">ISO 8601</a>
     * string, that the calendar state will change. If the current calendar state is
     * <code>OPEN</code>, <code>NextTransitionTime</code> indicates when the calendar
     * state changes to <code>CLOSED</code>, and vice-versa.</p>
     */
    inline GetCalendarStateResult& WithNextTransitionTime(const Aws::String& value) { SetNextTransitionTime(value); return *this;}

    /**
     * <p>The time, as an <a href="https://en.wikipedia.org/wiki/ISO_8601">ISO 8601</a>
     * string, that the calendar state will change. If the current calendar state is
     * <code>OPEN</code>, <code>NextTransitionTime</code> indicates when the calendar
     * state changes to <code>CLOSED</code>, and vice-versa.</p>
     */
    inline GetCalendarStateResult& WithNextTransitionTime(Aws::String&& value) { SetNextTransitionTime(std::move(value)); return *this;}

    /**
     * <p>The time, as an <a href="https://en.wikipedia.org/wiki/ISO_8601">ISO 8601</a>
     * string, that the calendar state will change. If the current calendar state is
     * <code>OPEN</code>, <code>NextTransitionTime</code> indicates when the calendar
     * state changes to <code>CLOSED</code>, and vice-versa.</p>
     */
    inline GetCalendarStateResult& WithNextTransitionTime(const char* value) { SetNextTransitionTime(value); return *this;}

  private:

    CalendarState m_state;

    Aws::String m_atTime;

    Aws::String m_nextTransitionTime;
  };

} // namespace Model
} // namespace SSM
} // namespace Aws
