/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.transport.netty4;

import io.netty.buffer.ByteBuf;
import io.netty.channel.ChannelHandlerContext;
import io.netty.handler.codec.ByteToMessageDecoder;
import io.netty.handler.codec.TooLongFrameException;
import java.util.List;
import org.elasticsearch.common.bytes.BytesReference;
import org.elasticsearch.transport.TcpTransport;
import org.elasticsearch.transport.netty4.Netty4Utils;

final class Netty4SizeHeaderFrameDecoder
extends ByteToMessageDecoder {
    private static final int HEADER_SIZE = 6;

    Netty4SizeHeaderFrameDecoder() {
        this.setCumulator(COMPOSITE_CUMULATOR);
    }

    protected void decode(ChannelHandlerContext ctx, ByteBuf in, List<Object> out) throws Exception {
        try {
            int messageLengthWithHeader;
            int messageLength;
            while (in.readableBytes() >= 6 && (messageLength = TcpTransport.readMessageLength((BytesReference)Netty4Utils.toBytesReference(in))) != -1 && (messageLengthWithHeader = messageLength + 6) <= in.readableBytes()) {
                int readerIndex = in.readerIndex();
                ByteBuf message = in.retainedSlice(readerIndex + 6, messageLength);
                out.add(message);
                in.readerIndex(readerIndex + messageLengthWithHeader);
            }
        }
        catch (IllegalArgumentException ex) {
            throw new TooLongFrameException((Throwable)ex);
        }
    }
}

