/*
 * Decompiled with CFR 0.152.
 */
package com.thoughtworks.xstream.converters.reflection;

import com.thoughtworks.xstream.converters.reflection.FieldDictionary;
import com.thoughtworks.xstream.converters.reflection.ImmutableFieldKeySorter;
import com.thoughtworks.xstream.converters.reflection.ObjectAccessException;
import com.thoughtworks.xstream.converters.reflection.ReflectionProvider;
import com.thoughtworks.xstream.core.JVM;
import com.thoughtworks.xstream.core.util.Fields;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectStreamClass;
import java.io.Serializable;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Modifier;
import java.util.Iterator;
import java.util.Map;
import java.util.WeakHashMap;

public class PureJavaReflectionProvider
implements ReflectionProvider {
    private transient Map serializedDataCache;
    protected FieldDictionary fieldDictionary;

    public PureJavaReflectionProvider() {
        this(new FieldDictionary(new ImmutableFieldKeySorter()));
    }

    public PureJavaReflectionProvider(FieldDictionary fieldDictionary) {
        this.fieldDictionary = fieldDictionary;
        this.init();
    }

    public Object newInstance(Class type) {
        ObjectAccessException oaex = null;
        try {
            Constructor<?>[] constructors = type.getDeclaredConstructors();
            for (int i = 0; i < constructors.length; ++i) {
                Constructor<?> constructor = constructors[i];
                if (constructor.getParameterTypes().length != 0) continue;
                if (!constructor.isAccessible()) {
                    constructor.setAccessible(true);
                }
                return constructor.newInstance(new Object[0]);
            }
            if (Serializable.class.isAssignableFrom(type)) {
                return this.instantiateUsingSerialization(type);
            }
            oaex = new ObjectAccessException("Cannot construct type as it does not have a no-args constructor");
        }
        catch (InstantiationException e) {
            oaex = new ObjectAccessException("Cannot construct type", e);
        }
        catch (IllegalAccessException e) {
            oaex = new ObjectAccessException("Cannot construct type", e);
        }
        catch (InvocationTargetException e) {
            if (e.getTargetException() instanceof RuntimeException) {
                throw (RuntimeException)e.getTargetException();
            }
            if (e.getTargetException() instanceof Error) {
                throw (Error)e.getTargetException();
            }
            oaex = new ObjectAccessException("Constructor for type threw an exception", e.getTargetException());
        }
        oaex.add("construction-type", type.getName());
        throw oaex;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Object instantiateUsingSerialization(final Class type) {
        ObjectAccessException oaex = null;
        try {
            Map map = this.serializedDataCache;
            synchronized (map) {
                byte[] data = (byte[])this.serializedDataCache.get(type);
                if (data == null) {
                    ByteArrayOutputStream bytes = new ByteArrayOutputStream();
                    DataOutputStream stream = new DataOutputStream(bytes);
                    stream.writeShort(-21267);
                    stream.writeShort(5);
                    stream.writeByte(115);
                    stream.writeByte(114);
                    stream.writeUTF(type.getName());
                    stream.writeLong(ObjectStreamClass.lookup(type).getSerialVersionUID());
                    stream.writeByte(2);
                    stream.writeShort(0);
                    stream.writeByte(120);
                    stream.writeByte(112);
                    data = bytes.toByteArray();
                    this.serializedDataCache.put(type, data);
                }
                ObjectInputStream in = new ObjectInputStream(new ByteArrayInputStream(data)){

                    protected Class resolveClass(ObjectStreamClass desc) throws IOException, ClassNotFoundException {
                        return Class.forName(desc.getName(), false, type.getClassLoader());
                    }
                };
                return in.readObject();
            }
        }
        catch (IOException e) {
            oaex = new ObjectAccessException("Cannot create type by JDK serialization", e);
        }
        catch (ClassNotFoundException e) {
            oaex = new ObjectAccessException("Cannot find class", e);
        }
        oaex.add("construction-type", type.getName());
        throw oaex;
    }

    public void visitSerializableFields(Object object, ReflectionProvider.Visitor visitor) {
        Iterator iterator = this.fieldDictionary.fieldsFor(object.getClass());
        while (iterator.hasNext()) {
            Field field = (Field)iterator.next();
            if (!this.fieldModifiersSupported(field)) continue;
            this.validateFieldAccess(field);
            Object value = Fields.read(field, object);
            visitor.visit(field.getName(), field.getType(), field.getDeclaringClass(), value);
        }
    }

    public void writeField(Object object, String fieldName, Object value, Class definedIn) {
        Field field = this.fieldDictionary.field(object.getClass(), fieldName, definedIn);
        this.validateFieldAccess(field);
        Fields.write(field, object, value);
    }

    public Class getFieldType(Object object, String fieldName, Class definedIn) {
        return this.fieldDictionary.field(object.getClass(), fieldName, definedIn).getType();
    }

    public boolean fieldDefinedInClass(String fieldName, Class type) {
        Field field = this.fieldDictionary.fieldOrNull(type, fieldName, null);
        return field != null && this.fieldModifiersSupported(field);
    }

    protected boolean fieldModifiersSupported(Field field) {
        int modifiers = field.getModifiers();
        return !Modifier.isStatic(modifiers) && !Modifier.isTransient(modifiers);
    }

    protected void validateFieldAccess(Field field) {
        if (Modifier.isFinal(field.getModifiers())) {
            if (JVM.is15()) {
                if (!field.isAccessible()) {
                    field.setAccessible(true);
                }
            } else {
                throw new ObjectAccessException("Invalid final field " + field.getDeclaringClass().getName() + "." + field.getName());
            }
        }
    }

    public Field getField(Class definedIn, String fieldName) {
        return this.fieldDictionary.field(definedIn, fieldName, null);
    }

    public Field getFieldOrNull(Class definedIn, String fieldName) {
        return this.fieldDictionary.fieldOrNull(definedIn, fieldName, null);
    }

    public void setFieldDictionary(FieldDictionary dictionary) {
        this.fieldDictionary = dictionary;
    }

    private Object readResolve() {
        this.init();
        return this;
    }

    protected void init() {
        this.serializedDataCache = new WeakHashMap();
    }
}

