/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.nwdiag;

import java.util.Collection;
import net.sourceforge.plantuml.graphic.StringBounder;
import net.sourceforge.plantuml.nwdiag.DiagGroup;
import net.sourceforge.plantuml.nwdiag.GridTextBlockSimple;
import net.sourceforge.plantuml.nwdiag.LinkedElement;
import net.sourceforge.plantuml.nwdiag.Network;
import net.sourceforge.plantuml.ugraphic.MinMax;
import net.sourceforge.plantuml.ugraphic.UGraphic;
import net.sourceforge.plantuml.ugraphic.URectangle;
import net.sourceforge.plantuml.ugraphic.UTranslate;
import net.sourceforge.plantuml.ugraphic.color.HColor;
import net.sourceforge.plantuml.ugraphic.color.HColorSet;

public class GridTextBlockDecorated
extends GridTextBlockSimple {
    public static final HColorSet colors = HColorSet.instance();
    public static final int NETWORK_THIN = 5;
    private final Collection<DiagGroup> groups;

    public GridTextBlockDecorated(int lines, int cols, Collection<DiagGroup> groups) {
        super(lines, cols);
        this.groups = groups;
    }

    @Override
    public void drawGrid(UGraphic ug) {
        for (DiagGroup group : this.groups) {
            this.drawGroups(ug, group);
        }
        this.drawNetworkTube(ug);
    }

    private void drawGroups(UGraphic ug, DiagGroup group) {
        StringBounder stringBounder = ug.getStringBounder();
        MinMax size = null;
        double y = 0.0;
        for (int i = 0; i < this.data.length; ++i) {
            double lineHeight = this.lineHeight(stringBounder, i);
            double x = 0.0;
            for (int j = 0; j < this.data[i].length; ++j) {
                double colWidth = this.colWidth(stringBounder, j);
                LinkedElement element = this.data[i][j];
                if (element != null && group.matches(element)) {
                    MinMax minMax = element.getMinMax(stringBounder, colWidth, lineHeight).translate(new UTranslate(x, y));
                    size = size == null ? minMax : size.addMinMax(minMax);
                }
                x += colWidth;
            }
            y += lineHeight;
        }
        if (size != null) {
            HColor color = group.getColor();
            if (color == null) {
                color = colors.getColorIfValid("#AAA");
            }
            size.draw(ug, color);
        }
    }

    private void drawNetworkTube(UGraphic ug) {
        StringBounder stringBounder = ug.getStringBounder();
        double y = 0.0;
        for (int i = 0; i < this.data.length; ++i) {
            Network network = this.getNetwork(i);
            double x = 0.0;
            double xmin = -1.0;
            double xmax = 0.0;
            for (int j = 0; j < this.data[i].length; ++j) {
                boolean hline;
                boolean bl = hline = this.isPresent(i, j) || this.isPresent(i - 1, j);
                if (hline && xmin < 0.0) {
                    xmin = x;
                }
                x += this.colWidth(stringBounder, j);
                if (!hline) continue;
                xmax = x;
            }
            URectangle rect = new URectangle(xmax - xmin, 5.0);
            rect.setDeltaShadow(1.0);
            UGraphic ug2 = ug.apply(new UTranslate(xmin, y));
            if (network != null && network.getColor() != null) {
                ug2 = ug2.apply(network.getColor().bg());
            }
            ug2.draw(rect);
            y += this.lineHeight(stringBounder, i);
        }
    }

    private Network getNetwork(int i) {
        for (int j = 0; j < this.data[i].length; ++j) {
            if (!this.isPresent(i, j)) continue;
            return this.data[i][j].getNetwork();
        }
        return null;
    }
}

