/*
 * Decompiled with CFR 0.152.
 */
package org.apache.batik.transcoder.wmf.tosvg;

import java.io.DataInputStream;
import java.io.IOException;
import java.net.URL;
import java.util.Vector;
import org.apache.batik.transcoder.wmf.tosvg.GdiObject;
import org.apache.batik.transcoder.wmf.tosvg.MetaRecord;

public class RecordStore {
    private transient URL url;
    protected transient int numRecords;
    protected transient int numObjects;
    public transient int lastObjectIdx;
    protected transient int vpX;
    protected transient int vpY;
    protected transient int vpW;
    protected transient int vpH;
    protected transient Vector records;
    protected transient Vector objectVector;
    protected transient boolean bReading = false;

    public RecordStore() {
        this.reset();
    }

    public void reset() {
        this.numRecords = 0;
        this.vpX = 0;
        this.vpY = 0;
        this.vpW = 1000;
        this.vpH = 1000;
        this.numObjects = 0;
        this.records = new Vector(20, 20);
        this.objectVector = new Vector();
    }

    synchronized void setReading(boolean bl) {
        this.bReading = bl;
    }

    synchronized boolean isReading() {
        return this.bReading;
    }

    public boolean read(DataInputStream dataInputStream) throws IOException {
        this.setReading(true);
        this.reset();
        int n = 0;
        this.numRecords = 0;
        this.numObjects = dataInputStream.readShort();
        this.objectVector.ensureCapacity(this.numObjects);
        for (int i = 0; i < this.numObjects; ++i) {
            this.objectVector.add(new GdiObject(i, false));
        }
        while (n != -1 && (n = (int)dataInputStream.readShort()) != -1) {
            MetaRecord metaRecord;
            int n2;
            switch (n) {
                case 763: 
                case 1313: 
                case 1583: 
                case 2610: {
                    n2 = dataInputStream.readShort();
                    byte[] byArray = new byte[n2];
                    for (int i = 0; i < n2; ++i) {
                        byArray[i] = dataInputStream.readByte();
                    }
                    String string = new String(byArray);
                    metaRecord = new MetaRecord.StringRecord(string);
                    break;
                }
                default: {
                    metaRecord = new MetaRecord();
                }
            }
            n2 = dataInputStream.readShort();
            metaRecord.numPoints = n2;
            metaRecord.functionId = n;
            for (int i = 0; i < n2; ++i) {
                metaRecord.AddElement(new Integer(dataInputStream.readShort()));
            }
            this.records.add(metaRecord);
            ++this.numRecords;
        }
        this.setReading(false);
        return true;
    }

    public void addObject(int n, Object object) {
        for (int i = 0; i < this.numObjects; ++i) {
            GdiObject gdiObject = (GdiObject)this.objectVector.get(i);
            if (gdiObject.used) continue;
            gdiObject.Setup(n, object);
            this.lastObjectIdx = i;
            break;
        }
    }

    public void addObjectAt(int n, Object object, int n2) {
        if (n2 == 0 || n2 > this.numObjects) {
            this.addObject(n, object);
            return;
        }
        this.lastObjectIdx = n2;
        for (int i = 0; i < this.numObjects; ++i) {
            GdiObject gdiObject = (GdiObject)this.objectVector.get(i);
            if (i != n2) continue;
            gdiObject.Setup(n, object);
            break;
        }
    }

    public URL getUrl() {
        return this.url;
    }

    public void setUrl(URL uRL) {
        this.url = uRL;
    }

    public GdiObject getObject(int n) {
        return (GdiObject)this.objectVector.get(n);
    }

    public MetaRecord getRecord(int n) {
        return (MetaRecord)this.records.get(n);
    }

    public int getNumRecords() {
        return this.numRecords;
    }

    public int getNumObjects() {
        return this.numObjects;
    }

    public int getVpX() {
        return this.vpX;
    }

    public int getVpY() {
        return this.vpY;
    }

    public int getVpW() {
        return this.vpW;
    }

    public int getVpH() {
        return this.vpH;
    }

    public void setVpX(int n) {
        this.vpX = n;
    }

    public void setVpY(int n) {
        this.vpY = n;
    }

    public void setVpW(int n) {
        this.vpW = n;
    }

    public void setVpH(int n) {
        this.vpH = n;
    }
}

