/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.painless.node;

import java.util.Objects;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.elasticsearch.painless.AnalyzerCaster;
import org.elasticsearch.painless.ClassWriter;
import org.elasticsearch.painless.Globals;
import org.elasticsearch.painless.Locals;
import org.elasticsearch.painless.Location;
import org.elasticsearch.painless.MethodWriter;
import org.elasticsearch.painless.Operation;
import org.elasticsearch.painless.ScriptRoot;
import org.elasticsearch.painless.WriterConstants;
import org.elasticsearch.painless.lookup.PainlessLookupUtility;
import org.elasticsearch.painless.lookup.def;
import org.elasticsearch.painless.node.AExpression;
import org.objectweb.asm.Type;

public final class EBinary
extends AExpression {
    final Operation operation;
    private AExpression left;
    private AExpression right;
    private Class<?> promote = null;
    private Class<?> shiftDistance = null;
    boolean cat = false;
    private boolean originallyExplicit = false;

    public EBinary(Location location, Operation operation, AExpression left, AExpression right) {
        super(location);
        this.operation = Objects.requireNonNull(operation);
        this.left = Objects.requireNonNull(left);
        this.right = Objects.requireNonNull(right);
    }

    @Override
    void extractVariables(Set<String> variables) {
        this.left.extractVariables(variables);
        this.right.extractVariables(variables);
    }

    @Override
    void analyze(ScriptRoot scriptRoot, Locals locals) {
        this.originallyExplicit = this.explicit;
        if (this.operation == Operation.MUL) {
            this.analyzeMul(scriptRoot, locals);
        } else if (this.operation == Operation.DIV) {
            this.analyzeDiv(scriptRoot, locals);
        } else if (this.operation == Operation.REM) {
            this.analyzeRem(scriptRoot, locals);
        } else if (this.operation == Operation.ADD) {
            this.analyzeAdd(scriptRoot, locals);
        } else if (this.operation == Operation.SUB) {
            this.analyzeSub(scriptRoot, locals);
        } else if (this.operation == Operation.FIND) {
            this.analyzeRegexOp(scriptRoot, locals);
        } else if (this.operation == Operation.MATCH) {
            this.analyzeRegexOp(scriptRoot, locals);
        } else if (this.operation == Operation.LSH) {
            this.analyzeLSH(scriptRoot, locals);
        } else if (this.operation == Operation.RSH) {
            this.analyzeRSH(scriptRoot, locals);
        } else if (this.operation == Operation.USH) {
            this.analyzeUSH(scriptRoot, locals);
        } else if (this.operation == Operation.BWAND) {
            this.analyzeBWAnd(scriptRoot, locals);
        } else if (this.operation == Operation.XOR) {
            this.analyzeXor(scriptRoot, locals);
        } else if (this.operation == Operation.BWOR) {
            this.analyzeBWOr(scriptRoot, locals);
        } else {
            throw this.createError(new IllegalStateException("Illegal tree structure."));
        }
    }

    private void analyzeMul(ScriptRoot scriptRoot, Locals variables) {
        this.left.analyze(scriptRoot, variables);
        this.right.analyze(scriptRoot, variables);
        this.promote = AnalyzerCaster.promoteNumeric(this.left.actual, this.right.actual, true);
        if (this.promote == null) {
            throw this.createError(new ClassCastException("Cannot apply multiply [*] to types [" + PainlessLookupUtility.typeToCanonicalTypeName(this.left.actual) + "] and [" + PainlessLookupUtility.typeToCanonicalTypeName(this.right.actual) + "]."));
        }
        this.actual = this.promote;
        if (this.promote == def.class) {
            this.left.expected = this.left.actual;
            this.right.expected = this.right.actual;
            if (this.expected != null) {
                this.actual = this.expected;
            }
        } else {
            this.left.expected = this.promote;
            this.right.expected = this.promote;
        }
        this.left = this.left.cast(scriptRoot, variables);
        this.right = this.right.cast(scriptRoot, variables);
        if (this.left.constant != null && this.right.constant != null) {
            if (this.promote == Integer.TYPE) {
                this.constant = (Integer)this.left.constant * (Integer)this.right.constant;
            } else if (this.promote == Long.TYPE) {
                this.constant = (Long)this.left.constant * (Long)this.right.constant;
            } else if (this.promote == Float.TYPE) {
                this.constant = Float.valueOf(((Float)this.left.constant).floatValue() * ((Float)this.right.constant).floatValue());
            } else if (this.promote == Double.TYPE) {
                this.constant = (Double)this.left.constant * (Double)this.right.constant;
            } else {
                throw this.createError(new IllegalStateException("Illegal tree structure."));
            }
        }
    }

    private void analyzeDiv(ScriptRoot scriptRoot, Locals variables) {
        block11: {
            this.left.analyze(scriptRoot, variables);
            this.right.analyze(scriptRoot, variables);
            this.promote = AnalyzerCaster.promoteNumeric(this.left.actual, this.right.actual, true);
            if (this.promote == null) {
                throw this.createError(new ClassCastException("Cannot apply divide [/] to types [" + PainlessLookupUtility.typeToCanonicalTypeName(this.left.actual) + "] and [" + PainlessLookupUtility.typeToCanonicalTypeName(this.right.actual) + "]."));
            }
            this.actual = this.promote;
            if (this.promote == def.class) {
                this.left.expected = this.left.actual;
                this.right.expected = this.right.actual;
                if (this.expected != null) {
                    this.actual = this.expected;
                }
            } else {
                this.left.expected = this.promote;
                this.right.expected = this.promote;
            }
            this.left = this.left.cast(scriptRoot, variables);
            this.right = this.right.cast(scriptRoot, variables);
            if (this.left.constant != null && this.right.constant != null) {
                try {
                    if (this.promote == Integer.TYPE) {
                        this.constant = (Integer)this.left.constant / (Integer)this.right.constant;
                        break block11;
                    }
                    if (this.promote == Long.TYPE) {
                        this.constant = (Long)this.left.constant / (Long)this.right.constant;
                        break block11;
                    }
                    if (this.promote == Float.TYPE) {
                        this.constant = Float.valueOf(((Float)this.left.constant).floatValue() / ((Float)this.right.constant).floatValue());
                        break block11;
                    }
                    if (this.promote == Double.TYPE) {
                        this.constant = (Double)this.left.constant / (Double)this.right.constant;
                        break block11;
                    }
                    throw this.createError(new IllegalStateException("Illegal tree structure."));
                }
                catch (ArithmeticException exception) {
                    throw this.createError(exception);
                }
            }
        }
    }

    private void analyzeRem(ScriptRoot scriptRoot, Locals variables) {
        block11: {
            this.left.analyze(scriptRoot, variables);
            this.right.analyze(scriptRoot, variables);
            this.promote = AnalyzerCaster.promoteNumeric(this.left.actual, this.right.actual, true);
            if (this.promote == null) {
                throw this.createError(new ClassCastException("Cannot apply remainder [%] to types [" + PainlessLookupUtility.typeToCanonicalTypeName(this.left.actual) + "] and [" + PainlessLookupUtility.typeToCanonicalTypeName(this.right.actual) + "]."));
            }
            this.actual = this.promote;
            if (this.promote == def.class) {
                this.left.expected = this.left.actual;
                this.right.expected = this.right.actual;
                if (this.expected != null) {
                    this.actual = this.expected;
                }
            } else {
                this.left.expected = this.promote;
                this.right.expected = this.promote;
            }
            this.left = this.left.cast(scriptRoot, variables);
            this.right = this.right.cast(scriptRoot, variables);
            if (this.left.constant != null && this.right.constant != null) {
                try {
                    if (this.promote == Integer.TYPE) {
                        this.constant = (Integer)this.left.constant % (Integer)this.right.constant;
                        break block11;
                    }
                    if (this.promote == Long.TYPE) {
                        this.constant = (Long)this.left.constant % (Long)this.right.constant;
                        break block11;
                    }
                    if (this.promote == Float.TYPE) {
                        this.constant = Float.valueOf(((Float)this.left.constant).floatValue() % ((Float)this.right.constant).floatValue());
                        break block11;
                    }
                    if (this.promote == Double.TYPE) {
                        this.constant = (Double)this.left.constant % (Double)this.right.constant;
                        break block11;
                    }
                    throw this.createError(new IllegalStateException("Illegal tree structure."));
                }
                catch (ArithmeticException exception) {
                    throw this.createError(exception);
                }
            }
        }
    }

    private void analyzeAdd(ScriptRoot scriptRoot, Locals variables) {
        this.left.analyze(scriptRoot, variables);
        this.right.analyze(scriptRoot, variables);
        this.promote = AnalyzerCaster.promoteAdd(this.left.actual, this.right.actual);
        if (this.promote == null) {
            throw this.createError(new ClassCastException("Cannot apply add [+] to types [" + PainlessLookupUtility.typeToCanonicalTypeName(this.left.actual) + "] and [" + PainlessLookupUtility.typeToCanonicalTypeName(this.right.actual) + "]."));
        }
        this.actual = this.promote;
        if (this.promote == String.class) {
            this.left.expected = this.left.actual;
            if (this.left instanceof EBinary && ((EBinary)this.left).operation == Operation.ADD && this.left.actual == String.class) {
                ((EBinary)this.left).cat = true;
            }
            this.right.expected = this.right.actual;
            if (this.right instanceof EBinary && ((EBinary)this.right).operation == Operation.ADD && this.right.actual == String.class) {
                ((EBinary)this.right).cat = true;
            }
        } else if (this.promote == def.class) {
            this.left.expected = this.left.actual;
            this.right.expected = this.right.actual;
            if (this.expected != null) {
                this.actual = this.expected;
            }
        } else {
            this.left.expected = this.promote;
            this.right.expected = this.promote;
        }
        this.left = this.left.cast(scriptRoot, variables);
        this.right = this.right.cast(scriptRoot, variables);
        if (this.left.constant != null && this.right.constant != null) {
            if (this.promote == Integer.TYPE) {
                this.constant = (Integer)this.left.constant + (Integer)this.right.constant;
            } else if (this.promote == Long.TYPE) {
                this.constant = (Long)this.left.constant + (Long)this.right.constant;
            } else if (this.promote == Float.TYPE) {
                this.constant = Float.valueOf(((Float)this.left.constant).floatValue() + ((Float)this.right.constant).floatValue());
            } else if (this.promote == Double.TYPE) {
                this.constant = (Double)this.left.constant + (Double)this.right.constant;
            } else if (this.promote == String.class) {
                this.constant = this.left.constant.toString() + this.right.constant.toString();
            } else {
                throw this.createError(new IllegalStateException("Illegal tree structure."));
            }
        }
    }

    private void analyzeSub(ScriptRoot scriptRoot, Locals variables) {
        this.left.analyze(scriptRoot, variables);
        this.right.analyze(scriptRoot, variables);
        this.promote = AnalyzerCaster.promoteNumeric(this.left.actual, this.right.actual, true);
        if (this.promote == null) {
            throw this.createError(new ClassCastException("Cannot apply subtract [-] to types [" + PainlessLookupUtility.typeToCanonicalTypeName(this.left.actual) + "] and [" + PainlessLookupUtility.typeToCanonicalTypeName(this.right.actual) + "]."));
        }
        this.actual = this.promote;
        if (this.promote == def.class) {
            this.left.expected = this.left.actual;
            this.right.expected = this.right.actual;
            if (this.expected != null) {
                this.actual = this.expected;
            }
        } else {
            this.left.expected = this.promote;
            this.right.expected = this.promote;
        }
        this.left = this.left.cast(scriptRoot, variables);
        this.right = this.right.cast(scriptRoot, variables);
        if (this.left.constant != null && this.right.constant != null) {
            if (this.promote == Integer.TYPE) {
                this.constant = (Integer)this.left.constant - (Integer)this.right.constant;
            } else if (this.promote == Long.TYPE) {
                this.constant = (Long)this.left.constant - (Long)this.right.constant;
            } else if (this.promote == Float.TYPE) {
                this.constant = Float.valueOf(((Float)this.left.constant).floatValue() - ((Float)this.right.constant).floatValue());
            } else if (this.promote == Double.TYPE) {
                this.constant = (Double)this.left.constant - (Double)this.right.constant;
            } else {
                throw this.createError(new IllegalStateException("Illegal tree structure."));
            }
        }
    }

    private void analyzeRegexOp(ScriptRoot scriptRoot, Locals variables) {
        this.left.analyze(scriptRoot, variables);
        this.right.analyze(scriptRoot, variables);
        this.left.expected = String.class;
        this.right.expected = Pattern.class;
        this.left = this.left.cast(scriptRoot, variables);
        this.right = this.right.cast(scriptRoot, variables);
        this.promote = Boolean.TYPE;
        this.actual = Boolean.TYPE;
    }

    private void analyzeLSH(ScriptRoot scriptRoot, Locals variables) {
        this.left.analyze(scriptRoot, variables);
        this.right.analyze(scriptRoot, variables);
        Class<?> lhspromote = AnalyzerCaster.promoteNumeric(this.left.actual, false);
        Class<?> rhspromote = AnalyzerCaster.promoteNumeric(this.right.actual, false);
        if (lhspromote == null || rhspromote == null) {
            throw this.createError(new ClassCastException("Cannot apply left shift [<<] to types [" + PainlessLookupUtility.typeToCanonicalTypeName(this.left.actual) + "] and [" + PainlessLookupUtility.typeToCanonicalTypeName(this.right.actual) + "]."));
        }
        this.promote = lhspromote;
        this.actual = this.promote;
        this.shiftDistance = rhspromote;
        if (lhspromote == def.class || rhspromote == def.class) {
            this.left.expected = this.left.actual;
            this.right.expected = this.right.actual;
            if (this.expected != null) {
                this.actual = this.expected;
            }
        } else {
            this.left.expected = lhspromote;
            if (rhspromote == Long.TYPE) {
                this.right.expected = Integer.TYPE;
                this.right.explicit = true;
            } else {
                this.right.expected = rhspromote;
            }
        }
        this.left = this.left.cast(scriptRoot, variables);
        this.right = this.right.cast(scriptRoot, variables);
        if (this.left.constant != null && this.right.constant != null) {
            if (this.promote == Integer.TYPE) {
                this.constant = (Integer)this.left.constant << (Integer)this.right.constant;
            } else if (this.promote == Long.TYPE) {
                this.constant = (Long)this.left.constant << (Integer)this.right.constant;
            } else {
                throw this.createError(new IllegalStateException("Illegal tree structure."));
            }
        }
    }

    private void analyzeRSH(ScriptRoot scriptRoot, Locals variables) {
        this.left.analyze(scriptRoot, variables);
        this.right.analyze(scriptRoot, variables);
        Class<?> lhspromote = AnalyzerCaster.promoteNumeric(this.left.actual, false);
        Class<?> rhspromote = AnalyzerCaster.promoteNumeric(this.right.actual, false);
        if (lhspromote == null || rhspromote == null) {
            throw this.createError(new ClassCastException("Cannot apply right shift [>>] to types [" + PainlessLookupUtility.typeToCanonicalTypeName(this.left.actual) + "] and [" + PainlessLookupUtility.typeToCanonicalTypeName(this.right.actual) + "]."));
        }
        this.promote = lhspromote;
        this.actual = this.promote;
        this.shiftDistance = rhspromote;
        if (lhspromote == def.class || rhspromote == def.class) {
            this.left.expected = this.left.actual;
            this.right.expected = this.right.actual;
            if (this.expected != null) {
                this.actual = this.expected;
            }
        } else {
            this.left.expected = lhspromote;
            if (rhspromote == Long.TYPE) {
                this.right.expected = Integer.TYPE;
                this.right.explicit = true;
            } else {
                this.right.expected = rhspromote;
            }
        }
        this.left = this.left.cast(scriptRoot, variables);
        this.right = this.right.cast(scriptRoot, variables);
        if (this.left.constant != null && this.right.constant != null) {
            if (this.promote == Integer.TYPE) {
                this.constant = (Integer)this.left.constant >> (Integer)this.right.constant;
            } else if (this.promote == Long.TYPE) {
                this.constant = (Long)this.left.constant >> (Integer)this.right.constant;
            } else {
                throw this.createError(new IllegalStateException("Illegal tree structure."));
            }
        }
    }

    private void analyzeUSH(ScriptRoot scriptRoot, Locals variables) {
        this.left.analyze(scriptRoot, variables);
        this.right.analyze(scriptRoot, variables);
        Class<?> lhspromote = AnalyzerCaster.promoteNumeric(this.left.actual, false);
        Class<?> rhspromote = AnalyzerCaster.promoteNumeric(this.right.actual, false);
        this.promote = lhspromote;
        this.actual = this.promote;
        this.shiftDistance = rhspromote;
        if (lhspromote == null || rhspromote == null) {
            throw this.createError(new ClassCastException("Cannot apply unsigned shift [>>>] to types [" + PainlessLookupUtility.typeToCanonicalTypeName(this.left.actual) + "] and [" + PainlessLookupUtility.typeToCanonicalTypeName(this.right.actual) + "]."));
        }
        if (lhspromote == def.class || rhspromote == def.class) {
            this.left.expected = this.left.actual;
            this.right.expected = this.right.actual;
            if (this.expected != null) {
                this.actual = this.expected;
            }
        } else {
            this.left.expected = lhspromote;
            if (rhspromote == Long.TYPE) {
                this.right.expected = Integer.TYPE;
                this.right.explicit = true;
            } else {
                this.right.expected = rhspromote;
            }
        }
        this.left = this.left.cast(scriptRoot, variables);
        this.right = this.right.cast(scriptRoot, variables);
        if (this.left.constant != null && this.right.constant != null) {
            if (this.promote == Integer.TYPE) {
                this.constant = (Integer)this.left.constant >>> (Integer)this.right.constant;
            } else if (this.promote == Long.TYPE) {
                this.constant = (Long)this.left.constant >>> (Integer)this.right.constant;
            } else {
                throw this.createError(new IllegalStateException("Illegal tree structure."));
            }
        }
    }

    private void analyzeBWAnd(ScriptRoot scriptRoot, Locals variables) {
        this.left.analyze(scriptRoot, variables);
        this.right.analyze(scriptRoot, variables);
        this.promote = AnalyzerCaster.promoteNumeric(this.left.actual, this.right.actual, false);
        if (this.promote == null) {
            throw this.createError(new ClassCastException("Cannot apply and [&] to types [" + PainlessLookupUtility.typeToCanonicalTypeName(this.left.actual) + "] and [" + PainlessLookupUtility.typeToCanonicalTypeName(this.right.actual) + "]."));
        }
        this.actual = this.promote;
        if (this.promote == def.class) {
            this.left.expected = this.left.actual;
            this.right.expected = this.right.actual;
            if (this.expected != null) {
                this.actual = this.expected;
            }
        } else {
            this.left.expected = this.promote;
            this.right.expected = this.promote;
        }
        this.left = this.left.cast(scriptRoot, variables);
        this.right = this.right.cast(scriptRoot, variables);
        if (this.left.constant != null && this.right.constant != null) {
            if (this.promote == Integer.TYPE) {
                this.constant = (Integer)this.left.constant & (Integer)this.right.constant;
            } else if (this.promote == Long.TYPE) {
                this.constant = (Long)this.left.constant & (Long)this.right.constant;
            } else {
                throw this.createError(new IllegalStateException("Illegal tree structure."));
            }
        }
    }

    private void analyzeXor(ScriptRoot scriptRoot, Locals variables) {
        this.left.analyze(scriptRoot, variables);
        this.right.analyze(scriptRoot, variables);
        this.promote = AnalyzerCaster.promoteXor(this.left.actual, this.right.actual);
        if (this.promote == null) {
            throw this.createError(new ClassCastException("Cannot apply xor [^] to types [" + PainlessLookupUtility.typeToCanonicalTypeName(this.left.actual) + "] and [" + PainlessLookupUtility.typeToCanonicalTypeName(this.right.actual) + "]."));
        }
        this.actual = this.promote;
        if (this.promote == def.class) {
            this.left.expected = this.left.actual;
            this.right.expected = this.right.actual;
            if (this.expected != null) {
                this.actual = this.expected;
            }
        } else {
            this.left.expected = this.promote;
            this.right.expected = this.promote;
        }
        this.left = this.left.cast(scriptRoot, variables);
        this.right = this.right.cast(scriptRoot, variables);
        if (this.left.constant != null && this.right.constant != null) {
            if (this.promote == Boolean.TYPE) {
                this.constant = (Boolean)this.left.constant ^ (Boolean)this.right.constant;
            } else if (this.promote == Integer.TYPE) {
                this.constant = (Integer)this.left.constant ^ (Integer)this.right.constant;
            } else if (this.promote == Long.TYPE) {
                this.constant = (Long)this.left.constant ^ (Long)this.right.constant;
            } else {
                throw this.createError(new IllegalStateException("Illegal tree structure."));
            }
        }
    }

    private void analyzeBWOr(ScriptRoot scriptRoot, Locals variables) {
        this.left.analyze(scriptRoot, variables);
        this.right.analyze(scriptRoot, variables);
        this.promote = AnalyzerCaster.promoteNumeric(this.left.actual, this.right.actual, false);
        if (this.promote == null) {
            throw this.createError(new ClassCastException("Cannot apply or [|] to types [" + PainlessLookupUtility.typeToCanonicalTypeName(this.left.actual) + "] and [" + PainlessLookupUtility.typeToCanonicalTypeName(this.right.actual) + "]."));
        }
        this.actual = this.promote;
        if (this.promote == def.class) {
            this.left.expected = this.left.actual;
            this.right.expected = this.right.actual;
            if (this.expected != null) {
                this.actual = this.expected;
            }
        } else {
            this.left.expected = this.promote;
            this.right.expected = this.promote;
        }
        this.left = this.left.cast(scriptRoot, variables);
        this.right = this.right.cast(scriptRoot, variables);
        if (this.left.constant != null && this.right.constant != null) {
            if (this.promote == Integer.TYPE) {
                this.constant = (Integer)this.left.constant | (Integer)this.right.constant;
            } else if (this.promote == Long.TYPE) {
                this.constant = (Long)this.left.constant | (Long)this.right.constant;
            } else {
                throw this.createError(new IllegalStateException("Illegal tree structure."));
            }
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    void write(ClassWriter classWriter, MethodWriter methodWriter, Globals globals) {
        methodWriter.writeDebugInfo(this.location);
        if (this.promote == String.class && this.operation == Operation.ADD) {
            if (!this.cat) {
                methodWriter.writeNewStrings();
            }
            this.left.write(classWriter, methodWriter, globals);
            if (!(this.left instanceof EBinary) || !((EBinary)this.left).cat) {
                methodWriter.writeAppendStrings(this.left.actual);
            }
            this.right.write(classWriter, methodWriter, globals);
            if (!(this.right instanceof EBinary) || !((EBinary)this.right).cat) {
                methodWriter.writeAppendStrings(this.right.actual);
            }
            if (this.cat) return;
            methodWriter.writeToStrings();
            return;
        } else if (this.operation == Operation.FIND || this.operation == Operation.MATCH) {
            this.right.write(classWriter, methodWriter, globals);
            this.left.write(classWriter, methodWriter, globals);
            methodWriter.invokeVirtual(Type.getType(Pattern.class), WriterConstants.PATTERN_MATCHER);
            if (this.operation == Operation.FIND) {
                methodWriter.invokeVirtual(Type.getType(Matcher.class), WriterConstants.MATCHER_FIND);
                return;
            } else {
                if (this.operation != Operation.MATCH) throw new IllegalStateException("Illegal tree structure.");
                methodWriter.invokeVirtual(Type.getType(Matcher.class), WriterConstants.MATCHER_MATCHES);
            }
            return;
        } else {
            this.left.write(classWriter, methodWriter, globals);
            this.right.write(classWriter, methodWriter, globals);
            if (this.promote == def.class || this.shiftDistance != null && this.shiftDistance == def.class) {
                int flags = 0;
                if (this.originallyExplicit) {
                    flags |= 4;
                }
                methodWriter.writeDynamicBinaryInstruction(this.location, this.actual, this.left.actual, this.right.actual, this.operation, flags);
                return;
            } else {
                methodWriter.writeBinaryInstruction(this.location, this.actual, this.operation);
            }
        }
    }

    @Override
    public String toString() {
        return this.singleLineToString(this.left, this.operation.symbol, this.right);
    }
}

