/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.painless.node;

import java.util.List;
import java.util.Objects;
import java.util.Set;
import org.elasticsearch.painless.ClassWriter;
import org.elasticsearch.painless.Globals;
import org.elasticsearch.painless.Locals;
import org.elasticsearch.painless.Location;
import org.elasticsearch.painless.MethodWriter;
import org.elasticsearch.painless.ScriptRoot;
import org.elasticsearch.painless.lookup.PainlessMethod;
import org.elasticsearch.painless.node.AExpression;

final class PSubCallInvoke
extends AExpression {
    private final PainlessMethod method;
    private final Class<?> box;
    private final List<AExpression> arguments;

    PSubCallInvoke(Location location, PainlessMethod method, Class<?> box, List<AExpression> arguments) {
        super(location);
        this.method = Objects.requireNonNull(method);
        this.box = box;
        this.arguments = Objects.requireNonNull(arguments);
    }

    @Override
    void extractVariables(Set<String> variables) {
        throw this.createError(new IllegalStateException("Illegal tree structure."));
    }

    @Override
    void analyze(ScriptRoot scriptRoot, Locals locals) {
        for (int argument = 0; argument < this.arguments.size(); ++argument) {
            AExpression expression = this.arguments.get(argument);
            expression.expected = this.method.typeParameters.get(argument);
            expression.internal = true;
            expression.analyze(scriptRoot, locals);
            this.arguments.set(argument, expression.cast(scriptRoot, locals));
        }
        this.statement = true;
        this.actual = this.method.returnType;
    }

    @Override
    void write(ClassWriter classWriter, MethodWriter methodWriter, Globals globals) {
        methodWriter.writeDebugInfo(this.location);
        if (this.box.isPrimitive()) {
            methodWriter.box(MethodWriter.getType(this.box));
        }
        for (AExpression argument : this.arguments) {
            argument.write(classWriter, methodWriter, globals);
        }
        methodWriter.invokeMethodCall(this.method);
    }

    @Override
    public String toString() {
        return this.singleLineToStringWithOptionalArgs(this.arguments, this.prefix, this.method.javaMethod.getName());
    }
}

